@extends('frontend.layouts.print-pdf')

@section('title', 'Order #'.$order->getOrderNumber(). ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<table width="100%" align="left" cellpadding="0" cellspacing="0" border="0">
    <tbody><tr>
    <td>
        <table width="100%" cellpadding="0" cellspacing="0" border="0" align="center">
            <tbody>
                <tr>
                    <td valign="top" align="center">
                        <div class="cropped">
                            @php
                                $string = $user->ac_code . "\x0D" . str_replace('#', '', $rxOrderArray['name']) . "\x0D" . $order->getOrderNumber();
                            @endphp
                            <img src="{{generateBarcode($string,40,3)}}" width="430px">
                            
                        </div>
                        <table width="100%" cellpadding="0" cellspacing="0" border="0">
                            <tbody>
                            <tr>
                                <td valign="top" width="25%"><img src="{{ URL::asset('public/img/backend/brand/logo.gif') }}" height="40" alt="" hspace="10"></td>
                                <td valign="top" align="center" width="40%"><h2 style="font-family:Arial, Verdana, Helvetica, sans-serif;margin:0px;font-size: 20px;" class="GriffonLight">Rx Order</h2></td>                                
                                <td valign="top" align="right" width="35%" style="font-size: 11px;">
                                    @if(isset($shouldWait) && $shouldWait)
                                        <span class="text-right" style="font-size: 22px;font-weight: bold;color: black;margin-top:0px;margin-right:25px;border: 3px solid;padding: 2px;">WAIT</span><br>
                                    @endif
                                    @if($order->isRedo())
                                        <span class="text-right">REDO OF W{{$order->reason_oid}}: {{ $order->reason_type.' ('.$order->reason_notes.')' }}</span>
                                    @endif
                                </td>
                            </tr></tbody>
                        </table>
                        <div class="tableValueNames">
                                {!! displayNewCustomerWarning($user->created_at, 'print-pdf') !!}
                        </div>
                    </td>
                </tr>
                <tr>
                    
                    <td><table width="100%" cellpadding="1" cellspacing="0" border="0" class="tabletext">

                        <tbody><tr valign="top" class="rowtopborder">
                            <td class="tableValueNames labels" width="15%" align="left">Account No.</td>
                            <td valign="top" width="60%" align="left">
                                <b class="text-values">{{ $user->ac_code }} - {{ $profile->business_name }}</b> 
                                <div style="width: 100%;height: 15px;overflow: hidden;">
                                    <img src="{{ generateBarcode($user->ac_code) }}" width="70px" height="51px">  
                                </div>  
                            </td>
                            <td class="tableValueNames labels" valign="bottom" width="25%" align="center">Order No.</td>
                        </tr>
                        <tr valign="top">
                            <td class="tableValueNames labels" align="left">Patient / Tray</td>
                            <td valign="top" align="left">
                                <b class="text-values">{{ $rxOrderArray['name'] }}</b>                                    
                                <div style="width: 100%;height: 15px;overflow: hidden;">
                                    <img src="{{ generateBarcode(str_replace('#','',$rxOrderArray['name'])) }}" width="250px" height="55px">  
                                </div>
                            </td>
                            <td valign="top" align="center" style="font-size:18px" class="text-values"><b>{{ $order->getOrderNumber() }}</b>
                            </td>
                        </tr>

                        <tr valign="top" class="rowbtmborder1">
                            <td class="tableValueNames labels" align="left">Date</td>
                            <td valign="top" align="left" class="text-values"><b>{{ date_time_format($order->created_at,'d-M-Y h:i a')}}</b>
                            </td>
                            <td valign="top" align="center">
                            <div class="cropped">
                                <img src="{{ generateBarcode($order->getOrderNumber()) }}" width="70px">                                    
                            </div></td>                                
                        </tr>
                    </tbody></table></td>
                </tr>
                <tr>
                    <td valign="top" align="center">
                        <table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse;margin-top:2px;">
                            <tbody><tr>
                                <td align="left" valign="top">
                                    <table width="100%" cellpadding="0" cellspacing="0" border="0">
                                        <tbody><tr>
                                            <td valign="center" align="left">
                                                <table width="100%" cellpadding="2" cellspacing="0" border="1" class="dottedborder">
                                                    <tbody><tr class="tableValueNames" align="center">
                                                        <td>&nbsp;</td>
                                                        @foreach($rxOrderArray['distance']['label'] as $key =>$value)
                                                            <td class="bggray labels">{{$value}}</td>
                                                        @endforeach
                                                    </tr>
                                                    <tr class="rxValues" align="center">
                                                        <td class="bggray labels">R</td>
                                                        @if(!empty(strtolower($rxOrderArray['distance']['right_dist_type'])) && strtolower($rxOrderArray['distance']['right_dist_type']) != 'order')
                                                            <td colspan="{{ count($rxOrderArray['distance']['right']) }}" style="text-align: left;" class="text-values">
                                                                {{ $rxOrderArray['distance']['right_dist_type'] }}
                                                            </td>
                                                        @else
                                                            @foreach($rxOrderArray['distance']['right'] as $key =>$value)
                                                                <td class="text-values">
                                                                    <b>{{$value}}</b>
                                                                </td>
                                                            @endforeach
                                                        @endif
                                                    </tr>
                                                    <tr class="rxValues" align="center">
                                                        <td class="bggray labels">L</td>
                                                        @if(!empty(strtolower($rxOrderArray['distance']['left_dist_type'])) && strtolower($rxOrderArray['distance']['left_dist_type']) != 'order')
                                                            <td colspan="{{ count($rxOrderArray['distance']['left']) }}" style="text-align: left;" class="text-values">
                                                                {{ $rxOrderArray['distance']['left_dist_type'] }}
                                                            </td>
                                                        @else
                                                            @foreach($rxOrderArray['distance']['left'] as $key =>$value)
                                                                <td class="text-values">
                                                                    <b>{{$value}}</b>
                                                                </td>
                                                            @endforeach
                                                        @endif
                                                    </tr>
                                                    @if(!empty($rxOrderArray['intermediateStrengthText']))
                                                        <tr class="rxValues">
                                                            <td class="bggray">&nbsp;</td>
                                                            <td colspan="{{ count($rxOrderArray['reading']['label']) }}" style="font-size: 12px;" class="text-values">
                                                                {{ $rxOrderArray['intermediateStrengthText'] }}
                                                            </td>
                                                        </tr>
                                                    @endif
                                                    <tr class="tableValueNames labels" align="center">
                                                        <td>&nbsp;</td>
                                                        @foreach($rxOrderArray['reading']['label'] as $key =>$value)
                                                            <td class="bggray labels">{{$value}}</td>
                                                        @endforeach
                                                    </tr>
                                                    <tr class="rxValues" align="center">
                                                        <td class="bggray labels">R</td>
                                                        @foreach($rxOrderArray['reading']['right'] as $key =>$value)
                                                            <td class="text-values"><b>{{ $value }}</b></td>
                                                        @endforeach
                                                    </tr>
                                                    <tr class="rxValues" align="center">
                                                        <td class="bggray">L</td>
                                                        @foreach($rxOrderArray['reading']['left'] as $key =>$value)
                                                            <td class="text-values"><b>{{ $value }}</b></td>
                                                        @endforeach
                                                    </tr>
                                                    <tr class="tableValueNames labels" align="center">
                                                        <td>&nbsp;</td>
                                                        @foreach($rxOrderArray['single_info']['label'] as $key =>$value)
                                                            <td class="bggray labels">{{$value}}</td>
                                                        @endforeach
                                                    </tr>
                                                    <tr class="tableValueNames" align="center">
                                                        <td>&nbsp;</td>
                                                        @foreach($rxOrderArray['single_info']['values'] as $key =>$value)
                                                            <td class="text-values"><b>{{ $value }}</b></td>
                                                        @endforeach
                                                    </tr>
                                                    @if(isset($rxOrderArray['s_info']))
                                                        <tr align="center">
                                                            <td rowspan="3" align="center" valign="middle" class="labels">Special Info</td>
                                                            <td>&nbsp;</td>
                                                            @foreach($rxOrderArray['s_info']['label'] as $key =>$value)
                                                                <td class="bggray">{{$value}}</td>
                                                            @endforeach
                                                            <td rowspan="2" colspan="2" valign="middle" align="center" class="labels"><input type="checkbox" name="use_shorter_corridor"  onclick="return false;" value="{{$rxOrderArray['s_info']['use_shorter_corridor']}}"  id="use_shorter_corridor" /> Use Shorter Corridor</td>
                                                        </tr>
                                                        <tr>
                                                            <td align="center">&nbsp;</td>
                                                            @foreach($rxOrderArray['s_info']['values'] as $key =>$value)
                                                                <td class="text-values"><b>{{ $value }}</b></td>
                                                            @endforeach
                                                        </tr>
                                                    @endif
                                                </tbody></table>
                                            </td>
                                        </tr>
                                    </tbody></table>
                                </td>
                            </tr>
                        </tbody></table>
                    </td>
                </tr>
                <tr><td style="height:5px;"></td></tr>
                <tr>
                    <td>  
                        <table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse">
                            <tbody><tr><td width="50%" valign="top">
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse">
                                    <tbody><tr>
                                        <td valign="top" align="left">
                                            <table width="100%" cellpadding="2" cellspacing="0" border="1" class="tabletext dottedborder" style="border-collapse:collapse">
                                                <tbody><tr class="subtablehead">
                                                    <th colspan="2" class="labels">FRAME</th>
                                                </tr>
                                                <tr>
                                                    <td class="bggray tableValueNames labels" width="30%">Frame Type</td>
                                                    <td class="tableValues text-values"><b>{{$rxOrderArray['frame']['frame_type']}}</b></td>
                                                </tr>
                                                <tr>
                                                    <td class="bggray tableValueNames labels" >Lens Thickness</td>
                                                    <td class="tableValues text-values" ><b>
                                                    {{!empty($rxOrderArray['frame']['specify_thickness']) ? $rxOrderArray['frame']['specify_thickness'] : ''}}
                                                    @if(!empty($rxOrderArray['frame']['specify_thickness_data']['r_ct_or_et']))
                                                            ({{ $rxOrderArray['frame']['specify_thickness_data']['r_ct_or_et'] }} {{$rxOrderArray['frame']['specify_thickness_data']['l_ct_or_et']}})
                                                        @endif
                                                    </b></td>
                                                </tr>
                                                @if(!empty($rxOrderArray['frame']['bevel_type']))
                                                <tr>
                                                    <td class="bggray tableValueNames labels" >Bevel Type</td>
                                                    <td class="tableValues text-values" ><b
                                                        >{{!empty($rxOrderArray['frame']['bevel_type']) ? $rxOrderArray['frame']['bevel_type'] : ''}}
                                                    </b></td>
                                                </tr>
                                                @endif
                                                @foreach($rxOrderArray['frame']['frame_info']['label'] as $key =>$value)
                                                    <tr>
                                                        <td class="bggray tableValueNames labels">{{ ucwords($value) }}</td>
                                                        @if($rxOrderArray['frame']['frame_info']['values'][strtolower($value)] == '✓')
                                                            <td class="tableValues text-values" style="font-family: 'DejaVu Sans', sans-serif;"><b>{!! $rxOrderArray['frame']['frame_info']['values'][strtolower($value)] !!}</b></td>
                                                        @else
                                                            <td class="tableValues text-values"><b>{!! $rxOrderArray['frame']['frame_info']['values'][strtolower($value)] !!}</b></td>
                                                        @endif
                                                    </tr>
                                                @endforeach
                                                <tr>
                                                    <td colspan="2" style="height:15px;"></td>
                                                </tr>
                                            </tbody></table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table width="100%" cellpadding="2" cellspacing="0" border="1" class="tabletext dottedborder">
                                                <tbody><tr class="subtablehead">
                                                    <th colspan="4" class="labels">FRAME SIZE</th>
                                                </tr>
                                                <tr class="bggray tableValueNames labels" align="center">
                                                    @foreach($rxOrderArray['frame']['frame_size']['label'] as $key =>$value)
                                                        <td width="25%">{{$value}}</td>
                                                    @endforeach
                                                </tr>
                                                <tr class="tableValues text-values" align="center">
                                                    @foreach($rxOrderArray['frame']['frame_size']['values'] as $key =>$value)
                                                        <td><b>{{$value}}</b></td>
                                                    @endforeach
                                                </tr>
                                                <tr>
                                                    <td colspan="4" style="height:15px;"></td>
                                                </tr>
                                            </tbody></table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table width="100%" cellpadding="2" cellspacing="0" border="1" class="tabletext dottedborder">
                                                <tbody><tr class="subtablehead labels">
                                                    <th colspan="3">MODIFY SHAPE</th>
                                                </tr>
                                                <tr class="tableValues labels">
                                                    <td width="10%"><b style="font-family: DejaVu Sans, sans-serif;">{!! $rxOrderArray['frame']['modify_shape']['a'] !!} A</b></td>
                                                    <td width="25%"><b >{{ $rxOrderArray['frame']['modify_shape']['a_option'] }}</b></td>
                                                    <td width="25%"><b >{{ $rxOrderArray['frame']['modify_shape']['a_increase'] }}</b></td>
                                                </tr>
                                                <tr class="tableValues labels">
                                                    <td><b style="font-family: DejaVu Sans, sans-serif;">{!! $rxOrderArray['frame']['modify_shape']['b'] !!} B</b></td>
                                                    <td><b>{{ $rxOrderArray['frame']['modify_shape']['b_option'] }}</b></td>
                                                    <td><b>{{ $rxOrderArray['frame']['modify_shape']['b_increase'] }}</b></td>
                                                </tr>
                                                <tr>
                                                    <td colspan="3" style="height:15px;"></td>
                                                </tr>
                                            </tbody></table>
                                        </td>
                                    </tr>

                                </tbody></table>

                            </td>
                            <td valign="top" width="50%"    >
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse">
                                    <tbody><tr>
                                        <td>
                                                <table width="100%" cellpadding="2" cellspacing="0" border="1" style="border-collapse:collapse" class="tabletext dottedborder">
                                                <tbody><tr class="subtablehead labels">
                                                    <th colspan="2">JOB TYPE</th>
                                                </tr>
                                                <tr>
                                                    <td colspan="2" class="tableValues text-values" id="frame_cell"><b>{{ $rxOrderArray['frame']['job_type'] }}</b></td>
                                                </tr>

                                                <tr>
                                                    @if(isset($rxOrderArray['frame']['invoice_order_no']))
                                                        <td class="bggray tableValueNames labels">Invoice/Order Number</td>
                                                        <td class="text-values"><b>{{$rxOrderArray['frame']['invoice_order_no']}}</b></td>
                                                    @else
                                                        <td colspan="2" style="height:15px;"></td>
                                                    @endif
                                                </tr>


                                                <tr class="subtablehead labels">
                                                    <th colspan="2">LENS INFORMATION</th>
                                                </tr>
                                                @if(isset($rxOrderArray['lens_group']))
                                                    @foreach($rxOrderArray['lens_group']['group_values'] as $key => $value)
                                                        <tr class="tableValues">
                                                            <td align="left" class="bggray tableValueNames labels">{{ $value }}</td>
                                                            <td id="lensValue1" class="text-values"><b>{{ $rxOrderArray['lens_group']['att_values'][$key] }}</b></td>
                                                        </tr>
                                                    @endforeach
                                                @else
                                                    <tr>
                                                        <td width="30%" class="bggray tableValueNames labels">Lens Type</td>
                                                        <td class="tableValues text-values">
                                                            @if (!empty($rxOrderArray['package']['label']))
                                                                <b>{!! str_replace('Single Vision Surfaced Conventional', 'Single Vision', $rxOrderArray['lens']['lens_type']) !!}</b>
                                                                {!! displayLensTypeNote($rxOrderArray['lens']['lens_type']) !!}
                                                            @else
                                                                <b>{!! $rxOrderArray['lens']['lens_type'] !!}</b>
                                                            @endif
                                                            
                                                        </td>
                                                    </tr>
                                                    <tr class="tableValues">
                                                        <td align="left" class="bggray tableValueNames labels">Sub-Type</td>
                                                        <td id="lensValue1" class="text-values"><b>{{ $rxOrderArray['lens']['sub_type'] }}</b></td>
                                                    </tr>
                                                    <tr class="tableValues">
                                                        <td align="left" class="bggray tableValueNames labels">Lens Name</td>
                                                        <td id="lensValue3" class="text-values"><b>{{ $rxOrderArray['lens']['lens_name'] }}</b></td>
                                                    </tr>
                                                    <tr class="tableValues">
                                                        <td align="left" class="bggray tableValueNames labels">Material</td>
                                                        <td id="lensValue5" class="text-values"><b>{{ $rxOrderArray['lens']['lens_material'] }}</b></td>
                                                    </tr>
                                                    <tr class="tableValues">
                                                        <td align="left" class="bggray tableValueNames labels">Filter</td>
                                                        <td id="lensValue5" class="text-values"><b>{{ $rxOrderArray['lens']['lens_filter'] }}</b></td>
                                                    </tr>
                                                    <tr class="tableValues">
                                                        <td align="left" class="bggray tableValueNames labels">Colour</td>
                                                        <td id="lensValue5" class="text-values"><b>{{ $rxOrderArray['lens']['lens_colour'] }}</b></td>
                                                    </tr>
                                                    <tr class="tableValues">
                                                        <td align="left" class="bggray tableValueNames labels">Coating</td>
                                                        <td id="lensValue5" class="text-values"><b>{{ $rxOrderArray['lens']['coating_name'] }}</b></td>
                                                    </tr>
                                                    <tr class="tableValues">
                                                        <td align="left" class="bggray tableValueNames labels">Coating Colour</td>
                                                        <td id="lensValue5" class="text-values"><b>{{ $rxOrderArray['lens']['coating_colour'] }}</b></td>
                                                    </tr>
                                                @endif
                                                @if(isset($rxOrderArray['is_tinting']) && $rxOrderArray['is_tinting'] == 1)
                                                    <tr>
                                                        <td colspan="2" style="height:15px;"></td>
                                                    </tr>
                                                    <tr class="subtablehead labels">
                                                        <th colspan="2">TINTING</th>
                                                    </tr>
                                                    <tr>
                                                        <td class="bggray tableValueNames labels">Tint</td>
                                                        <td class="tableValues text-values"><b>{{ $rxOrderArray['tint_option'] != '1' ? 'Match Sample' : ''}}</b></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="bggray tableValueNames labels">Colour</td>
                                                        <td class="tableValues text-values"><b>{{ $rxOrderArray['tint_color_sample']}}</b></td>
                                                    </tr>
                                                @endif
                                                <tr>
                                                    <td colspan="2" style="height:15px;"></td>
                                                </tr>
                                                <tr class="subtablehead labels">
                                                    <th colspan="2">Additional Items</th>
                                                </tr>
                                                <tr>
                                                    <td class="bggray tableValueNames labels">Add Clip-On</td>
                                                    <td class="tableValues text-values"><b>{{ $rxOrderArray['additional_items']['add_clip_on']}}</b></td>
                                                </tr>
                                                <tr>
                                                    <td class="bggray tableValueNames labels">Add Repairs</td>
                                                    <td class="tableValues text-values"><b>
                                                        @if(!empty($rxOrderArray['additional_items']['repairs_services']))
                                                            @foreach($rxOrderArray['additional_items']['repairs_services'] as $value)
                                                                @if(!empty($value)) 
                                                                    <span>{{ \App\Models\Backend\RxValidations::decodeValue($value) }}</span>
                                                                @endif
                                                            @endforeach
                                                        @endif
                                                    </b></td>
                                                </tr>
                                                <tr>
                                                    <td class="bggray tableValueNames labels">Description</td>
                                                    <td class="tableValues text-values"><b>{{ $rxOrderArray['additional_items']['repair_description'] }}</b></td>
                                                </tr>
                                                @if(!empty($rxOrderArray['package']['label']))
                                                <tr>
                                                    <td class="bggray tableValueNames labels">Package</td>
                                                    <td class="tableValues text-values"><b>{{ $rxOrderArray['package']['label'] }}</b></td>
                                                </tr>
                                                @endif
                                                @if(!empty($rxOrderArray['multipair_ref']))
                                                <tr>
                                                    <td colspan="2" valign="bottom" align="center" style="font-family: arial, verdana;padding=1px;" class="labels"><b>MULTI-PAIR</b>
                                                    <div class="cropped3">                                            
                                                        <img src="{{ generateBarcode('MP') }}" width="70px">                                            
                                                    </div>
                                                    <span style="font-size:10px;" class="text-values">{{ $rxOrderArray['multipair_ref'] }}</span>
                                                    </style="font-family:></td>
                                                </tr>
                                                @elseif(!empty($order->rxOrder))
                                                    @php
                                                        $isInternalMP = $order->rxOrder->isInternalMP();
                                                    @endphp
                                                    @if($isInternalMP != 0)
                                                    <tr>
                                                        <td colspan=2 valign="bottom" align="center" style="font-family: Arial, Verdana; padding: 1px;" class="tableValues"><b>CSE01 ({{ $isInternalMP }})</b>
                                                        <div class="cropped3">
                                                            <img src="{{ generateBarcode('CSE01') }}" width="70px">
                                                        </div>
                                                        </td>
                                                    </tr>
                                                    @endif
                                                @endif
                                                </tbody></table>  
                                            </td>
                                        </tr>

                                    </tbody></table>
                                </td>
                            </tr></tbody></table>
                        </td>
                    </tr>
                    <tr>
                    <td style="height:5px;"></td>
                </tr>
                <tr>
                    <td valign="top" align="center">
                        <table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse">
                            <tbody><tr>
                                <td align="left">
                                    <table width="100%" cellpadding="2" cellspacing="0" border="1" style="border-collapse:collapse" class="tabletext dottedborder">
                                        <tbody><tr class="subtablehead labels">
                                            <th>SPECIAL INSTRUCTIONS</th>
                                        </tr>
                                        <tr class="tableValues text-values">
                                            <td><b>{!! $rxOrderArray['additional_items']['special_instructions'] !!}</b></td>
                                        </tr>
                                    </tbody></table>
                                </td>
                            </tr>
                        </tbody></table>
                    </td>
                </tr>
            </tbody></table>
    </td>
</tr>
</tbody>
</table>
@endsection