@extends('backend.layouts.split')

@section('title', 'All Orders' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-basket font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> All Orders </span>
                </div>
            </div>
            <div class="portlet-body">
                @include('backend.auth.orders.includes.orders-search-form', array_merge(compact('orders', 'pageCount', 'customers'), ['isBackend' => true]))
                <input type="hidden" id="total-records" value="{{ $totalRecords ?? 0 }}">
                <div class="table-data-container all-orders_container" style="margin-top:5%">
                    <div id="records-container">
                        @include('partials.orderlist', ['orders' => $orders, 'pageCount' => $pageCount, 'isBackend' => true])
                    </div>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
@include('backend.auth.templates.includes.templates-modal')
@include('backend.auth.orders.includes.side-panel')
@endsection