@extends('backend.layouts.split')

@section('title', 'Edit Template' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())


@section('content')
    {{ html()->modelForm($template, 'PATCH', route('admin.auth.template.update', $template->id))->class('form-actions top')->open() }}
    <div class="row" style="margin-top:25px">
        <div class="col-md-12">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <h4 class="card-title mb-0 caption-subject bold">
                        @lang('labels.backend.access.emails.management')
                        <small class="text-muted">@lang('labels.backend.access.emails.edit')</small>
                    </h4>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label('Label')->class('control-label')->for('label') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-label"></i>
                                        </span>
                                        {{ html()->text('title')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.frontend.templates.title'))
                                            ->attribute('maxlength', 191)
                                            ->attribute('value', $template->title)
                                            ->required()
                                            ->autofocus() }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label('Subject')->class('control-label')->for('subject') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-label"></i>
                                        </span>
                                        {{ html()->text('subject')
                                            ->class('form-control input-circle-right')
                                            ->placeholder('Subject')
                                            ->attribute('maxlength', 191)
                                            ->attribute('value', $template->subject)
                                            ->required()
                                            ->autofocus() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12" style="padding:0%">
                                <div class="form-group">
                                    <div class="col-md-12">               
                                        {{ html()->label('Description')->class('control-label')->for('description') }}
                                        <textarea class="ckeditor form-control" name="description" rows="6" data-error-container="#editor2_error">{!!$template->description!!}</textarea>
                                        <div id="editor2_error"> </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions right">
                        {{ form_cancel(route('admin.auth.template.index'), __('buttons.general.cancel')) }}
                        {{ form_submit(__('buttons.general.crud.update')) }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{ html()->form()->close() }}
@endsection