@extends('backend.layouts.split')

@section('title', 'Profile' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<h1 class="page-title"> User Profile</h1>
    <div class="profile">
        <div class="tabbable-line tabbable-full-width">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab_1_1" data-toggle="tab"> Overview </a>
                </li>
                <li>
                    <a href="#tab_1_3" data-toggle="tab"> Account </a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab_1_1">
                    <div class="row">
                        <div class="col-md-3">
                            <ul class="list-unstyled profile-nav">
                                <li>
                                    <img src="{{ $logged_in_user->picture }}" class="img-responsive pic-bordered" />
                                </li>
                            </ul>
                        </div>
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-8 profile-info">
                                    <h1 class="font-green sbold uppercase">{{$logged_in_user->name}}</h1>
                                    <a href="mailto:{{$logged_in_user->email}}"> {{$logged_in_user->email}} </a>
                                    <br><br>
                                    <ul class="list-inline">
                                        <li>
                                            <i class="fa fa-calendar"></i> {{ timezone()->convertToLocal($logged_in_user->created_at) }} ({{ $logged_in_user->created_at->diffForHumans() }}) 
                                        </li>
                                    </ul>
                                </div>
                                <!--end col-md-8-->
                                <div class="col-md-4">
                                </div>
                            </div>
                            <!--end row-->
                            <div class="tabbable-line tabbable-custom-profile">
                                <ul class="nav nav-tabs">
                                    <li class="active">
                                        <a href="#tab_1_11" data-toggle="tab"> Orders </a>
                                    </li>
                                    <li>
                                        <a href="#tab_1_22" data-toggle="tab"> Feeds </a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane active" id="tab_1_11">
                                        <div class="portlet-body">
                                            <table class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th>
                                                            <i class="fa fa-briefcase"></i> ID 
                                                        </th>
                                                        <th class="hidden-xs">
                                                            <i class="fa fa-list" aria-hidden="true"></i> Type 
                                                        </th>
                                                        <th>
                                                            <i class="fa fa-bookmark"></i> Status 
                                                        </th>
                                                        <th>
                                                            <i class="fa fa-usd" aria-hidden="true"></i> Amount 
                                                        </th>
                                                        <th> </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($orders as $order)
                                                    <tr>
                                                        <td> {{$order->id}} </td>
                                                        <td> {{$order->type}} </td>
                                                        <td><span class="label label-sm label-success"> {{$order->statusModel->name}} </td>
                                                        <td> {{$order->price}} </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!--tab-pane-->
                                    <div class="tab-pane" id="tab_1_22">
                                        <div class="tab-pane active" id="tab_1_1_1">
                                            <div class="scroller" data-height="290px" data-always-visible="1" data-rail-visible1="1">
                                                <ul class="feeds">
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <!--tab-pane-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--tab_1_2-->
                <div class="tab-pane" id="tab_1_3">
                    <div class="row profile-account">
                        <div class="col-md-3">
                            <ul class="ver-inline-menu tabbable margin-bottom-10">
                                <li class="active">
                                    <a data-toggle="tab" href="#tab_1-1">
                                        <i class="fa fa-cog"></i> Personal info </a>
                                    <span class="after"> </span>
                                </li>
                                <li>
                                    <a data-toggle="tab" href="#tab_2-2">
                                    <i class="fa fa-picture-o"></i> Change Avatar </a>
                                </li>
                                <li>
                                    <a data-toggle="tab" href="#tab_3-3">
                                        <i class="fa fa-lock"></i> Change Password </a>
                                </li>
                                <li>
                                    <a data-toggle="tab" href="#tab_3-4">
                                        <i class="fa fa-eye"></i> Settings </a>
                                </li>
                            </ul>
                        </div>
                        <div class="col-md-9" >
                            <div class="tab-content">
                                {{-- ===== Edit Profile ===== --}}
                                <div id="tab_1-1" class="tab-pane active">
                                    @include('backend.auth.user.account.tabs.edit')</div>
                                {{-- ===== Change Avatar ===== --}}
                                <div id="tab_2-2" class="tab-pane">
                                    @include('backend.auth.user.account.tabs.profile')</div>
                                {{-- ===== Change Password ===== --}}
                                <div id="tab_3-3" class="tab-pane">
                                    @include('backend.auth.user.account.tabs.change-password')
                                </div>
                                <div id="tab_3-4" class="tab-pane">
                                    @include('backend.auth.user.account.tabs.settings',['settings'=>$settings])
                                </div>
                            </div>
                        </div>
                        <!--end col-md-9-->
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection



