<?php 
use App\Models\Backend\UserProfile;
?>
@extends('backend.layouts.split')

@section('title', __('labels.backend.access.users.edit') . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection
@section('content')
    {{ html()->modelForm($user, 'PATCH', route('admin.auth.user.update', $user->id))->class('form-actions top')->open() }}
    <input type="hidden" name="roles" value="5">
    <div class="row" style="margin-top:25px">
        <div class="col-md-12">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <h4 class="card-title mb-0 caption-subject bold">
                        @lang('labels.backend.access.users.management')
                        <small class="text-muted">@lang('labels.backend.access.users.edit')</small>
                    </h4>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.first_name'))->class('control-label')->for('first_name') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-user"></i>
                                        </span>
                                        {{ html()->text('first_name')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.first_name'))
                                            ->attribute('maxlength', 191)
                                            ->if($user->isCustomerAdmin(), function ($divElement) {
                                                return $divElement->attribute('readOnly',true);
                                            })
                                            ->required()
                                            ->autofocus() }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.last_name'))->class('control-label')->for('last_name') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-user"></i>
                                        </span>
                                        {{ html()->text('last_name')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.last_name'))
                                            ->attribute('maxlength', 191)
                                            ->if($user->isCustomerAdmin(), function ($divElement) {
                                                return $divElement->attribute('readOnly',true);
                                            })
                                            ->required() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.email'))->class('control-label')->for('email') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-envelope"></i>
                                        </span>
                                        {{ html()->email('email')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.email'))
                                            ->attribute('maxlength', 191)
                                            ->if($user->isCustomerAdmin(), function ($divElement) {
                                                return $divElement->attribute('readOnly',true);
                                            })
                                            ->required() }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6" style="margin-top: 25px;">
                                <div class="form-group">
                                    {{ html()->label('Enabled')->class('col-md-4 control-label style-lable')->for('confirmed') }}
                                    <div class="input-group">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            {{ html()->checkbox('confirmed', true)->class('make-switch')->attribute('data-on-color','primary')->attribute('data-off-color','danger')->attribute('data-on-text','Yes')->attribute('data-off-text','No') }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="customer-profile-container" style="display:<?= ($user->isCustomerAdmin()) ? '' : 'none'; ?>">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Business Name'))->class('control-label')->for('business_name') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-building" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('business_name')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->business_name)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                    }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Customer Code'))->class('control-label')->for('ac_code') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-building" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('ac_code')
                                                ->class('form-control input-circle-right')
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                    }}
                                        </div>
                                    </div>
                                </div>                              
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Address Line 1'))->class('control-label')->for('address1') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-map-marker" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('address1')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->address1)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>                            
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Address Line 2'))->class('col-md-12 control-label')->for('address2') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-map-marker" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('address2')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->address2)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('City'))->class('control-label')->for('city') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-building-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('city')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->city)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>                            
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('State'))->class('col-md-12 control-label')->for('state') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-location-arrow" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('state')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->state)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Country'))->class('control-label')->for('country') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-globe" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('country')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Country'))
                                                ->value($profile->country)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>                            
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Zip Code'))->class('col-md-12 control-label')->for('zip_code') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-list-ol" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('zip_code')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->zip_code)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Phone'))->class('control-label')->for('phone') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-phone-square" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('phone')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->phone)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>                            
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Fax'))->class('col-md-12 control-label')->for('fax') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-fax" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('fax')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->fax)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">                         
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Ship Via Code'))->class('col-md-12 control-label')->for('cust_ship_via_cod') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('cust_ship_via_cod')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->cust_ship_via_cod)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>                        
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Comments'))->class('col-md-12 control-label')->for('cust_commnt') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('cust_commnt')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->cust_commnt)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>                 
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Language'))->class('col-md-12 control-label')->for('cust_language') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('cust_language')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->cust_language)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>          
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Phone Ext'))->class('col-md-12 control-label')->for('cust_phone_ext') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('cust_phone_ext')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->cust_phone_ext)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>      
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('On Hold'))->class('col-md-12 control-label')->for('cust_on_hold') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('cust_on_hold')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->cust_on_hold)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Eom Table'))->class('col-md-12 control-label')->for('cust_eom_table') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('cust_eom_table')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->cust_eom_table)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Group Customer Number'))->class('col-md-12 control-label')->for('cust_group_cust_no') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('cust_group_cust_no')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->cust_group_cust_no)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Active X'))->class('col-md-12 control-label')->for('cust_active_x') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('cust_active_x')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->cust_active_x)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Supplier Dollar'))->class('col-md-12 control-label')->for('cust_suppress_dollar') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('cust_suppress_dollar')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->cust_suppress_dollar)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Def E U'))->class('col-md-12 control-label')->for('cust_def_e_u') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('cust_def_e_u')
                                                ->class('form-control input-circle-right')
                                                ->value($profile->cust_def_e_u)
                                                ->attribute('maxlength', 191)
                                                ->attribute('readOnly', true)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Date of Birth'))->class('control-label')->for('date_of_birth') }}
                                        <div class="input-group date-picker">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-calendar"></i>
                                            </span>
                                            {{ html()->text('date_of_birth')
                                                ->class('form-control input-circle-right datepicker')
                                                ->placeholder(__('Date of Birth'))
                                                ->value($profile->date_of_birth)
                                                ->attribute('maxlength', 191) 
                                                ->attribute('data-date-format', 'yyyy-mm-dd') }}
                                        </div>
                                    </div>
                                </div>    
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ html()->label(__('Ethnicity'))->class('control-label')->for('ethnicity') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-globe"></i>
                                            </span>
                                            <select name="ethnicity" class="form-control input-circle-right">
                                            <option value="">Please Select</option>
                                                @foreach (UserProfile::getEthnicityArrayLabel() as $key => $ethnicity)
                                                    <option value="{{ $key }}" <?= ($key == $profile->ethnicity) ? 'selected' : '' ?>>{{ $ethnicity }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>                          
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Celebrates Holidays'))->class('control-label')->for('religion') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-globe"></i>
                                            </span>
                                            <select name="religion" class="form-control input-circle-right">
                                            <option value="">Please Select</option>
                                                @foreach (UserProfile::getReligionArrayLabel() as $key => $religion)
                                                    <option value="{{ $key }}" <?= ($key == $profile->religion) ? 'selected' : '' ?>>{{ $religion }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ html()->label(__('Notes'))->class('control-label')->for('notes') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o"></i>
                                            </span>
                                            {{ html()->textArea('notes')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Notes'))
                                                ->value($profile->notes)
                                                ->attribute('maxlength', 191) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions right">
                        {{ form_cancel(route('admin.auth.user.index'), __('buttons.general.cancel')) }}
                        {{ form_submit(__('buttons.general.crud.update')) }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{ html()->form()->close() }}
@endsection