@extends('backend.layouts.split')

@section('title', __('labels.backend.access.users.view') . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection

@section('content')
<h1 class="page-title"> User Profile</h1>
    <div class="profile">
        <div class="tabbable-line tabbable-full-width">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab_1_1" data-toggle="tab">Info</a>
                </li>
                @if($user->isCustomerAdmin())
                    <li>
                        <a href="#tab_1_3" data-toggle="tab">Customer Staff</a>
                    </li>
                @endif
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab_1_1">
                    @include('backend.auth.user.show.tabs.overview')
                </div>
                <!--tab_1_2-->
                <div class="tab-pane" id="tab_1_3">
                    <div class="row profile-account">
                        <div class="col-md-12" >
                            <div class="tab-content">
                                {{-- Cutomer Admin's Staff --}}
                                <div id="tab_1-1" class="tab-pane active">
                                    @if(!empty($customerStaff))
                                        @include('backend.auth.user.show.tabs.customer-staff',compact('customerStaff'))
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
