<?php
use App\Models\Backend\UserProfile;
?>
<style type="text/css">
    .dropify-wrapper{
        height: 150px;
    }
</style>
{{ html()->modelForm($user, 'POST', route('admin.auth.updateApi',$user))->class('form-horizontal enable_change_btn')->attribute('enctype', 'multipart/form-data')->open() }}
@method('POST')
<input type="hidden" name="steps" value="personal_info">
<div class="col">
    <div class="table-responsive">
        <table class="table table-striped table-hover table-bordered">
            @if($user->isFrontendUser())
                <tr>
                    <th>Login As</th>
                    <td>
                        {!! $user->login_as_button !!}
                    </td>
                </tr>
            @endif
            <tr>
                <th>Logo</th>
                <td>
                    @if(0 /*!$user->isGravatar()*/)
                    <div class="fileinput-new card-img-top" style="width: 200px; height: auto;">
                        <img src="{{ $user->picture }}" class="img-responsive" />
                    </div>
                    @else
                        {{ html()->file('avatar_location')->class('default-dropify picture')->attribute('data-allowed-file-extensions','png jpg jpeg')->attribute('data-show-loader','true')->attribute('data-max-file-size','20M') }}
                        <input type="hidden" name="avatar_type" value="storage" checked  />
                    @endif
                </td>
            </tr>
            <tr>
                <th>@lang('labels.backend.access.users.tabs.content.overview.first_name')</th>
                    <td>
                        <input type="text" name="first_name" 
                            class="form-control" 
                            value="{{ $user->first_name }}"
                            >
                    </td>
            </tr>
             <tr>
                <th>@lang('labels.backend.access.users.tabs.content.overview.last_name')</th>
                    <td>
                        <input type="text" name="last_name" 
                            class="form-control" 
                            value="{{ $user->last_name }}"
                            >
                    </td>
            </tr>
            <tr>
                <th>@lang('labels.backend.access.users.tabs.content.overview.email')</th>
                <td>{{ $user->email }}</td>
            </tr>
            @if (!empty($profile))
            <tr>
                <th>Business Name</th>
                <td>{{ $profile->business_name }}</td>
            </tr>
            <tr>
                <th>Street 1</th>
                <td>{{ $profile->address1 }}</td>
            </tr>
            <tr>
                <th>Street 2</th>
                <td>{{ $profile->address2 }}</td>
            </tr>
            <tr>
                <th>City</th>
                <td>{{ $profile->city }}</td>
            </tr>
            <tr>
                <th>Province</th>
                <td>{{ $profile->state }}</td>
            </tr>
            <tr>
                <th>Country</th>
                <td>{{ $profile->country }}</td>
            </tr>
            <tr>
                <th>Postal Code</th>
                <td>{{ $profile->zip_code }}</td>
            </tr>
            <tr>
                <th>Phone</th>
                <td>{{ $formattedPhone }}</td>
            </tr>
            <tr>
                <th>Extension</th>
                <td>{{ $profile->cust_phone_ext }}</td>
            </tr>
            <tr>
                <th>Fax</th>
                <td>{{ $formattedFax }}</td>
            </tr>
            <tr>
                <th>Birthday</th>
                <td>
                    <div class="input-group date-picker">
                        <span class="input-group-text">
                            <i class="fa fa-calendar"></i>
                        </span>
                        {{ html()->text('date_of_birth')
                            ->class('form-control')
                            ->placeholder(__('Birthday'))
                            ->value($profile->date_of_birth)
                            ->attribute('maxlength', 191)
                            ->attribute('data-date-format', 'yyyy-mm-dd') }}
                    </div>
                </td>
            </tr>
            <tr>
                <th>Celebrates Holidays</th>
                <td>
                    <select name="religion[]" class="form-control select2_custom" multiple>
                        <option value="">Please Select</option>
                        <?php
                            $religion = !empty($profile->religion) ? json_decode($profile->religion,1) : [];
                        ?>
                        @foreach (UserProfile::getReligionArrayLabel() as $key => $value)
                            <option value="{{ $value->name }}" <?= in_array($value->name, $religion) ? 'selected' : '' ?>>{{ $value->name }}</option>
                        @endforeach
                    </select>
                </td>
            </tr>
            <tr>
                <th>Ship via</th>
                <td>{{ $profile->cust_ship_via_cod }}</td>
            </tr>
            <tr>
                <th>Comments</th>
                <td>{{ $profile->cust_commnt }}</td>
            </tr>
            <tr>
                <th>Language</th>
                <td>{{ $profile->cust_language }}</td>
            </tr>
            <tr>
                <th>On Hold</th>
                <td>{{ $profile->cust_on_hold }}</td>
            </tr>
            <tr>
                <th>EOM Discount Table</th>
                <td>{{ $profile->cust_eom_table }}</td>
            </tr>
            <tr>
                <th>Buying Group Number</th>
                <td>{{ $profile->cust_group_cust_no }}</td>
            </tr>
            <tr>
                <th>Is Active</th>
                <td>{{ $profile->cust_active_x }}</td>
            </tr>
            <tr>
                <th>Hide Prices on Invoice</th>
                <td>{{ $profile->cust_suppress_dollar }}</td>
            </tr>
            <tr>
                <th>Default Job Type</th>
                <td>{{ $profile->cust_def_e_u }}</td>
            </tr>
            <tr>
                <th>Customer Type</th>
                <td>{{ $profile->cust_type }}</td>
            </tr>
            <tr>
                <th>Freight Amount</th>
                <td>{{ $profile->cust_freight_amt }}</td>
            </tr>
            <tr>
                <th>Note</th>
                <td>{{ $profile->notes }}</td>
            </tr>
            <tr>
                <th>Default Price List</th>
                <td>{{ $profile->cust_prlist_default }}</td>
            </tr>
            <tr>
                <th>Stock Price List</th>
                <td>{{ $profile->cust_prlist_stock }}</td>
            </tr>
            <tr>
                <th>Contact 2</th>
                <td>{{ $profile->cust_contact_2 }}</td>
            </tr>
            <tr>
                <th>Contact 3</th>
                <td>{{ $profile->cust_contact_3 }}</td>
            </tr>
            <tr>
                <th>Buying Group</th>
                <td>{{ $profile->cust_group }}</td>
            </tr>
            @endif
            <tr>
                <th>Account Access</th>
                <td>
                    <div class="input-group">
                        <label class="mt-checkbox mt-checkbox-outline">
                            {{ html()->checkbox('active', $user->active ? true : false)->class('make-switch')->attribute('data-on-color','primary')->attribute('data-off-color','danger')->attribute('data-on-text','Enabled')->attribute('data-off-text','Disabled')->attribute('data-id',$user->id) }}
                        </label>
                    </div>
                </td>
            </tr>
            <tr>
                <th>@lang('labels.backend.access.users.tabs.content.overview.timezone')</th>
                <td>{{ $user->timezone }}</td>
            </tr>
            <tr>
                <th>@lang('labels.backend.access.users.tabs.content.overview.last_login_at')</th>
                <td>
                    @if($user->last_login_at)
                        {{ timezone()->convertToLocal($user->last_login_at) }}
                    @else
                        N/A
                    @endif
                </td>
            </tr>
            <tr>
                <th>@lang('labels.backend.access.users.tabs.content.overview.last_login_ip')</th>
                <td>{{ $user->last_login_ip ?? 'N/A' }}</td>
            </tr>
            @if(!$user->email)
            <tr>
                <th>Permissions</th>
                <td>
                    <div class="col-sm-12">
                        <div class="col-sm-6">
                            <input type="checkbox" id="place-orders" {{ $user->permission_order_placed == 1 ? 'checked' : '' }} class="readonly-checkbox" readonly>
                            <label for="place-orders">Place Orders</label>
                        </div>
                        <div class="col-sm-6">
                            <input type="checkbox" id="see-prices-invoices" {{ $user->permission_prices_invoices == 1 ? 'checked' : '' }} class="readonly-checkbox" readonly>
                            <label for="see-prices-invoices">See Prices & Invoices</label>
                        </div>
                    </div>
                </td>
            </tr>
            @endif
        </table>
    </div>
</div><!--table-responsive-->
{{ html()->closeModelForm() }}
@section('scripts')
<script>

    const readonlyCheckboxes = document.querySelectorAll('.readonly-checkbox');
        readonlyCheckboxes.forEach(function(checkbox) {
            checkbox.addEventListener('click', function(event) {
                event.preventDefault();
            });
    });

    var imageUrl = "<?= $user->user_picture ?>";
    $(function() {
            var drEvent = $('.picture').dropify({
                defaultFile: imageUrl,
            });
        $(".make-switch").bootstrapSwitch();
        $('.date-picker input').datepicker({
            autoclose: true,
            'format': 'yyyy-mm-dd',
            orientation: 'bottom'
        });
        $(".select2_custom").select2({
            placeholder: "Select..."
        });

        // Prevent form submission if the input is readonly
        $(".enable_change_btn").on('submit', function (e) {
            let readonlyInputs = $(this).find('.readonly-checkbox[readonly]');
            if (readonlyInputs.length > 0) {
                e.preventDefault();
                toastr.error('Cannot submit form with readonly fields.');
                return false;
            }
        });

         // Handle Enter key press in input fields
        $(".enable_change_btn input[type='text']").on('keydown', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault(); // Prevent form submission
                return false;
            }
        });

        $(".enable_change_btn input,.enable_change_btn select").on('change paste switchChange.bootstrapSwitch', function () {
            if ($(this).hasClass('readonly-checkbox') && $(this).attr('readonly')) {
                return; // Skip AJAX call for readonly checkboxes
            }

            let form = $(this).closest('form').serializeArray();
            let formData= new FormData();
            $.each(form, function (key, input) {
                formData.append(input.name, input.value);
            });
            formData.append('avatar_location', $('.picture')[0].files[0]);
            $.ajax({
                url: $(this).closest('form').attr('action'),
                type: "POST",
                data:formData,
                processData: false,
                contentType: false,
                success: function(response){
                    toastr.success(response.message);
                    if(response.status == true){
                        $(document).find('.split-table tr.active .user-status-label').replaceWith(response.active);
                    }
                },
                error: function(error){
                    toastr.error('Something went wrong. Please try again later!')
                }
            });
        });
    });
</script>
@endsection