@extends('frontend.layouts.split')

@section('content')

<h1 class="page-title"> Consumables Order</h1>
{{ html()->form('POST', route('frontend.store-consumables-order'))->attribute('id','confirm-order_form')->open() }}
<input type="hidden" id="order_submit" name="confirm_order" value="true">
<input type="hidden" id="id" name="id" value="{{ $order->id }}">
<input type="hidden" id="quantity" name="quantity" value="{{ $request->quantity }}">
<div class="row">
    <div class="col-md-6 col-sm-offset-3">
        <div class="portlet light bordered confirm-portlet">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-edit font-dark"></i>
                    <span class="caption-subject font-dark bold uppercase">MISC ORDER CONFIRMATION</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="note note-info">
                    <div class="mt-element-overlay">
                        <div class="mt-overlay-1">
                            <img class="center confirm-order-image" src="{{asset('public/img/test/blue-pads.jpg')}}"/>
                        </div>
                    </div>
                    <div class="info-box">
                        <h4 class="block">{{ $order->name }}</h4>
                        <h4>Quantity:  {{ $request->quantity }}</h4>
                        <p>{{ $order->description }}</p>
                    </div>
                </div>
            </div>
            <div class="form-actions aligned-stock-btn">
                {{ form_cancel(route('frontend.user.new-consumables-lens-order'), __('buttons.general.cancel')) }}
                {{ form_button('javascript:void(0);','Confirm Order','btn yellow mt-ladda-btn ladda-button btn-submit-order') }}
            </div>
        </div>
    </div>
</div>
{{ html()->form()->close() }}
@endsection

@push('after-scripts')
<script>
    $(function() {
            
        $("#order_submit").change(function(){
            alert("The text has been changed.");
        });            

        $('.btn-submit-order').click(function() {
            $('#confirm-order_form').submit();
        });
    })
</script>
@endpush