<?php 
use App\Models\Backend\StockOrder;
?>
@extends('frontend.layouts.split')
@section('content')
<h1>Confirm Stock Order</h1>
<div class="row" >
    <div class="text-center">
        <h3>All prices on this page are Net/Net. No further discounts applicable.</h3>
        <div class="col-md-3">
        </div>
        <div class="col-md-6">
            <h4 class="text-center"><b>Combinition Type</b></h4>
            <p class="text-center"><span class="badge bg-success"><?= ucwords(str_replace('_', ' ', $order["combinition"])) ?></span></p>
            <h4 class="text-center"><b>Patient/Reference</b></h4>
            <p>{{ $order["patient"] }}</p>
        </div>
    </div>
</div>
@if( $order["combinition"] == StockOrder::BOTH_EYES )
{{ html()->form('POST', route('frontend.store-stock-order'))->attribute('id','stock-order_form')->open() }}
<input type="hidden" name="submit_type" id="submit_type" value="submitted">
<input type="hidden" name="type"              value="stock">
<input type="hidden" name="combinition" value="{{ $order['combinition'] }}">
<input type="hidden" name="patient"           value="{{ $order['patient'] }}">
<input type="hidden" name="l_material"        value="{{ $order['l_material'] }}">
<input type="hidden" name="l_colour"          value="{{ $order['l_colour'] }}">
<input type="hidden" name="l_coating"         value="{{ $order['l_coating'] }}">
<input type="hidden" name="l_sph"             value="{{ $order['l_sph'] }}">
<input type="hidden" name="l_cyl"             value="{{ $order['l_cyl'] }}">
<input type="hidden" name="l_quantity"        value="{{ $order['l_quantity'] }}">
<input type="hidden" name="l_size"            value="{{ $order['l_size'] }}">
<input type="hidden" name="l_price"           value="{{ $order['l_price'] }}">
<input type="hidden" name="l_barcode"           value="{{ $order['l_barcode'] }}">
<input type="hidden" name="l_vendor"           value="{{ $order['l_vendor'] }}">
<input type="hidden" name="l_cards"           value="{{ $order['l_cards'] }}">
<input type="hidden" name="r_material"        value="{{ $order['r_material'] }}">
<input type="hidden" name="r_colour"          value="{{ $order['r_colour'] }}">
<input type="hidden" name="r_coating"         value="{{ $order['r_coating'] }}">
<input type="hidden" name="r_sph"             value="{{ $order['r_sph'] }}">
<input type="hidden" name="r_cyl"             value="{{ $order['r_cyl'] }}">
<input type="hidden" name="r_quantity"        value="{{ $order['r_quantity'] }}">
<input type="hidden" name="r_size"            value="{{ $order['r_size'] }}">
<input type="hidden" name="r_price"           value="{{ $order['r_price'] }}">
<input type="hidden" name="r_barcode"           value="{{ $order['r_barcode'] }}">
<input type="hidden" name="r_vendor"           value="{{ $order['r_vendor'] }}">
<input type="hidden" name="r_cards"           value="{{ $order['r_cards'] }}">
<div class="row mt-3">
    <div class="col-md-6">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <span class="caption-subject font-dark bold uppercase">Left Eye</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-bordered">
                        <tr>
                            <th>Left material</th>
                            <td>{{ $order["l_material"] }}</td>
                        </tr>
                        <tr>
                            <th>Left Colour</th>
                            <td>{{ $order["l_colour"] }}</td>
                        </tr>           
                        <tr>
                            <th>Left Coating</th>
                            <td>{{ $order["l_coating"] }}</td>
                        </tr>            
                        <tr>
                            <th>Lest SPH</th>
                            <td>{{ $order["l_sph"] }}</td>
                        </tr>            
                        <tr>
                            <th>Left CYL</th>
                            <td>{{ $order["l_cyl"] }}</td>
                        </tr>            
                        <tr>
                            <th>Left Qunatity</th>
                            <td>{{ $order["l_quantity"] }}</td>
                        </tr>  
                        <tr>
                            <th>Left Size</th>
                            <td>{{ $order["r_size"] }}</td>
                        </tr>            
                        <tr>
                            <th>Left Price</th>
                            <td>{{ $order["l_price"] }}</td>
                        </tr>            
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <span class="caption-subject font-dark bold uppercase">Right Eye</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-bordered">
                        <tr>
                            <th>Right Material</th>
                            <td>{{ $order["r_material"] }}</td>
                        </tr>
                        <tr>
                            <th>Right Colour</th>
                            <td>{{ $order["r_colour"] }}</td>
                        </tr>
                        <tr>
                            <th>Right Coating</th>
                            <td>{{ $order["r_coating"] }}</td>
                        </tr>
                        <tr>
                            <th>Right SPH</th>
                            <td>{{ $order["r_sph"] }}</td>
                        </tr>
                        <tr>
                            <th>Right CYL</th>
                            <td>{{ $order["r_cyl"] }}</td>
                        </tr>
                        <tr>
                            <th>Right Qunatity</th>
                            <td>{{ $order["r_quantity"] }}</td>
                        </tr>
                        <tr>
                            <th>Right Size</th>
                            <td>{{ $order["r_size"] }}</td>
                        </tr>
                        <tr>
                            <th>Right Price</th>
                            <td>{{ $order["r_price"] }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="form-actions aligned-stock-btn">
            {{ form_cancel(route('frontend.user.new-stock-lens-order'), __('buttons.general.cancel')) }}
            {{ form_button('javascript:void(0);','Confirm Order','btn yellow mt-ladda-btn ladda-button btn-submit-order') }}
        </div>
    </div>
</div>
{{ html()->form()->close() }}
@else
<div class="row mt-3">
    @if( $order["combinition"] == StockOrder::LEFT_EYE )
    {{ html()->form('POST', route('frontend.store-stock-order'))->attribute('id','stock-order_form')->open() }}
        <input type="hidden" name="submit_type" id="submit_type" value="submitted">
        <input type="hidden" name="type"              value="stock">
        <input type="hidden" name="combinition" value="{{ $order['combinition'] }}">
        <input type="hidden" name="patient"           value="{{ $order['patient'] }}">
        <input type="hidden" name="l_material"        value="{{ $order['l_material'] }}">
        <input type="hidden" name="l_colour"          value="{{ $order['l_colour'] }}">
        <input type="hidden" name="l_coating"         value="{{ $order['l_coating'] }}">
        <input type="hidden" name="l_sph"             value="{{ $order['l_sph'] }}">
        <input type="hidden" name="l_cyl"             value="{{ $order['l_cyl'] }}">
        <input type="hidden" name="l_quantity"        value="{{ $order['l_quantity'] }}">
        <input type="hidden" name="l_size"            value="{{ $order['l_size'] }}">
        <input type="hidden" name="l_price"           value="{{ $order['l_price'] }}">
        <div class="col-md-12">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject font-dark bold uppercase">Left Eye</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover table-bordered">
                            <tr>
                                <th>Left material</th>
                                <td>{{ $order["l_material"] }}</td>
                            </tr>
                            <tr>
                                <th>Left Colour</th>
                                <td>{{ $order["l_colour"] }}</td>
                            </tr>           
                            <tr>
                                <th>Left Coating</th>
                                <td>{{ $order["l_coating"] }}</td>
                            </tr>            
                            <tr>
                                <th>Left SPH</th>
                                <td>{{ $order["l_sph"] }}</td>
                            </tr>            
                            <tr>
                                <th>Left CYL</th>
                                <td>{{ $order["l_cyl"] }}</td>
                            </tr>            
                            <tr>
                                <th>Left Qunatity</th>
                                <td>{{ $order["l_quantity"] }}</td>
                            </tr>  
                            <tr>
                                <th>Left Size</th>
                                <td>{{ $order["l_size"] }}</td>
                            </tr>            
                            <tr>
                                <th>Left Price</th>
                                <td>{{ $order["l_price"] }}</td>
                            </tr>            
                        </table>
                    </div>
                </div>
            </div>
            <div class="form-actions aligned-stock-btn">
                {{ form_cancel(route('frontend.user.new-stock-lens-order'), __('buttons.general.cancel')) }}
                {{ form_button('javascript:void(0);','Confirm Order','btn yellow mt-ladda-btn ladda-button btn-submit-order') }}
            </div>
        </div>
        {{ html()->form()->close() }}
    @elseif( $order["combinition"] == StockOrder::LEFT_EYE )
    {{ html()->form('POST', route('frontend.store-stock-order'))->attribute('id','stock-order_form')->open() }}
    <input type="hidden" name="submit_type" id="submit_type" value="submitted">
    <input type="hidden" name="type"              value="stock">
    <input type="hidden" name="combinition" value="{{ $order['combinition'] }}">
    <input type="hidden" name="patient"           value="{{ $order['patient'] }}">
    <input type="hidden" name="r_material"        value="{{ $order['r_material'] }}">
    <input type="hidden" name="r_colour"          value="{{ $order['r_colour'] }}">
    <input type="hidden" name="r_coating"         value="{{ $order['r_coating'] }}">
    <input type="hidden" name="r_sph"             value="{{ $order['r_sph'] }}">
    <input type="hidden" name="r_cyl"             value="{{ $order['r_cyl'] }}">
    <input type="hidden" name="r_quantity"        value="{{ $order['r_quantity'] }}">
    <input type="hidden" name="r_size"            value="{{ $order['r_size'] }}">
    <input type="hidden" name="r_price"           value="{{ $order['r_price'] }}">
        <div class="col-md-12">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject font-dark bold uppercase">Right Eye</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover table-bordered">
                            <tr>
                                <th>Right material</th>
                                <td>{{ $order["r_material"] }}</td>
                            </tr>
                            <tr>
                                <th>Right Colour</th>
                                <td>{{ $order["r_colour"] }}</td>
                            </tr>           
                            <tr>
                                <th>Right Coating</th>
                                <td>{{ $order["r_coating"] }}</td>
                            </tr>            
                            <tr>
                                <th>Lest SPH</th>
                                <td>{{ $order["r_sph"] }}</td>
                            </tr>            
                            <tr>
                                <th>Right CYL</th>
                                <td>{{ $order["r_cyl"] }}</td>
                            </tr>            
                            <tr>
                                <th>Right Qunatity</th>
                                <td>{{ $order["r_quantity"] }}</td>
                            </tr>  
                            <tr>
                                <th>Right Size</th>
                                <td>{{ $order["r_size"] }}</td>
                            </tr>            
                            <tr>
                                <th>Right Price</th>
                                <td>{{ $order["r_price"] }}</td>
                            </tr>            
                        </table>
                    </div>
                </div>
            </div>
            <div class="form-actions aligned-stock-btn">
                {{ form_cancel(route('frontend.user.new-stock-lens-order'), __('buttons.general.cancel')) }}
                {{ form_button('javascript:void(0);','Confirm Order','btn yellow mt-ladda-btn ladda-button btn-submit-order') }}
            </div>
        </div>
        {{ html()->form()->close() }}
    @endif
</div>
@endif
@endsection

@push('after-scripts')
<script>
    $(function () {
        $(".btn-submit-order").on('click',function(e){
            $('#submit_type').val('submitted');
            $('#stock-order_form').submit();
        });
    });
</script>
@endpush

