@extends('frontend.layouts.split')

@section('title', 'Consumable Orders' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())


@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-basket font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Consumables </span>
                </div>
                <div class="actions">
                    @if(Gate::check('frontend create orders') || Gate::check('frontend admin'))
                        <button class="btn green">
                            <a href="{{ route('frontend.user.new-consumables-lens-order') }}"  data-toggle="tooltip" title="@lang('New Consumable Order')" style="color:#fff; text-decoration: none;">Add New</a>
                        </button>
                    @endif
                </div>
            </div>
            <div class="portlet-body">
                @include('frontend.auth.orders.includes.orders-search-form', compact('orders', 'pageCount'))
                <div class="order-list">
                    <div class="row">
                        <div class="col-md-12 p-0" style="margin-top:5%">
                            <div class="col-md-4 p-0 table-data-container adjust_height-container">
                                @include('partials.orderlist', compact('orders', 'pageCount'))
                            </div>
                            <div class="col-md-8">
                                <div class="tabbable-custom nav-justified order-details-container box-shadow">
                                    <ul class="nav nav-pills nav-justified">
                                        <li class="nav-item">
                                            <a href="#tab_order" data-toggle="tab" class="nav-link active tab_order"> Order </a>
                                        </li>
                                        <li>
                                            <a href="#tab_comments" data-toggle="tab" class="data-tabs tab_comments" data-value="comments" data-id="comment-tab-wrapper"> Comments </a>
                                        </li>
                                        <li>
                                            <a href="#tab_invoice" data-toggle="tab" class="data-tabs tab_invoice" data-value="invoice" data-id="tab_invoice"> Invoice </a>
                                        </li>
                                    </ul>
                                    <div class="tab-content">
                                        <div class="tab-pane active" id="tab_order">
                                            <center><h3>Click to view <i class="fa fa-shopping-cart" aria-hidden="true"></i></h3></center>
                                        </div>
                                        <div class="tab-pane" id="tab_comments">
                                            <div id="comment-tab-wrapper">
                                            </div>
                                        </div>
                                        <div class="tab-pane" id="tab_invoice">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dt-more-container text-center">
                    <button type="button" class="btn blue mt-ladda-btn ladda-button btn-outline btn-circle" id="load-more-btn" data-style="slide-up" data-spinner-color="#333" data-attr="table-data-container" <?= (!$orders->hasMorePages()) ? 'disabled' : '' ?>>
                        <span class="ladda-label"> <i class="icon-arrow-down"></i>  Load More</span>
                        <span class="ladda-spinner"></span>
                    </button>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
@endsection