<?php 
use App\Models\Backend\OrderStatus;
use App\Models\Backend\Order;
?>
<style type="text/css">
    .input-group .form-control:last-child{
        height: 34px;
    }
</style>
<form action="@if(isset($isBackend) && $isBackend){{route('admin.auth.search-orders')}}@else{{route('frontend.search-orders')}}@endif" method="POST" id="orders_search_form">
    @csrf
    <div class="table-container" style="padding: 15px 0;">
        <div class="row" id="search_form">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="">Search</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fa fa-th-list" aria-hidden="true"></i>
                        </span>
                        <input type="text" class="form-control form-filter input-sm" name="search" placeholder="Search Order, Invoice and Patient Reference">
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                @include('partials.order_status_select', ['type' => 'customer'])
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="">Date Range</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fa fa-calendar"></i>
                        </span>
                        <input type="text" name="date_range" id="date_range" class="form-control" placeholder="Date Range" data-date-format="mm/dd/yyyy" readonly="readonly">
                        <input type="hidden" name="from_date" id="from_date">
                        <input type="hidden" name="to_date" id="to_date">
                    </div>
                </div>
            </div>
            <div class="col-md-3 justify-content-end" style="margin-top:21px;">
                <button type="submit" class="btn blue me-2" id="search_button">
                    <i class="fa fa-search" aria-hidden="true"></i> Search
                </button>
                <button type="button" class="btn red" id="reset_search">Clear</button>
            </div>
        </div>
    </div>
</form>
