@extends('frontend.layouts.print')

@section('title', 'Order #'.$order->getOrderNumber(). ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<style>
    .svg-icons-order {
        width: 16px;
        height: 18px;
        position: relative;
        top: 4px;
    }
</style>
<table width="700" align="center" cellpadding="0" cellspacing="0" border="0" class="contentarea">
    <tbody><tr>
        <td>
            <table width="100%" cellpadding="0" cellspacing="0" border="0">
                <tbody><tr>
                    <td valign="top" align="center">
                        <table width="700" cellpadding="0" cellspacing="0" border="0" class="tabletext">

                            <tbody><tr>
                                <td colspan="4">
                                    <table width="100%" cellpadding="0" cellspacing="0" border="0">
                                        <tbody><tr height="30px" font="red" class="headerFooter">
                                            <td align="left">{{ $order->getOrderNumber() }}</td>
                                            <td align="right">{{ $order->getOrderNumber() }}</td>
                                        </tr>
                                        <tr>
                                            <td valign="top" width="25%"><img src="{{ URL::asset('public/img/backend/brand/logo.gif') }}" height="40" alt="Lens Shapers Logo"></td>
                                            <td valign="middle" align="center"><h2 class="GriffonLight">{{ $order->online ? 'Web Order #' : 'Offline Order # ' }} {{ $order->getOfflineOrderNumber() }}</h2></td>
                                        </tr>
                                    </tbody></table>
                                </td>
                            </tr>
                            <tr class="rowtopborder">
                                <td valign="top" width="15%" align="left">Account Name</td>
                                <td valign="top" width="35%" align="left"><b>{!! $user->getBusinessName() !!}</b></td>
                                <td valign="top" width="15%" align="left">{{ $order->online ? 'Web Order No.' : 'Offline Order No. ' }}</td>
                                <td valign="top" align="left"><b>{{$order->getOfflineOrderNumber()}}</b></td>
                            </tr>
                                                            <tr>
                                <td valign="top" align="left">Account No.</td>
                                <td valign="top" align="left"><b>{{ $user->ac_code }}</b></td>
                                <td valign="top" align="left">Submitted on</td>
                                <td valign="top" align="left"><b>{{ date_time_format($order->created_at,'d-M-Y h:i a')}}</b></td>
                            </tr>
                            <tr>
                                <td valign="top" align="left">Address</td>
                                <td valign="top" align="left"><b>{!! $user->getAddress() !!}</b></td>
                                <td valign="top" align="left">Job Type</td>
                                <td valign="top" align="left"><b>{!! $order->type_label !!} Order</b></td>
                            </tr>
                        </tbody></table>
                    </td>
                </tr>
                <tr><td style="height:5px;"></td></tr>
                
            </tbody>
        </table>
        <div style="width: 100%; border: 1px solid #ddd;">
            <!-- Header -->
            <div style="background-color: #C7DCEC; border-bottom: 1px solid #ddd; padding: 8px; text-align: center; font-weight: bold;">
                Consumables Order Detail
            </div>
        
            <?php if ($order->consumableModals->count() > 0) { ?>
                <!-- Column Headers -->
                <div style="display: flex; border-bottom: 1px solid #ddd; background-color: #f5f5f5;">
                    <div style="width: 20%; border-right: 1px solid #ddd; padding: 8px; font-weight: bold;">Quantity</div>
                    <div style="width: 80%; border-right: 1px solid #ddd; padding: 8px; font-weight: bold;">Item</div>
                </div>
        
                <?php $total = 0; ?>
                @foreach ($order->consumableModals as $key => $value)
                    <!-- Row Data -->
                    <div style="display: flex;  solid #ddd;">
                        <div style="width: 20%;  solid #ddd; padding: 8px;">{{ $value->quantity }}x</div>
                        <div style="width: 80%;  solid #ddd; padding: 8px;">{{ $value->name }} - {{ $value->sub_name }}</div>
                    </div>
                @endforeach
            <?php } else { ?>
                <!-- No Consumables Found -->
                <div style="padding: 8px; text-align: center; color: #999;">
                    No Consumables Found
                </div>
            <?php } ?>
        </div>
</td>
</tr>
</tbody></table>
@endsection