@extends('frontend.layouts.customer-login')

@section('title', __('labels.frontend.passwords.reset_password_box_title') . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')

    {{ html()->form('POST', route('frontend.auth.password.email.post'))->class('login-form')->open() }}
    <h3 class="form-title">@lang('labels.frontend.passwords.reset_password_box_title')</h3>
    <div class="form-group">
        {{ html()->label('Customer Code')->for('ac_code_display') }}
        <div class="input-icon">
            <i class="fa fa-code"></i>
            <input type="text" id="ac_code_display" class="form-control" placeholder="Enter your AC Code" maxlength="191" required autofocus>
            <input type="hidden" name="ac_code" id="ac_code_hidden">
        </div>
        <div id="ac_code_error" class="text-danger" style="display: none;"></div>
    </div>
    <div class="form-actions">
        {{ form_submit(__('labels.frontend.passwords.send_password_reset_link_button')) }}
    </div>
    <script>
        document.getElementById('ac_code_display').addEventListener('blur', function() {
            var acCode = this.value.trim();
            var errorDiv = document.getElementById('ac_code_error');
            errorDiv.style.display = 'none';
            errorDiv.textContent = '';
            if (acCode) {
                fetch('{{ route("frontend.auth.password.get-business-name") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({ ac_code: acCode })
                })
                .then(response => {
                    if (!response.ok) {
                        return response.json().then(err => { throw err; });
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.business_name) {
                        document.getElementById('ac_code_display').value = acCode + ' - ' + data.business_name;
                        document.getElementById('ac_code_hidden').value = acCode;
                    } else {
                        document.getElementById('ac_code_hidden').value = acCode;
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    if (error.errors && error.errors.ac_code) {
                        errorDiv.textContent = error.errors.ac_code[0];
                        errorDiv.style.display = 'block';
                    } else {
                        errorDiv.textContent = 'Invalid Customer Code';
                        errorDiv.style.display = 'block';
                    }
                    document.getElementById('ac_code_hidden').value = acCode;
                });
            } else {
                document.getElementById('ac_code_hidden').value = '';
            }
        });
    </script>
    {{ html()->form()->close() }}
@endsection
