@extends('frontend.layouts.split')

@section('title', 'Credit Memos' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fas fa-file-alt font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> CREDIT MEMOS </span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="order-list">
                    <div class="row">
                        <div class="col-lg-6 col-md-12 p-0 table-data-container adjust_height-container nscroller" style="padding: 0;">
                            <div class="table-responsive scrollable-container" id="records-container">
                                <table class="table table-striped table-bordered table-hover order-column box-shadow credit-memos split-table">
                                    <thead>
                                        <tr role="row" class="heading">
                                            <th>
                                                <span class="d-block">Credit #</span>
                                            </th>
                                            <th width="20%">
                                                <span class="d-block">Credit Date</span>
                                            </th>
                                            <th width="28%">
                                                <span class="d-block">Patient Reference</span>
                                            </th>
                                            <th>
                                                <span class="d-block">Original Invoice</span>
                                            </th>
                                            <th>
                                                <span class="d-block">Amount</span>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($creditMemos as $value)
                                            <tr data-id="{{ $value['credit_number'] }}">
                                                <td>
                                                    <span class="d-block">
                                                        {{ $value['credit_number'] }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="d-block">
                                                        {{ date('d-M-Y',strtotime($value['date'])) }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="d-block">
                                                        {{ $value['patient_reference'] }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="d-block">
                                                        {{ $value['doc_no'] }}
                                                    </span>
                                                </td>
                                                <td class="text-right" style="padding-right: 13px;">
                                                    <span class="d-block">
                                                        ${{ number_format($value['credit_amount'],2) }}
                                                    </span>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12 p-0">
                            <div class="tabbable-custom nav-justified order-details-container box-shadow" id="order-details-container">
                                <ul class="nav nav-pills nav-justified">
                                    <li class="nav-item">
                                        <a href="#tab_details" data-toggle="tab" class="nav-link active tab_details" aria-expanded="true"></a>
                                    </li>
                                </ul>
                                <div class="tab-content" data-height-set="true">
                                    <div class="tab-pane active tab_data-container" id="tab_details">
                                        <center><h3>Choose a credit memo on left to see details...</h3></center>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
@endsection
@push('after-scripts')
<script type="text/javascript">
    var url = "{{ route('frontend.credit-memos.file') }}";
    $(function() {
        $('.credit-memos tbody tr').on('click',function(e){
            // Handle row selection
            $('.split-table tbody tr').removeClass('active');
            $(this).addClass('active');

            let fileName = $(this).attr('data-id');
            $.ajax({
                url: url,
                type: "POST",
                data:{id:fileName,_token:'{{ csrf_token() }}'},
                success: function(data){
                    var html = '<object data="'+data+'" type="application/pdf" width="100%" height="100%"><iframe src="'+data+'" width="100%" height="100%"></iframe></object>';
                    // var html = '<iframe src="'+data+'" width="100%" height="100%"></iframe>';
                     $('.tab-content .tab_data-container').html(html);
                },
            });
        });
    });
</script>
@endpush