<?php $unreadNotifications = $logged_in_user->unreadNotifications(); ?>
<nav class="navbar navbar-expand-lg mega-menu" role="navigation">
    <div class="container-fluid">
        <div class="clearfix fixed-top d-flex align-items-center">
            <!-- Brand and toggle get grouped for better mobile display -->
            <button type="button" class="navbar-toggler" data-toggle="collapse" data-target=".navbar-responsive-collapse">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- End Toggle Button -->
            <!-- BEGIN LOGO -->
            <a id="index" class="page-logo" href="{{ route('frontend.user.common.dashboard') }}" style="text-align: center;">
                <img src="{{ URL::asset('img/backend/brand/logo.png') }}" alt="Logo"> </a>
            <!-- END LOGO -->
            <!-- BEGIN HEADER MENU -->
            <div class="nav-collapse collapse navbar-collapse navbar-responsive-collapse">
                <ul class="navbar-nav">
                    <li class="dropdown dropdown-fw dropdown-fw-disabled {{
                        active_class(Active::checkUriPattern('dashboard'),'selected active open')
                    }}">
                        <a href="{{ route('frontend.user.common.dashboard') }}" class="text-uppercase">
                            <i class="icon-home"></i> Dashboard </a>
                            <!-- {!! svg_image('dashboard.svg', 'svg-icons', 'Dashboard') !!} @lang('Dashboard') -->
                        </a>
                    </li>
                    <li class="dropdown dropdown-fw dropdown-fw-disabled {{ active_class(Active::checkRoute('frontend.user.orders'),'selected active open') }}">
                        <a href="{{ route('frontend.user.orders') }}" class="text-uppercase">
                              <i class="icon-basket-loaded"></i> Orders </a>
                             <!-- {!! svg_image('orders-menu.svg', 'svg-icons', 'Orders') !!} @lang('Orders') -->
                        </a>
                    </li>
                    @if(auth()->user()->isAcessible(['view frontend']))
                        @if(auth()->user()->isAcessible(['frontend admin']) || auth()->user()->isOrderPlacedPermission())
                            <li class="dropdown dropdown-fw dropdown-fw-disabled hover-open-list {{ active_class(Active::checkUriPattern('orders/create*'),'mselected active') }}">
                                <a href="javascript:void(0);" class="text-uppercase">
                                    <i class="icon-basket"></i> New Order </a>
                                    <!-- {!! svg_image('new-orders.svg', 'svg-icons', 'New Order') !!} @lang('New Order') -->
                                </a>
                                <ul class="dropdown-menu dropdown-menu-fw dropdown-menu-child">
                                    <li class="{{ active_class(Active::checkUriPattern('orders/create/rx-lens'),'active') }}">
                                        <a href="{{ route('frontend.user.new-rx-lens-order') }}">
                                            <img src="{{ asset('img/orders/rx.svg') }}" class="type-icons"> <span class="">Rx Lenses</span> </a>
                                            <!-- {!! svg_image('rx.svg', 'svg-icons', 'Rx Lenses') !!} @lang('Rx Lenses') -->
                                        </a>
                                    </li>
                                    @if(auth()->user()->isStockUser())
                                        <li class="{{ active_class(Active::checkUriPattern('orders/create/stock-lens'),'selected active open') }}">
                                            <a href="{{ route('frontend.user.new-stock-lens-order') }}">
                                                <img src="{{ asset('img/orders/sv-g_(stock).svg') }}" class="type-icons"> Stock Lenses </a>
                                                <!-- {!! svg_image('stock.svg', 'svg-icons', 'Stock Lenses') !!} @lang('Stock Lenses') -->
                                            </a>
                                        </li>
                                    @endif
                                    <li class="{{ active_class(Active::checkUriPattern('orders/create/consumeables*'),'active') }}">
                                        <a href="{{ route('frontend.user.new-consumables-lens-order') }}">
                                            <img src="{{ asset('img/orders/consumeable.svg') }}" class="type-icons"> Consumables </a>
                                            <!-- {!! svg_image('consumable.svg', 'svg-icons', 'Consumables') !!} @lang('Consumables') -->
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        @endif
                        <li class="dropdown dropdown-fw dropdown-fw-disabled {{ active_class(Active::checkRoute('frontend.user.saved-orders'),'selected active open') }}">
                            <a href="{{ route('frontend.user.saved-orders') }}" class="text-uppercase">
                                <i class="fa fa-save"></i> Saved Orders
                                <!-- {!! svg_image('saved-order.svg', 'svg-icons', 'Saved Orders') !!} @lang('Saved Orders') -->
                                @php 
                                    $savedOrdersCount = \App\Models\Backend\Order::where('user_id', auth()->user()->getCustomerAdmin()->id)->where('is_saved',1)->get()->count();
                                @endphp
                                @if($savedOrdersCount > 0)
                                    <span class="badge badge-danger saved-badge notifications-badge">{{ $savedOrdersCount }}</span>
                                
                                @endif
                            </a>
                        </li>
                        <li class="dropdown dropdown-fw dropdown-fw-disabled {{ active_class(Active::checkUriPattern('notifications'),'selected active open') }}" id="notification-header-link">
                            <a href="{{ route('frontend.user.notifications') }}" class="text-uppercase">
                                <i class="fa fa-bell"></i> Notifications 
                                <!-- <img class="svg-icons" src="{{ asset('public/storage/svg/notification.svg') }}" alt="Notifications"></img> -->
                                <!-- Notifications  -->
                                @if(count($unreadNotifications) > 0)
                                    <span class="badge badge-danger notifications-badge-counter">{{ count($unreadNotifications) }}</span>
                                @else
                                    <span class="badge badge-danger notifications-badge-counter"></span>
                                @endif
                            </a>
                        </li>
                        @can('frontend admin')
                            @if($logged_in_user->isStatementAccessible())
                                <li class="dropdown dropdown-fw dropdown-fw-disabled {{ active_class(Active::checkUriPattern('statements'),'selected active open') }}">
                                    <a href="{{ route('frontend.statements.index') }}" class="text-uppercase">
                                        <i class="fas fa-file-invoice"></i> Statements </a>
                                        <!-- {!! svg_image('statements.svg', 'svg-icons', 'Statements') !!} @lang('Statements') -->
                                    </a>
                                </li>
                            @endif
                            <li class="dropdown dropdown-fw dropdown-fw-disabled {{ active_class(Active::checkRoute('frontend.credit-memos.index'),'selected active open') }}">
                                <a href="{{ route('frontend.credit-memos.index') }}" class="text-uppercase">
                                     <i class="fas fa-file-alt"></i> Credit Memos </a>
                                    <!-- {!! svg_image('credit-memo.svg', 'svg-icons', 'Credit Memos') !!} @lang('Credit Memos') -->
                                </a>
                            </li>
                            <li class="dropdown dropdown-fw dropdown-fw-disabled {{ active_class(Active::checkUriPattern('account'),'selected active open') }}">
                                <a href="{{ route('frontend.user.account') }}" class="text-uppercase">
                                     <i class="fa fa-cogs"></i> Settings </a>
                                    <!-- {!! svg_image('setting.svg', 'svg-icons', 'Settings') !!} @lang('Settings') -->
                                </a>
                            </li>
                        @endcan
                    @endif
                </ul>
            </div>
            <!-- END HEADER MENU -->
            <!-- BEGIN TOPBAR ACTIONS -->
            <div class="topbar-actions">
                <!-- END GROUP NOTIFICATION -->
                <!-- BEGIN USER PROFILE -->
                <div class="btn-group-img btn-group">
                    <button type="button" class="btn btn-sm md-skip dropdown-toggle profile-btn" data-toggle="dropdown">
                        <span class="text-center">
                             {{ $logged_in_user->name }} <i class="fa fa-arrow-down"></i> <br>
                            <!-- {{ $logged_in_user->name }} <img class="svg-icons" src="{{ asset('public/storage/svg/arrow-down.svg') }}" alt="Arrow Down"></img> <br> -->
                            {{ $logged_in_user->ac_code }} - {{ $logged_in_user->getCustomerAdmin()->getBusinessName() }}
                        </span>
                        @if(!$logged_in_user->getCustomerAdmin()->isGravatar())
                            <img class="avatar" src="{{ $logged_in_user->getCustomerAdmin()->picture }}" alt="">
                        @else
                            <img class="avatar" src="{{ $logged_in_user->getCustomerAdmin()->picture }}" alt="" style="display: none;">
                        @endif
                    </button>
                    <ul class="dropdown-menu dropdown-menu-v2 dropdown-menu-start" role="menu">
                        <li>
                            <a href="{{ route('frontend.user.common.dashboard') }}">
                                <i class="icon-home"></i> @lang('Dashboard') </a>
                                <!-- {!! svg_image('dashboard.svg', 'svg-icons', 'Dashboard') !!} @lang('Dashboard') </a> -->
                        </li>
                        <li>
                            <a href="{{ route('frontend.user.orders') }}">
                                <i class="icon-basket-loaded"></i> @lang('Orders') </a>
                                <!-- {!! svg_image('orders-menu.svg', 'svg-icons', 'Orders') !!} @lang('Orders') </a> -->
                        </li>
                        <li>
                            <a href="{{ route('frontend.user.account') }}#notifications">
                                 <i class="fa fa-bell"></i> @lang('Notifications') </a>
                                <!-- {!! svg_image('notification.svg', 'svg-icons', 'Notifications') !!} @lang('Notifications') </a> -->
                        </li>
                        <li>
                            <a href="{{ route('frontend.user.account') }}#account">
                                <i class="fa fa-cogs"></i> Settings
                            </a>
                                <!-- {!! svg_image('setting.svg', 'svg-icons', 'Settings') !!} @lang('Settings') </a> -->
                        </li>
                        @can('frontend admin')
                        @endcan
                        @if (session()->has('admin_user_id') && session()->has('temp_user_id'))
                            <li>
                                {!! $logged_in_user->back_to_admin_button !!}
                            </li>
                        @endif
                        <li>
                            <a href="{{ route('frontend.auth.logout') }}">
                                <i class="icon-key"></i> Log Out </a>
                                <!-- <img class="svg-icons" src="{{ asset('public/storage/svg/logout.svg') }}" alt="Log Out"></img> Log Out </a> -->
                        </li>
                    </ul>
                </div>
                <!-- END USER PROFILE -->
            </div>
            <!-- END TOPBAR ACTIONS -->
        </div>
    </div>
    <!--/container-->
</nav>