<!DOCTYPE html>
@langrtl
    <html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
@else
    <html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@endlangrtl
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <title>@yield('title', app_name())</title>
        <meta name="description" content="@yield('meta_description', 'Lens Shapers')">
        <meta name="author" content="@yield('meta_author', 'Lens Shapers')">
        @yield('meta')
        @stack('before-styles')
        
        @stack('after-styles')
    </head>
    <body class="login" style="background: url('{{ URL::asset('assets/pages/media/bg/3.jpg') }}') no-repeat center center fixed; background-size: cover;">
        @include('includes.partials.messages')
        <div class="logo">
            <a href="javascript:void(0);">
                <img src="{{ URL::asset('img/backend/brand/logo.png') }}" alt="" />
            </a>
        </div>
        <div class="content">
            @yield('content')
        </div>

        <!-- Scripts -->
        @stack('before-scripts')
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        @stack('after-scripts')
    </body>
</html>
