<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>@yield('title', app_name())</title>
    @stack('before-styles')
    <style type="text/css">
        body {
            display: block;
            margin: 8px;
            font-family: Arial, Verdana, Helvetica, sans-serif;
        }
        .position-relative{
            position: relative;
        }
        .barcode-text{
            position: absolute;left: 16px;bottom: -7px;font-size: 12px;
        }
        .wd120ht15border { height:15px; width:120px; border:1px solid #CCCCCC;}
        .wd70ht15border { height:15px; width:70px; border:1px solid #CCCCCC;}
        .wd50ht15border { height:15px; width:50px; border:1px solid #CCCCCC;}
        .wd120ht19border { height:19px; width:120px; border:1px solid #CCCCCC;}
        .wd70ht19border { height:19px; width:70px; border:1px solid #CCCCCC;}
        .wd50ht19border { height:19px; width:50px; border:1px solid #CCCCCC;}

        .subtablehead{font-family:Arial Narrow, Arial, Verdana, Helvetica, sans-serif; font-size:10px; color:#000000; background-color:#F2F2F2 ; font-weight:300;   }
        .subtablehead th{   /*line-height:22px; */ font-weight:600; text-align:left; padding:5px;  }

        .tabletext,.tableValueNames { font-family:Arial, Verdana, Helvetica, sans-serif ; /*line-height:15px;*/}
        .tabletext td, .tabletext th{ padding:2px;}
        .tabletext td table{ margin-left:-5px;}

/*        .tableValueNames { */
/*            font-family:Arial Narrow, Arial, Verdana, Helvetica, sans-serif ; font-size:10px; */
            /*line-height:15px;*/ 
/*            color:#585858*/
/*        }*/
        .labels{
            font-size: 10px !important;
        }
        .text-values{
            font-size: 14px !important;
        }
        .tableValueNames td, .tabletext th{ padding:3px;}
        .tableValueNames td table{ margin-left:-5px;}
        .tableValueNames td{  border-bottom: none; }

        .tableValues { font-family:Arial, Verdana, Helvetica, sans-serif ; font-size:15px; /*line-height:15px;*/}
        .tableValues td, .tabletext th{ padding-left:5px;}
        .tableValues td table{ margin-left:-5px;}

        .safeBg{    background:#ffffff; }
        .vldMessage{background:#FF0000 url(images/validation-message.gif) no-repeat 5px center; padding:5px 5px 5px 55px; margin:15px auto; font-weight:700; }
        .blankVld { height:0px;}
        .eMsgBg{    background:#FF0000; }
        .font10{    font-size:10px; font-family:Arial, Verdana; }

        .rxValues{  font-family:Arial, Verdana, Helvetica, sans-serif ; font-size:16px ;}
        .rxValues td, .tabletext th{ padding-left:5px;}
        .rxValues td table{ margin-left:-5px;}

        .bggray{    background:#F2F2F2; }
        .dottedborder{ border: solid 1px #BDBDBD; border-collapse:collapse; }
        .rowtopborder td{   border-top:1px solid #BDBDBD;   }
        .rowbtmborder td{   border-bottom:1px solid #BDBDBD;    }

        .cropped {
            width: 100%; /* width of container */
            height: auto !important; /* height of container */
            overflow: hidden;
        }

        .cropped2 {
            width: 100%; /* width of container */
            height: 25px; /* height of container */
            overflow: hidden;
        }
        
         .cropped3 {
            width: 100%; /* width of container */
            height: 15px; /* height of container */
            overflow: hidden;
        }

    </style>
    <link rel="shortcut icon" href="{{asset('public/favicon.ico')}}" />

    @stack('after-styles')
</head>
<body>
    @yield('content')
    @stack('before-scripts')
    {!! script(URL::asset('public/assets/global/plugins/jquery.min.js')) !!}
    <script type="text/javascript">
        $(function() {
            if(checkUrlParam('action')){
                window.print();
            }
        });
        function checkUrlParam(name){
            var results = new RegExp('[\?&]' + name + '=([^&#]*)')
                      .exec(window.location.search);
            return (results !== null) ? results[1] || 0 : false;
        }
    </script>
    @stack('after-scripts')
</body>
</html>
