@extends('frontend.layouts.split')

@section('title', 'Account Statements' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable">
            <div class="portlet-title" style="border-bottom: none;">
                <div class="caption">
                    <i class="fas fa-file-alt font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Account Statements </span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="order-list">
                    <div class="row">
                        <div class="col-md-12 p-0">
                            <div class="col-md-3 p-0 table-data-container">
                                <div class="table-responsive">
                                    <div class="tabbable-custom nav-justified order-details-container box-shadow">
                                        <ul class="nav nav-pills nav-justified">
                                            <li class="nav-item">
                                                <!-- <a href="#tab_details" data-toggle="tab" class="tab_details"> Details </a> -->
                                            </li>
                                        </ul>
                                        <div class="tab-content">
                                            <div class="tab-pane active nscroller ps" id="tab_details" style="height:700px">
                                                <div id="statements_tree" class="demo jstree jstree-1 jstree-default" role="tree" aria-multiselectable="true" tabindex="0" aria-activedescendant="demo_root_1" aria-busy="false"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-9 p-0">
                                <div class="tabbable-custom nav-justified order-details-container box-shadow">
                                    <ul class="nav nav-pills nav-justified">
                                        <li class="nav-item">
                                            <a href="#tab_details" data-toggle="tab" class="nav-link active tab_details">  </a>
                                        </li>
                                    </ul>
                                    <div class="tab-content">
                                        <div class="tab-pane active tab_statements" id="tab_details" style="height:660px">
                                            <center><h3>Choose a statement on left to see details...</h3></center>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
@endsection
@push('after-scripts')
{{ style(URL::asset('public/assets/global/plugins/jstree/dist/themes/default/style.min.css')) }}
{!! script(URL::asset('public/assets/global/plugins/jstree/dist/jstree.min.js')) !!}
<style type="text/css">
    .jstree-node{
        font-size: 16px;
    }
    .tab-content object{
        width: 100%;
        height: 100%;
    }
</style>
<script type="text/javascript">
    var url = "{{ route('frontend.statements.file') }}";
    $(function() {
        $('#statements_tree').jstree({
            'plugins': ["wholerow", "types"],
            'core': {
                "themes" : {
                    "responsive": false,
                    // "variant" : "large"
                },    
                'data' : {
                  'url' : "{{ route('frontend.statements.load-content-api') }}",
                  'type':'POST',
                  'async':true,
                  'data' : function (node) {
                    return { 'id' : node.id,'parent' : node.parent,_token: '{{csrf_token()}}' };
                  }
                }
            },
            "types" : {
                "default" : {
                    "icon" : "fa fa-folder"
                },
                "file" : {
                    "icon" : "fa fa-file"
                }
            },
        });
        $('#statements_tree').on('changed.jstree', function (e, data) {
            var node = $('#statements_tree').jstree(true).get_bottom_selected();
            node = $('#statements_tree').jstree(true).get_node(node);
            if(node && node.data != null){
                let fileName = node.data.path;
                let name = node.text;
                $.ajax({
                    url: url,
                    type: "POST",
                    data:{id:fileName,name:name,_token:'{{ csrf_token() }}'},
                    success: function(data){
                        var randomParam = Math.random();
                        var html = '<iframe src="'+data+'?rand='+randomParam+'" width="100%" height="100%"></iframe>';
                         $('.tab-content .tab_statements').html(html);
                    },
                });
                // var html = '<object data="'+node.data.url+'" type="application/pdf"><iframe src="'+node.data.url+'"></iframe></object>';
                // $('.tab-content .tab_statements').html(html);
                // console.log(node);
            }
        });
    });
</script>
@endpush