{{ html()->form('PATCH', route('frontend.auth.password.update'))->class('form-horizontal')->open() }}
<div class="form-group col">
    <div class="col-md-12">
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-picture font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Change Password </span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div class="portlet-body">
                @if($logged_in_user->isTempPass())
                <div class="alert alert-danger" role="alert">For security reasons, please change your temporary password before proceeding.</div>
                @endif
                @if(!$logged_in_user->isTempPass())
                <div class="form-group">
                    {{ html()->label('Current Password')->for('old_password') }}

                    {{ html()->password('old_password')
                        ->class('form-control')
                        ->placeholder('Current Password')
                        ->autofocus()
                        ->required()
                            }}
                </div><!--form-group-->
                @endif
                <div class="form-group">
                    {{ html()->label('New Password')->for('password') }}

                    {{ html()->password('password')
                        ->class('form-control')
                        ->placeholder('New Password')
                        ->required()
                            }}
                </div><!--form-group-->

                <div class="form-group">
                    {{ html()->label('New Password Again')->for('password_confirmation') }}

                    {{ html()->password('password_confirmation')
                        ->class('form-control')
                        ->placeholder('New Password Again')
                        ->required()
                            }}
                </div><!--form-group-->
                <div class="form-actions text-right">
                    {{ form_submit(__('labels.general.buttons.update') . ' ' . __('validation.attributes.frontend.password')) }}
                </div>
            </div>
        </div>
    </div>
</div>
{{ html()->form()->close() }}
