@extends('frontend.layouts.split')
@section('layout_mode', 'app')

@section('title', __('labels.backend.access.users.management') . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . __('labels.backend.access.users.deactivated'))

@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row mt-4">
            <div class="colmd-12">
                 <!-- BEGIN EXAMPLE TABLE PORTLET-->
                 <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <span class="caption-subject bold uppercase"> {{ __('labels.backend.access.users.management') }}</span>
                                <small class="text-muted">@lang('labels.backend.access.users.deactivated')</small>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="table-toolbar">
                            </div>
                            <table class="table table-striped table-bordered table-hover table-checkable order-column table-data_table" id="sample_1"">
                                <thead>
                                    <tr>
                                        <th>@lang('labels.backend.access.users.table.first_name')</th>
                                        <th>@lang('labels.backend.access.users.table.last_name')</th>
                                        <th>@lang('labels.backend.access.users.table.email')</th>
                                        <th>@lang('labels.backend.access.users.table.confirmed')</th>
                                        <th>@lang('labels.backend.access.users.table.roles')</th>
                                        <th>@lang('labels.backend.access.users.table.other_permissions')</th>
                                        <th>@lang('labels.backend.access.users.table.social')</th>
                                        <th>@lang('labels.backend.access.users.table.last_updated')</th>
                                        <th>@lang('labels.general.actions')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if($users->count())
                                        @foreach($users as $user)
                                        <tr class="odd gradeX">
                                            <td style="text-align:left; padding-left:12px;">{{ $user->first_name }}</td>
                                            <td>{{ $user->last_name }}</td>
                                            <td><a href="mailto:{{$user->email}}"> {{$user->email}} </a></td>
                                            <td>{!! $user->confirmed_label !!}</td>
                                            <td>{!! $user->roles_label !!}</td>
                                            <td>{!! $user->permissions_label !!}</td>
                                            <td>{!! $user->social_buttons !!}</td>
                                            <td>{{ $user->updated_at->diffForHumans() }}</td>
                                            <td>{!! $user->action_buttons !!}</td>
                                        </tr>
                                        @endforeach
                                    @else
                                        <tr><td colspan="9"><p class="text-center">@lang('strings.backend.access.users.no_deactivated')</p></td></tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- END EXAMPLE TABLE PORTLET-->
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {!! $users->total() !!} {{ trans_choice('labels.backend.access.users.table.total', $users->total()) }}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {!! $users->render() !!}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection
