@extends('frontend.layouts.split')

@section('title', __('labels.backend.access.users.management') . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . __('labels.backend.access.users.edit'))

@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection

@section('content')
    {{ html()->modelForm($user, 'PATCH', route('frontend.user.update', $user->id))->class('form-actions top')->open() }}
    <input type="hidden" name="roles" value="5">
    <div class="row" style="margin-top:25px">
        <div class="col-md-12">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <h4 class="card-title mb-0 caption-subject bold">
                        @lang('labels.backend.access.users.management')
                        <small class="text-muted">@lang('labels.backend.access.users.edit')</small>
                    </h4>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.first_name'))->class('control-label')->for('first_name') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-user"></i>
                                        </span>
                                        {{ html()->text('first_name')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.first_name'))
                                            ->attribute('maxlength', 191)
                                            ->required()
                                            ->autofocus() }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.last_name'))->class('control-label')->for('last_name') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-user"></i>
                                        </span>
                                        {{ html()->text('last_name')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.last_name'))
                                            ->attribute('maxlength', 191)
                                            ->required() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.email'))->class('control-label')->for('email') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-envelope"></i>
                                        </span>
                                        {{ html()->email('email')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.email'))
                                            ->attribute('maxlength', 191)
                                            ->required() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row" style="margin-top:30px">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label('Enabled')->class('col-md-4 control-label style-lable')->for('confirmed') }}
                                    <div class="input-group">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            {{ html()->checkbox('confirmed', true)->class('make-switch')->attribute('data-on-color','primary')->attribute('data-off-color','danger')->attribute('data-on-text','Yes')->attribute('data-off-text','No') }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions right">
                        {{ form_cancel(route('admin.auth.user.index'), __('buttons.general.cancel')) }}
                        {{ form_submit(__('buttons.general.crud.update')) }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{ html()->form()->close() }}
<input type="hidden" value="{{$roles}}" class="get-roles">
@endsection