<style>
    .frame-container {
        display: flex;
        flex-direction: column;
        height: 93vh;
        overflow: hidden;
    }
    
    .frame-header {
        background: white;
        z-index: 1000;
        padding: 15px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .frame-content {
        flex: 1;
        overflow-y: auto;
        padding: 15px;
    }
    
    /* Header Container */
    .header-container {
        background: white;
        padding: 15px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        width: 100%;
        /* overflow: hidden; */
        position: relative;
        z-index: 1000;
    }

    .bootstrap-select {
        z-index: 1001 !important;
    }

    /* Dropdown Menu Fix */
    .dropdown-menu {
        z-index: 1002 !important; /* Higher than selectpicker */
        position: absolute;
    }

    /* Table Container - Ensure Proper Stacking */
    .frame-content {
        position: relative;
        z-index: 1; /* Regular stacking level */
    }

    /* Modal Backdrop Fix (if needed) */
    .modal-backdrop {
        z-index: 1040; /* Below modal but above everything else */
    }

    .modal {
        z-index: 1050; /* Above backdrop */
    }
    
    /* Child Container - Flex Layout */
    .child-container {
        display: flex;
        flex-wrap: nowrap;
        justify-content: space-between;
        align-items: center;
        gap: 15px;
        width: 100%;
    }
    
    /* Left Section - Counter and Timestamp */
    .left {
        display: flex;
        align-items: center;
        gap: 15px;
        flex-shrink: 0;
    }
    
    .counter-box {
        background: #4CAF50;
        color: white;
        padding: 5px 10px;
        border-radius: 4px;
        font-weight: bold;
    }
    
    .crontab {
        white-space: nowrap;
        font-size: 0.9em;
        color: #666;
    }
    
    /* Right Section - Filters and Buttons */
    .right {
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        gap: 8px; /* Reduced gap between items */
        justify-content: flex-start; /* Changed from flex-end to flex-start */
        flex-grow: 1;
        min-width: 0;
        margin-left: 0; /* Ensure no left margin */
        padding-left: 0; /* Ensure no left padding */
    }
    
    /* Input Groups - Dropdowns and Buttons */
    .input-group {
        display: contents;
        flex-shrink: 0; /* Changed from 1 to prevent shrinking */
        min-width: 0;
        margin-right: 0; /* Remove any right margin */
    }
    
    /* Select Dropdowns */
    .selectpicker {
        min-width: 120px  !important;
        max-width: 200px;
        margin-right: 0; /* Remove right margin */
    }
    
    /* Buttons */
    .btn {
        white-space: nowrap;
        padding: 6px 12px;
        margin-right: 0; /* Remove right margin */
    }
    
    /* Form Switch */
    .form-check.form-switch {
        white-space: nowrap;
        padding-left: 2.5em;
        margin-right: 0; /* Remove right margin */
    }
    
    /* Responsive Adjustments */
    @media (max-width: 1200px) {
        .right {
            gap: 8px;
        }
        .selectpicker {
            min-width: 120px !important;
        }
    }
    
    @media (max-width: 992px) {
        .child-container {
            flex-wrap: wrap;
        }
        .left {
            order: 1;
            width: 100%;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .right {
            order: 2;
            width: 100%;
            justify-content: space-between;
        }
    }
    
    @media (max-width: 768px) {
        .right {
            gap: 6px;
        }
        .input-group {
            flex-basis: calc(50% - 5px);
            margin-bottom: 10px;
        }
        .selectpicker {
            width: 100% !important;
            min-width: 100% !important;
        }
    }
    
    @media (max-width: 576px) {
        .left {
            flex-direction: column;
            align-items: flex-start;
            gap: 5px;
        }
        .right {
            flex-direction: column;
            align-items: stretch;
        }
        .input-group {
            flex-basis: 100%;
        }
        .btn {
            width: 100%;
        }
    }

@media (max-width: 768px) {
    .bootstrap-select .dropdown-toggle {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    .bootstrap-select.show .dropdown-toggle {
        white-space: normal;
    }
}
</style>
<div class="header-container">
    <div class="child-container">
        <div class="left">
            <div class="counter-box colored">
                <span class="counter">{{ $count }}</span>
            </div>
            <span class="crontab">{{ $cronStamp }}</span>
        </div>
        <div class="right">
            <!-- Package Dropdown -->
            <div class="input-group">
                <select name="package" data-size="10" id="packageDropdown" class="selectpicker show-tick packageDropdown" data-show-subtext="true" data-live-search="true">
                    <option value="">Select Package</option>
                    @foreach($packageCollection as $key => $value)
                        <option value="{{ $key }}" id="{{ $key }}" {{ $selectedPackageId == $key ? 'selected' : '' }}>{{ $value }}</option>
                    @endforeach
                </select>
            </div>

            <!-- Price Dropdown -->
            <div class="input-group">
                <select name="price" data-size="10" id="priceDropdown" class="selectpicker show-tick priceDropdown" data-show-subtext="true" data-live-search="true">
                    <option value="">Price Filter</option>
                    @foreach($priceFilters as $key => $value)
                        <option value="{{ $key }}" id="{{ $key }}" {{ $selectedPriceFilterId == $key ? 'selected' : '' }}>{{ $value }}</option>
                    @endforeach
                </select>
            </div>

             <!-- Status Dropdown -->
              <div class="input-group">
                <select name="status" data-size="10" id="statusDropdown" class="selectpicker show-tick statusDropdown" data-show-subtext="true" data-live-search="true">
                    <option value="">Select Status</option>
                   @foreach($statusFilter as $key => $value)
                        <option value="{{ $key }}" id="{{ $key }}" {{ $selectedStatusFilterId == $key ? 'selected' : '' }}>{{ $value }}</option>
                    @endforeach
                </select>
            </div>

            <!-- Manufacturer Dropdown -->
            <div class="input-group">
                <select name="manufacturer" data-size="10" id="manufacturerDropdown" class="selectpicker show-tick manufacturerDropdown" data-show-subtext="true" data-live-search="true">
                    <option value="">Select Manufacturer</option>
                    <option value="all" id="all" {{ $selectedManufacturerId == 'all' ? 'selected' : '' }}>All</option>
                    @foreach($manufacturersCollection as $manufacturer)
                        <option value="{{ $manufacturer['manufacturer_id'] }}" id="{{ $manufacturer['manufacturer_id'] }}" {{ $selectedManufacturerId == $manufacturer['manufacturer_id'] ? 'selected' : '' }}>
                            {{ $manufacturer['manufacturer_name'] }}
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- Brand Dropdown -->
            <div class="input-group">
                <select name="brand" data-size="10" id="brandDropdown" class="selectpicker show-tick brandDropdown" data-show-subtext="true" data-live-search="true">
                    <option value="">Select Brand</option>
                    @foreach($brandsCollection as $brand)
                        <option value="{{ $brand['brand_id'] }}" id="{{ $brand['brand_id'] }}" {{ $selectedBrandId == $brand['brand_id'] ? 'selected' : '' }}>
                            {{ $brand['brand_name'] }}
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- Model Dropdown -->
              <div class="input-group">
                <select name="model" data-size="10" id="modelDropdown" class="selectpicker show-tick modelDropdown" data-show-subtext="true" data-live-search="true">
                    <option value="">Select Model</option>
                    @foreach($modelsCollection as $model)
                        <option value="{{ $model['name'] }}" id="{{ $model['name'] }}" {{ $selectedModelName == $model['name'] ? 'selected' : '' }}>
                            {{ $model['name'] }}
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- Action Buttons -->
            <div class="input-group">
                <a href="#" class="btn red" id="resetButton">Reset</a>
            </div>

            <div class="input-group">
                <div class="form-check form-switch">
                    <input class="grouping-toggle-event" data-toggle="toggle" type="checkbox" id="frameGrouping">
                    <label class="form-check-label">Frames Grouping</label>
                </div>
            </div>

            <div class="input-group">
                <button onclick="importInHouseModel()" class="btn bg-warning text-dark" style="border-color: #6c757d">Import Frames</button>
            </div>

            <div class="input-group">
                <button onclick="exportToCSV()" class="btn bg-warning text-dark" style="border-color: #6c757d">Export CSV</button>
            </div>
        </div>
    </div>
</div>