<style>
    .table thead th {
        position: sticky;
        top: -2px;
        z-index: 1;
        border: none !important;
        background: #C7DCEC !important;
    }

    .table th, 
    .table td {
        border-left: none !important;
        border-right: none !important;
    }

    .table th, .table td {
        width: 10%;
     }
    /* .table th:nth-child(1), .table td:nth-child(1) {
        width: 13%;
    } */
    .table th:nth-child(2), .table td:nth-child(2) {
        width: 29%;
    }
    .table th:nth-child(3), .table td:nth-child(3) {
        width: 27%;
    }
    .table th:nth-child(4), .table td:nth-child(4) {
        width: 34%;
    }

   .table.not-backend th:nth-child(1), .table.not-backend td:nth-child(1) {
        width: 5%;
    }
    .table.not-backend th:nth-child(3), .table.not-backend td:nth-child(3) {
        width: 16%;
    }
    .table.not-backend th:nth-child(4), .table.not-backend td:nth-child(4) {
        width: 33%;
    }
    .table.not-backend th:nth-child(5), .table.not-backend td:nth-child(5) {
        width: 27%;
    }
</style>
<!-- resources/views/partials/orderlist.blade.php -->
<table class="table table-striped table-bordered table-hover order-column split-table box-shadow {{ !isset($isBackend) ? 'not-backend' : '' }}" data-more="<?= (!empty($orders) && $orders->hasMorePages()) ? 'yes' : 'no' ?>" data-page="<?= $pageCount ?>">
        <thead>
            <tr role="row" class="heading">
                @if(isset($isBackend) && $isBackend)
                    <th> 
                        <span class="d-block">Order #</span>
                        <span class="d-block">Invoice #</span>
                    </th>
                    <th> 
                        <span class="d-block">Patient Reference</span>
                        <span class="d-block">Order Date</span>
                    </th>
                    <th> 
                        <span class="d-block">Customer</span>
                    </th>
                    <th> 
                        <span class="d-block">Status</span>
                    </th>
                @else
                    <th>
                        <span class="d-block">Order #</span>
                    </th>
                    <th>
                        <span class="d-block">Patient Reference</span>
                    </th>
                    <th>
                        <span class="d-block">Order Date</span>
                    </th>
                    <th>
                        <span class="d-block">Status</span>
                    </th>
                    <th>
                        <span class="d-block">Expected</span>
                    </th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php
                // Determine selected order id from $orderId or query param
                $selectedOrderId = $orderId ?? (request('order') ? intval(request('order')) : null);
            @endphp
            @foreach ($orders as $order)
                <tr data-id="{{ $order->id }}" class="position-relative{{ ($selectedOrderId && $selectedOrderId == $order->id) ? ' active selected' : '' }}" id="tr_order-{{ $order->id }}" type="{{$order->type}}">
                    @if(isset($isBackend) && $isBackend)
                        <td>
                            <span class="d-block">
                                {!! $order->getMethodIcon() !!} {{ $order->getOrderNumber() }}
                            </span>
                            <span class="d-block">
                                {{ $order->invoice_no }}
                            </span>
                        </td>
                        <td class="position-relative">
                            <span class="d-block">
                                {{ $order->getPatient() }}
                            </span>
                            <span class="ship-date">
                                {{ $order->getOrderDate() }}
                            </span>
                        </td>
                        <td>
                            <span class="d-block">
                                {{ optional($order->user)->ac_code ? optional($order->user)->ac_code . ' - ' . optional($order->user)->getBusinessName() : '' }}
                            </span>
                        </td>
                        <td>
                            {!! $order->getStatusLabelAttribute(true) !!}
                            @php
                                $count = $order->unread_notifications_count ?? 0;
                            @endphp
                            @if($count > 0)
                                <span class="badge badge-danger order_notification-counter">{{$count}}</span>
                            @else
                                <span class="badge badge-danger order_notification-counter" style="display:none;">0</span>
                            @endif
                        </td>
                    @else
                        <td>
                            <span class="d-block">
                                {!! $order->getMethodIcon() !!} {{ $order->getOrderNumber() }}
                            </span>
                        </td>
                        <td>
                            <span class="d-block">
                                {{ $order->getPatient() }}
                            </span>
                        </td>
                        <td>
                            <span class="d-block">
                                {{ $order->getOrderDate('d-M-Y') }}
                            </span>
                        </td>
                        <td>
                            <span class="d-block">
                                {!! $order->getStatusLabelAttribute(true) !!}
                            </span>
                        </td>
                        <td>
                            <span class="d-block">
                                {{ !empty($order->eta) ? date('d-M-Y',strtotime($order->eta)) : '' }}
                            </span>
                            @php
                                $count = $order->unread_notifications_count ?? 0;
                            @endphp
                            @if($count > 0)
                                <span class="badge badge-danger order_notification-counter">{{$count}}</span>
                            @else
                                <span class="badge badge-danger order_notification-counter" style="display:none;">0</span>
                            @endif
                        </td>
                    @endif
                </tr>                                
            @endforeach
        </tbody>
   </table>
       <script>
        function ensureSelectedOrderRow() {
            var selectedOrderId = "{{ $selectedOrderId }}";
            if (selectedOrderId) {
                var rows = document.querySelectorAll('.split-table tbody tr');
                rows.forEach(function(row) {
                    if (row.getAttribute('data-id') == selectedOrderId) {
                        row.classList.add('selected');
                    } else {
                        row.classList.remove('selected');
                    }
                });
            }
        }
        ensureSelectedOrderRow();
        window.ensureSelectedOrderRow = ensureSelectedOrderRow;
    </script>
    @push('after-scripts')
        <script>
            $(document).ajaxComplete(function() {
                if (typeof window.ensureSelectedOrderRow == 'function') {
                    window.ensureSelectedOrderRow();
                }
            });
        </script>
    @endpush