<div class="order-summary-grid">
    <div class="order-info-row add-border {{ $type != 'consumables' ? 'stock' : 'consumables' }} {{ $isCustomerAdmin ? '' : 'admin' }}">
        <div class="order-info-column">
            <div class="order-info-header">Customer</div>
            <div class="order-info-value {{ $type == 'stock' ? 'status' : '' }}"><b>{{ $order->user->ac_code }} - {{ $order->user->getBusinessName() }}</b></div>
        </div>
        <div class="order-info-column">
            <div class="order-info-header">Submitted On</div>
            <div class="order-info-value"><b>{{ date_time_format($order->created_at,'d-M-Y h:i a') }}</b></div>
        </div>
        @if($type == 'stock')
            <div class="order-info-column">
                <div class="order-info-header">Patient/Reference</div>
                <div class="order-info-value"><b>{{ $stockOrder->order->patient }}</b></div>
            </div>
        @endif

        @if($type == 'rx')
            <div class="order-info-column">
                <div class="order-info-header">Patient/Reference</div>
                <div class="order-info-value"><b>{{ $rxOrderArray['name']  }}</b></div>
            </div>
        @endif
        
        <div class="order-info-column">
            <div class="order-info-header">
                @if($type == 'stock')
                    {{ $stockOrder->order->online ? 'Web Order No.' : 'Offline Order No.' }}
                @else
                    {{ $isCustomerAdmin ? 'Order No' : ($order->online ? 'Web Order No.' : 'Offline Order No.') }}
                @endif
            </div>
            <div class="order-info-value"><b>
                @if($type == 'stock')
                    {{ $isCustomerAdmin ? $stockOrder->order->getOfflineOrderNumber() : $stockOrder->order->getOrderNumber() }}
                @else
                    {{ $isCustomerAdmin ? $order->getOfflineOrderNumber() : $order->getOrderNumber() }}
                @endif
            </b></div>
        </div>
    </div>

    <div class="order-info-row customer-admin">

        <div class="order-info-column admin">
            <div class="order-info-header admin">Order Type</div>
            <div class="order-info-value admin order-type-value">
                <span class="order-type-label">{!! $order->type_label !!}</span>
            </div>
        </div>

        <div class="order-info-column">
            <div class="order-info-header">Invoice</div>
            <div class="order-info-value"><b>{{ $order->invoice_no }}</b></div>
        </div>
        <div class="order-info-column">
            <div class="order-info-header">Tray</div>
            <div class="order-info-value"><b>{{ $order->tray }}</b></div>
        </div>

        <div class="order-info-column">
            <div class="order-info-header">Status</div>
            <div class="order-info-value status">
                {!! $order->getTrakingStatus(true) !!}
            </div>
        </div>

        <div class="order-info-column">
           @if(!empty($order->tracking_no))
                <div class="order-info-header">Tracking Info</div>
                    @switch(strtolower($order->shipping_carrier))
                        @case('ics')
                            <div class="order-info-value" tracking_no="{{ $order->tracking_no }}" data-ship-type="{{ $order->shipping_carrier }}">
                                <b>ICS Tracking # <a target="_blank" href="http://www.icscourier.ca/online-services/tracking.aspx?trackNums={{ $order->tracking_no }}">{{ $order->tracking_no }}</a></b>
                            </div>
                            @break
                        @case('fedex')
                            <div class="order-info-value" tracking_no="{{ $order->tracking_no }}" data-ship-type="{{ $order->shipping_carrier }}">
                                <b>FedEx Tracking # <a target="_blank" href="https://www.fedex.com/apps/fedextrack/?action=track&trackingnumber={{ $order->tracking_no }}">{{ $order->tracking_no }}</a></b>
                            </div>
                            @break
                        @case('ups')
                            <div class="order-info-value" tracking_no="{{ $order->tracking_no }}" data-ship-type="{{ $order->shipping_carrier }}">
                                <b>UPS Tracking # <a target="_blank" href="http://wwwapps.ups.com/WebTracking/track?track=yes&trackNums={{ $order->tracking_no }}">{{ $order->tracking_no }}</a></b>
                            </div>
                            @break
                    @endswitch
            @else
                <div class="order-info-header">ETA</div>
                <div class="order-info-value"><b>{{ $order->eta ? $order->eta->format('Y-m-d') : '' }}</b></div>
            @endif
        </div>
       
      
    </div>
</div>