@php
$isCustomerAdmin = auth()->user()->hasRole('customer_admin') ? auth()->user()->hasRole('customer_admin') : auth()->user()->hasRole('customer_staff');
$user = $order->user ?? $order->user;
$orderNumber = $isCustomerAdmin ? ($order->getOfflineOrderNumber() ?? $order->getOfflineOrderNumber()) : ($order->getOrderNumber() ?? '');
@endphp

<div class="order-info-container">
    <!-- Order Information -->
    @include('partials.ordersummary.details',[
            'isCustomerAdmin' => $isCustomerAdmin,
            'order' => $order,
            'type' => 'rx',
            'user' => $user,
            'rxOrderArray' => $rxOrderArray,
            'rxOrder' => $rxOrder
        ])
    @if($order->online != 0)
        <!-- Reference and Package Info -->
            @if($order->isRedo() || !empty($rxOrderArray['package']['label']) || !empty($rxOrderArray['multipair_ref']))
                <div class="reference-header-section">
                    <div class="reference-header-grid">
                        @if($order->isRedo())
                        <div class="reference-header-column">
                            <div class="reference-header">Redo Reference</div>
                            <div class="reference-value">W{{$order->reason_oid}}: {{ $order->reason_type }}<br>{{ $order->reason_notes }}</div>
                        </div>
                        @endif
                        
                        @if(!empty($rxOrderArray['package']['label']))
                        <div class="reference-header-column">
                            <div class="reference-header">Package</div>
                            <div class="reference-value">{{ $rxOrderArray['package']['label'] }}</div>
                        </div>
                        @endif
                        
                        @if(!empty($rxOrderArray['multipair_ref']))
                        <div class="reference-header-column">
                            <div class="reference-header">Multi-Pair</div>
                            <div class="reference-value">{{ $rxOrderArray['multipair_ref'] }}</div>
                        </div>
                        @endif
                    </div>
                </div>
            @endif

        <!-- Scrollable Content Box -->
        <div class="scrollable-content-box {{ $isCustomerAdmin ? '' : 'admin-view' }}">
            <div class="order-summary-container">
                <div class="rx-order-table {{ $isCustomerAdmin ? 'customer-view' : 'admin-view' }}">
                    <!-- Lenses Section -->
                    <div class="rx-section">
                        <div class="section-header">
                            <span>Rx Lenses</span>
                            @if(!$isCustomerAdmin)
                                <div class="lens-price-col">Price</div>
                            @endif
                        </div>
                        <div class="rx-lens-row">
                            <div class="rx-side-col">R</div>
                            <div class="rx-lens-details">
                                @if(isset($rxOrderArray['lens_group']))
                                    {!! implode(', ', $rxOrderArray['lens_group']['att_values']) !!}
                                @elseif(!empty($rxOrderArray['distance']['right_dist_type']) && strtolower($rxOrderArray['distance']['right_dist_type']) != 'order')
                                    {{ $rxOrderArray['distance']['right_dist_type'] }}
                                @else
                                    {!! implode(', ', array_filter([
                                            $rxOrderArray['lens']['lens_type'] ?? '',
                                            $rxOrderArray['lens']['sub_type'] ?? '',
                                            $rxOrderArray['lens']['lens_name'] ?? '',
                                            $rxOrderArray['lens']['lens_material'] ?? '',
                                            $rxOrderArray['lens']['lens_filter'] ?? '',
                                            $rxOrderArray['lens']['lens_colour'] ?? '',
                                            $rxOrderArray['lens']['coating_name'] ?? '',
                                            $rxOrderArray['lens']['coating_colour'] ?? ''
                                        ])) 
                                    !!}
                                @endif
                            </div>
                            @if(!$isCustomerAdmin && !empty($rxOrderArray['prices']['right_lens_type']))
                                <div class="rx-price-col">${{ $rxOrderArray['prices']['right_lens_type'] }}</div>
                            @endif
                        </div>
                        <div class="rx-lens-row">
                            <div class="rx-side-col">L</div>
                            <div class="rx-lens-details">
                                @if(isset($rxOrderArray['lens_group']))
                                    {!! implode(', ', $rxOrderArray['lens_group']['att_values']) !!}
                                @elseif(!empty($rxOrderArray['distance']['left_dist_type']) && strtolower($rxOrderArray['distance']['left_dist_type']) != 'order')
                                    {{ $rxOrderArray['distance']['left_dist_type'] }}
                                @else
                                    {!! implode(', ', array_filter([
                                            $rxOrderArray['lens']['lens_type'] ?? '',
                                            $rxOrderArray['lens']['sub_type'] ?? '',
                                            $rxOrderArray['lens']['lens_name'] ?? '',
                                            $rxOrderArray['lens']['lens_material'] ?? '',
                                            $rxOrderArray['lens']['lens_filter'] ?? '',
                                            $rxOrderArray['lens']['lens_colour'] ?? '',
                                            $rxOrderArray['lens']['coating_name'] ?? '',
                                            $rxOrderArray['lens']['coating_colour'] ?? ''
                                        ])) 
                                    !!}
                                @endif
                            </div>
                            @if(!$isCustomerAdmin && !empty($rxOrderArray['prices']['left_lens_type']))
                                <div class="rx-price-col">${{ $rxOrderArray['prices']['left_lens_type'] }}</div>
                            @endif
                        </div>
                    </div>
                    <!-- Distance Section -->
                    <div class="rx-v-table">
                        <div class="rx-v-row rx-v-header">
                            <div class="rx-v-cell rx-v-side-col"></div>
                            @foreach($rxOrderArray['distance']['label'] as $key =>$value)
                                @if($value != '')
                                    <div class="rx-v-cell rx-v-data-col">{{$value}}</div>
                                @endif
                            @endforeach
                                <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                        <div class="rx-v-row">
                            <div class="rx-v-cell rx-v-side-col">R</div>
                            @foreach($rxOrderArray['distance']['right'] as $key =>$value)
                                @if($key != '')
                                    <div class="rx-v-cell rx-v-data-col">{{$value}}</div>
                                @endif
                            @endforeach
                            <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                        <div class="rx-v-row">
                            <div class="rx-v-cell rx-v-side-col">L</div>
                            @foreach($rxOrderArray['distance']['left'] as $key =>$value)
                                @if($key != '')
                                    <div class="rx-v-cell rx-v-data-col">{{$value}}</div>
                                @endif
                            @endforeach
                            <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                        @if(!empty($rxOrderArray['intermediateStrengthText']))
                            <div class="rx-v-row">
                                <div class="rx-v-cell rx-v-side-col"></div>
                                <div class="rx-v-cell">
                                    <div class="rx-v-note-col-nowrap">{{ $rxOrderArray['intermediateStrengthText'] }}</div>
                                </div>
                            </div>
                        @endif
                    </div>

                    <!-- Reading Section -->
                    <div class="rx-v-table">
                        <div class="rx-v-row rx-v-header">
                            <div class="rx-v-cell rx-v-side-col"></div>
                            @foreach($rxOrderArray['reading']['label'] as $key =>$value)
                                <div class="rx-v-cell rx-v-data-col">{{$value}}</div>
                            @endforeach
                            <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                        <div class="rx-v-row">
                            <div class="rx-v-cell rx-v-side-col">R</div>
                            @foreach($rxOrderArray['reading']['right'] as $key =>$value)
                                <div class="rx-v-cell rx-v-data-col">{{ $value }}</div>
                            @endforeach
                        </div>
                        <div class="rx-v-row">
                            <div class="rx-v-cell rx-v-side-col">L</div>
                            @foreach($rxOrderArray['reading']['left'] as $key =>$value)
                                <div class="rx-v-cell rx-v-data-col">{{ $value }}</div>
                            @endforeach
                            <!-- <div class="rx-v-cell rx-v-data-col"></div> -->
                        </div>
                    </div>

                    <!-- Single Info Section -->
                    <div class="rx-v-table">
                        <div class="rx-v-row rx-v-header">
                            <div class="rx-v-cell rx-v-side-col"></div>
                            @foreach($rxOrderArray['single_info']['label'] as $key =>$value)
                                <div class="rx-v-cell rx-v-data-col">{{$value}}</div>
                            @endforeach
                            <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                        <div class="rx-v-row">
                            <div class="rx-v-cell rx-v-side-col"></div>
                            @foreach($rxOrderArray['single_info']['values'] as $key =>$value)
                                <div class="rx-v-cell rx-v-data-col">{{$value}}</div>
                            @endforeach
                            <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                    </div>

                    <!-- Frame Section -->
                    <div class="rx-section">
                        <div class="section-header-row">Frame</div>
                        <div class="rx-frame-row">
                            <div class="rx-side-col"></div>
                            <div class="rx-frame-details">{{ $rxOrderArray['frame']['frame_type'] }}</div>
                        </div>
                        <div class="rx-frame-details-row">
                            <div class="rx-side-col"></div>
                            <div class="rx-frame-details">
                                @php
                                    $frameInfo = [];
                                    foreach ($rxOrderArray['frame']['frame_info']['values'] as $key => $value) {
                                        if (!empty($value)) {
                                            if ($value == '✓') {
                                                if($key == 'pof'){
                                                    $labelIndex = array_search(ucwords($key), $rxOrderArray['frame']['frame_info']['label']);
                                                    $label = $labelIndex !== false ? $rxOrderArray['frame']['frame_info']['label'][$labelIndex] : $key;
                                                    $frameInfo[] = $value . ' ' . ucwords($label);
                                                }
                                            } else {
                                                $frameInfo[] = $value;
                                            }
                                        }
                                    }
                                @endphp
                                @if (!empty($frameInfo))
                                    {!! implode(', ', $frameInfo) !!}
                                @endif
                            </div>
                        </div>
                        <div class="rx-frame-size-row">
                            <div class="rx-side-col"></div>
                            <div class="rx-frame-size-details">
                                @foreach($rxOrderArray['frame']['frame_size']['label'] as $key =>$value)
                                    @if(!empty($rxOrderArray['frame']['frame_size']['values'][$key]))
                                        <span>{{ $value }}: {{ $rxOrderArray['frame']['frame_size']['values'][$key] }}</span>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                        <div class="rx-frame-options-row">
                            <div class="rx-side-col"></div>
                            <div class="rx-frame-options">
                                <span>{{!empty($rxOrderArray['frame']['specify_thickness']) ? 'Lens Thickness: '.$rxOrderArray['frame']['specify_thickness'].',' : ''}} </span>
                                <span>{{$rxOrderArray['frame']['specify_thickness_data']['r_ct_or_et']}}</span>
                                <span>{{$rxOrderArray['frame']['specify_thickness_data']['l_ct_or_et']}}</span>
                                @if(!empty($rxOrderArray['frame']['bevel_type']))
                                    <span>Bevel Type: {{$rxOrderArray['frame']['bevel_type']}}</span>
                                @endif
                                <span>{!!$rxOrderArray['frame']['safety_stamp']!!}</span>
                                <span>{!!$rxOrderArray['frame']['edge_polish']!!}</span>
                            </div>
                        </div>
                    </div>

                    <!-- Modify Shape Section -->
                    @if(!empty($rxOrderArray['frame']['modify_shape']['a_option']))
                        <div class="rx-section">
                            <div class="section-header-row">Modify Shape</div>
                            <div class="rx-modify-shape-row">
                                <div class="rx-side-col"></div>
                                <div class="rx-modify-shape-details">
                                    <span>A: {!! $rxOrderArray['frame']['modify_shape']['a'] !!}</span>
                                    <span>{{ $rxOrderArray['frame']['modify_shape']['a_option'] }}</span>
                                    <span>{{ $rxOrderArray['frame']['modify_shape']['a_increase'] }}</span>

                                    <span>B: {!! $rxOrderArray['frame']['modify_shape']['b'] !!}</span>
                                    <span>{{ $rxOrderArray['frame']['modify_shape']['b_option'] }}</span>
                                    <span>{{ $rxOrderArray['frame']['modify_shape']['b_increase'] }}</span>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Add-ons Section -->
                    @if(!empty($rxOrderArray['additional_items']['add_clip_on']))
                        <div class="rx-section">
                            <div class="section-header-row">Add-ons</div>
                            <div class="rx-addons-row">
                                <div class="rx-side-col"></div>
                                <div class="rx-addons-details">
                                    <span>{{ $rxOrderArray['additional_items']['add_clip_on'] }}</span>
                                </div>
                                @if(!$isCustomerAdmin && !empty($rxOrderArray['prices']['custom_clip_on']))
                                    <div class="rx-price-col">${{ $rxOrderArray['prices']['custom_clip_on'] }}</div>
                                @endif
                            </div>
                            @if(!empty($rxOrderArray['additional_items']['repairs_services']))
                                @foreach($rxOrderArray['additional_items']['repairs_services'] as $key => $value)
                                    @if(!empty($value)) 
                                        <div class="rx-repairs-row">
                                            <div class="rx-side-col"></div>
                                            <div class="rx-repairs-details">
                                                <span>{{ \App\Models\Backend\RxValidations::decodeValue($value) }}</span>
                                            </div>
                                            @if(!$isCustomerAdmin && !empty($rxOrderArray['prices']['repairs_services']) && isset($rxOrderArray['prices']['repairs_services'][$key]))
                                                <div class="rx-price-col">${{ $rxOrderArray['prices']['repairs_services'][$key] }}</div>
                                            @endif
                                        </div>
                                    @endif
                                @endforeach
                            @endif
                            @if(!empty($rxOrderArray['additional_items']['repair_description']))
                                <div class="rx-repair-desc-row">
                                    <div class="rx-side-col"></div>
                                    <div class="rx-repair-desc">
                                        <span>{{ $rxOrderArray['additional_items']['repair_description'] }}</span>
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endif

                    <!-- Job Section -->
                    <div class="rx-section">
                        <div class="section-header-row">Job</div>
                        <div class="rx-job-row">
                            <div class="rx-side-col"></div>
                            <div class="rx-job-details">
                                <span>{!! $rxOrderArray['frame']['job_type'] !!}</span>
                                <span><span id="pof-field"></span></span>
                            </div>
                        </div>
                    </div>
                                
                    <!-- Total Price Section (Admin Only) -->
                    @if(!$isCustomerAdmin && (!empty($rxOrderArray['prices']['additional']) || !empty($rxOrderArray['prices']['total_price'])))
                        <div class="rx-section">
                            <!-- Additional Prices -->
                            @if(!empty($rxOrderArray['prices']['additional']))
                                <div class="rx-section">
                                    <div class="section-header-row">Additional Charges</div>
                                    @foreach($rxOrderArray['prices']['additional'] as $value)
                                        <div class="rx-addons-row">
                                            <div class="rx-side-col"></div>
                                            <div class="rx-addons-details">
                                                <span>{{ $value['label'] }}</span>
                                            </div>
                                            @if(!$isCustomerAdmin)
                                                <div class="rx-price-col">${{ $value['price'] }}</div>
                                            @endif
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    @endif
                        <!-- Instructions Section -->
                        @if(!empty($rxOrderArray['additional_items']['special_instructions']))
                            <div class="rx-section">
                                <div class="section-header-row">Instructions</div>
                                <div class="rx-instructions-row">
                                    <div class="rx-side-col"></div>
                                    <div class="rx-instructions-details">
                                        <span>{{ $rxOrderArray['additional_items']['special_instructions'] }}</span>
                                    </div>
                                </div>
                            </div>
                        @endif
                 </div>
            </div>
            @if(!$isCustomerAdmin && (!empty($rxOrderArray['prices']['additional']) || !empty($rxOrderArray['prices']['total_price'])))
                <!-- Total Price -->
                @if(!empty($rxOrderArray['prices']['total_price']))
                    <div class="total-price-container">
                        <div class="total-price-label">Total:</div>
                        <div class="total-price-value">${{ number_format($rxOrderArray['prices']['total_price'], 2) }}</div>
                    </div>
                @endif
            @endif
        </div>
    @else
            <div class="text-center mt-5">Order data not available.</div>
    @endif
</div>

<!-- Fixed Action Buttons -->
    @include('partials.actions.printbtn',[
        'isCustomerAdmin' => $isCustomerAdmin,
        'order' => $order,
        'type' => 'rx'
    ])