@if($isBackend ?? false)
    <table class="table table-striped table-hover order-column" data-more="<?= ($users->hasMorePages()) ? 'yes' : 'no' ?>" data-page="<?= $pageCount ?>" data-type="users">
        <thead>
            <tr role="row" class="heading">
                <th><span class="d-block">Account Number</span><span class="d-block">Account Name</span></th>
                <th><span class="d-block">Full Name</span><span class="d-block">User Type</span></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $value)
                <tr data-id="{{ $value->id }}">
                    <td><span class="d-block">{{ $value->ac_code }}</span><span class="d-block">{!! $value->getBusinessName() !!}</span></td>
                    <td><span class="d-block">{!! $value->full_name !!}</span><span class="d-block">{!! $value->type_label !!}{!! $value->status_label !!}</span></td>
                </tr>
            @endforeach
        </tbody>
    </table>
@else
    <table class="table table-striped table-hover order-column split-table" data-more="<?= ($users->hasMorePages()) ? 'yes' : 'no' ?>" data-page="<?= $pageCount ?>" data-type="users">
        <thead>
            <tr role="row" class="heading">
                <th><span class="d-block">Account Number</span><span class="d-block">Account Name</span></th>
                <th><span class="d-block">Full Name</span><span class="d-block">Status</span></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $value)
                <tr data-id="{{ $value->id }}">
                    <td><span class="d-block">{{ $value->ac_code }}</span><span class="d-block">{!! $value->getBusinessName() !!}</span></td>
                    <td><span class="d-block">{!! $value->full_name !!}</span><span class="d-block">{!! $value->type_label !!}{!! $value->status_label !!}</span></td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endif