<?php

use Illuminate\Http\Request;
use App\Http\Controllers\Api\OrderController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

/*Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});*/

// API Routes with API Client Authentication
Route::middleware(['api.client'])->group(function () {
    
    // Order Creation API
    Route::prefix('orders')->group(function () {
        Route::post('/consumable', [OrderController::class, 'createConsumableOrder'])->name('api.orders.create-consumable');
        Route::post('/stock', [OrderController::class, 'createStockOrder'])->name('api.orders.create-stock');
        Route::post('/rx', [OrderController::class, 'createRxOrder'])->name('api.orders.create-rx');
    });
});