<?php

use App\Http\Controllers\Backend\Auth\OrdersController;
use App\Http\Controllers\Backend\Auth\PhoneLogController;
use App\Http\Controllers\Backend\Auth\Role\RoleController;
use App\Http\Controllers\Backend\Auth\User\UserController;
use App\Http\Controllers\Backend\Auth\EmailTemplateController;
use App\Http\Controllers\Backend\Auth\ApiClientController;
use App\Http\Controllers\Backend\Auth\User\UserAccessController;
use App\Http\Controllers\Backend\Auth\User\UserSocialController;
use App\Http\Controllers\Backend\Auth\User\UserStatusController;
use App\Http\Controllers\Backend\Auth\User\UserSessionController;
use App\Http\Controllers\Backend\Auth\User\UserPasswordController;
use App\Http\Controllers\Backend\Auth\User\UserConfirmationController;

// All route names are prefixed with 'admin.auth'.
Route::group([
    'prefix' => 'auth',
    'as' => 'auth.',
    'middleware' => ['role:'.config('access.users.admin_role').'|'.config('access.users.lab_manager').'|'.config('access.users.lab_staff')]
], function () {
    // User Management
    Route::group([], function () {
        // User Status'
        Route::get('user/deactivated', [UserStatusController::class, 'getDeactivated'])->name('user.deactivated');
        Route::get('user/deleted', [UserStatusController::class, 'getDeleted'])->name('user.deleted');

        // User CRUD
        Route::get('user', [UserController::class, 'index'])->name('user.index');
        Route::post('user/search', [UserController::class, 'search'])->name('user.search');
        Route::get('user/create', [UserController::class, 'create'])->name('user.create');
        Route::post('user', [UserController::class, 'store'])->name('user.store');

        // Specific User
        Route::group(['prefix' => 'user/{user}'], function () {
            // User
            Route::get('/', [UserController::class, 'show'])->name('user.show');
            Route::get('edit', [UserController::class, 'edit'])->name('user.edit');
            Route::patch('/', [UserController::class, 'update'])->name('user.update');
            Route::delete('/', [UserController::class, 'destroy'])->name('user.destroy');
            Route::post('update-api', [UserController::class, 'updateApi'])->name('updateApi');

            // Account
            Route::get('account/confirm/resend', [UserConfirmationController::class, 'sendConfirmationEmail'])->name('user.account.confirm.resend');

            // Status
            Route::get('mark/{status}', [UserStatusController::class, 'mark'])->name('user.mark')->where(['status' => '[0,1]']);

            // Social
            Route::delete('social/{social}/unlink', [UserSocialController::class, 'unlink'])->name('user.social.unlink');

            // Confirmation
            Route::get('confirm', [UserConfirmationController::class, 'confirm'])->name('user.confirm');
            Route::get('unconfirm', [UserConfirmationController::class, 'unconfirm'])->name('user.unconfirm');

            // Password
            Route::get('password/change', [UserPasswordController::class, 'edit'])->name('user.change-password');
            Route::patch('password/change', [UserPasswordController::class, 'update'])->name('user.change-password.post');

            // Access
            Route::get('login-as', [UserAccessController::class, 'loginAs'])->name('user.login-as');

            // Session
            Route::get('clear-session', [UserSessionController::class, 'clearSession'])->name('user.clear-session');

            // Deleted
            Route::get('delete', [UserStatusController::class, 'delete'])->name('user.delete-permanently');
            Route::get('restore', [UserStatusController::class, 'restore'])->name('user.restore');
        });
    });

    // Role Management
    Route::group([], function () {
        Route::get('role', [RoleController::class, 'index'])->name('role.index');
        Route::get('role/create', [RoleController::class, 'create'])->name('role.create');
        Route::post('role', [RoleController::class, 'store'])->name('role.store');

        Route::group(['prefix' => 'role/{role}'], function () {
            Route::get('edit', [RoleController::class, 'edit'])->name('role.edit');
            Route::patch('/', [RoleController::class, 'update'])->name('role.update');
            Route::delete('/', [RoleController::class, 'destroy'])->name('role.destroy');
        });
    });

    //Email Template Management
    Route::group([], function () {
        Route::get('template', [EmailTemplateController::class, 'index'])->name('template.index');
        Route::get('template/create', [EmailTemplateController::class, 'create'])->name('template.create');
        Route::post('template', [EmailTemplateController::class, 'store'])->name('template.store');

        Route::group(['prefix' => 'template/{template}'], function () {
            Route::get('/', [EmailTemplateController::class, 'show'])->name('template.show');
            Route::get('edit', [EmailTemplateController::class, 'edit'])->name('template.edit');
            Route::patch('/', [EmailTemplateController::class, 'update'])->name('template.update');
            Route::delete('/', [EmailTemplateController::class, 'destroy'])->name('template.destroy');
        });
        Route::post('send-email', [EmailTemplateController::class, 'sendMail'])->name('template.send-mail');
    });

    //Api Client Management
    Route::group([], function () {
        Route::get('api-client', [ApiClientController::class, 'index'])->name('api-client.index');
        Route::get('api-client/create', [ApiClientController::class, 'create'])->name('api-client.create');
        Route::post('api-client/store', [ApiClientController::class, 'store'])->name('api-client.store');
        Route::group(['prefix' => 'api-client/{apiClient}'], function () {
            Route::get('/', [ApiClientController::class, 'show'])->name('api-client.show');
            Route::get('edit', [ApiClientController::class, 'edit'])->name('api-client.edit');
            Route::patch('/', [ApiClientController::class, 'update'])->name('api-client.update');
            Route::delete('/', [ApiClientController::class, 'destroy'])->name('api-client.destroy');
            Route::post('regenerate-token', [ApiClientController::class, 'regenerateToken'])->name('api-client.regenerate_token');
        });
    });

    Route::post('search-orders', [OrdersController::class, 'searchOrders'])->name('search-orders');
    Route::post('orders/lab/configuration/save', [OrdersController::class, 'saveLabOrderConfiguration'])->name('orders.lab.configuration.save');

});