<?php

use Diglactic\Breadcrumbs\Breadcrumbs;
use App\Models\Backend\Order;

Breadcrumbs::for('admin.auth.user.index', function ($trail) {
    $trail->push(__('labels.backend.access.users.management'), route('admin.auth.user.index'));
});

Breadcrumbs::for('admin.user.account', function ($trail) {
    $trail->push(__('Profile'), route('admin.user.account'));
});

Breadcrumbs::for('admin.auth.user.deactivated', function ($trail) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.deactivated'), route('admin.auth.user.deactivated'));
});

Breadcrumbs::for('admin.auth.user.deleted', function ($trail) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.deleted'), route('admin.auth.user.deleted'));
});

Breadcrumbs::for('admin.auth.user.create', function ($trail) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('labels.backend.access.users.create'), route('admin.auth.user.create'));
});

Breadcrumbs::for('admin.auth.user.show', function ($trail, $id) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.view'), route('admin.auth.user.show', $id));
});

Breadcrumbs::for('admin.auth.user.edit', function ($trail, $id) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.edit'), route('admin.auth.user.edit', $id));
});

Breadcrumbs::for('admin.auth.user.change-password', function ($trail, $id) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.change-password'), route('admin.auth.user.change-password', $id));
});

/*
 * Frontend Routes
 * Routes that are used for frontend.
 */
Breadcrumbs::for('frontend.user.index', function ($trail) {
    $trail->push(__('labels.backend.access.users.management'), route('frontend.user.index'));
});

Breadcrumbs::for('frontend.user.create', function ($trail) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('labels.backend.access.users.create'), route('frontend.user.create'));
});

Breadcrumbs::for('frontend.user.account', function ($trail) {
    $trail->push(__('Profile'), route('frontend.user.account'));
});

Breadcrumbs::for('frontend.user.dashboard', function ($trail) {
    $trail->push(__('Dashboard'), route('frontend.user.dashboard'));
});

Breadcrumbs::for('frontend.user.edit', function ($trail, $id) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.edit'), route('frontend.user.edit', $id));
});

Breadcrumbs::for('frontend.user.show', function ($trail, $id) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.view'), route('frontend.user.show', $id));
});

Breadcrumbs::for('frontend.user.deleted', function ($trail) {
    $trail->parent('admin.auth.user.index');
    $trail->push(__('menus.backend.access.users.deleted'), route('frontend.user.deleted'));
});

/*
 * Backend Orders Routes
 * Routes that are used for orders.
 */
Breadcrumbs::for('admin.orders-all', function ($trail) {
    $trail->push(__('All Orders'));
});

Breadcrumbs::for('admin.rx-lens-orders', function ($trail) {
    $trail->push(__('Rx Lens'));
});

Breadcrumbs::for('admin.stock-lens-orders', function ($trail) {
    $trail->push(__('Stock Lens'));
});

Breadcrumbs::for('admin.consumables-lens-orders', function ($trail) {
    $trail->push(__('Consumables'));
});

Breadcrumbs::for('admin.order.show', function ($trail, $order) {
    switch ($order->type) {
        case Order::ORDER_RX:
            $trail->push(__('Rx Lenses'), route('admin.rx-lens-orders'));
            break;
        case Order::ORDER_CONSUMABLE:
            $trail->push(__('Consumables'), route('admin.consumables-lens-orders'));
            break;
        case Order::ORDER_STOCK:
            $trail->push(__('Stock Lenses'), route('admin.stock-lens-orders'));
            break;
    }
    $trail->push(__($order->getOrderNumber()));
});

/*
 * Frontend Orders Routes
 * Routes that are used for orders.
 */
Breadcrumbs::for('frontend.user.orders', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.orders'));
});

Breadcrumbs::for('frontend.user.rx-lens-orders', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.rx-lens-orders'));
    $trail->push(__('RX Lens'));
});

Breadcrumbs::for('frontend.user.stock-lens-orders', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.stock-lens-orders'));
    $trail->push(__('Stock Lens'));
});

Breadcrumbs::for('frontend.user.tray-lens-orders', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.tray-lens-orders'));
    $trail->push(__('Tray Lens'));
});

Breadcrumbs::for('frontend.user.barcode-lens-orders', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.barcode-lens-orders'));
    $trail->push(__('Barcode Lens'));
});

Breadcrumbs::for('frontend.user.consumables-lens-orders', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.consumables-lens-orders'));
    $trail->push(__('Consumables Lens'));
});

/*
 * Frontend Create Orders Routes
 * Routes that are used for orders.
 */
Breadcrumbs::for('frontend.user.orders-all', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.orders-all'));
    $trail->push(__('All Orders'));
});

Breadcrumbs::for('frontend.user.new-rx-lens-order', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.new-rx-lens-order'));
    $trail->push(__('RX Lens'));
});

Breadcrumbs::for('frontend.user.new-stock-lens-order', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.new-stock-lens-order'));
    $trail->push(__('Stock Lens'));
});

Breadcrumbs::for('frontend.user.new-tray-lens-order', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.new-tray-lens-order'));
    $trail->push(__('Tray Lens'));
});

Breadcrumbs::for('frontend.user.new-barcode-lens-order', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.new-barcode-lens-order'));
    $trail->push(__('Barcode Lens'));
});

Breadcrumbs::for('frontend.user.new-consumables-lens-order', function ($trail) {
    $trail->push(__('Orders'), route('frontend.user.new-consumables-lens-order'));
    $trail->push(__('Consumables Lens'));
});

/*
 * Frontend Confirm and Store Orders Routes
 * Routes that are used for orders.
 */
Breadcrumbs::for('frontend.store-consumables-order', function ($trail) {
    $trail->push(__('Orders'), route('frontend.store-consumables-order'));
    $trail->push(__('Confirm Consumables Lens'));
});

Breadcrumbs::for('frontend.store-stock-order', function ($trail) {
    $trail->push(__('Orders'), route('frontend.store-stock-order'));
    $trail->push(__('Confirm Stock Lens'));
});

Breadcrumbs::for('frontend.confirm-stock-order', function ($trail) {
    $trail->push(__('Orders'), route('frontend.confirm-stock-order'));
    $trail->push(__('Confirm Stock Lens'));
});

/*
 * Frontend Show Orders Routes
 * Routes that are used for orders.
 */
Breadcrumbs::for('frontend.user.orders.show', function ($trail, $id) {
    $trail->push(__('Orders'), route('frontend.user.orders.show', $id));
});

Breadcrumbs::for('admin.auth.template.index', function ($trail) {
    $trail->push(__('labels.backend.access.emails.email_templates'), route('admin.auth.template.index'));
});

Breadcrumbs::for('admin.auth.template.create', function ($trail) {
    $trail->parent('admin.auth.template.index');
    $trail->push(__('labels.backend.access.emails.email_templates'), route('admin.auth.template.create'));
});

Breadcrumbs::for('admin.auth.template.store', function ($trail) {
    $trail->push(__('labels.backend.access.emails.create'), route('admin.auth.template.store'));
});

Breadcrumbs::for('admin.auth.template.show', function ($trail, $id) {
    $trail->parent('admin.auth.template.index');
    $trail->push(__('labels.backend.access.emails.email_template'), route('admin.auth.template.show', $id));
});

Breadcrumbs::for('admin.auth.template.edit', function ($trail, $id) {
    $trail->parent('admin.auth.template.index');
    $trail->push(__('menus.backend.access.temapltes.edit'), route('admin.auth.template.edit', $id));
});

Breadcrumbs::for('admin.auth.template.destroy', function ($trail) {
    $trail->parent('admin.auth.template.index');
    $trail->push(__('menus.backend.access.temapltes.deleted'), route('admin.auth.template.destroy'));
});

Breadcrumbs::for('frontend.auth.password.expired', function ($trail) {
    $trail->parent('admin.auth.template.index');
    $trail->push(__('menus.backend.access.temapltes.deleted'), route('frontend.auth.password.expired'));
});

Breadcrumbs::for('frontend.auth.user.change-password', function ($trail, $id) {
    $trail->parent('frontend.user.index');
    $trail->push(__('menus.backend.access.users.change-password'), route('frontend.auth.user.change-password', $id));
});

Breadcrumbs::for('backend.frames.index', function ($trail) {
    $trail->push('Brand Index', route('backend.frames.index'));
});