<?php

use App\Http\Controllers\Frontend\Auth\LoginController;
use App\Http\Controllers\Backend\Auth\LoginAdminController;
use App\Http\Controllers\Frontend\Auth\RegisterController;
use App\Http\Controllers\Frontend\Auth\SocialLoginController;
use App\Http\Controllers\Frontend\Auth\NotificationController;
use App\Http\Controllers\Frontend\Auth\ResetPasswordController;
use App\Http\Controllers\Frontend\Auth\ConfirmAccountController;
use App\Http\Controllers\Frontend\Auth\ForgotPasswordController;
use App\Http\Controllers\Frontend\Auth\UpdatePasswordController;
use App\Http\Controllers\Frontend\Auth\PasswordExpiredController;
use Illuminate\Support\Facades\Route;

/*
 * Frontend Access Routes
 * All route names are prefixed with 'frontend.auth.'
 */
Route::name('auth.')->group(function () {
    // These routes require the user to be logged in
    Route::middleware(['auth', 'revalidate'])->group(function () {
        /**
         * Routes for Dropbox authentication
         * If setting the access code directly, don't rely on Dropbox::getAccessToken()
         */
        Route::get('/logout', [LoginController::class, 'logout'])->name('logout');

        // For when admin is logged in as user from backend
        Route::get('/logout-as', [LoginController::class, 'logoutAs'])->name('logout-as');

        // These routes cannot be hit if the password is expired
        Route::middleware('password_expires')->group(function () {
            // Change Password Routes
            Route::patch('/password/update', [UpdatePasswordController::class, 'update'])->name('password.update');
        });

        // Password
        Route::get('/password/change/user/{user}', [ResetPasswordController::class, 'edit'])->name('user.change-password');
        Route::patch('/password/change/user/{user}', [ResetPasswordController::class, 'update'])->name('user.change-password.post');

        // Password expired routes
        Route::get('/password/expired', [PasswordExpiredController::class, 'expired'])->name('password.expired');
        Route::patch('/password/expired', [PasswordExpiredController::class, 'update'])->name('password.expired.update');
    });

    // These routes require no user to be logged in
    Route::middleware('guest')->group(function () {
        // Authentication Routes
        // Admin Login
        Route::get('/admin/login', [LoginAdminController::class, 'showLoginForm'])->name('login');
        Route::post('/admin/login', [LoginAdminController::class, 'login'])->name('login.post');

        // Socialite Routes
        // Route::get('/login/{provider}', [SocialLoginController::class, 'login'])->name('social.login');
        // Route::get('/login/{provider}/callback', [SocialLoginController::class, 'login']);

        // Registration Routes
        // Route::get('/register', [RegisterController::class, 'showRegistrationForm'])->name('register');
        // Route::post('/register', [RegisterController::class, 'register'])->name('register.post');

        // Confirm Account Routes
        Route::get('/account/confirm/{token}', [ConfirmAccountController::class, 'confirm'])->name('account.confirm');
        Route::get('/account/confirm/resend/{uuid}', [ConfirmAccountController::class, 'sendConfirmationEmail'])->name('account.confirm.resend');

        // Password Reset Routes
        Route::get('/password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.email');
        Route::post('/password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email.post');

        Route::get('/password/reset/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset.form');
        Route::post('/password/reset', [ResetPasswordController::class, 'reset'])->name('password.reset');

        // AJAX endpoint for fetching ac_codes by email
        Route::post('/password/get-ac-codes', [ResetPasswordController::class, 'getAcCodesByEmail'])->name('password.get-ac-codes');

        // AJAX endpoint for fetching business name by ac_code
        Route::post('/password/get-business-name', [ForgotPasswordController::class, 'getBusinessNameByAcCode'])->name('password.get-business-name');
    });

    Route::post('/customer-reads-all-notifications', [NotificationController::class, 'customerReadsAllNotifications'])->name('user.read-notifications');
});