<?php

use App\Http\Controllers\LanguageController;
use App\Http\Controllers\Backend\DashboardController;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\FrameStyleController;
use App\Http\Controllers\CronController;
use App\Http\Controllers\OrderStatusController;
use App\Http\Controllers\Frontend\Auth\LoginController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

/*
 * Global Routes
 * Routes that are used between both frontend and backend.
 */

// Switch between the included languages
Route::get('/lang/{lang}', [LanguageController::class, 'swap'])->name('lang.swap');

// Customer Login Routes
Route::middleware('guest')->group(function () {
    Route::get('/login', [LoginController::class, 'showCustomerLoginForm'])->name('login');
    Route::post('/login', [LoginController::class, 'customerLogin'])->name('login.post');
});

/*
 * Frontend Routes
 * Namespaces indicate folder structure
 */
Route::name('frontend.')->group(function () {
    include_route_files(__DIR__ . '/frontend/');
});

/*
 * Backend Routes
 * Namespaces indicate folder structure
 */
Route::prefix('admin')->name('admin.')->middleware('admin_group')->group(function () {
    /*
     * These routes need view-backend permission
     * (good if you want to allow more than one group in the backend,
     * then limit the backend features by different roles or permissions)
     *
     * Note: Administrator has all permissions so you do not have to specify the administrator role everywhere.
     * These routes cannot be hit if the password is expired
     */
    include_route_files(__DIR__ . '/backend/');
});

Route::get('/clear', function () {
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('config:clear');
    Artisan::call('view:clear');
    Artisan::call('config:cache');
    return 'Completed';
})->name('clear');

Route::get('/migrate', function () {
    Artisan::call('migrate:data');
    return 'Completed';
})->name('migrate');

// Frame Routes
Route::get('/frames', [FrameStyleController::class, 'index'])->name('backend.frames.index');
Route::post('/frames-collections', [FrameStyleController::class, 'syncFramesData'])->name('backend.frames.syncFramesData');
Route::post('/save-packages', [FrameStyleController::class, 'savePackages'])->name('backend.frames.savePackages');
Route::get('/get-frame-image', [FrameStyleController::class, 'getFrameImage'])->name('backend.frames.getFrameImage');
Route::post('/save-tier-price', [FrameStyleController::class, 'saveTierPrice'])->name('backend.frames.saveTierPrice');
Route::get('/model-filter', [FrameStyleController::class, 'getModelsByBrand'])->name('backend.frames.getModelsByBrand');
Route::get('/update-data', [FrameStyleController::class, 'updateStyleATable'])->name('backend.frames.updateStyleATable');
Route::post('/import-model', [FrameStyleController::class, 'importModel'])->name('backend.frames.importModel');

Route::middleware(['auth', 'admin'])->group(function () {
    // Cron Routes
    Route::get('/cron', [CronController::class, 'index'])->name('backend.cron.index');
    Route::get('/sync-cron', [CronController::class, 'syncCron'])->name('backend.cron.syncCron');
    Route::post('/save-description', [CronController::class, 'saveDescription'])->name('backend.cron.saveDescription');
    Route::get('/get-logs', [CronController::class, 'getLogs'])->name('backend.cron.getLogs');

    // OrderStatus Routes
    Route::get('/list', [OrderStatusController::class, 'index'])->name('backend.orderstatus.index');
    Route::post('/update-color', [OrderStatusController::class, 'updateColor'])->name('backend.orderstatus.updateColor');
    Route::post('/update-sorting-order', [OrderStatusController::class, 'updateSortingOrder'])->name('backend.orderstatus.updateSortingOrder');
});

Route::post('/dashboard/recent-notification', [DashboardController::class, 'recentNotification'])->name('dashboard.recent-notification');
Route::post('/dashboard/mark-notification', [DashboardController::class, 'markNotification'])->name('dashboard.markNotification');