<!-- use App\Models\Backend\LabOrders; -->
<?php
use App\Models\Auth\User;
?>

<div class="row row-top-margin">
    <div class="col-md-12">
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-envelope font-green"></i>
                    <span class="caption-subject font-green sbold uppercase">Lab Order Control </span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-toolbar">
                    <div class="row">
                       <div class="col-md-6"></div>
                        <div class="col-md-6">
                            <div class="btn-group float-end">
                            
                            </div>
                        </div>
                    </div>
                </div>
                <table class="table table-striped table-bordered">
                    <thead>
                        <tr role="row" class="heading">
                            <th>Business Account</th>
                            <th>Order Type</th>
                            <th>Enable Control</th>
                        </tr>
                    </thead>
                    <tbody style="visibility: hidden;">
                        <tr>
                            <td width="45%">
                                <select class="form-control select2" id="user_account_select" name="user_accounts[]" multiple data-placeholder="Choose Multiple Accounts...">
                                    <?php if(isset($usersForSelect)): ?>
                                        <option value="all" name="all" <?php if(isset($savedConfig['user_accounts']) && in_array('all', $savedConfig['user_accounts'])): ?> selected <?php endif; ?>>
                                            000 - Enable for all Accounts
                                        </option>
                                        <?php $__currentLoopData = $usersForSelect; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($value->id); ?>" <?php if(isset($savedConfig['user_accounts']) && in_array((string)$value->id, $savedConfig['user_accounts'])): ?> selected <?php endif; ?>>
                                                <?php echo e($value->ac_code .' - '. $value->business_name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </td>
                            <td width="45%">
                                 <select class="form-control select2" id="order_type_select" name="order_type_select[]" multiple data-placeholder="Choose Multiple Order Types...">
                                    <?php if(isset($orderType)): ?>
                                        <?php $__currentLoopData = $orderType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Key => $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($Key); ?>" <?php if(isset($savedConfig['order_types']) && in_array($Key, $savedConfig['order_types'])): ?> selected <?php endif; ?>>
                                                <?php echo e($type); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </td>
                            <td width="10%">
                                <input type="checkbox" name="status" id="status_checkbox" <?php if(isset($savedConfig['status']) && $savedConfig['status'] == "true"): ?> checked <?php endif; ?>>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('after-scripts'); ?>
<script>
$(window).on('load', function() {
    $('tbody').css('visibility', 'visible');
});

$(document).ready(function() {
    function saveConfiguration() {
        var data = {
            _token: '<?php echo e(csrf_token()); ?>',
            user_accounts: $('#user_account_select').val(),
            order_types: $('#order_type_select').val(),
            status: $('#status_checkbox').is(':checked')
        };
        $.post('<?php echo e(route("admin.auth.orders.lab.configuration.save")); ?>', data, function(response) {
            if(response.success) {
                console.log(response.message);
                if (response.user_accounts) {
                    $('#user_account_select').val(response.user_accounts).trigger('change');
                }
            }
        });
    }

    $('#user_account_select, #order_type_select, #status_checkbox').on('change', function() {
        saveConfiguration();
    });
});
</script>
<?php $__env->stopPush(); ?><?php /**PATH /var/www/html/lens-shapers/resources/views/backend/laborder/configuration.blade.php ENDPATH**/ ?>