<?php
use App\Models\Backend\PhoneLog;
use App\Models\Backend\Order;
use App\Models\Backend\OrderStatus;

// Define $order variable for consistent order checking
$order = null;
if (isset($orderId) && $orderId) {
    $order = \App\Models\Backend\Order::find($orderId);
}
?>
<div class="row row-top-margin<?php echo e($isBackend ? ' backend' : ''); ?>">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable">
            <div class="portlet-body">
                <?php if($isBackend): ?>
                <div class="row justify-content-center text-center" style="margin-bottom: 5px;">
                    <div class="d-flex justify-content-center align-items-center gap-3 flex-wrap">
                        <span class="label label-sm label-info" style="font-size: 20px;padding: 6px;margin-right: 10px;">
                            Last Updated: <?php echo e(date_time_format(\App\Models\Backend\AppSettings::findByKey(\App\Models\Backend\AppSettings::LAST_UPDATE_ORDERS_TIME), 'Y-m-d h:i a')); ?>

                        </span>

                        <?php if(numberOfSubmittedOrder() > 0): ?>
                            <span class="label label-sm label-danger" style="font-size: 20px;padding: 6px;">
                                Submitted Status Orders Not Printed
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                <?php echo $__env->make($searchFormInclude, compact('orders', 'pageCount', 'isBackend') + (isset($customers) ? compact('customers') : []), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <div class="order-list">
                    <div class="row">
                        <div class="col-lg-6 col-md-12 p-0 table-data-container adjust_height-container" style="padding: 0; overflow-y: auto;">
                            <div class="table-responsive scrollable-container" id="records-container">
                                <?php echo $__env->make('partials.orderlist', compact('orders', 'pageCount') + ['isBackend' => $isBackend], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12 p-0 adjust_height-container">
                            <div class="tabbable-custom nav-justified order-details-container box-shadow" id="order-details-container" style="<?php echo e($isBackend ? 'height: 100%;' : ''); ?>">
                                <ul class="nav nav-pills nav-justified">
                                    <li class="nav-item">
                                        <a href="#tab_order" data-toggle="tab" class="nav-link active tab_order" aria-expanded="true"> Order </a>
                                    </li>
                                    <?php if(!$isBackend && $pageType == 0): ?>
                                        <li class="nav-item">
                                            <a href="#tab_comments" data-toggle="tab" class="data-tabs nav-link tab_comments" data-value="comments" data-id="tab_comments" aria-expanded="false"> Notifications <span class="badge badge-danger noti_counter-span" style="display:none;">0</span> </a>
                                        </li>
                                        <?php if(auth()->user()->isOrderPricesInvoicesPermission()): ?>
                                            <li class="nav-item">
                                                <a href="#tab_invoice" data-toggle="tab" class="data-tabs nav-link tab_invoice" data-value="invoice" data-id="tab_invoice" aria-expanded="false"> Invoice </a>
                                            </li>
                                        <?php endif; ?>
                                    <?php elseif($isBackend): ?>
                                        <li class="nav-item">
                                            <a href="#tab_comments" data-toggle="tab" class="data-tabs nav-link tab_comments" data-value="comments" data-id="tab_comments" aria-expanded="false"> Notifications <span class="badge badge-danger noti_counter-span" style="display:none;">0</span> </a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#tab_invoice" data-toggle="tab" class="data-tabs nav-link tab_invoice" data-value="invoice" data-id="tab_invoice" aria-expanded="false"> Invoice </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                                <div class="tab-content" data-height-set="true" style="height: 100%;">
                                    <div class="tab-pane active" id="tab_order">
                                        <?php if(!$isBackend): ?>
                                            <?php if($order): ?>
                                                <?php echo $__env->make('partials.ordersummary.details', [
                                                    'isCustomerAdmin' => auth()->user()->hasRole('customer_admin') || auth()->user()->hasRole('customer_staff'),
                                                    'order' => $order,
                                                    'type' => $order->type,
                                                    'stockOrder' => $order->type == \App\Models\Backend\Order::ORDER_STOCK ? \App\Models\Backend\StockOrder::where('order_id', $orderId)->first() : null,
                                                    'rxOrderArray' => $order->type == \App\Models\Backend\Order::ORDER_RX ? \App\Models\Backend\RxOrders::where('order_id', $orderId)->first()->getShowData() : []
                                                ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                            <?php else: ?>
                                                <center><h3>Choose an order on left to see details...</h3></center>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <center><h3>Choose an order on left to see details...</h3></center>
                                        <?php endif; ?>
                                    </div>
                                    <div class="tab-pane<?php echo e((isset($commentsData) && $commentsData && !$isBackend) ? ' active' : ''); ?>" id="tab_comments">
                                        <?php if(!$isBackend): ?>
                                            <div id="comment-tab-wrapper">
                                                <?php if(isset($commentsData) && $commentsData): ?>
                                                    <?php echo $commentsData; ?>

                                                <?php endif; ?>
                                            </div>
                                            <div class="form-group comment-box-container">
                                                <div class="container-extend">
                                                    <div class="row" style="padding:0px;">
                                                        <div class="col-12">
                                                            <div id="textarea-header" style="display: none; font-weight: bold;"></div>
                                                            <textarea class="form-control todo-taskbody-taskdesc" id="comment_textarea" placeholder="Type here..." rows="3" cols="10" style="resize: none; display: none;"></textarea>
                                                            <input type="hidden" name="order_id" id="cmt_order_id" value="">
                                                            <!-- Moved buttons inside the same row, right below textarea -->
                                                            <div class="text-end mt-2" id="textarea-buttons" style="display: none;">
                                                                <span class="btn btn-outline-secondary btn-sm me-2 red" id="cancel-comment-btn">Cancel</span>
                                                                <span class="btn btn-primary btn-sm blue" id="send-comment-btn">Send</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- Action Buttons (unchanged) -->
                                                    <div class="mt-5" id="action-buttons" style="display: block;">
                                                        <div class="d-flex justify-content-between">
                                                            <!-- Left Side Group - Request Cancellation -->
                                                            <div>
                                                                <button class="btn btn-danger add-comment-btn" data-type="order_cancellation" data-placeholder="Please provide a reason for cancelling the order..." data-loading-text="Saving ..." type="button">
                                                                    <i class="fa fa-times"></i> Request Cancellation
                                                                </button>
                                                            </div>
                                                            <!-- Right Side Group - Request Change -->
                                                            <div>
                                                                <button class="btn btn-primary add-comment-btn" data-type="request_change" data-placeholder="Describe the changes you'd like to request for this order..." data-loading-text="Saving ..." type="button">
                                                                    <i class="fa fa-exchange"></i> Request Change
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <div id="comment-tab-wrapper">
                                            </div>
                                            <div class="form-group comment-box-container">
                                                <div class="container-extend">
                                                    <div class="row" style="padding:0px;">
                                                        <div class="col-12">
                                                            <div id="textarea-header" style="display: none; font-weight: bold;"></div>
                                                            <textarea class="form-control todo-taskbody-taskdesc" id="comment_textarea" placeholder="Type your private note here..." rows="3" cols="10" style="resize: none; display: none; height: 100px;" data-type="notes"></textarea>
                                                            <input type="hidden" name="order_id" id="cmt_order_id" value="">
                                                            <div class="text-end mt-2" id="textarea-buttons" style="display: none;">
                                                                <span class="btn btn-outline-secondary btn-sm me-2 red" id="cancel-comment-btn">Cancel</span>
                                                                <span class="btn btn-primary btn-sm blue" id="send-comment-btn">Send</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="mt-5" id="action-buttons" style="display: block;">
                                                        <div class="d-flex justify-content-between">
                                                            <div class="d-flex  me-2">
                                                                <button class="btn btn-danger me-2 add-comment-btn" data-type="<?= \App\Models\Backend\PhoneLog::TYPE_PHONE_LOG ?>" data-placeholder="Type your phone log details here..." data-loading-text="Saving ..." type="button">
                                                                    <i class="fa fa-phone"></i> Phone Log
                                                                </button>
                                                                <button class="btn btn-warning mt-ladda-btn ladda-button btn-outline add-comment-btn" data-type="<?= \App\Models\Backend\PhoneLog::TYPE_NOTE ?>" data-placeholder="Type your private note here..." data-loading-text="Saving ..." type="button">
                                                                        <i class="fa fa-lock"></i> Add Note (Private to LS)
                                                                    </button>
                                                                </div>
                                                                <button class="btn btn-primary add-comment-btn" data-type="<?= \App\Models\Backend\PhoneLog::TYPE_QUESTION ?>" data-placeholder="Type your question for the customer here..." data-loading-text="Saving ..." type="button">
                                                                    <i class="fa fa-question-circle"></i> Ask Customer
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="tab-pane" id="tab_invoice">
                                        <?php if($order): ?>
                                            <?php if($order->invoice_no): ?>
                                                <!-- Invoice content will be loaded here via JavaScript -->
                                            <?php else: ?>
                                                <center><h3>No invoice found with order status</h3></center>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <center><h3>Choose an order on left to see details...</h3></center>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
<div class="modal fade bs-modal-lg" id="start_redo-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <?php echo e(html()->form('POST', route('frontend.user.redo'))->attribute('id','start_redo_order-form')->open()); ?>

            <input type="hidden" name="id" value="">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>

                <h4 class="modal-title"><i class="fas fa-redo" aria-hidden="true"></i>&nbsp;&nbsp;Start Redo</h4>
            </div>
            <div class="modal-body">
                <div class="form-body">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <label for="">Reason for Redo</label>
                        <select name="reason" class="form-control select2_custom" required>
                            <option value="">Please Select</option>
                            <?php $__currentLoopData = \App\Models\Backend\Order::getReasonsArrayList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group form-md-line-input">
                        <label for="">Notes</label>
                        <textarea class="form-control" rows="3" name="notes" placeholder="Add more details..."></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn dark btn-outline">Cancel</button>
                <button type="submit" class="btn blue btn-outline">Next</button>
            </div>
            <?php echo e(html()->form()->close()); ?>

        </div>
    </div>
</div>
<?php if($isBackend): ?>
<?php echo $__env->make('backend.auth.templates.includes.templates-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('backend.auth.orders.includes.side-panel', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php endif; ?>
<?php $__env->startPush('after-scripts'); ?>
<script>
    window.isLoaderFStop = true;
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/html/lens-shapers/resources/views/partials/orders.blade.php ENDPATH**/ ?>