<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', app_name()); ?></title>
    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', 'Lens Shapers'); ?>">
    <meta name="author" content="<?php echo $__env->yieldContent('meta_author', 'Lens Shapers'); ?>">
    <?php echo $__env->yieldContent('meta'); ?>
    <?php echo $__env->yieldPushContent('before-styles'); ?>

    <link rel="shortcut icon" href="<?php echo e(asset('public/favicon.ico')); ?>" id="favicon" />

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <?php
    $layoutMode = 'split';
    $sections = $__env->getSections();
    if (isset($sections['layout_mode'])) {
        $layoutMode = trim($sections['layout_mode']);
    }
    ?>
    <?php if($layoutMode == 'split'): ?>
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
        <script src="https://js.pusher.com/4.1/pusher.min.js"></script>
    <?php endif; ?>
    <script src="<?php echo e(asset('assets/global/plugins/bootstrap-select/js/bootstrap-select.min.js')); ?>"></script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php if($layoutMode == 'split'): ?>
        <script src="//cdn.ckeditor.com/4.22.1/full-all/ckeditor.js"></script>
    <?php else: ?>
        <script src="//cdn.ckeditor.com/4.22.1/full-all/ckeditor.js"></script>
    <?php endif; ?>
        <script src="https://unpkg.com/@popperjs/core@2"></script>
        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

    <?php echo $__env->yieldPushContent('after-styles'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script type="text/javascript">
        var baseUrl = "<?= url('') ?>/admin";
    </script>
</head>
<body class="<?php if($layoutMode == 'app'): ?>page-header-fixed page-sidebar-closed-hide-logo page-content-white <?php else: ?> page-sidebar-closed-hide-logo <?php endif; ?>">
    <?php if($layoutMode == 'split'): ?>
        <div class="chatpageloader loader" style="display: none;">
            <div class="lds-ring">
            </div>
        </div>
    <?php endif; ?>
    <?php echo $__env->make('includes.partials.messages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php if($layoutMode == 'app'): ?>
        <div class="page-wrapper">
            <?php echo $__env->make('backend.includes.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <div class="page-container">
                <?php echo $__env->make('backend.includes.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <div class="page-content-wrapper">
                    <div class="page-content">
                        <?php if(!Route::is('frames.index')): ?>
                            <?php echo Breadcrumbs::render(); ?>

                        <?php endif; ?>
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('backend.auth.orders.includes.message-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('backend.includes.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    <?php else: ?>
        <div class="wrapper split-wrapper">
            <header class="page-header custom-page-header split-header">
                <?php echo $__env->make('backend.includes.split-header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </header>
            <div class="split-content">
                <div class="container-fluid p-0">
                    <div class="page-content">
                        <div class="breadcrumbs">
                            
                        </div>
                        <?php echo $content ?? ''; ?><?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
            </div>
            <footer class="split-footer">
                <?php echo $__env->make('backend.includes.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </footer>
            <?php echo $__env->make('backend.auth.orders.includes.message-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    <?php endif; ?>

    <!-- Scripts -->
    <?php echo $__env->yieldPushContent('before-scripts'); ?>
    <?php if($layoutMode == 'app'): ?>
        <script type="text/javascript">
            var validateUrl = "<?= route('admin.user.validate') ?>";
            var loginUrl = "<?= route('frontend.auth.login') ?>";
            $(function() {
                $.ajax({
                    url: validateUrl,
                    type: "GET",
                    cache: false,
                    error: function (request, status, error) {
                        window.location.replace(loginUrl);
                    }
                });
            });
        </script>
    <?php else: ?>
        <script type="text/javascript">
            let portalType = 'admin';
        </script>
        <script type="text/javascript">
            var validateUrl = "<?= route('admin.user.validate') ?>";
            var loginUrl = "<?= route('login') ?>";
            var userId = "<?= auth()->user()->id ?>";
            var isSuperAdmin = true;
            var notificationChannel = null;
            var PhoneLog = {
                TYPE_ORDER_CANCELLATION: 'order_cancellation',
                TYPE_REQUEST_CHANGE: 'request_change',
                TYPE_PHONE_LOG: 'phone_log',
                TYPE_NOTE: 'notes',
                TYPE_QUESTION: 'questions'
            };
            var pusher = new Pusher("<?php echo e(config('app.pusher.key')); ?>", {
                cluster: "<?php echo e(config('app.pusher.options.cluster')); ?>",
                encrypted: true
            });
            notificationChannel = pusher.subscribe("<?php echo e(Auth::user()->getChannelId()); ?>");
            window.isLoaderStop = true;
            window.isLoaderFStop = false;
            $(function() {
                $('.chatpageloader').hide();
                $.ajax({
                    url: validateUrl,
                    type: "GET",
                    cache: false,
                    error: function (request, status, error) {
                        window.location.replace(loginUrl);
                    }
                });
            });
        </script>
    <?php endif; ?>
    <?php echo $__env->yieldPushContent('after-scripts'); ?>
</body>
</html>
<?php /**PATH /var/www/html/lens-shapers/resources/views/backend/layouts/split.blade.php ENDPATH**/ ?>