<?php
$isCustomerAdmin = auth()->user()->hasRole('customer_admin') ? auth()->user()->hasRole('customer_admin') : auth()->user()->hasRole('customer_staff');
$user = $order->user ?? $order->user;
$orderNumber = $isCustomerAdmin ? ($order->getOfflineOrderNumber() ?? $order->getOfflineOrderNumber()) : ($order->getOrderNumber() ?? '');
?>

<div class="order-info-container">
    <!-- Order Information -->
    <?php echo $__env->make('partials.ordersummary.details',[
            'isCustomerAdmin' => $isCustomerAdmin,
            'order' => $order,
            'type' => 'rx',
            'user' => $user,
            'rxOrderArray' => $rxOrderArray,
            'rxOrder' => $rxOrder
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php if($order->online != 0): ?>
        <!-- Reference and Package Info -->
            <?php if($order->isRedo() || !empty($rxOrderArray['package']['label']) || !empty($rxOrderArray['multipair_ref'])): ?>
                <div class="reference-header-section">
                    <div class="reference-header-grid">
                        <?php if($order->isRedo()): ?>
                        <div class="reference-header-column">
                            <div class="reference-header">Redo Reference</div>
                            <div class="reference-value">W<?php echo e($order->reason_oid); ?>: <?php echo e($order->reason_type); ?><br><?php echo e($order->reason_notes); ?></div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if(!empty($rxOrderArray['package']['label'])): ?>
                        <div class="reference-header-column">
                            <div class="reference-header">Package</div>
                            <div class="reference-value"><?php echo e($rxOrderArray['package']['label']); ?></div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if(!empty($rxOrderArray['multipair_ref'])): ?>
                        <div class="reference-header-column">
                            <div class="reference-header">Multi-Pair</div>
                            <div class="reference-value"><?php echo e($rxOrderArray['multipair_ref']); ?></div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

        <!-- Scrollable Content Box -->
        <div class="scrollable-content-box <?php echo e($isCustomerAdmin ? '' : 'admin-view'); ?>">
            <div class="order-summary-container">
                <div class="rx-order-table <?php echo e($isCustomerAdmin ? 'customer-view' : 'admin-view'); ?>">
                    <!-- Lenses Section -->
                    <div class="rx-section">
                        <div class="section-header">
                            <span>Rx Lenses</span>
                            <?php if(!$isCustomerAdmin): ?>
                                <div class="lens-price-col">Price</div>
                            <?php endif; ?>
                        </div>
                        <div class="rx-lens-row">
                            <div class="rx-side-col">R</div>
                            <div class="rx-lens-details">
                                <?php if(isset($rxOrderArray['lens_group'])): ?>
                                    <?php echo implode(', ', $rxOrderArray['lens_group']['att_values']); ?>

                                <?php elseif(!empty($rxOrderArray['distance']['right_dist_type']) && strtolower($rxOrderArray['distance']['right_dist_type']) != 'order'): ?>
                                    <?php echo e($rxOrderArray['distance']['right_dist_type']); ?>

                                <?php else: ?>
                                    <?php echo implode(', ', array_filter([
                                            $rxOrderArray['lens']['lens_type'] ?? '',
                                            $rxOrderArray['lens']['sub_type'] ?? '',
                                            $rxOrderArray['lens']['lens_name'] ?? '',
                                            $rxOrderArray['lens']['lens_material'] ?? '',
                                            $rxOrderArray['lens']['lens_filter'] ?? '',
                                            $rxOrderArray['lens']['lens_colour'] ?? '',
                                            $rxOrderArray['lens']['coating_name'] ?? '',
                                            $rxOrderArray['lens']['coating_colour'] ?? ''
                                        ])); ?>

                                <?php endif; ?>
                            </div>
                            <?php if(!$isCustomerAdmin && !empty($rxOrderArray['prices']['right_lens_type'])): ?>
                                <div class="rx-price-col">$<?php echo e($rxOrderArray['prices']['right_lens_type']); ?></div>
                            <?php endif; ?>
                        </div>
                        <div class="rx-lens-row">
                            <div class="rx-side-col">L</div>
                            <div class="rx-lens-details">
                                <?php if(isset($rxOrderArray['lens_group'])): ?>
                                    <?php echo implode(', ', $rxOrderArray['lens_group']['att_values']); ?>

                                <?php elseif(!empty($rxOrderArray['distance']['left_dist_type']) && strtolower($rxOrderArray['distance']['left_dist_type']) != 'order'): ?>
                                    <?php echo e($rxOrderArray['distance']['left_dist_type']); ?>

                                <?php else: ?>
                                    <?php echo implode(', ', array_filter([
                                            $rxOrderArray['lens']['lens_type'] ?? '',
                                            $rxOrderArray['lens']['sub_type'] ?? '',
                                            $rxOrderArray['lens']['lens_name'] ?? '',
                                            $rxOrderArray['lens']['lens_material'] ?? '',
                                            $rxOrderArray['lens']['lens_filter'] ?? '',
                                            $rxOrderArray['lens']['lens_colour'] ?? '',
                                            $rxOrderArray['lens']['coating_name'] ?? '',
                                            $rxOrderArray['lens']['coating_colour'] ?? ''
                                        ])); ?>

                                <?php endif; ?>
                            </div>
                            <?php if(!$isCustomerAdmin && !empty($rxOrderArray['prices']['left_lens_type'])): ?>
                                <div class="rx-price-col">$<?php echo e($rxOrderArray['prices']['left_lens_type']); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <!-- Distance Section -->
                    <div class="rx-v-table">
                        <div class="rx-v-row rx-v-header">
                            <div class="rx-v-cell rx-v-side-col"></div>
                            <?php $__currentLoopData = $rxOrderArray['distance']['label']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($value != ''): ?>
                                    <div class="rx-v-cell rx-v-data-col"><?php echo e($value); ?></div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                        <div class="rx-v-row">
                            <div class="rx-v-cell rx-v-side-col">R</div>
                            <?php $__currentLoopData = $rxOrderArray['distance']['right']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($key != ''): ?>
                                    <div class="rx-v-cell rx-v-data-col"><?php echo e($value); ?></div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                        <div class="rx-v-row">
                            <div class="rx-v-cell rx-v-side-col">L</div>
                            <?php $__currentLoopData = $rxOrderArray['distance']['left']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($key != ''): ?>
                                    <div class="rx-v-cell rx-v-data-col"><?php echo e($value); ?></div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                        <?php if(!empty($rxOrderArray['intermediateStrengthText'])): ?>
                            <div class="rx-v-row">
                                <div class="rx-v-cell rx-v-side-col"></div>
                                <div class="rx-v-cell">
                                    <div class="rx-v-note-col-nowrap"><?php echo e($rxOrderArray['intermediateStrengthText']); ?></div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Reading Section -->
                    <div class="rx-v-table">
                        <div class="rx-v-row rx-v-header">
                            <div class="rx-v-cell rx-v-side-col"></div>
                            <?php $__currentLoopData = $rxOrderArray['reading']['label']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="rx-v-cell rx-v-data-col"><?php echo e($value); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                        <div class="rx-v-row">
                            <div class="rx-v-cell rx-v-side-col">R</div>
                            <?php $__currentLoopData = $rxOrderArray['reading']['right']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="rx-v-cell rx-v-data-col"><?php echo e($value); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="rx-v-row">
                            <div class="rx-v-cell rx-v-side-col">L</div>
                            <?php $__currentLoopData = $rxOrderArray['reading']['left']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="rx-v-cell rx-v-data-col"><?php echo e($value); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <!-- <div class="rx-v-cell rx-v-data-col"></div> -->
                        </div>
                    </div>

                    <!-- Single Info Section -->
                    <div class="rx-v-table">
                        <div class="rx-v-row rx-v-header">
                            <div class="rx-v-cell rx-v-side-col"></div>
                            <?php $__currentLoopData = $rxOrderArray['single_info']['label']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="rx-v-cell rx-v-data-col"><?php echo e($value); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                        <div class="rx-v-row">
                            <div class="rx-v-cell rx-v-side-col"></div>
                            <?php $__currentLoopData = $rxOrderArray['single_info']['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="rx-v-cell rx-v-data-col"><?php echo e($value); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="rx-v-cell rx-v-data-col"></div>
                        </div>
                    </div>

                    <!-- Frame Section -->
                    <div class="rx-section">
                        <div class="section-header-row">Frame</div>
                        <div class="rx-frame-row">
                            <div class="rx-side-col"></div>
                            <div class="rx-frame-details"><?php echo e($rxOrderArray['frame']['frame_type']); ?></div>
                        </div>
                        <div class="rx-frame-details-row">
                            <div class="rx-side-col"></div>
                            <div class="rx-frame-details">
                                <?php
                                    $frameInfo = [];
                                    foreach ($rxOrderArray['frame']['frame_info']['values'] as $key => $value) {
                                        if (!empty($value)) {
                                            if ($value == '✓') {
                                                if($key == 'pof'){
                                                    $labelIndex = array_search(ucwords($key), $rxOrderArray['frame']['frame_info']['label']);
                                                    $label = $labelIndex !== false ? $rxOrderArray['frame']['frame_info']['label'][$labelIndex] : $key;
                                                    $frameInfo[] = $value . ' ' . ucwords($label);
                                                }
                                            } else {
                                                $frameInfo[] = $value;
                                            }
                                        }
                                    }
                                ?>
                                <?php if(!empty($frameInfo)): ?>
                                    <?php echo implode(', ', $frameInfo); ?>

                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="rx-frame-size-row">
                            <div class="rx-side-col"></div>
                            <div class="rx-frame-size-details">
                                <?php $__currentLoopData = $rxOrderArray['frame']['frame_size']['label']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(!empty($rxOrderArray['frame']['frame_size']['values'][$key])): ?>
                                        <span><?php echo e($value); ?>: <?php echo e($rxOrderArray['frame']['frame_size']['values'][$key]); ?></span>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="rx-frame-options-row">
                            <div class="rx-side-col"></div>
                            <div class="rx-frame-options">
                                <span><?php echo e(!empty($rxOrderArray['frame']['specify_thickness']) ? 'Lens Thickness: '.$rxOrderArray['frame']['specify_thickness'].',' : ''); ?> </span>
                                <span><?php echo e($rxOrderArray['frame']['specify_thickness_data']['r_ct_or_et']); ?></span>
                                <span><?php echo e($rxOrderArray['frame']['specify_thickness_data']['l_ct_or_et']); ?></span>
                                <?php if(!empty($rxOrderArray['frame']['bevel_type'])): ?>
                                    <span>Bevel Type: <?php echo e($rxOrderArray['frame']['bevel_type']); ?></span>
                                <?php endif; ?>
                                <span><?php echo $rxOrderArray['frame']['safety_stamp']; ?></span>
                                <span><?php echo $rxOrderArray['frame']['edge_polish']; ?></span>
                            </div>
                        </div>
                    </div>

                    <!-- Modify Shape Section -->
                    <?php if(!empty($rxOrderArray['frame']['modify_shape']['a_option'])): ?>
                        <div class="rx-section">
                            <div class="section-header-row">Modify Shape</div>
                            <div class="rx-modify-shape-row">
                                <div class="rx-side-col"></div>
                                <div class="rx-modify-shape-details">
                                    <span>A: <?php echo $rxOrderArray['frame']['modify_shape']['a']; ?></span>
                                    <span><?php echo e($rxOrderArray['frame']['modify_shape']['a_option']); ?></span>
                                    <span><?php echo e($rxOrderArray['frame']['modify_shape']['a_increase']); ?></span>

                                    <span>B: <?php echo $rxOrderArray['frame']['modify_shape']['b']; ?></span>
                                    <span><?php echo e($rxOrderArray['frame']['modify_shape']['b_option']); ?></span>
                                    <span><?php echo e($rxOrderArray['frame']['modify_shape']['b_increase']); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Add-ons Section -->
                    <?php if(!empty($rxOrderArray['additional_items']['add_clip_on'])): ?>
                        <div class="rx-section">
                            <div class="section-header-row">Add-ons</div>
                            <div class="rx-addons-row">
                                <div class="rx-side-col"></div>
                                <div class="rx-addons-details">
                                    <span><?php echo e($rxOrderArray['additional_items']['add_clip_on']); ?></span>
                                </div>
                                <?php if(!$isCustomerAdmin && !empty($rxOrderArray['prices']['custom_clip_on'])): ?>
                                    <div class="rx-price-col">$<?php echo e($rxOrderArray['prices']['custom_clip_on']); ?></div>
                                <?php endif; ?>
                            </div>
                            <?php if(!empty($rxOrderArray['additional_items']['repairs_services'])): ?>
                                <?php $__currentLoopData = $rxOrderArray['additional_items']['repairs_services']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(!empty($value)): ?> 
                                        <div class="rx-repairs-row">
                                            <div class="rx-side-col"></div>
                                            <div class="rx-repairs-details">
                                                <span><?php echo e(\App\Models\Backend\RxValidations::decodeValue($value)); ?></span>
                                            </div>
                                            <?php if(!$isCustomerAdmin && !empty($rxOrderArray['prices']['repairs_services']) && isset($rxOrderArray['prices']['repairs_services'][$key])): ?>
                                                <div class="rx-price-col">$<?php echo e($rxOrderArray['prices']['repairs_services'][$key]); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php if(!empty($rxOrderArray['additional_items']['repair_description'])): ?>
                                <div class="rx-repair-desc-row">
                                    <div class="rx-side-col"></div>
                                    <div class="rx-repair-desc">
                                        <span><?php echo e($rxOrderArray['additional_items']['repair_description']); ?></span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <!-- Job Section -->
                    <div class="rx-section">
                        <div class="section-header-row">Job</div>
                        <div class="rx-job-row">
                            <div class="rx-side-col"></div>
                            <div class="rx-job-details">
                                <span><?php echo $rxOrderArray['frame']['job_type']; ?></span>
                                <span><span id="pof-field"></span></span>
                            </div>
                        </div>
                    </div>
                                
                    <!-- Total Price Section (Admin Only) -->
                    <?php if(!$isCustomerAdmin && (!empty($rxOrderArray['prices']['additional']) || !empty($rxOrderArray['prices']['total_price']))): ?>
                        <div class="rx-section">
                            <!-- Additional Prices -->
                            <?php if(!empty($rxOrderArray['prices']['additional'])): ?>
                                <div class="rx-section">
                                    <div class="section-header-row">Additional Charges</div>
                                    <?php $__currentLoopData = $rxOrderArray['prices']['additional']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="rx-addons-row">
                                            <div class="rx-side-col"></div>
                                            <div class="rx-addons-details">
                                                <span><?php echo e($value['label']); ?></span>
                                            </div>
                                            <?php if(!$isCustomerAdmin): ?>
                                                <div class="rx-price-col">$<?php echo e($value['price']); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                        <!-- Instructions Section -->
                        <?php if(!empty($rxOrderArray['additional_items']['special_instructions'])): ?>
                            <div class="rx-section">
                                <div class="section-header-row">Instructions</div>
                                <div class="rx-instructions-row">
                                    <div class="rx-side-col"></div>
                                    <div class="rx-instructions-details">
                                        <span><?php echo e($rxOrderArray['additional_items']['special_instructions']); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                 </div>
            </div>
            <?php if(!$isCustomerAdmin && (!empty($rxOrderArray['prices']['additional']) || !empty($rxOrderArray['prices']['total_price']))): ?>
                <!-- Total Price -->
                <?php if(!empty($rxOrderArray['prices']['total_price'])): ?>
                    <div class="total-price-container">
                        <div class="total-price-label">Total:</div>
                        <div class="total-price-value">$<?php echo e(number_format($rxOrderArray['prices']['total_price'], 2)); ?></div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    <?php else: ?>
            <div class="text-center mt-5">Order data not available.</div>
    <?php endif; ?>
</div>

<!-- Fixed Action Buttons -->
    <?php echo $__env->make('partials.actions.printbtn',[
        'isCustomerAdmin' => $isCustomerAdmin,
        'order' => $order,
        'type' => 'rx'
    ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/lens-shapers/resources/views/partials/rx.blade.php ENDPATH**/ ?>