<?php $__env->startSection('title', 'Customer Login' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name()); ?>

<?php $__env->startSection('content'); ?>
    <!-- BEGIN LOGIN FORM -->
    <?php echo e(html()->form('POST', route('login.post'))->class('login-form')->open()); ?>

        <h3 class="form-title">Customer Login</h3>
        <div class="alert alert-danger d-none">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <span> Missing Information. </span>
        </div>
        <div class="mb-3">
            <!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
            <?php echo e(html()->label('Account Number')->for('ac_code')->class('form-label')); ?>

            <div class="input-group">
                <span class="input-group-text"><i class="fa fa-user"></i></span>
                <?php echo e(html()->text('ac_code')
                    ->class('form-control')
                    ->placeholder('Account Number')
                    ->attribute('maxlength', 191)
                    ->attribute('autofocus', 'autofocus')
                    ->required()); ?>

            </div>
        </div>
        <div class="mb-3">
            <!-- <?php echo e(html()->label(__('validation.attributes.frontend.password'))->for('password')->class('form-label')); ?> -->
            <div class="input-group">
                <span class="input-group-text"><i class="fa fa-lock"></i></span>
                <?php echo e(html()->password('password')
                    ->class('form-control')
                    ->placeholder(__('validation.attributes.frontend.password'))
                    ->required()); ?>

            </div>
        </div>
        <div class="d-flex justify-content-end">
            <?php echo e(form_submit(__('labels.frontend.auth.login_button'),'btn btn-success')); ?>

        </div>
        <div class="forget-password mt-3">
            <p> <a href="javascript:;" id="forget-password" style="color: white;">Forgot Password? Click Here </a> </p>
        </div>
    <?php echo e(html()->form()->close()); ?>

    <!-- END LOGIN FORM -->
    <!-- BEGIN FORGOT PASSWORD FORM -->
    <?php echo e(html()->form('POST', route('frontend.auth.password.email.post'))->class('forget-form')->open()); ?>

        <h3>RESET PASSWORD?</h3>
        <p> Enter your account number below to reset your password. </p>
        <div class="mb-3">
            <div class="input-group">
                <span class="input-group-text"><i class="fa fa-envelope"></i></span>
                <?php echo e(html()->text('ac_code')
                    ->class('form-control')
                    ->placeholder('Account Number')
                    ->attribute('id', 'fac_code')
                    ->attribute('maxlength', 10)
                    ->required()
                    ->autofocus()); ?>

            </div>
        </div>
        <div class="d-flex justify-content-between">
            <button type="button" id="back-btn" class="btn btn-outline-secondary">Back </button>
            <?php echo e(form_submit(__('labels.frontend.passwords.send_password_reset_link_button'),'btn btn-success')); ?>

        </div>
    <?php echo e(html()->form()->close()); ?>

    <!-- END FORGOT PASSWORD FORM -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
<script>
jQuery(document).ready(function() {
    jQuery('#forget-password').click(function () {
        jQuery('.login-form').hide();
        jQuery('.forget-form').show();
    });

    jQuery('#back-btn').click(function () {
        jQuery('.login-form').show();
        jQuery('.forget-form').hide();
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.customer-login', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/customers/login.blade.php ENDPATH**/ ?>