<?php 
use App\Models\Auth\Role;
?>
<style type="text/css">
    .input-group .form-control:last-child{
        height: 34px;
    }
</style>
<form action="<?php echo e(route('admin.auth.user.search')); ?>" method="POST" id="orders_search_form" onsubmit="return false;">
    <?php echo csrf_field(); ?>
    <div class="table-container">
        <div class="row" id="search_form">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="">Search</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="fa fa-th-list" aria-hidden="true"></i>
                            </span>
                        </div>
                        <input type="text" class="form-control form-filter input-sm" name="search" placeholder="Search account no., business name, first or last name">
                    </div>
                </div>
            </div>  
            <div class="col-md-3">
                <div class="form-group">
                    <label for="">User Type</label>
                    <select class="form-control select2" name="status[]" data-placeholder="Choose Multiple user Types" multiple>
                        <?php $__currentLoopData = Role::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($value->id); ?>"><?php echo e(ucwords(str_replace('_', ' ', $value->name))); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="col-md-3 text-right" style="margin-top:25px;">
                <button type="submit" class="btn blue me-2" id="search_button">
                    <i class="fa fa-search" aria-hidden="true"></i> Search
                </button>
                <button type="button" class="btn red" id="reset_search">Clear</button>
            </div>
        </div>
    </div>
</form>
<?php /**PATH /var/www/html/lens-shapers/resources/views/backend/auth/user/includes/search-form.blade.php ENDPATH**/ ?>