<?php
use App\Models\Backend\UserProfile;
?>
<style type="text/css">
    .dropify-wrapper{
        height: 150px;
    }
</style>
<?php echo e(html()->modelForm($user, 'POST', route('admin.auth.updateApi',$user))->class('form-horizontal enable_change_btn')->attribute('enctype', 'multipart/form-data')->open()); ?>

<?php echo method_field('POST'); ?>
<input type="hidden" name="steps" value="personal_info">
<div class="col">
    <div class="table-responsive">
        <table class="table table-striped table-hover table-bordered">
            <?php if($user->isFrontendUser()): ?>
                <tr>
                    <th>Login As</th>
                    <td>
                        <?php echo $user->login_as_button; ?>

                    </td>
                </tr>
            <?php endif; ?>
            <tr>
                <th>Logo</th>
                <td>
                    <?php if(0 /*!$user->isGravatar()*/): ?>
                    <div class="fileinput-new card-img-top" style="width: 200px; height: auto;">
                        <img src="<?php echo e($user->picture); ?>" class="img-responsive" />
                    </div>
                    <?php else: ?>
                        <?php echo e(html()->file('avatar_location')->class('default-dropify picture')->attribute('data-allowed-file-extensions','png jpg jpeg')->attribute('data-show-loader','true')->attribute('data-max-file-size','20M')); ?>

                        <input type="hidden" name="avatar_type" value="storage" checked  />
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th><?php echo app('translator')->get('labels.backend.access.users.tabs.content.overview.first_name'); ?></th>
                    <td>
                        <input type="text" name="first_name" 
                            class="form-control" 
                            value="<?php echo e($user->first_name); ?>"
                            >
                    </td>
            </tr>
             <tr>
                <th><?php echo app('translator')->get('labels.backend.access.users.tabs.content.overview.last_name'); ?></th>
                    <td>
                        <input type="text" name="last_name" 
                            class="form-control" 
                            value="<?php echo e($user->last_name); ?>"
                            >
                    </td>
            </tr>
            <tr>
                <th><?php echo app('translator')->get('labels.backend.access.users.tabs.content.overview.email'); ?></th>
                <td><?php echo e($user->email); ?></td>
            </tr>
            <?php if(!empty($profile)): ?>
            <tr>
                <th>Business Name</th>
                <td><?php echo e($profile->business_name); ?></td>
            </tr>
            <tr>
                <th>Street 1</th>
                <td><?php echo e($profile->address1); ?></td>
            </tr>
            <tr>
                <th>Street 2</th>
                <td><?php echo e($profile->address2); ?></td>
            </tr>
            <tr>
                <th>City</th>
                <td><?php echo e($profile->city); ?></td>
            </tr>
            <tr>
                <th>Province</th>
                <td><?php echo e($profile->state); ?></td>
            </tr>
            <tr>
                <th>Country</th>
                <td><?php echo e($profile->country); ?></td>
            </tr>
            <tr>
                <th>Postal Code</th>
                <td><?php echo e($profile->zip_code); ?></td>
            </tr>
            <tr>
                <th>Phone</th>
                <td><?php echo e($formattedPhone); ?></td>
            </tr>
            <tr>
                <th>Extension</th>
                <td><?php echo e($profile->cust_phone_ext); ?></td>
            </tr>
            <tr>
                <th>Fax</th>
                <td><?php echo e($formattedFax); ?></td>
            </tr>
            <tr>
                <th>Birthday</th>
                <td>
                    <div class="input-group date-picker">
                        <span class="input-group-text">
                            <i class="fa fa-calendar"></i>
                        </span>
                        <?php echo e(html()->text('date_of_birth')
                            ->class('form-control')
                            ->placeholder(__('Birthday'))
                            ->value($profile->date_of_birth)
                            ->attribute('maxlength', 191)
                            ->attribute('data-date-format', 'yyyy-mm-dd')); ?>

                    </div>
                </td>
            </tr>
            <tr>
                <th>Celebrates Holidays</th>
                <td>
                    <select name="religion[]" class="form-control select2_custom" multiple>
                        <option value="">Please Select</option>
                        <?php
                            $religion = !empty($profile->religion) ? json_decode($profile->religion,1) : [];
                        ?>
                        <?php $__currentLoopData = UserProfile::getReligionArrayLabel(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($value->name); ?>" <?= in_array($value->name, $religion) ? 'selected' : '' ?>><?php echo e($value->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
            </tr>
            <tr>
                <th>Ship via</th>
                <td><?php echo e($profile->cust_ship_via_cod); ?></td>
            </tr>
            <tr>
                <th>Comments</th>
                <td><?php echo e($profile->cust_commnt); ?></td>
            </tr>
            <tr>
                <th>Language</th>
                <td><?php echo e($profile->cust_language); ?></td>
            </tr>
            <tr>
                <th>On Hold</th>
                <td><?php echo e($profile->cust_on_hold); ?></td>
            </tr>
            <tr>
                <th>EOM Discount Table</th>
                <td><?php echo e($profile->cust_eom_table); ?></td>
            </tr>
            <tr>
                <th>Buying Group Number</th>
                <td><?php echo e($profile->cust_group_cust_no); ?></td>
            </tr>
            <tr>
                <th>Is Active</th>
                <td><?php echo e($profile->cust_active_x); ?></td>
            </tr>
            <tr>
                <th>Hide Prices on Invoice</th>
                <td><?php echo e($profile->cust_suppress_dollar); ?></td>
            </tr>
            <tr>
                <th>Default Job Type</th>
                <td><?php echo e($profile->cust_def_e_u); ?></td>
            </tr>
            <tr>
                <th>Customer Type</th>
                <td><?php echo e($profile->cust_type); ?></td>
            </tr>
            <tr>
                <th>Freight Amount</th>
                <td><?php echo e($profile->cust_freight_amt); ?></td>
            </tr>
            <tr>
                <th>Note</th>
                <td><?php echo e($profile->notes); ?></td>
            </tr>
            <tr>
                <th>Default Price List</th>
                <td><?php echo e($profile->cust_prlist_default); ?></td>
            </tr>
            <tr>
                <th>Stock Price List</th>
                <td><?php echo e($profile->cust_prlist_stock); ?></td>
            </tr>
            <tr>
                <th>Contact 2</th>
                <td><?php echo e($profile->cust_contact_2); ?></td>
            </tr>
            <tr>
                <th>Contact 3</th>
                <td><?php echo e($profile->cust_contact_3); ?></td>
            </tr>
            <tr>
                <th>Buying Group</th>
                <td><?php echo e($profile->cust_group); ?></td>
            </tr>
            <?php endif; ?>
            <tr>
                <th>Account Access</th>
                <td>
                    <div class="input-group">
                        <label class="mt-checkbox mt-checkbox-outline">
                            <?php echo e(html()->checkbox('active', $user->active ? true : false)->class('make-switch')->attribute('data-on-color','primary')->attribute('data-off-color','danger')->attribute('data-on-text','Enabled')->attribute('data-off-text','Disabled')->attribute('data-id',$user->id)); ?>

                        </label>
                    </div>
                </td>
            </tr>
            <tr>
                <th><?php echo app('translator')->get('labels.backend.access.users.tabs.content.overview.timezone'); ?></th>
                <td><?php echo e($user->timezone); ?></td>
            </tr>
            <tr>
                <th><?php echo app('translator')->get('labels.backend.access.users.tabs.content.overview.last_login_at'); ?></th>
                <td>
                    <?php if($user->last_login_at): ?>
                        <?php echo e(timezone()->convertToLocal($user->last_login_at)); ?>

                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th><?php echo app('translator')->get('labels.backend.access.users.tabs.content.overview.last_login_ip'); ?></th>
                <td><?php echo e($user->last_login_ip ?? 'N/A'); ?></td>
            </tr>
            <?php if(!$user->email): ?>
            <tr>
                <th>Permissions</th>
                <td>
                    <div class="col-sm-12">
                        <div class="col-sm-6">
                            <input type="checkbox" id="place-orders" <?php echo e($user->permission_order_placed == 1 ? 'checked' : ''); ?> class="readonly-checkbox" readonly>
                            <label for="place-orders">Place Orders</label>
                        </div>
                        <div class="col-sm-6">
                            <input type="checkbox" id="see-prices-invoices" <?php echo e($user->permission_prices_invoices == 1 ? 'checked' : ''); ?> class="readonly-checkbox" readonly>
                            <label for="see-prices-invoices">See Prices & Invoices</label>
                        </div>
                    </div>
                </td>
            </tr>
            <?php endif; ?>
        </table>
    </div>
</div><!--table-responsive-->
<?php echo e(html()->closeModelForm()); ?>

<?php $__env->startSection('scripts'); ?>
<script>

    const readonlyCheckboxes = document.querySelectorAll('.readonly-checkbox');
        readonlyCheckboxes.forEach(function(checkbox) {
            checkbox.addEventListener('click', function(event) {
                event.preventDefault();
            });
    });

    var imageUrl = "<?= $user->user_picture ?>";
    $(function() {
            var drEvent = $('.picture').dropify({
                defaultFile: imageUrl,
            });
        $(".make-switch").bootstrapSwitch();
        $('.date-picker input').datepicker({
            autoclose: true,
            'format': 'yyyy-mm-dd',
            orientation: 'bottom'
        });
        $(".select2_custom").select2({
            placeholder: "Select..."
        });

        // Prevent form submission if the input is readonly
        $(".enable_change_btn").on('submit', function (e) {
            let readonlyInputs = $(this).find('.readonly-checkbox[readonly]');
            if (readonlyInputs.length > 0) {
                e.preventDefault();
                toastr.error('Cannot submit form with readonly fields.');
                return false;
            }
        });

         // Handle Enter key press in input fields
        $(".enable_change_btn input[type='text']").on('keydown', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault(); // Prevent form submission
                return false;
            }
        });

        $(".enable_change_btn input,.enable_change_btn select").on('change paste switchChange.bootstrapSwitch', function () {
            if ($(this).hasClass('readonly-checkbox') && $(this).attr('readonly')) {
                return; // Skip AJAX call for readonly checkboxes
            }

            let form = $(this).closest('form').serializeArray();
            let formData= new FormData();
            $.each(form, function (key, input) {
                formData.append(input.name, input.value);
            });
            formData.append('avatar_location', $('.picture')[0].files[0]);
            $.ajax({
                url: $(this).closest('form').attr('action'),
                type: "POST",
                data:formData,
                processData: false,
                contentType: false,
                success: function(response){
                    toastr.success(response.message);
                    if(response.status == true){
                        $(document).find('.split-table tr.active .user-status-label').replaceWith(response.active);
                    }
                },
                error: function(error){
                    toastr.error('Something went wrong. Please try again later!')
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?><?php /**PATH /var/www/html/lens-shapers/resources/views/backend/auth/user/show/tabs/overview.blade.php ENDPATH**/ ?>