<?php echo e(html()->form('PATCH', route('frontend.auth.password.update'))->class('form-horizontal')->open()); ?>

<div class="form-group col">
    <div class="col-md-12">
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-picture font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Change Password </span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div class="portlet-body">
                <?php if($logged_in_user->isTempPass()): ?>
                <div class="alert alert-danger" role="alert">For security reasons, please change your temporary password before proceeding.</div>
                <?php endif; ?>
                <?php if(!$logged_in_user->isTempPass()): ?>
                <div class="form-group">
                    <?php echo e(html()->label('Current Password')->for('old_password')); ?>


                    <?php echo e(html()->password('old_password')
                        ->class('form-control')
                        ->placeholder('Current Password')
                        ->autofocus()
                        ->required()); ?>

                </div><!--form-group-->
                <?php endif; ?>
                <div class="form-group">
                    <?php echo e(html()->label('New Password')->for('password')); ?>


                    <?php echo e(html()->password('password')
                        ->class('form-control')
                        ->placeholder('New Password')
                        ->required()); ?>

                </div><!--form-group-->

                <div class="form-group">
                    <?php echo e(html()->label('New Password Again')->for('password_confirmation')); ?>


                    <?php echo e(html()->password('password_confirmation')
                        ->class('form-control')
                        ->placeholder('New Password Again')
                        ->required()); ?>

                </div><!--form-group-->
                <div class="form-actions text-right">
                    <?php echo e(form_submit(__('labels.general.buttons.update') . ' ' . __('validation.attributes.frontend.password'))); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php echo e(html()->form()->close()); ?>

<?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/user/account/tabs/change-password.blade.php ENDPATH**/ ?>