<div class="order-summary-grid">
    <div class="order-info-row add-border <?php echo e($type != 'consumables' ? 'stock' : 'consumables'); ?> <?php echo e($isCustomerAdmin ? '' : 'admin'); ?>">
        <div class="order-info-column">
            <div class="order-info-header">Customer</div>
            <div class="order-info-value <?php echo e($type == 'stock' ? 'status' : ''); ?>"><b><?php echo e($order->user->ac_code); ?> - <?php echo e($order->user->getBusinessName()); ?></b></div>
        </div>
        <div class="order-info-column">
            <div class="order-info-header">Submitted On</div>
            <div class="order-info-value"><b><?php echo e(date_time_format($order->created_at,'d-M-Y h:i a')); ?></b></div>
        </div>
        <?php if($type == 'stock'): ?>
            <div class="order-info-column">
                <div class="order-info-header">Patient/Reference</div>
                <div class="order-info-value"><b><?php echo e($stockOrder->order->patient); ?></b></div>
            </div>
        <?php endif; ?>

        <?php if($type == 'rx'): ?>
            <div class="order-info-column">
                <div class="order-info-header">Patient/Reference</div>
                <div class="order-info-value"><b><?php echo e($rxOrderArray['name']); ?></b></div>
            </div>
        <?php endif; ?>
        
        <div class="order-info-column">
            <div class="order-info-header">
                <?php if($type == 'stock'): ?>
                    <?php echo e($stockOrder->order->online ? 'Web Order No.' : 'Offline Order No.'); ?>

                <?php else: ?>
                    <?php echo e($isCustomerAdmin ? 'Order No' : ($order->online ? 'Web Order No.' : 'Offline Order No.')); ?>

                <?php endif; ?>
            </div>
            <div class="order-info-value"><b>
                <?php if($type == 'stock'): ?>
                    <?php echo e($isCustomerAdmin ? $stockOrder->order->getOfflineOrderNumber() : $stockOrder->order->getOrderNumber()); ?>

                <?php else: ?>
                    <?php echo e($isCustomerAdmin ? $order->getOfflineOrderNumber() : $order->getOrderNumber()); ?>

                <?php endif; ?>
            </b></div>
        </div>
    </div>

    <div class="order-info-row customer-admin">

        <div class="order-info-column admin">
            <div class="order-info-header admin">Order Type</div>
            <div class="order-info-value admin order-type-value">
                <span class="order-type-label"><?php echo $order->type_label; ?></span>
            </div>
        </div>

        <div class="order-info-column">
            <div class="order-info-header">Invoice</div>
            <div class="order-info-value"><b><?php echo e($order->invoice_no); ?></b></div>
        </div>
        <div class="order-info-column">
            <div class="order-info-header">Tray</div>
            <div class="order-info-value"><b><?php echo e($order->tray); ?></b></div>
        </div>

        <div class="order-info-column">
            <div class="order-info-header">Status</div>
            <div class="order-info-value status">
                <?php echo $order->getTrakingStatus(true); ?>

            </div>
        </div>

        <div class="order-info-column">
           <?php if(!empty($order->tracking_no)): ?>
                <div class="order-info-header">Tracking Info</div>
                    <?php switch(strtolower($order->shipping_carrier)):
                        case ('ics'): ?>
                            <div class="order-info-value" tracking_no="<?php echo e($order->tracking_no); ?>" data-ship-type="<?php echo e($order->shipping_carrier); ?>">
                                <b>ICS Tracking # <a target="_blank" href="http://www.icscourier.ca/online-services/tracking.aspx?trackNums=<?php echo e($order->tracking_no); ?>"><?php echo e($order->tracking_no); ?></a></b>
                            </div>
                            <?php break; ?>
                        <?php case ('fedex'): ?>
                            <div class="order-info-value" tracking_no="<?php echo e($order->tracking_no); ?>" data-ship-type="<?php echo e($order->shipping_carrier); ?>">
                                <b>FedEx Tracking # <a target="_blank" href="https://www.fedex.com/apps/fedextrack/?action=track&trackingnumber=<?php echo e($order->tracking_no); ?>"><?php echo e($order->tracking_no); ?></a></b>
                            </div>
                            <?php break; ?>
                        <?php case ('ups'): ?>
                            <div class="order-info-value" tracking_no="<?php echo e($order->tracking_no); ?>" data-ship-type="<?php echo e($order->shipping_carrier); ?>">
                                <b>UPS Tracking # <a target="_blank" href="http://wwwapps.ups.com/WebTracking/track?track=yes&trackNums=<?php echo e($order->tracking_no); ?>"><?php echo e($order->tracking_no); ?></a></b>
                            </div>
                            <?php break; ?>
                    <?php endswitch; ?>
            <?php else: ?>
                <div class="order-info-header">ETA</div>
                <div class="order-info-value"><b><?php echo e($order->eta ? $order->eta->format('Y-m-d') : ''); ?></b></div>
            <?php endif; ?>
        </div>
       
      
    </div>
</div><?php /**PATH /var/www/html/lens-shapers/resources/views/partials/ordersummary/details.blade.php ENDPATH**/ ?>