<?php
use App\Models\Backend\ScheduledCrons;

$cron = ScheduledCrons::getActive();
?>


<?php $__env->startSection('title', 'Setup' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name()); ?>

<?php $__env->startSection('content'); ?>
<!-- <h1 class="page-title"> Update Product Paramters and Prices</h1> -->
<div class="row profile-account">
    <div class="col-md-2">
        <ul class="ver-inline-menu admin tabbable margin-bottom-10">
            <?php if(auth()->user()->isAcessible(['backend admin'])): ?>
                <li class="<?php echo e(request()->get('tab') === 'rx' || !request()->has('tab') ? 'active' : ''); ?>">
                    <a data-tab-target="rx">Rx Lenses</a>
                    <span class="after"> </span>
                </li>
                <li class="<?php echo e(request()->get('tab') === 'stock' ? 'active' : ''); ?>">
                    <a data-tab-target="stock">Stock Lenses</a>
                </li>


                <li class="<?php echo e(request()->get('tab') === 'consumable' ? 'active' : ''); ?>">
                    <a data-tab-target="consumable">Consumables</a>
                </li>

                <li class="<?php echo e(request()->get('tab') === 'rx_lens_addons' ? 'active' : ''); ?>">
                    <a data-tab-target="rx_lens_addons">Rx Lenses Addons</a>
                </li>

                <li class="<?php echo e(request()->get('tab') === 'rx_additional_charges' ? 'active' : ''); ?>">
                    <a data-tab-target="rx_additional_charges">Rx Lenses Additional Charges</a>
                </li>

                <li class="<?php echo e(request()->get('tab') === 'rx_base_cruve' ? 'active' : ''); ?>">
                    <a data-tab-target="rx_base_cruve">Base Curve</a>
                </li>

                <li class="<?php echo e(request()->get('tab') === 'religions' ? 'active' : ''); ?>">
                    <a data-tab-target="religions">Celebrates Holidays</a>
                </li>

                <li class="<?php echo e(request()->get('tab') === 'assets' ? 'active' : ''); ?>">
                    <a data-tab-target="assets">Assets</a>
                </li>

                <li class="<?php echo e(request()->get('tab') === 'dashboard' ? 'active' : ''); ?>">
                    <a data-tab-target="dashboard">Dashboard</a>
                </li>

                <li class="<?php echo e(request()->get('tab') === 'stock_center_price' ? 'active' : ''); ?>">
                    <a data-tab-target="stock_center_price">Stock Center Price</a>
                </li>

                <li class="<?php echo e(request()->get('tab') === 'help_video_link' ? 'active' : ''); ?>">
                    <a data-tab-target="help_video_link">Help Video Link</a>
                </li>

                <li class="<?php echo e(request()->get('tab') === 'frame_assets' ? 'active' : ''); ?>">
                    <a data-tab-target="frame_assets">Frame Assets</a>
                </li>

               <li class="<?php echo e(request()->get('tab') === 'cron_tab' ? 'active' : ''); ?>">
                    <a data-tab-target="cron_tab">Cron List</a>
                </li>

                <li class="<?php echo e(request()->get('tab') === 'orderstatus' ? 'active' : ''); ?>">
                    <a data-tab-target="orderstatus">Order Status</a>
                </li>
            <?php endif; ?>
            <?php if(auth()->user()->isAcessible(['backend admin']) || auth()->user()->isLabManager()): ?>
                <li class="<?php echo e(request()->get('tab') === 'frame_tab' ? 'active' : ''); ?>">
                    <a data-tab-target="frame_tab">Frames</a>
                </li>
            <?php endif; ?>
            <?php if(auth()->user()->isAcessible(['backend admin'])): ?>
                <li class="<?php echo e(request()->get('tab') === 'laborder_tab' ? 'active' : ''); ?>">
                    <a data-tab-target="laborder_tab">LabZilla Control</a>
                </li>
            <?php endif; ?>
        </ul>

    </div>
    <div class="col-md-10" >
        <?php if(!empty($cron)): ?>
            <div class="alert alert-success cron-alert" role="alert">
                <?php echo e($cron->details); ?>

            </div>
        <?php else: ?>
            <div class="alert alert-success cron-alert" role="alert" style="display:none;">
            </div>
        <?php endif; ?>
        <div class="tab-content">
            <?php if(auth()->user()->isAcessible(['backend admin'])): ?>
                <div id="rx" class="tab-pane <?php echo e(request()->get('tab') === 'rx' || !request()->has('tab') ? 'show active' : ''); ?>">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.rx', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="stock" class="tab-pane <?php echo e(request()->get('tab') === 'stock' ? 'show active' : ''); ?>">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.stock', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="consumable" class="tab-pane">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.consumable', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="rx_lens_addons" class="tab-pane">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.rx_lens_addons', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="rx_additional_charges" class="tab-pane">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.rx_additional_charges', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="rx_base_cruve" class="tab-pane">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.rx_base_cruve', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="religions" class="tab-pane">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.religions', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="assets" class="tab-pane">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.assets', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="dashboard" class="tab-pane">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="stock_center_price" class="tab-pane">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.stock_center_price', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="help_video_link" class="tab-pane">
                    <?php echo $__env->make('backend.auth.orders.includes.tabs.help_video_link', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="frame_assets" class="tab-pane">
                    <?php echo $__env->make('backend.frames.assets', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <div id="cron_tab" class="tab-pane <?php echo e(request()->get('tab') === 'cron_tab' ? 'show active' : ''); ?>">
                    <?php echo $__env->make('backend.cron.index', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 
                </div>
                <div id="orderstatus" class="tab-pane <?php echo e(request()->get('tab') === 'orderstatus' ? 'show active' : ''); ?>">
                    <?php echo $__env->make('backend.orderstatus.index', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 
                </div>
            <?php endif; ?>
            <?php if(auth()->user()->isAcessible(['backend admin']) || auth()->user()->isLabManager()): ?>
                <div id="frame_tab" class="tab-pane <?php echo e(request()->get('tab') === 'frame_tab' ? 'show active' : ''); ?>">
                    <?php echo $__env->make('backend.frames.index', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            <?php endif; ?>
             <?php if(auth()->user()->isAcessible(['backend admin']) || auth()->user()->isLabManager()): ?>
                <div id="laborder_tab" class="tab-pane <?php echo e(request()->get('tab') === 'laborder_tab' ? 'show active' : ''); ?>">
                    <?php echo $__env->make('backend.laborder.configuration', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            <?php endif; ?>
    </div>
    </div>
    <!--end col-md-9-->
</div>
<div class="modal fade bs-modal-lg" id="show-custom-list" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <?php echo e(html()->form('POST', route('admin.religions.store'))->class('form-actions top')->attribute('id','list-form')->open()); ?>

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"><i class="fa fa-bookmark" aria-hidden="true"></i>&nbsp;&nbsp;Add New</h4>
            </div>
            <div class="modal-body">
                <div class="form-body">
                    <div class="col">
                        <div class="form-group">
                            <?php echo e(html()->label('Name')->class('form-control-label')->for('name')); ?>

                            <div class="input-group">
                                <span class="input-group-text input-circle-left">
                                    <i class="fa fa-user"></i>
                                </span>
                                <?php echo e(html()->text('name')
                                    ->class('form-control')
                                    ->placeholder('Name')
                                    ->attribute('maxlength', 191)
                                    ->required()
                                    ->autofocus()); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn dark btn-outline">Close</button>
                <?php echo e(form_submit('Submit')); ?>

            </div>
        </div>
        <?php echo e(html()->form()->close()); ?>

    </div>
</div>
 
<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
<script type="text/javascript">

    // Login for  Setup tab admin portal start

    // Define special tabs that need width maintenance
    const SPECIAL_TABS = ['cron_tab', 'frame_tab', 'orderstatus'];
    const SPECIAL_WIDTH_TABS = ['cron_tab', 'frame_tab'];
    const loadedTabs = {};

    // Function to set the proper width for special tabs
    function setSpecialTabWidth() {
        const pageContent = document.querySelector('.page-content');
        if (pageContent) {
            pageContent.style.maxWidth = '100%';
            pageContent.style.width = '100%';
        }
        $('.col-md-2').addClass('extend-width');
        $('.col-md-10').addClass('grid-container');
    }

    // Function to update URL
    function updateUrl(tab) {
        const url = new URL(window.location.href);
        url.searchParams.set('tab', tab);
        window.history.pushState({}, '', url);
    }

    // Handle tab switching manually
    $(document).on('click', 'a[data-tab-target]', function(e) {
        e.preventDefault();
        const $parentLi = $(this).closest('li');
        const targetTab = $(this).attr('data-tab-target');

        // If tab is already active, just apply width adjustments
        if ($parentLi.hasClass('active')) {
            if (SPECIAL_WIDTH_TABS.includes(targetTab)) {
                setSpecialTabWidth();
            }
            return false;
        }

        // Switch tab manually
        $('.ver-inline-menu li').removeClass('active');
        $parentLi.addClass('active');
        $('.tab-pane').removeClass('show active');
        $(`#${targetTab}`).addClass('show active');

        // Update URL
        updateUrl(targetTab);

        // Apply width adjustments
        if (SPECIAL_WIDTH_TABS.includes(targetTab)) {
            setSpecialTabWidth();
        }

        // Load grid if needed
        if (targetTab === 'frame_tab' && !loadedTabs['frame_tab']) {
            if (typeof loadFrameGrid === 'function') {
                loadFrameGrid();
                loadedTabs['frame_tab'] = true;
            } else {
                // Retry after a short delay if not loaded yet
                setTimeout(() => {
                    if (typeof loadFrameGrid === 'function') {
                        loadFrameGrid();
                        loadedTabs['frame_tab'] = true;
                    }
                }, 100);
            }
        } else if (targetTab === 'cron_tab' && !loadedTabs['cron_tab']) {
            loadCronGrid();
            loadedTabs['cron_tab'] = true;
        } else if (targetTab === 'orderstatus' && !loadedTabs['orderstatus']) {
            loadOrderStatusGrid();
            loadedTabs['orderstatus'] = true;
        } else if (targetTab === 'consumable' && !loadedTabs['consumable']) {
            initializeDropzone();
            loadedTabs['consumable'] = true;
        } else if (targetTab === 'assets' && !loadedTabs['assets']) {
            initializeDropzone2();
            loadedTabs['assets'] = true;
        } else if (targetTab === 'frame_assets' && !loadedTabs['frame_assets']) {
            initializeDropzone4();
            loadedTabs['frame_assets'] = true;
        }
    })


    // On page load, initialize active tab
    $(document).ready(function() {
        const urlParams = new URLSearchParams(window.location.search);
        const activeTab = urlParams.get('tab');
        // Apply width adjustments only for specific tabs on page load
        if (SPECIAL_WIDTH_TABS.includes(activeTab)) {
            setSpecialTabWidth();
        }
        // Activate the tab based on URL parameter
        if (activeTab) {
            $('.ver-inline-menu li').removeClass('active');
            $('.tab-pane').removeClass('active');
            $(`a[href="#${activeTab}"]`).parent('li').addClass('active');
            $(`#${activeTab}`).addClass('show active');

            // Load grid only if not already loaded
            if (activeTab === 'frame_tab' && !loadedTabs['frame_tab']) {
                if (typeof loadFrameGrid === 'function') {
                    loadFrameGrid();
                    loadedTabs['frame_tab'] = true;
                } else {
                    // Retry after a short delay if not loaded yet
                    setTimeout(() => {
                        if (typeof loadFrameGrid === 'function') {
                            loadFrameGrid();
                            loadedTabs['frame_tab'] = true;
                        }
                    }, 100);
                }
            } else if (activeTab === 'cron_tab' && !loadedTabs['cron_tab']) {
                loadCronGrid();
                loadedTabs['cron_tab'] = true;
            } else if (activeTab === 'orderstatus' && !loadedTabs['orderstatus']) {
                loadOrderStatusGrid();
                loadedTabs['orderstatus'] = true;
            } else if (activeTab === 'consumable' && !loadedTabs['consumable']) {
                initializeDropzone();
                loadedTabs['consumable'] = true;
            } else if (activeTab === 'assets' && !loadedTabs['assets']) {
                initializeDropzone2();
                loadedTabs['assets'] = true;
            } else if (activeTab === 'frame_assets' && !loadedTabs['frame_assets']) {
                initializeDropzone4();
                loadedTabs['frame_assets'] = true;
            }
        }
    });

    // Login for  Setup tab admin portal end

    var allImages = '<?= !empty($allImages) ? json_encode($allImages) : json_encode([]) ?>';
    var allAssetsImages = '<?= !empty($allAssetsImages) ? json_encode($allAssetsImages) : json_encode([]) ?>';
    var allFlyersImages = '<?= !empty($allFlyersImages) ? json_encode($allFlyersImages) : json_encode([]) ?>';
    let modelAssetsImages = '<?= !empty($modelAssetsImages) ? json_encode($modelAssetsImages) : json_encode([]) ?>';
    $(function() {
        // Initialize inline editing
        
        allImages = $.parseJSON(allImages);
        allAssetsImages = $.parseJSON(allAssetsImages);
        allFlyersImages = $.parseJSON(allFlyersImages);
        modelAssetsImages = $.parseJSON(modelAssetsImages);
        // $(".owl-carousel").owlCarousel({
        //     margin:10,
        //     loop:true
        // });
        $('.file-csv').dropify();
        // $('.file-images').dropify();
        $('.file-csv-form').on('submit',function(event){
            event.preventDefault();
            var url = $(this).attr('action');
            var formData= new FormData();
            var form_data = $(this).serializeArray();
            $.each(form_data, function (key, input) {
                formData.append(input.name, input.value);
            });
            formData.append('attachment_file', $(this).find('.file-csv')[0].files[0]);
            $.each($(".file-images"), function(i, obj) {
                $.each(obj.files,function(j, file){
                    formData.append('images['+j+']', file);
                });
            });
            $.ajax({
                url: url,
                type: "POST",
                data:formData,
                processData: false,
                contentType: false,
                success: function(data){
                    if(data.status){
                        if(data.show_alert){
                            $('.cron-alert').html(data.message)
                            $('.cron-alert').show();
                        }
                        toastr.success(data.message);
                    }
                    else
                        toastr.error(data.message);
                },
                error: function(request, status, error){
                    toastr.error('Error: Something went wrong.');
                }
            });
        });
        $(document).on('change','.update-status',function(e){
            let val = $(this).val();
            if($(this).prop('checked')){
                var status = 1;
            }
            else{
                var status = 0;
            }
            $.post('<?php echo e(route('admin.religions.update-status')); ?>', {_token:'<?php echo e(csrf_token()); ?>', id:val, status:status}, function(data){
                if(data.status){
                    toastr.success(data.message);
                }
                else{
                    toastr.error(data.message);
                }
            });
        });
        $(document).on('click','#add_new_list',function(e){
            $('#list-form')[0].reset();
            $('#show-custom-list').modal('show');
        });
        $(document).on('submit','#list-form',function(e){
            e.preventDefault();
            $.ajax({
                url: $(this).attr('action'),
                type:'POST',
                data: $(this).serialize(),
                success: function(data) {
                    if(data.status){
                        toastr.success(data.message);
                        refreshData();
                        $('#show-custom-list').modal('hide');
                    }else{
                        toastr.error(data.message);
                    }
                },
                error: function(response) {
                    toastr.error('Something went wrong');
                }
            });
        });
        $(document).on('click','.remove-list-data',function(e){
            if(confirm('Are you sure?')){
                $.ajax({
                    url: '<?php echo e(route('admin.religions.destroy')); ?>',
                    type:'POST',
                    data: {id:$(this).attr('data-id'),_token:'<?php echo e(csrf_token()); ?>'},
                    success: function(data) {
                        if(data.status){
                            toastr.success(data.message);
                            refreshData();
                        }else{
                            toastr.error(data.message);
                        }
                    },
                    error: function(response) {
                        toastr.error('Something went wrong');
                    }
                });
            }
        });

        // Simple inline editing implementation to replace jQuery editable plugin
        $('.inline-edit_text').each(function() {
            var $element = $(this);
            var originalValue = $element.data('value') || $element.text();
            var pk = $element.data('pk');
            var url = $element.data('url');

            $element.on('click', function() {
                if ($element.find('input').length > 0) return; // Already editing

                var input = $('<input type="text" class="form-control" style="display: inline-block; width: auto;">');
                input.val(originalValue);
                $element.html(input);
                input.focus().select();

                input.on('blur keypress', function(e) {
                    if (e.type === 'blur' || (e.type === 'keypress' && e.which === 13)) {
                        var newValue = input.val();
                        if (newValue !== originalValue) {
                            // Send AJAX request
                            $.ajax({
                                url: url,
                                type: 'POST',
                                data: {
                                    _token: $('meta[name="csrf-token"]').attr('content'),
                                    pk: pk,
                                    value: newValue
                                },
                                success: function(data) {
                                    if(data.code == 200){
                                        originalValue = newValue;
                                        $element.data('value', newValue);
                                        $element.text(newValue);
                                    } else {
                                        alert('Something went wrong. Please try again!');
                                        $element.text(originalValue);
                                    }
                                },
                                error: function() {
                                    alert('Something went wrong. Please try again!');
                                    $element.text(originalValue);
                                }
                            });
                        } else {
                            $element.text(originalValue);
                        }
                    } else if (e.type === 'keypress' && e.which === 27) { // Escape
                        $element.text(originalValue);
                    }
                });
            });
        });
        Dropzone.options.dropzone =
         {
            init: function() {
                let myDropzone = this;
                $.each(allImages, function (key, value) {
                    myDropzone.displayExistingFile({ name: value.name, size: value.size}, value.path);
                });
            },
            maxFilesize: 12,
            renameFile: function(file) {
                // var dt = new Date();
                // var time = dt.getTime();
               return file.name;
            },
            acceptedFiles: ".jpeg,.jpg,.png,.gif",
            addRemoveLinks: true,
            timeout: 50000,
            removedfile: function(file)
            {
                var name = file.name;
                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('admin.orders.settings')); ?>",
                    data: {filename: name,type:'consumable-image-remove',_token:"<?php echo e(csrf_token()); ?>"},
                    success: function (data){
                        console.log("File has been successfully removed!!");
                        if(data.status)
                            toastr.success(data.message);
                        else
                            toastr.error(data.message);
                    },
                    error: function(e) {
                        console.log(e);
                    }
                });
                    var fileRef;
                    return (fileRef = file.previewElement) != null ?
                    fileRef.parentNode.removeChild(file.previewElement) : void 0;
            },

            success: function(file, response)
            {
                console.log(response);
            },
            error: function(file, response)
            {
               return false;
            }
        };
        Dropzone.options.dropzone2 =
         {
            init: function() {
                let myDropzone = this;
                $.each(allAssetsImages, function (key, value) {
                    mockFile = { name: value.name, size: value.size };

                    myDropzone.emit("addedfile", mockFile);
                    myDropzone.emit("thumbnail", mockFile, value.path);
                    myDropzone.emit("complete", mockFile);
                });
                updateDropzoneTemplate($('#dropzone2'));
            },
            maxFilesize: 12,
            renameFile: function(file) {
                // var dt = new Date();
                // var time = dt.getTime();
               return file.name;
            },
            acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
            addRemoveLinks: true,
            timeout: 50000,
            removedfile: function(file)
            {
                var name = file.name;
                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('admin.orders.settings')); ?>",
                    data: {filename: name,type:'assets-remove',_token:"<?php echo e(csrf_token()); ?>"},
                    success: function (data){
                        if(data.status)
                            toastr.success(data.message);
                        else
                            toastr.error(data.message);
                    },
                    error: function(e) {
                        console.log(e);
                    }
                });
                var fileRef;
                return (fileRef = file.previewElement) != null ?
                fileRef.parentNode.removeChild(file.previewElement) : void 0;
            },
            success: function(file, response)
            {
                let myDropzone = this;
                toastr.success('Uploaded Successfully');
                mockFile = { name: file.name, size: file.size };

                myDropzone.emit("addedfile", mockFile);
                myDropzone.emit("thumbnail", mockFile, '/assets/img/rx-colors/'+file.name);
                myDropzone.emit("complete", mockFile);
                var fileRef;
                (fileRef = file.previewElement) != null ?
                fileRef.parentNode.removeChild(file.previewElement) : void 0;
                setTimeout(function() {
                    updateDropzoneTemplate($('#dropzone2'));
                }, 500);
            },
            error: function(file, response)
            {
                if(response)
                    toastr.error(response);
                return false;
            }
        };
        Dropzone.options.dropzone3 =
         {
            init: function() {
                let myDropzone = this;
                $.each(allFlyersImages, function (key, value) {
                    mockFile = { name: value.name, size: value.size };

                    myDropzone.emit("addedfile", mockFile);
                    myDropzone.emit("thumbnail", mockFile, value.path);
                    myDropzone.emit("complete", mockFile);
                });
                updateDropzoneTemplate($('#dropzone3'));
            },
            maxFilesize: 12,
            renameFile: function(file) {
                // var dt = new Date();
                // var time = dt.getTime();
               return file.name;
            },
            acceptedFiles: ".svg,.png,.jpg,jpeg",
            addRemoveLinks: true,
            createImageThumbnails: true,
            clickable: true,
            timeout: 50000,
            removedfile: function(file)
            {
                var name = file.name;
                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('admin.orders.settings')); ?>",
                    data: {filename: name,type:'flyers-remove',_token:"<?php echo e(csrf_token()); ?>"},
                    success: function (data){
                        if(data.status)
                            toastr.success(data.message);
                        else
                            toastr.error(data.message);
                    },
                    error: function(e) {
                        console.log(e);
                    }
                });
                var fileRef;
                return (fileRef = file.previewElement) != null ?
                fileRef.parentNode.removeChild(file.previewElement) : void 0;
            },
            success: function(file, response)
            {
                let myDropzone = this;
                toastr.success('Uploaded Successfully');
                mockFile = { name: file.name, size: file.size };

                myDropzone.emit("addedfile", mockFile);
                myDropzone.emit("thumbnail", mockFile, '/storage/app/public/flyers/'+file.name);
                myDropzone.emit("complete", mockFile);
                var fileRef;
                (fileRef = file.previewElement) != null ?
                fileRef.parentNode.removeChild(file.previewElement) : void 0;
                setTimeout(function() {
                    updateDropzoneTemplate($('#dropzone3'));
                }, 500);
            },
            error: function(file, response)
            {
                if(response)
                    toastr.error(response);
                return false;
            }
        };
        $(".editable-ajax-form input,.editable-ajax-form select").on('change', function () {
            let form = $(this).closest('form');
            $.ajax({
                url: form.attr('action'),
                type: "POST",
                data:form.serialize(),
                success: function(response){
                    toastr.success(response.message);
                },
                error: function(error){
                    toastr.error('Something went wrong. Please try again later!')
                }
            });
        });

        $(".ajax-form").on('submit', function (event) {
            event.preventDefault();
            let form = $(this);
            var editor = CKEDITOR.instances['dashboard_content'];
            var updatedContent = editor.getData();

            var formData = $(this).serializeArray();
            formData.push({ name: 'dashboard_content2', value: updatedContent });
            var serializedData = $.param(formData);
            $.ajax({
                url: form.attr('action'),
                type: "POST",
                data:serializedData,
                success: function(response){
                    toastr.success(response.message);
                },
                error: function(error){
                    toastr.error('Something went wrong. Please try again later!')
                }
            });
        });
    });
function updateDropzoneTemplate(element){
    let filename = '';
    element.find('.dz-complete').each(function(i, obj) {
        filename = $(obj).find('.dz-details .dz-filename span').text()+' ('+$(obj).find('.dz-details .dz-size span').text()+')';
        $(obj).find('.dz-remove').html(filename+' <span><i class="fa fa-remove"></i></span>');
    });
}

function initializeDropzone() {
    console.log('Initializing dropzone');
    if ($('#dropzone').length > 0) {
        console.log('Dropzone element found, setting options');

        // Check if Dropzone is already attached and destroy it
        if ($('#dropzone').hasClass('dz-clickable')) {
            console.log('Dropzone already attached, destroying existing instance');
            // Find and destroy existing dropzone instance
            if (Dropzone.instances && Dropzone.instances.length > 0) {
                Dropzone.instances.forEach(function(dz) {
                    if (dz.element && dz.element.id === 'dropzone') {
                        dz.destroy();
                    }
                });
            }
        }

        Dropzone.options.dropzone = {
            init: function() {
                console.log('dropzone - init function running');
                console.log('allImages:', allImages);

                let myDropzone = this;
                $.each(allImages, function (key, value) {
                    console.log('Processing consumable image:', value);
                    myDropzone.displayExistingFile({ name: value.name, size: value.size}, value.path);
                });
            },
            maxFilesize: 12,
            renameFile: function(file) {
                return file.name;
            },
            acceptedFiles: ".jpeg,.jpg,.png,.gif",
            addRemoveLinks: true,
            timeout: 50000,
            removedfile: function(file)
            {
                var name = file.name;
                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('admin.orders.settings')); ?>",
                    data: {filename: name,type:'consumable-image-remove',_token:"<?php echo e(csrf_token()); ?>"},
                    success: function (data){
                        console.log("File has been successfully removed!!");
                        if(data.status)
                            toastr.success(data.message);
                        else
                            toastr.error(data.message);
                    },
                    error: function(e) {
                        console.log(e);
                    }
                });
                var fileRef;
                return (fileRef = file.previewElement) != null ?
                fileRef.parentNode.removeChild(file.previewElement) : void 0;
            },

            success: function(file, response)
            {
                console.log(response);
            },
            error: function(file, response)
            {
               return false;
            }
        };
        console.log('Dropzone options set, initializing dropzone');
        // Initialize the dropzone
        new Dropzone("#dropzone");
    } else {
        console.log('Dropzone element not found');
    }
}

function initializeDropzone2() {
    console.log('Initializing dropzone2');
    if ($('#dropzone2').length > 0) {
        console.log('Dropzone2 element found, setting options');

        // Check if Dropzone is already attached and destroy it
        if ($('#dropzone2').hasClass('dz-clickable')) {
            console.log('Dropzone already attached, destroying existing instance');
            // Find and destroy existing dropzone instance
            if (Dropzone.instances && Dropzone.instances.length > 0) {
                Dropzone.instances.forEach(function(dz) {
                    if (dz.element && dz.element.id === 'dropzone2') {
                        dz.destroy();
                    }
                });
            }
        }

        Dropzone.options.dropzone2 = {
            init: function() {
                console.log('dropzone2 - init function running');
                console.log('allAssetsImages:', allAssetsImages);

                let myDropzone = this;
                let parsedAllAssetsImages = allAssetsImages;

                // Parse if it's a string
                if (typeof allAssetsImages === 'string') {
                    try {
                        parsedAllAssetsImages = JSON.parse(allAssetsImages);
                        console.log('Parsed allAssetsImages:', parsedAllAssetsImages);
                    } catch (e) {
                        console.error('Failed to parse allAssetsImages:', e);
                        return;
                    }
                }

                if (Array.isArray(parsedAllAssetsImages)) {
                    $.each(parsedAllAssetsImages, function (key, value) {
                        console.log('Processing asset:', value);
                        mockFile = { name: value.name, size: value.size };

                        myDropzone.emit("addedfile", mockFile);
                        // Use relative path for thumbnail like other dropzones
                        myDropzone.emit("thumbnail", mockFile, '/assets/img/rx-colors/' + value.name);
                        myDropzone.emit("complete", mockFile);
                    });
                } else {
                    console.log('parsedAllAssetsImages is not an array, skipping processing');
                }
                console.log('Calling updateDropzoneTemplate for dropzone2');
                updateDropzoneTemplate($('#dropzone2'));
            },
            maxFilesize: 12,
            renameFile: function(file) {
                return file.name;
            },
            acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
            addRemoveLinks: true,
            timeout: 50000,
            removedfile: function(file)
            {
                var name = file.name;
                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('admin.orders.settings')); ?>",
                    data: {filename: name,type:'assets-remove',_token:"<?php echo e(csrf_token()); ?>"},
                    success: function (data){
                        if(data.status)
                            toastr.success(data.message);
                        else
                            toastr.error(data.message);
                    },
                    error: function(e) {
                        console.log(e);
                    }
                });
                var fileRef;
                return (fileRef = file.previewElement) != null ?
                fileRef.parentNode.removeChild(file.previewElement) : void 0;
            },
            success: function(file, response)
            {
                let myDropzone = this;
                toastr.success('Uploaded Successfully');
                mockFile = { name: file.name, size: file.size };

                myDropzone.emit("addedfile", mockFile);
                myDropzone.emit("thumbnail", mockFile, '/assets/img/rx-colors/'+file.name);
                myDropzone.emit("complete", mockFile);
                var fileRef;
                (fileRef = file.previewElement) != null ?
                fileRef.parentNode.removeChild(file.previewElement) : void 0;
                setTimeout(function() {
                    updateDropzoneTemplate($('#dropzone2'));
                }, 500);
            },
            error: function(file, response)
            {
                if(response)
                    toastr.error(response);
                return false;
            }
        };
        console.log('Dropzone2 options set, initializing dropzone');
        // Initialize the dropzone
        new Dropzone("#dropzone2");
    } else {
        console.log('Dropzone2 element not found');
    }
}

function initializeDropzone4() {
    if ($('#dropzone4').length > 0) {
        // Check if Dropzone is already attached and destroy it
        if ($('#dropzone4').hasClass('dz-clickable')) {
            // Find and destroy existing dropzone instance
            if (Dropzone.instances && Dropzone.instances.length > 0) {
                Dropzone.instances.forEach(function(dz) {
                    if (dz.element && dz.element.id === 'dropzone4') {
                        dz.destroy();
                    }
                });
            }
        }

        Dropzone.options.dropzone4 = {
            init: function() {
                let myDropzone = this;
                let parsedModelAssetsImages = modelAssetsImages;

                // Parse if it's a string
                if (typeof modelAssetsImages === 'string') {
                    try {
                        parsedModelAssetsImages = JSON.parse(modelAssetsImages);
                        console.log('Parsed modelAssetsImages:', parsedModelAssetsImages);
                    } catch (e) {
                        console.error('Failed to parse modelAssetsImages:', e);
                        return;
                    }
                }

                if (Array.isArray(parsedModelAssetsImages)) {
                    $.each(parsedModelAssetsImages, function (key, value) {
                        mockFile = { name: value.name, size: value.size };

                        myDropzone.emit("addedfile", mockFile);
                        // Use relative path for thumbnail like other dropzones
                        myDropzone.emit("thumbnail", mockFile, '/assets/img/models/' + value.name);
                        myDropzone.emit("complete", mockFile);
                    });
                }
                updateDropzoneTemplate($('#dropzone4'));
            },
            maxFilesize: 12,
            renameFile: function(file) {
                return file.name;
            },
            acceptedFiles: ".svg,.png,.jpg,jpeg",
            addRemoveLinks: true,
            createImageThumbnails: true,
            clickable: true,
            timeout: 50000,
            removedfile: function(file)
            {
                var name = file.name;
                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('admin.orders.settings')); ?>",
                    data: {filename: name,type:'assets-model-remove',_token:"<?php echo e(csrf_token()); ?>"},
                    success: function (data){
                        console.log("File has been successfully removed!!", data);
                        if(data.status)
                            toastr.success(data.message);
                        else
                            toastr.error(data.message);
                    },
                    error: function(e) {
                        console.log(e);
                    }
                });
                var fileRef;
                return (fileRef = file.previewElement) != null ?
                fileRef.parentNode.removeChild(file.previewElement) : void 0;
            },
            success: function(file, response)
            {
                let myDropzone = this;
                toastr.success('Uploaded Successfully');
                mockFile = { name: file.name, size: file.size };

                myDropzone.emit("addedfile", mockFile);
                myDropzone.emit("thumbnail", mockFile, '/assets/img/models/'+file.name);
                myDropzone.emit("complete", mockFile);
                var fileRef;
                (fileRef = file.previewElement) != null ?
                fileRef.parentNode.removeChild(file.previewElement) : void 0;
                setTimeout(function() {
                    updateDropzoneTemplate($('#dropzone4'));
                }, 500);
            },
            error: function(file, response)
            {
                if(response)
                    toastr.error(response);
                return false;
            }
        };
        console.log('Dropzone4 options set, initializing dropzone');
        // Initialize the dropzone
        new Dropzone("#dropzone4");
    } else {
        console.log('Dropzone4 element not found');
    }
}
function refreshData(){
    $.ajax({
        url: "<?php echo e(route('admin.religions.list-api')); ?>",
        type: "GET",
        success: function(data){
            $data = $(data);
            $('.list-table').html('');
            $('.list-table').html($data);
        }
    });
}

(function() {
    function init() {
        //  Color Status Tab grid code start
        document.addEventListener('click', (event) => {
            if (event.target.matches('#loadOrdertatus')) {
                document.getElementsByClassName('cron-alert')[0].style.display = 'none';
                loadOrderStatusGrid();
            }
        });

        document.addEventListener('click', (event) => {
            if (event.target.matches('#loadCronGrid')) {
                document.getElementsByClassName('cron-alert')[0].style.display = 'none';
                loadCronGrid();
            }
        });

        function attachDragAndDropListeners() {
            let draggedRow = null;
            // Drag start event (delegated to #tableBody)
            $('#tableBody').on('dragstart', 'tr', function (e) {
                draggedRow = $(this); // Store the dragged row
                $(this).css('opacity', '0.4'); // Visual feedback
            });

            // Drag over event (delegated to #tableBody)
            $('#tableBody').on('dragover', 'tr', function (e) {
                e.preventDefault(); // Allow drop
                const targetRow = $(this); // Get the target row

                // Ensure we're not comparing the dragged row with itself
                if (targetRow[0] !== draggedRow[0]) {
                    const rect = targetRow[0].getBoundingClientRect(); // Get target row's position
                    const next = (e.originalEvent.clientY - rect.top) / (rect.bottom - rect.top) > 0.5; // Check mouse position

                    // Insert the dragged row before or after the target row
                    if (next) {
                        targetRow.after(draggedRow);
                    } else {
                        targetRow.before(draggedRow);
                    }
                }
            });

            // Drag end event (delegated to #tableBody)
            $('#tableBody').on('dragend', 'tr', function (e) {
                $(this).css('opacity', '1');
                updateSortingOrder();
            });
        }

        // Function to update sorting order in the database
        function updateSortingOrder() {
            const order = [];
            const rows = document.querySelectorAll('#tableBody tr');
            rows.forEach((row, index) => {
                const rowId = row.getAttribute('data-id'); // Get the row ID
                if (!rowId) return;  // Skip rows without a data-id attribute
                order.push({ id: rowId, sort_order: index + 1 }); // Add row ID and new sort order
            });

            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

            fetch('/update-sorting-order', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                body: JSON.stringify({ order: order })
            })
            .then(response => response.json())
            .then(data => {
                // Update the sorting column in the DOM
                rows.forEach((row, index) => {
                    const sortingCell = row.children[4]; // Assuming the sorting column is the 5th column (0-based index)
                    sortingCell.textContent = index + 1; // Update the sorting column value
                });
            })
            .catch(error => {
                console.error('Error updating sorting order:', error);
            });
        }

        // Function to load order status grid
        function loadOrderStatusGrid() {
            let indexURL = document.getElementById('orderStatusData').getAttribute('data-order-index');
            $.ajax({
                url: indexURL,
                method: "GET",
                success: function(response) {
                    let orderstatus = response.orderstatus;
                    let stylesHtml = `
                                    <div class="table-responsive order-status-table">
                                        <table class="table table-bordered table-striped table-hover data-table">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Name</th>
                                                <th>Title</th>
                                                <th>Color</th>
                                                <th>Sorting</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tableBody">`;

                    orderstatus.forEach(function(order) {
                        stylesHtml += `
                            <tr data-id="${order.id}" id="order-${order.id}" draggable="true">
                                <td>${order.id}</td>
                                <td>${order.name}</td>
                                <td>${order.title}</td>
                                <td id="${order.id}" class="main-color-picker">
                                    <span class="pick-color"><input type="color" value="${order.color}" style="background-color:${order.color}" class="color-picker" onchange="updateColor(this, '${order.id}', 'update')"></span>
                                    <span class="color-code" onclick="updateColor(this, '${order.id}', 'edit')">${order.color}</span>
                                </td>
                                <td>${order.sorting}</td>
                                <td class="${order.active == '1' ? 'text-success' : 'text-danger'}">  ${order.active == '1' ? 'Active' : 'InActive'} </td>
                            </tr>
                        `;
                    });

                    stylesHtml += `
                    </tbody>
                    </table>
                    </div>
                    `;

                    $('#orderStatusData').html(stylesHtml);
                    // Re-attach drag-and-drop listeners after content is loaded
                    attachDragAndDropListeners();
                },
                error: function() {
                    $('#orderStatusData').html('<p>Sorry, there was an error loading the data.</p>');
                }
            });
        }

        // Function to update the color in the database
        function updateColor(colorInput, orderId, type)
        {
            const selectedColor = colorInput.value;
            const td = document.getElementById(orderId);
            if (td && type == 'update') {
                td.innerHTML = '';
                // Create the color code span
                let colorCode = document.createElement('span');
                colorCode.classList.add('color-code');
                colorCode.textContent = selectedColor;
                colorCode.setAttribute('onclick', `updateColor(this, '${orderId}', 'edit')`);

                // Create the pick-color span element
                let pickColor = document.createElement('span');
                pickColor.classList.add('pick-color');

                // Create the color input element
                let colorInputElement = document.createElement('input');
                colorInputElement.type = 'color';
                colorInputElement.value = selectedColor;
                colorInputElement.style.backgroundColor = selectedColor;
                colorInputElement.classList.add('color-picker');
                colorInputElement.setAttribute('onchange', `updateColor(this, '${orderId}', 'update')`);

                // Append the color input to the pick-color span
                pickColor.appendChild(colorInputElement);

                // Append both spans to the parent td element
                td.appendChild(pickColor);
                td.appendChild(colorCode);
            }

            const colorCode = td.querySelector('.color-code');
            if (colorCode && type == 'edit') {
                // Replace the color code span with an input field
                const colorInputElement = document.createElement('input');
                colorInputElement.type = 'text';
                colorInputElement.value = colorCode.textContent;
                colorInputElement.classList.add('input-color-picker');
                colorInputElement.setAttribute('onchange', `updateColor(this, '${orderId}', 'update')`);
                // Replace the color code span with the new input
                td.replaceChild(colorInputElement, colorCode);
                colorInputElement.focus(); // Focus on the new input field

                // Add event listener to detect clicks outside the input field
                document.addEventListener('click', function onClickOutside(event) {
                    // Check if the click is outside the td and not on the .color-code element
                    if (!td.contains(event.target) && !event.target.closest('.color-code')) {
                        // Check if the colorInputElement is still a child of the td
                        if (td.contains(colorInputElement)) {
                            // If the click is outside the td and not on .color-code, revert the input back to a span
                            const updatedColorCode = document.createElement('span');
                            updatedColorCode.classList.add('color-code');
                            updatedColorCode.textContent = colorInputElement.value;
                            updatedColorCode.setAttribute('onclick', `updateColor(this, '${orderId}', 'edit')`);
                            // Replace the input with the new span
                            td.replaceChild(updatedColorCode, colorInputElement);
                        }
                        // Remove the event listener
                        document.removeEventListener('click', onClickOutside);
                    }
                });
            }
            if (colorInput.value !== undefined && colorInput.value !== null && colorInput.value !== '') {
                var xhr = new XMLHttpRequest();
                xhr.open('POST', '/update-color', true);
                xhr.setRequestHeader('Content-Type', 'application/json');
                var csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);

                xhr.onload = function () {
                    if (xhr.status === 200) {
                        colorInput.style.backgroundColor = colorInput.value;
                        if (type == 'edit') {
                            const updatedColorCode = document.createElement('span');
                            updatedColorCode.classList.add('color-code');
                            updatedColorCode.textContent = colorInput.value;
                            updatedColorCode.setAttribute('onclick', `updateColor(this, '${orderId}', 'edit')`);
                            td.replaceChild(updatedColorCode, colorInput);
                            // Reload the entire page after success
                            document.getElementById('loadOrdertatus').click();
                        }
                    }
                };
                xhr.send(JSON.stringify({
                    orderId: orderId,
                    newColor: selectedColor
                }));
            } else {
                // If no change, revert to the original color code span
                const colorCode = td.querySelector('.color-code');
                if (colorCode) {
                    const originalColor = colorCode.textContent; // Get the original color value
                    const updatedColorCode = document.createElement('span');
                    updatedColorCode.classList.add('color-code');
                    updatedColorCode.textContent = originalColor;
                    updatedColorCode.setAttribute('onclick', `updateColor(this, '${orderId}', 'edit')`);
                    // Replace the input with the original span (color code)
                    td.replaceChild(updatedColorCode, colorInput);
                }
            }
        }
        //  Color Status Tab grid code end

        function modifyDescription(td) {
            // Check if already in edit mode (input field exists)
            if (td.querySelector('input')) {
                return; // Exit if already editing
            }
            
            var originalContent = td.textContent.trim(); // Use textContent to avoid HTML issues
            td.innerHTML = `<input type="text" value="${originalContent}"
                                  onblur="saveDescription(this, ${td.id})"
                                  class="editable-input" maxlength="255" />`;
            td.querySelector('input').focus();
        }

        function saveDescription(input, id) {
            var updatedDescription = input.value;
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '/save-description', true);
            xhr.setRequestHeader('Content-Type', 'application/json');
            var csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
            xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    input.parentElement.innerHTML = updatedDescription;
                }
            };
            xhr.send(JSON.stringify({
                id: id,
                description: updatedDescription
            }));
        }

        function loadCronGrid() {
            const headerClass = document.querySelector('.navbar-fixed-top');
            const pageContent = document.querySelector('.page-content');
            if (pageContent) {
                pageContent.style.maxWidth = 'inherit';
                pageContent.style.width = '100%';
                pageContent.style.maxWidth = '100%';
                headerClass.style.maxWidth = '100%';
            }
            let indexURL = document.getElementById('cronData').getAttribute('data-cron-index');
            $.ajax({
                url: indexURL,
                method: "GET",
                success: function(response) {
                    let crons = response.crons;
                    let stylesHtml = `
                                    <div class="table-responsive">
                                    <table class="table table-bordered table-striped table-sm table-hover w-auto data-table">
                                        <thead>
                                            <tr>
                                                <th>Command</th>
                                                <th>Description</th>
                                                <th>Name</th>
                                                <th>Short Description</th>
                                                <th>Last Ran</th>
                                                <th>Next Scheduled</th>
                                                <th>Status</th>
                                                <th>Minute</th>
                                                <th>Hour</th>
                                                <th>Day</th>
                                                <th>Month</th>
                                                <th>Weekday</th>
                                            </tr>
                                        </thead>
                                        <tbody>`;
                                        crons.forEach(function(cron) {
                                            stylesHtml += `
                                                <tr>
                                                    <td title="${cron.command}">${cron.command && cron.command.length > 100 ? cron.command.substring(0, 100) + '...' : cron.command}</td>
                                                    <td class="text-wrap" style="width: 50rem;"
                                                        onclick="modifyDescription(this)"
                                                        ondblclick="return false;"
                                                        id="${cron.id}"
                                                        data-original-content="${cron.description && cron.description.length > 100 ? cron.description.substring(0, 100) + '...' : cron.description}">
                                                        ${cron.description && cron.description.length > 100 ? cron.description.substring(0, 100) + '...' : cron.description}
                                                    </td>
                                                    <td>${cron.name ? cron.name : '-'}</td>
                                                    <td>${cron.short_description}</td>
                                                    <td>${cron.last_scheduled ? cron.last_scheduled : '-'}</td>
                                                    <td>${cron.next_scheduled}</td>
                                                    <td class="${cron.status == '1' ? 'text-success' : cron.status == '2' ? 'text-warning' : 'text-danger'}">
                                                        ${cron.status == '1' ? 'Success' : cron.status == '2' ? 'Disabled' : 'Error'}
                                                    </td>
                                                    <td>${cron.minute}</td>
                                                    <td>${cron.hour}</td>
                                                    <td>${cron.day}</td>
                                                    <td>${cron.month}</td>
                                                    <td>${cron.weekday}</td>
                                                    <td>
                                                        <a href="#" class="btn btn-info btn-sm" onclick="getLogs(${cron.id})">Logs</a>
                                                    </td>
                                                </tr>
                                            `;
                                        });
                                stylesHtml += `
                                </tbody>
                            </table>
                        </div>
                            `;
                    $('#cronData').html(stylesHtml);
                },
                error: function() {
                    $('#cronData').html('<p>Sorry, there was an error loading the data.</p>');
                }
            });
        }

        function getLogs(id) {

            let xhr = new XMLHttpRequest();
            xhr.open('GET', '/get-logs?id=' + id, true);
            xhr.onload = function() {
                if (xhr.status === 200) {
                    let response = JSON.parse(xhr.responseText);
                    let logs = response.message.logs;
                    if (!logs) logs = 'No logs available for this job.';
                    document.getElementById('logsContent').innerText = logs;
                    $('#logsModal').modal('show');
                } else {
                    console.error('Request failed with status: ' + xhr.status);
                }
              };
            xhr.onerror = function() {
                console.error('Request failed');
            };
            xhr.send();
        }

        // Make functions global
        window.loadOrderStatusGrid = loadOrderStatusGrid;
        window.loadCronGrid = loadCronGrid;
        window.updateColor = updateColor;
        window.modifyDescription = modifyDescription;
        window.saveDescription = saveDescription;
        window.getLogs = getLogs;
        window.attachDragAndDropListeners = attachDragAndDropListeners;
        window.updateSortingOrder = updateSortingOrder;

        // Cron Tab grid code end
    }

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();  // DOM is already ready—run now
    }
})();

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.split', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/lens-shapers/resources/views/backend/auth/orders/settings.blade.php ENDPATH**/ ?>