<?php $unreadNotifications = $logged_in_user->unreadNotifications(); ?>
<nav class="navbar navbar-expand-lg mega-menu" role="navigation">
    <div class="container-fluid">
        <div class="clearfix fixed-top d-flex align-items-center">
            <!-- Brand and toggle get grouped for better mobile display -->
            <button type="button" class="navbar-toggler" data-toggle="collapse" data-target=".navbar-responsive-collapse">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- End Toggle Button -->
            <!-- BEGIN LOGO -->
            <a id="index" class="page-logo" href="<?php echo e(route('frontend.user.common.dashboard')); ?>" style="text-align: center;">
                <img src="<?php echo e(URL::asset('img/backend/brand/logo.png')); ?>" alt="Logo"> </a>
            <!-- END LOGO -->
            <!-- BEGIN HEADER MENU -->
            <div class="nav-collapse collapse navbar-collapse navbar-responsive-collapse">
                <ul class="navbar-nav">
                    <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkUriPattern('dashboard'),'selected active open')); ?>">
                        <a href="<?php echo e(route('frontend.user.common.dashboard')); ?>" class="text-uppercase">
                            <i class="icon-home"></i> Dashboard </a>
                            <!-- <?php echo svg_image('dashboard.svg', 'svg-icons', 'Dashboard'); ?> <?php echo app('translator')->get('Dashboard'); ?> -->
                        </a>
                    </li>
                    <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkRoute('frontend.user.orders'),'selected active open')); ?>">
                        <a href="<?php echo e(route('frontend.user.orders')); ?>" class="text-uppercase">
                              <i class="icon-basket-loaded"></i> Orders </a>
                             <!-- <?php echo svg_image('orders-menu.svg', 'svg-icons', 'Orders'); ?> <?php echo app('translator')->get('Orders'); ?> -->
                        </a>
                    </li>
                    <?php if(auth()->user()->isAcessible(['view frontend'])): ?>
                        <?php if(auth()->user()->isAcessible(['frontend admin']) || auth()->user()->isOrderPlacedPermission()): ?>
                            <li class="dropdown dropdown-fw dropdown-fw-disabled hover-open-list <?php echo e(active_class(Active::checkUriPattern('orders/create*'),'mselected active')); ?>">
                                <a href="javascript:void(0);" class="text-uppercase">
                                    <i class="icon-basket"></i> New Order </a>
                                    <!-- <?php echo svg_image('new-orders.svg', 'svg-icons', 'New Order'); ?> <?php echo app('translator')->get('New Order'); ?> -->
                                </a>
                                <ul class="dropdown-menu dropdown-menu-fw dropdown-menu-child">
                                    <li class="<?php echo e(active_class(Active::checkUriPattern('orders/create/rx-lens'),'active')); ?>">
                                        <a href="<?php echo e(route('frontend.user.new-rx-lens-order')); ?>">
                                            <img src="<?php echo e(asset('img/orders/rx.svg')); ?>" class="type-icons"> <span class="">Rx Lenses</span> </a>
                                            <!-- <?php echo svg_image('rx.svg', 'svg-icons', 'Rx Lenses'); ?> <?php echo app('translator')->get('Rx Lenses'); ?> -->
                                        </a>
                                    </li>
                                    <?php if(auth()->user()->isStockUser()): ?>
                                        <li class="<?php echo e(active_class(Active::checkUriPattern('orders/create/stock-lens'),'selected active open')); ?>">
                                            <a href="<?php echo e(route('frontend.user.new-stock-lens-order')); ?>">
                                                <img src="<?php echo e(asset('img/orders/sv-g_(stock).svg')); ?>" class="type-icons"> Stock Lenses </a>
                                                <!-- <?php echo svg_image('stock.svg', 'svg-icons', 'Stock Lenses'); ?> <?php echo app('translator')->get('Stock Lenses'); ?> -->
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <li class="<?php echo e(active_class(Active::checkUriPattern('orders/create/consumeables*'),'active')); ?>">
                                        <a href="<?php echo e(route('frontend.user.new-consumables-lens-order')); ?>">
                                            <img src="<?php echo e(asset('img/orders/consumeable.svg')); ?>" class="type-icons"> Consumables </a>
                                            <!-- <?php echo svg_image('consumable.svg', 'svg-icons', 'Consumables'); ?> <?php echo app('translator')->get('Consumables'); ?> -->
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>
                        <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkRoute('frontend.user.saved-orders'),'selected active open')); ?>">
                            <a href="<?php echo e(route('frontend.user.saved-orders')); ?>" class="text-uppercase">
                                <i class="fa fa-save"></i> Saved Orders
                                <!-- <?php echo svg_image('saved-order.svg', 'svg-icons', 'Saved Orders'); ?> <?php echo app('translator')->get('Saved Orders'); ?> -->
                                <?php 
                                    $savedOrdersCount = \App\Models\Backend\Order::where('user_id', auth()->user()->getCustomerAdmin()->id)->where('is_saved',1)->get()->count();
                                ?>
                                <?php if($savedOrdersCount > 0): ?>
                                    <span class="badge badge-danger saved-badge notifications-badge"><?php echo e($savedOrdersCount); ?></span>
                                
                                <?php endif; ?>
                            </a>
                        </li>
                        <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkUriPattern('notifications'),'selected active open')); ?>" id="notification-header-link">
                            <a href="<?php echo e(route('frontend.user.notifications')); ?>" class="text-uppercase">
                                <i class="fa fa-bell"></i> Notifications 
                                <!-- <img class="svg-icons" src="<?php echo e(asset('public/storage/svg/notification.svg')); ?>" alt="Notifications"></img> -->
                                <!-- Notifications  -->
                                <?php if(count($unreadNotifications) > 0): ?>
                                    <span class="badge badge-danger notifications-badge-counter"><?php echo e(count($unreadNotifications)); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-danger notifications-badge-counter"></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('frontend admin')): ?>
                            <?php if($logged_in_user->isStatementAccessible()): ?>
                                <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkUriPattern('statements'),'selected active open')); ?>">
                                    <a href="<?php echo e(route('frontend.statements.index')); ?>" class="text-uppercase">
                                        <i class="fas fa-file-invoice"></i> Statements </a>
                                        <!-- <?php echo svg_image('statements.svg', 'svg-icons', 'Statements'); ?> <?php echo app('translator')->get('Statements'); ?> -->
                                    </a>
                                </li>
                            <?php endif; ?>
                            <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkRoute('frontend.credit-memos.index'),'selected active open')); ?>">
                                <a href="<?php echo e(route('frontend.credit-memos.index')); ?>" class="text-uppercase">
                                     <i class="fas fa-file-alt"></i> Credit Memos </a>
                                    <!-- <?php echo svg_image('credit-memo.svg', 'svg-icons', 'Credit Memos'); ?> <?php echo app('translator')->get('Credit Memos'); ?> -->
                                </a>
                            </li>
                            <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkUriPattern('account'),'selected active open')); ?>">
                                <a href="<?php echo e(route('frontend.user.account')); ?>" class="text-uppercase">
                                     <i class="fa fa-cogs"></i> Settings </a>
                                    <!-- <?php echo svg_image('setting.svg', 'svg-icons', 'Settings'); ?> <?php echo app('translator')->get('Settings'); ?> -->
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                </ul>
            </div>
            <!-- END HEADER MENU -->
            <!-- BEGIN TOPBAR ACTIONS -->
            <div class="topbar-actions">
                <!-- END GROUP NOTIFICATION -->
                <!-- BEGIN USER PROFILE -->
                <div class="btn-group-img btn-group">
                    <button type="button" class="btn btn-sm md-skip dropdown-toggle profile-btn" data-toggle="dropdown">
                        <span class="text-center">
                             <?php echo e($logged_in_user->name); ?> <i class="fa fa-arrow-down"></i> <br>
                            <!-- <?php echo e($logged_in_user->name); ?> <img class="svg-icons" src="<?php echo e(asset('public/storage/svg/arrow-down.svg')); ?>" alt="Arrow Down"></img> <br> -->
                            <?php echo e($logged_in_user->ac_code); ?> - <?php echo e($logged_in_user->getCustomerAdmin()->getBusinessName()); ?>

                        </span>
                        <?php if(!$logged_in_user->getCustomerAdmin()->isGravatar()): ?>
                            <img class="avatar" src="<?php echo e($logged_in_user->getCustomerAdmin()->picture); ?>" alt="">
                        <?php else: ?>
                            <img class="avatar" src="<?php echo e($logged_in_user->getCustomerAdmin()->picture); ?>" alt="" style="display: none;">
                        <?php endif; ?>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-v2 dropdown-menu-start" role="menu">
                        <li>
                            <a href="<?php echo e(route('frontend.user.common.dashboard')); ?>">
                                <i class="icon-home"></i> <?php echo app('translator')->get('Dashboard'); ?> </a>
                                <!-- <?php echo svg_image('dashboard.svg', 'svg-icons', 'Dashboard'); ?> <?php echo app('translator')->get('Dashboard'); ?> </a> -->
                        </li>
                        <li>
                            <a href="<?php echo e(route('frontend.user.orders')); ?>">
                                <i class="icon-basket-loaded"></i> <?php echo app('translator')->get('Orders'); ?> </a>
                                <!-- <?php echo svg_image('orders-menu.svg', 'svg-icons', 'Orders'); ?> <?php echo app('translator')->get('Orders'); ?> </a> -->
                        </li>
                        <li>
                            <a href="<?php echo e(route('frontend.user.account')); ?>#notifications">
                                 <i class="fa fa-bell"></i> <?php echo app('translator')->get('Notifications'); ?> </a>
                                <!-- <?php echo svg_image('notification.svg', 'svg-icons', 'Notifications'); ?> <?php echo app('translator')->get('Notifications'); ?> </a> -->
                        </li>
                        <li>
                            <a href="<?php echo e(route('frontend.user.account')); ?>#account">
                                <i class="fa fa-cogs"></i> Settings
                            </a>
                                <!-- <?php echo svg_image('setting.svg', 'svg-icons', 'Settings'); ?> <?php echo app('translator')->get('Settings'); ?> </a> -->
                        </li>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('frontend admin')): ?>
                        <?php endif; ?>
                        <?php if(session()->has('admin_user_id') && session()->has('temp_user_id')): ?>
                            <li>
                                <?php echo $logged_in_user->back_to_admin_button; ?>

                            </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo e(route('frontend.auth.logout')); ?>">
                                <i class="icon-key"></i> Log Out </a>
                                <!-- <img class="svg-icons" src="<?php echo e(asset('public/storage/svg/logout.svg')); ?>" alt="Log Out"></img> Log Out </a> -->
                        </li>
                    </ul>
                </div>
                <!-- END USER PROFILE -->
            </div>
            <!-- END TOPBAR ACTIONS -->
        </div>
    </div>
    <!--/container-->
</nav><?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/includes/split-header.blade.php ENDPATH**/ ?>