<?php
$isCustomerAdmin = auth()->user()->hasRole('customer_admin') ? auth()->user()->hasRole('customer_admin') : auth()->user()->hasRole('customer_staff');
?>
    
    <div class="order-info-container">
        
        <?php echo $__env->make('partials.ordersummary.details',[
            'isCustomerAdmin' => $isCustomerAdmin,
            'order' => $order,
            'type' => 'stock',
            'stockOrder' => $stockOrder
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <?php if($stockOrder->r_quantity || $stockOrder->l_quantity): ?>
            <div class="order-summary-container">
                    <div class="lens-order-table <?php echo e($isCustomerAdmin ? 'customer-view' : 'admin-view'); ?>">
                            <div class="order-summary-table-header">
                                <div class="lens-side-col">Stock Lenses</div>
                                <div class="lens-data-col">Sph</div>
                                <div class="lens-data-col">Cyl</div>
                                <div class="lens-qty-col-main">Qty</div>
                                <?php if(!$isCustomerAdmin): ?>
                                    <div class="lens-price-col">Price</div>
                                <?php endif; ?>
                            </div>
                            <?php if($stockOrder->isBoth() || $stockOrder->isRight()): ?>
                            <div class="table-row-stock">
                                <div class="lens-side-col">
                                    <span class="lens-side">R</span>
                                    <span class="lens-spec-col">
                                        <?php if($stockOrder->r_material): ?>
                                            <?php echo e($stockOrder->r_material); ?>

                                            <?php echo e($stockOrder->r_colour ?: $stockOrder->r_colour); ?> 
                                            <?php echo e($stockOrder->r_coating ?:$stockOrder->r_coating); ?>  
                                            <?php echo e($stockOrder->r_size ? $stockOrder->r_size.'mm' : ''); ?>

                                            <?php if(!$isCustomerAdmin): ?>
                                                <?php echo e($stockOrder->r_vendor ? '('.$stockOrder->r_vendor.')' : ''); ?>

                                                <?php echo e($stockOrder->r_cards ? '('.$stockOrder->r_cards.')' : ''); ?>

                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php echo e($stockOrder->r_desc ?: $stockOrder->r_desc); ?>

                                        <?php endif; ?>
                                    </span>
                                </div>
                                <div class="lens-data-col"><?php echo e($stockOrder->r_sph ?? ''); ?></div>
                                <div class="lens-data-col"><?php echo e($stockOrder->r_cyl ?? ''); ?></div>
                                <div class="lens-qty-col"><?php echo e($stockOrder->r_quantity ? $stockOrder->r_quantity : ''); ?></div>
                                <?php if(!$isCustomerAdmin): ?>
                                    <?php if(!empty($stockOrder->r_price)): ?>
                                        <div class="lens-price-col">$<?php echo e($stockOrder->r_price ? number_format($stockOrder->r_price, 2) : ''); ?></div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                            <?php if($stockOrder->isBoth() || $stockOrder->isBarcode() || $stockOrder->isLeft()): ?>
                            <div class="table-row-stock">
                                <div class="lens-side-col">
                                    <span class="lens-side">L</span>
                                    <span class="lens-spec-col">
                                        <?php if($stockOrder->l_material): ?>
                                            <?php echo e($stockOrder->l_material); ?>

                                            <?php echo e($stockOrder->l_colour ?: $stockOrder->l_colour); ?> 
                                            <?php echo e($stockOrder->l_coating ?: $stockOrder->l_coating); ?>  
                                            <?php echo e($stockOrder->l_size ? $stockOrder->l_size.'mm' : ''); ?>

                                            <?php if(!$isCustomerAdmin): ?>
                                                <?php echo e($stockOrder->l_vendor ? '('.$stockOrder->l_vendor.')' : ''); ?>

                                                <?php echo e($stockOrder->l_cards ? '('.$stockOrder->l_cards.')' : ''); ?>

                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php echo e($stockOrder->l_desc ?: $stockOrder->l_desc); ?>

                                        <?php endif; ?>
                                    </span>
                                </div>
                                <div class="lens-data-col"><?php echo e($stockOrder->l_sph ?? ''); ?></div>
                                <div class="lens-data-col"><?php echo e($stockOrder->l_cyl ?? ''); ?></div>
                                <div class="lens-qty-col"><?php echo e($stockOrder->l_quantity ? $stockOrder->l_quantity : ''); ?></div>
                                <?php if(!$isCustomerAdmin): ?>
                                    <?php if(!empty($stockOrder->l_price)): ?>
                                        <div class="lens-price-col">$<?php echo e($stockOrder->l_price ? number_format($stockOrder->l_price, 2) : ''); ?></div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if(!$isCustomerAdmin): ?>
                        <?php
                        $totalPrice = 0;
                        if (!$isCustomerAdmin) {
                            $totalPrice += $stockOrder->r_price ? (float)$stockOrder->r_price : 0;
                            $totalPrice += $stockOrder->l_price ? (float)$stockOrder->l_price : 0;
                        }
                        ?>
                        <div class="total-price-container">
                            <div class="total-price-label">Total:</div>
                            <div class="total-price-value">$<?php echo e(number_format($totalPrice, 2)); ?></div>
                        </div>
                    <?php endif; ?>
            </div>
             <?php else: ?>
                <div class="text-center mt-5">Order data not available.</div>
            <?php endif; ?>
        </div>
    <?php echo $__env->make('partials.actions.printbtn',[
            'isCustomerAdmin' => $isCustomerAdmin,
            'order' => $order
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php /**PATH /var/www/html/lens-shapers/resources/views/partials/stock.blade.php ENDPATH**/ ?>