<style>
    .table thead th {
        position: sticky;
        top: -2px;
        z-index: 1;
        border: none !important;
        background: #C7DCEC !important;
    }

    .table th, 
    .table td {
        border-left: none !important;
        border-right: none !important;
    }

    .table th, .table td {
        width: 10%;
     }
    /* .table th:nth-child(1), .table td:nth-child(1) {
        width: 13%;
    } */
    .table th:nth-child(2), .table td:nth-child(2) {
        width: 29%;
    }
    .table th:nth-child(3), .table td:nth-child(3) {
        width: 27%;
    }
    .table th:nth-child(4), .table td:nth-child(4) {
        width: 34%;
    }

   .table.not-backend th:nth-child(1), .table.not-backend td:nth-child(1) {
        width: 5%;
    }
    .table.not-backend th:nth-child(3), .table.not-backend td:nth-child(3) {
        width: 16%;
    }
    .table.not-backend th:nth-child(4), .table.not-backend td:nth-child(4) {
        width: 33%;
    }
    .table.not-backend th:nth-child(5), .table.not-backend td:nth-child(5) {
        width: 27%;
    }
</style>
<!-- resources/views/partials/orderlist.blade.php -->
<table class="table table-striped table-bordered table-hover order-column split-table box-shadow <?php echo e(!isset($isBackend) ? 'not-backend' : ''); ?>" data-more="<?= (!empty($orders) && $orders->hasMorePages()) ? 'yes' : 'no' ?>" data-page="<?= $pageCount ?>">
        <thead>
            <tr role="row" class="heading">
                <?php if(isset($isBackend) && $isBackend): ?>
                    <th> 
                        <span class="d-block">Order #</span>
                        <span class="d-block">Invoice #</span>
                    </th>
                    <th> 
                        <span class="d-block">Patient Reference</span>
                        <span class="d-block">Order Date</span>
                    </th>
                    <th> 
                        <span class="d-block">Customer</span>
                    </th>
                    <th> 
                        <span class="d-block">Status</span>
                    </th>
                <?php else: ?>
                    <th>
                        <span class="d-block">Order #</span>
                    </th>
                    <th>
                        <span class="d-block">Patient Reference</span>
                    </th>
                    <th>
                        <span class="d-block">Order Date</span>
                    </th>
                    <th>
                        <span class="d-block">Status</span>
                    </th>
                    <th>
                        <span class="d-block">Expected</span>
                    </th>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <?php
                // Determine selected order id from $orderId or query param
                $selectedOrderId = $orderId ?? (request('order') ? intval(request('order')) : null);
            ?>
            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr data-id="<?php echo e($order->id); ?>" class="position-relative<?php echo e(($selectedOrderId && $selectedOrderId == $order->id) ? ' active selected' : ''); ?>" id="tr_order-<?php echo e($order->id); ?>" type="<?php echo e($order->type); ?>">
                    <?php if(isset($isBackend) && $isBackend): ?>
                        <td>
                            <span class="d-block">
                                <?php echo $order->getMethodIcon(); ?> <?php echo e($order->getOrderNumber()); ?>

                            </span>
                            <span class="d-block">
                                <?php echo e($order->invoice_no); ?>

                            </span>
                        </td>
                        <td class="position-relative">
                            <span class="d-block">
                                <?php echo e($order->getPatient()); ?>

                            </span>
                            <span class="ship-date">
                                <?php echo e($order->getOrderDate()); ?>

                            </span>
                        </td>
                        <td>
                            <span class="d-block">
                                <?php echo e(optional($order->user)->ac_code ? optional($order->user)->ac_code . ' - ' . optional($order->user)->getBusinessName() : ''); ?>

                            </span>
                        </td>
                        <td>
                            <?php echo $order->getStatusLabelAttribute(true); ?>

                            <?php
                                $count = $order->unread_notifications_count ?? 0;
                            ?>
                            <?php if($count > 0): ?>
                                <span class="badge badge-danger order_notification-counter"><?php echo e($count); ?></span>
                            <?php else: ?>
                                <span class="badge badge-danger order_notification-counter" style="display:none;">0</span>
                            <?php endif; ?>
                        </td>
                    <?php else: ?>
                        <td>
                            <span class="d-block">
                                <?php echo $order->getMethodIcon(); ?> <?php echo e($order->getOrderNumber()); ?>

                            </span>
                        </td>
                        <td>
                            <span class="d-block">
                                <?php echo e($order->getPatient()); ?>

                            </span>
                        </td>
                        <td>
                            <span class="d-block">
                                <?php echo e($order->getOrderDate('d-M-Y')); ?>

                            </span>
                        </td>
                        <td>
                            <span class="d-block">
                                <?php echo $order->getStatusLabelAttribute(true); ?>

                            </span>
                        </td>
                        <td>
                            <span class="d-block">
                                <?php echo e(!empty($order->eta) ? date('d-M-Y',strtotime($order->eta)) : ''); ?>

                            </span>
                            <?php
                                $count = $order->unread_notifications_count ?? 0;
                            ?>
                            <?php if($count > 0): ?>
                                <span class="badge badge-danger order_notification-counter"><?php echo e($count); ?></span>
                            <?php else: ?>
                                <span class="badge badge-danger order_notification-counter" style="display:none;">0</span>
                            <?php endif; ?>
                        </td>
                    <?php endif; ?>
                </tr>                                
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
   </table>
       <script>
        function ensureSelectedOrderRow() {
            var selectedOrderId = "<?php echo e($selectedOrderId); ?>";
            if (selectedOrderId) {
                var rows = document.querySelectorAll('.split-table tbody tr');
                rows.forEach(function(row) {
                    if (row.getAttribute('data-id') == selectedOrderId) {
                        row.classList.add('selected');
                    } else {
                        row.classList.remove('selected');
                    }
                });
            }
        }
        ensureSelectedOrderRow();
        window.ensureSelectedOrderRow = ensureSelectedOrderRow;
    </script>
    <?php $__env->startPush('after-scripts'); ?>
        <script>
            $(document).ajaxComplete(function() {
                if (typeof window.ensureSelectedOrderRow == 'function') {
                    window.ensureSelectedOrderRow();
                }
            });
        </script>
    <?php $__env->stopPush(); ?><?php /**PATH /var/www/html/lens-shapers/resources/views/partials/orderlist.blade.php ENDPATH**/ ?>