<?php
$showButtons = $showButtons ?? false;
$data = $log->replyModel();
$logs = $data['logs'];
$currentUser = $data['user'];
$isCurrentUser = $log->user_id == auth()->id();
$isDeleteAllowed = $log->created_at->diffInSeconds(now()) <= 30;
$isAdmin = auth()->user()->isAdmin();
$senderClass = $isCurrentUser ? ($isAdmin ? 'sender-admin' : 'sender-customer') : ($isAdmin ? 'sender-customer' : 'sender-admin');
$ownerClass = $isCurrentUser ? 'current-user' : '';
?>
<li class="media comment comment-<?php echo e($log->id); ?> main-comment <?php echo e($ownerClass); ?>" 
    data-id="<?php echo e($log->id); ?>" 
    data-owner="<?php echo e($isCurrentUser ? 'current-user' : 'other-user'); ?>"
    data-sender="<?php echo e($isAdmin ? 'admin' : 'customer'); ?>">
    
    <div class="media-body todo-comment">
        <div class="comment-header">
            <?php if($log->getProfileImage()): ?>
                <img class="todo-userpic comment-avatar" src="<?php echo e($log->getProfileImage()); ?>" width="32" height="32">
            <?php endif; ?>
            <div class="user-info">
                <span class="todo-comment-username"><?php echo e($log->user->full_name); ?></span>
                <span class="todo-comment-date">
                    <?php echo e($log->created_at->diffForHumans()); ?>

                </span>
            </div>
            <?php if($log->isQuestion()): ?>
                <span class="comment-type badge-info float-right"><?php echo $log->getIcon(); ?> Order Enquiry</span>
            <?php elseif($log->isRequestChange()): ?>
                <span class="comment-type badge-warning float-right"><?php echo $log->getIcon(); ?> Order Change</span>
            <?php elseif($log->isRequestCancellation()): ?>
                <span class="comment-type badge-danger float-right"><?php echo $log->getIcon(); ?> Order Cancellation</span>
            <?php elseif($log->isPhoneLog()): ?>
                <span class="comment-type badge text-bg-secondary float-right"><?php echo $log->getIcon(); ?> Phone Log</span>   
            <?php else: ?>
                <span class="comment-type badge text-bg-secondary float-right"><?php echo $log->getIcon(); ?>Private Note</span>
            <?php endif; ?>
        </div>
        
        <p class="comment-content">
            <?php echo e($log->description); ?>

        </p>
        <?php if($showButtons && $isCurrentUser && $isDeleteAllowed): ?>
        <div class="comment-actions-append">
            <a data-id="<?php echo e($log->id); ?>" class="comment-action comp-cmt-tab-edit-btn" data-time="<?php echo e($log->created_at); ?>">
                <i class="fa fa-pencil"></i> Edit
            </a>
            <a data-id="<?php echo e($log->id); ?>" class="comment-action comp-cmt-tab-delete-btn" data-time="<?php echo e($log->created_at); ?>">
                <i class="fa fa-trash"></i> Delete
            </a>
        </div>
        <?php endif; ?>

        <!-- Replies Container -->
        <div class="replies-container">
            <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($reply['replied'] == $log->id): ?>
                <?php 
                    $isReplyCurrentUser = $reply['user_id'] == auth()->id();
                    $replySenderClass = $isReplyCurrentUser ? ($isAdmin ? 'sender-admin' : 'sender-customer') : ($isAdmin ? 'sender-customer' : 'sender-admin');
                    $replyOwnerClass = $isReplyCurrentUser ? 'current-user' : '';
                ?>
                <div class="media comment comment-<?php echo e($reply['id']); ?> reply <?php echo e($replyOwnerClass); ?>" 
                     data-id="<?php echo e($reply['id']); ?>" 
                     data-owner="<?php echo e($isReplyCurrentUser ? 'current-user' : 'other-user'); ?>"
                     data-sender="<?php echo e($isReplyCurrentUser ? ($isAdmin ? 'admin' : 'customer') : ($isAdmin ? 'customer' : 'admin')); ?>">
                    <div class="media-body todo-comment">
                        <div class="comment-header">
                            <?php if($reply['user']['avatar_location']): ?>
                                <img class="todo-userpic comment-avatar" 
                                    src="<?php echo e(asset('storage/app/public/'.$reply['user']['avatar_location'])); ?>" 
                                    width="32" height="32">
                            <?php endif; ?>
                            <div class="user-info">
                                <span class="todo-comment-username"><?php echo e($reply['user']['full_name']); ?></span>
                                <span class="todo-comment-date">
                                    <?php echo e(\Carbon\Carbon::parse($reply['created_at'])->diffForHumans()); ?>

                                </span>
                            </div>
                        </div>
                        <p class="comment-content">
                            <?php echo e($reply['description']); ?>

                            <?php if($isReplyCurrentUser && \Carbon\Carbon::parse($reply['created_at'])->diffInSeconds(now()) <= 30): ?>
                                 <div class="comment-actions-append-reply">
                                    <a data-id="<?php echo e($reply['id']); ?>" class="comment-action comp-cmt-tab-edit-btn" data-time="<?php echo e($reply['created_at']); ?>">
                                        <i class="fa fa-pencil"></i> Edit
                                    </a>
                                    <a data-id="<?php echo e($reply['id']); ?>" class="comment-action comp-cmt-tab-delete-btn" data-time="<?php echo e($reply['created_at']); ?>">
                                        <i class="fa fa-trash"></i> Delete
                                    </a>
                                </div>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <?php if (! ($log->replied)): ?>
        <?php if($log->type != 'notes'): ?>
            <div class="comment-actions">
                <a class="action-btn cmnt-reply-yes" data-id="<?php echo e($log->id); ?>" data-oid="<?php echo e($log->order_id); ?>">
                    <i class="fa fa-check"></i> Yes
                </a>
                <a class="action-btn cmnt-reply-no" data-id="<?php echo e($log->id); ?>" data-oid="<?php echo e($log->order_id); ?>">
                    <i class="fa fa-times"></i> No
                </a>
                <a class="action-btn cmnt-reply-ok" data-id="<?php echo e($log->id); ?>" data-oid="<?php echo e($log->order_id); ?>">
                    <i class="fa fa-check-square-o"></i> OK
                </a>
                <a class="action-btn cmnt-reply-done" data-id="<?php echo e($log->id); ?>" data-oid="<?php echo e($log->order_id); ?>">
                    <i class="fa fa-check-square-o"></i> Done
                </a>
                <a class="action-btn cmnt-reply" data-id="<?php echo e($log->id); ?>" data-oid="<?php echo e($log->order_id); ?>">
                    <i class="fa fa-reply"></i> Reply
                </a>
            </div>
            <div class="reply-form-container" style="display: none;">
                <textarea class="form-control reply-textarea" placeholder="Type your reply..."></textarea>
                <div class="float-end">
                    <button class="btn red btn-sm cancel-reply">Cancel</button>
                    <button class="btn btn-primary btn-sm submit-reply" data-id="<?php echo e($log->id); ?>" data-oid="<?php echo e($log->order_id); ?>">Send</button>
                </div>
            </div>
        <?php endif; ?>
        <?php endif; ?>
    </div>
</li><?php /**PATH /var/www/html/lens-shapers/resources/views/partials/chatbot.blade.php ENDPATH**/ ?>