<?php $__env->startSection('title', 'Rx Order' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name()); ?>
<?php $__env->startSection('content'); ?>
<style>
    .select2-container {
        width: 100% !important;
    }
</style>
<?php echo e(html()->form('POST', route('frontend.store-rx'))->attribute('id','rx-order_form')->open()); ?>

    <input type="hidden" name="submit_type" id="submit_type" value="submitted">
    <input type="hidden" name="data[price]" id="price" value="0">
    <input type="hidden" name="data[prices][total_price]" id="hidden_total_price" value="">
    <input type="hidden" name="data[package_label]" id="package_label" value="">
    <input type="hidden" name="data[package_price]" id="package_price" value="">
    <input type="hidden" name="data[frame_price]" id="frame_price" value="">
    <div class="chide hidden-prices-container">
        <input type="hidden" name="data[prices][right_lens_type]" id="price_right_lens_type" value="0.00">
        <input type="hidden" name="data[prices][left_lens_type]" id="price_left_lens_type" value="0.00">
        <input type="hidden" name="data[prices][custom_clip_on]" id="price_custom_clip_on" value="0.00">
    </div>
    <?php if(isset($editData) && !empty($editData)): ?>
        <?php if($editData['type'] == 'reuse'): ?>
            <div class="row">
                <div class="col-md-12 text-center" style="margin-top: -28px;">
                    <h2 class="badge bg-danger"><i class="fa fa-redo"></i> Reuse of <?php echo e($editData['order']->getOfflineOrderNumber()); ?></h2>
                </div>
            </div>
        <?php elseif($editData['type'] == 'edit'): ?>
            <div class="row">
                <div class="col-md-12 text-center" style="margin-top: -28px;">
                    <h2 class="badge bg-info"><i class="fa fa-pencil"></i> Editing Saved Order <?php echo e($editData['order']->getOfflineOrderNumber()); ?></h2>
                </div>
            </div>
            <input type="hidden" name="data[order_id]" value="<?php echo e($editData['order']->id); ?>">
        <?php else: ?>
            <div id="reason-container">
                <div class="row">
                    <div class="col-md-12 text-center" style="margin-top: -28px;">
                        <h2 class="badge bg-danger"><i class="fa fa-redo"></i> Redo of <?php echo e($editData['order']->getOfflineOrderNumber()); ?></h2>
                    </div>
                </div>
                <input type="hidden" name="reason[id]" value="<?php echo e($editData['id']); ?>" id="order-reason-id">
                <input type="hidden" name="reason[reason]" value="<?php echo e($editData['reason']); ?>" id="order-reason">
                <input type="hidden" name="reason[notes]" value="<?php echo e($editData['notes']); ?>" id="order-reason-notes">
            </div>
        <?php endif; ?>
    <?php endif; ?>
    <div class="row" style="margin-top: -5px;">
        <div class="col-md-7 col-rx-form-container nscroller" style="overflow-x: hidden;">
            <div class="portlet light bordered">
                <!-- <div class="portlet-title">
                    <div class="caption">
                        <i class=" icon-layers font-green"></i>
                        <span class="caption-subject font-green sbold uppercase">New Order</span>
                    </div>
                </div> -->
                <div class="portlet-body form rx-form-content">
                    <?php echo $__env->make('frontend.auth.orders.create.rx-form',$combinationArray, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
        </div>
        <div class="col-md-5">
            <div class="portlet light bordered rx-summary-container" style="padding:5px;padding-bottom: 0px;margin-bottom: 0;">
                <!-- <div class="portlet-title">
                    <h4 class="form-section bold">Summary</h4>
                </div> -->
                <div class="portlet-body">
                    <?php echo $__env->make('frontend.auth.orders.show.includes.rx-form-summary',['rxOrderArray'=>$combinationArray], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>                        
                    <div class="row stock-btn-container mt-5" style="border-top: 1px solid #e7ecf1;padding-top: 10px;padding-left: 10px;padding-right: 10px;">
                        <div class="row m-0 w-100">
                            <div class="col-md-12">
                                <div id="warningMsg">
                                    <div id="warningMsgSP" class=""></div>
                                    <div class="secondD " id="warningMsgCY"></div>
                                    <div id="warningMsgAD" class="secondD "></div>
                                    <div id="warningMsgSG" class="secondD "></div>
                                    <div id="warningCutOut" class="secondD "></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-12 zero-col-padding display-inline-flex">
                            <div class="col-md-4 nopadding">
                                <div class="form-actions btn-custom-focus">
                                    <button type="button" class="btn red btn-cancel">Cancel</button>
                                    <?php echo e(form_cancel('javascript:void(0);','Reset','btn yellow mt-ladda-btn ladda-button btn-outline btn-reset')); ?>

                                </div>
                            </div>
                            <div class="col-md-3 nopadding">
                                <div class="form-actions text-center">
                                </div>
                            </div>
                            <div class="col-md-5 nopadding">
                                <div class="form-actions aligned-stock-btn btn-custom-focus">
                                    <button class="btn green mt-ladda-btn ladda-button btn-outline" id="save_order-btn" type="button" disabled>Save For Later</button>
                                    <button class="btn blue" id="submit-btn" type="submit" disabled>Order Now</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- <div class="draggable-wrapper" id="generic_price_table">
        <div class="position-relative">
            <i class="glyphicon glyphicon-move" style="position: absolute;top: 5px;right: 1px;z-index: 1;font-size: 17px;color: #f4f5f7;"></i>
        </div>
        <div class="generic_content active clearfix blue">
            <div class="generic_head_price clearfix">
                <div class="generic_head_content clearfix">
                    <div class="head_bg"></div>
                    <div class="head">
                        <span>Expected Price</span>
                    </div>

                </div>
                <div class="generic_price_tag clearfix">
                    <span class="price">
                        <span class="sign">$</span>
                        <span class="currency">0</span>
                        <span class="cent">.00</span>
                    </span>
                </div>

            </div>
        </div>
    </div> -->
<?php echo e(html()->form()->close()); ?>

<div class="form-error-toaster" style="display:none;">
</div>
<?php $__env->startPush('after-scripts'); ?>
<script>
    // const wrapper = document.querySelector(".draggable-wrapper"),
    // header = wrapper.querySelector(".generic_head_price");

    // function onDrag({movementX, movementY}){
    //   let getStyle = window.getComputedStyle(wrapper);
    //   let leftVal = parseInt(getStyle.left);
    //   let topVal = parseInt(getStyle.top);
    //   wrapper.style.left = `${leftVal + movementX}px`;
    //   wrapper.style.top = `${topVal + movementY}px`;
    // }

    // header.addEventListener("mousedown", ()=>{
    //   header.classList.add("active");
    //   header.addEventListener("mousemove", onDrag);
    // });

    // document.addEventListener("mouseup", ()=>{
    //   header.classList.remove("active");
    //   header.removeEventListener("mousemove", onDrag);
    // });
  </script>
<script>
    window.isLoaderFStop = true;
    var combinationHideArray = '<?= json_encode($combinationHideArray); ?>';
    var validationUrl = "<?= route('frontend.user.rx-validation-api') ?>";
    var filteredValidationUrl = "<?= route('frontend.user.rx-filtered-validation-api') ?>";
    var cutoutValidationUrl = "<?= route('frontend.user.rx-cutout-validation') ?>";
    var baseColorImgUrl = "<?php echo e(URL::asset('public/assets/img/rx-colors')); ?>";
    var rx_lens_addons_json = "<?php echo e(url('storage/imports/rx_lens_addons.json')); ?>";
    var rx_lens_additional_charges_json = "<?php echo e(url('storage/imports/rx_additional_charges.json')); ?>";
    var rx_base_curve_json_url = "<?php echo e(url('storage/imports/base-curve-calculations.json')); ?>";
    var isOrderEdit = "<?php echo e(isset($editData) && !empty($editData) ? $editData['is_edit'] : false); ?>";
    var isOrderEditMode = false;
    var orderType = "<?php echo e(isset($editData) && !empty($editData) ? $editData['type'] : ''); ?>";
    var editOrderData = <?= isset($editData) && !empty($editData) ? json_encode($editData['order']->rxOrder->data) : 'null' ?>;
    var cstCode = parseInt("<?php echo e($user->profile->cust_prlist_default); ?>");
    var isPricesShow = "<?php echo e(auth()->user()->isOrderPricesInvoicesPermission()); ?>";
    var isMerchantUser = "<?php echo e(auth()->user()->isCustomerAdmin()); ?>";
    var addons_data = '';
    var rxFormData  = '';
    var rxFormDataValues = '';
    var isFillFields = true;
    var prevSelectionLensOption = '';
    var prevSelectionLensOptionType = '';
    var bcCalculations = {};
    var rxAdditionalCharges = {};
    window.isLoaderStop = true;
    var planoLenses = ['right_intermediate_strength','right_sph','left_sph','right_cyl','left_cyl','right_axis','left_axis','right_add','left_add'];
    var docBody = $(document.body);
    var shiftPressed = false;
    var highlightedDDLValue = '';
    var clickedOutside = false;
    var selectionMade = false;
    var isErrorShowFlag = false;
    var select2DataClearing = false;
    var baseCurveField = '';
    var oldBaseCurveField = '';
    var corridorField = '';
    var isPackageSelected = true;
    var packagePrice, additionalHiddenIndex = 0;
    var packageTeir = null;
    var custPriceTag = 'price_'+cstCode;
    let isFormDirty = false;
    var preBrand, preModel, preColour, preSize = null;
    // var savedSelections = {};
    $(function() {
        $('.chatpageloader').show();
        setTimeout(function(){
            $('.chatpageloader').hide();
        },10000);
        if($('#reason-container').length > 0){
            $('.summary-container .reason-content').show();
            let reason = 'REDO OF W'+$('#order-reason-id').val()+': '+$('#order-reason').val()+' ( '+$('#order-reason-notes').val()+' )';
            $('.summary-container #reason-content-field').html(reason);
        }
        rxFormResize();
        $('#submit-btn').removeAttr("disabled", "disabled");
        $('#save_order-btn').removeAttr("disabled", "disabled");
        if(!isPricesShow){
            $('span.price').parent().hide();
            $('span#sm-price').parent().hide();
            $('#hidden_total_price').val('');
        }else{
            $('span.price').parent().hide();
            $('span#sm-price').parent().hide();   
            $('#hidden_total_price').val('');         
        }
        // Removed validationData parsing - no longer needed with backend filtering
        if(!isNullOrEmpty(editOrderData)){
            try{
                editOrderData = editOrderData.replace(/(\r\n|\n|\r)/g,"");
                editOrderData = $.parseJSON(editOrderData);
            }
           catch(err){}
        }
        // if(Cookies.get('rx_form_fields')!=null && typeof $.parseJSON(Cookies.get('rx_form_fields')) == 'object'){
        //     savedSelections = $.parseJSON(Cookies.get('rx_form_fields'));
        // }
        combinationHideArray = $.parseJSON(combinationHideArray);
        $('.content-textarea').on('change keyup keydown paste cut', 'textarea', function () {
            $(this).height(0).height(this.scrollHeight);
        }).find('textarea').change();
        // $(document).scroll(function() {
        //     myID = document.getElementById("generic_price_table");

        //     var myScrollFunc = function () {
        //         var scroll = $(window).scrollTop()+125;
        //         $('#generic_price_table').css('top',scroll+'px');
        //     };

        //     window.addEventListener("scroll", myScrollFunc);
        // });
        $(".cal-base_curve").on("change", function(e){
            calculateMaxDia();
        });
        $('select[size], select[multiple]').on('wheel', function(e) {
            var $this = $(this);
            var scrollTop = this.scrollTop;
            var scrollHeight = this.scrollHeight;
            var height = $this.innerHeight();
            var delta = e.originalEvent.deltaY;
            var scrollingDown = delta > 0;

            if (
                (scrollingDown && scrollTop + height >= scrollHeight) ||
                (!scrollingDown && scrollTop <= 0)
            ) {
                // Let it bubble if at top or bottom
                return;
            }

            // Prevent parent container from scrolling
            e.stopPropagation();
        });
        $(document).on('click','.btn-segment_choice',function() {
            $(this).closest('.btn-group').removeClass('is-invalid');
            
            // Add active class to selected button and remove from siblings
            $(this).addClass('active').siblings('.btn-segment_choice').removeClass('active');
            
            var index = $(this).attr('data-index');
            var segmentElement = $(this);
            console.log('Clicked segment_choice with index:', index);
            setTimeout(function(){
                switch(index){
                    case 'lens_type':
                        var lens_type = $("input[name='data[lens][lens_type]']:checked"). val();

                        if(combinationHideArray.hasOwnProperty("lens_type") && typeof combinationHideArray.lens_type[lens_type] !== 'undefined'){

                            // removeCondition(combinationHideArray.lens_type);

                            showHideFields(combinationHideArray.lens_type[lens_type]);
                        }
                        updateLensArea(lens_type);
                    break;
                    case 'sv':
                        var lens_type = $("input[name='data[lens][lens_type]']:checked").val();
                        var sv_type = $("input[name='data[lens][lens_type][sv]']:checked").val();
                        if(combinationHideArray.hasOwnProperty("lens_type") && typeof combinationHideArray.lens_type[lens_type] !== 'undefined'){

                            removeCondition(combinationHideArray.lens_type[lens_type]['options']);

                            showHideFields(combinationHideArray.lens_type[lens_type]['options'][sv_type]);
                        }
                    break;
                    case 'progressive':
                        var lens_type = $("input[name='data[lens][lens_type]']:checked"). val();
                        var sv_type = $("input[name='data[lens][lens_type][progressive]']:checked"). val();
                        if(combinationHideArray.hasOwnProperty("lens_type") && typeof combinationHideArray.lens_type[lens_type] !== 'undefined'){

                            removeCondition(combinationHideArray.lens_type[lens_type]['options']);

                            showHideFields(combinationHideArray.lens_type[lens_type]['options'][sv_type]);
                        }
                    break;
                    case 'job_type':
                        $('.total_price-container').find('#lab-supplies-price').remove();
                        updateAdditionalHiddenInputPrices('frame','','');
                        $('#frame_price').val('0.00');
                        var job_type = $("input[name='data[frame][job_type]']:checked"). val();
                        console.log('Job type selected:', job_type);
                        console.log('Active labels:', $('.btn-frame_job_type_choice.active').length);
                        if(combinationHideArray.hasOwnProperty("job_type") && typeof combinationHideArray.job_type[job_type] !== 'undefined'){
                            // if(job_type == 'edged_frame_to_follow')
                            //     $('#model').addClass('required');
                            // else
                            //     $('#model').removeClass('required');

                            validateCheckBoxes();
                            checkBevelType();

                            removeCondition(combinationHideArray.job_type);

                            showHideFields(combinationHideArray.job_type[job_type]);
                        }
                        filterFrameInfo('brand','');
                        updateInvoiceOrderNo(1);
                        
                        // Update summary display
                        var jobTypeText = segmentElement.find('.label-txt').text().trim();
                        console.log('Job type text for summary:', jobTypeText);
                        $('.summary-container #job_type-field').html(jobTypeText);
                        showHideSummaryElements($('.summary-container #job_type-field'));
                        
                        // Trigger change on the radio to update summary
                        segmentElement.find('input').trigger('change');
                    break;
                    case 'frame_type':
                        var frame_type = $("input[name='data[frame][frame_type]']:checked"). val();
                        if(combinationHideArray.hasOwnProperty("frame_type") && typeof combinationHideArray.frame_type[frame_type] !== 'undefined'){
                            checkBevelType();
                            if(frame_type == 'other')
                                $('#ft_other input').addClass('required');
                            else
                                $('#ft_other input').removeClass('required');

                            removeCondition(combinationHideArray.frame_type);

                            showHideFields(combinationHideArray.frame_type[frame_type]);
                        }
                    break;
                    case 'shape':
                        calculateShapeFactor();
                    break;
                    default:
                        // removeCondition([],'all');
                    break;
                }
            }, 150);
        });
        $(document).on('click','#add_prism-btn',function(e){
            togglePrism();
        });
        $(document).on('click','.copy-distance',function(e){
            copyLeftToRight($(this));
        });
        $(document).on('click','.copy-all-r-l',function(e){
            elements = $(this).parent().parent().find('.copy-distance');
            $.each(elements, function( index, value ) {
                copyLeftToRight($(this));
            });
        });
        $(document).on('click','#remove_prism-link',function(e){
            togglePrism();
        });
        $(document).on('change',".ch_checkboxes",function(e){
            validateCheckBoxes();
        });
        $(document).on('change',"#invoice_order_no_field",function(e){
            updateInvoiceOrderNo(0);
        });
        $(document).on('change',"#packageList",function(e){
            // changePackage();
            // if(isPackageSelected){
                isPackageSelected = false;
                if(!isOrderEditMode){
                    clearSelect2($('#brand'));
                    initLensOptions('package');
                    filterFrameInfo('brand','');
                }
    
                updateLensThicknessOnPackage();
            // }
        });
        $(document).on('change',"#package",function(e){
            isPackageSelected = false;
            clearSelect2($('#brand'));
            $('#right-order_container span').text('');
            $('#left-order_container span').text('');
            $('#right-lens_type-price').text('0.00');
            $('#left-lens_type-price').text('0.00');
            $('.hidden-prices-container #price_right_lens_type').val('');
            $('.hidden-prices-container #price_left_lens_type').val('');

            updateSummaryPrice();
            if(!this.checked){
                $('#packageList').val(null);
                $.each($('.lens-data'), function( index, value ) {
                    $(this).val(null);
                });
                initLensOptions('');
                isPackageSelected = true;
                filterFrameInfo('brand','');
            }else if(isNullOrEmpty($('#packageList').val())){
                $("#packageList").val($("#packageList option:eq(1)").val());
                $('#packageList').trigger('change');
            }
            changePackage();
            updateLensThicknessOnPackage();
        });
        $(document).on('change',"#is_multipair",function(e){
            console.log('Multipair ref container visibility changed to:', this.checked ? 'visible' : 'hidden');
            $('.multipair_ref-container').hide();
            if(this.checked){
                $('.multipair_ref-container').show();
            }
        });
        $(document).on('change',"#package",function(e){
            $('.package-container').hide();
            if(this.checked){
                $('.package-container').show();
            }
        });
        $(document).on('change',"#a,#b",function(e){
            checkAndConditions();
        });
        $(document).on('change',"#a_shape_options",function(e){
            if($(this).val() != ''){
                let max = 0;
                let min = 0.50;
                if($(this).val() == 'Increase By:'){
                    max = rxFormDataValues['aMax'] - $('#a').val();
                }else if($(this).val() == 'Decrease By:'){
                    max =  $('#a').val() - rxFormDataValues['aMin'];
                }else{
                    max =  rxFormDataValues['aMax'];
                    min =  rxFormDataValues['aMin'];
                }
                appendOptionValues($('#a_increased_by'),min,max,0.50,2,null);
            }
        });
        $(document).on('change',"#b_shape_options",function(e){
            if($(this).val() != ''){
                let max = 0;
                let min = 0.50;
                if($(this).val() == 'Increase By:'){
                    max = rxFormDataValues['bMax'] - $('#b').val();
                }else if($(this).val() == 'Decrease By:'){
                    max =  $('#b').val() - rxFormDataValues['bMin'];
                }else{
                    max =  rxFormDataValues['bMax'];
                    min =  rxFormDataValues['bMin'];
                }
                appendOptionValues($('#b_increased_by'),min,max,0.50,2,null);
            }
        });
        $(document).on('change',"#pof",function(e){
            if(this.checked){
                $('.pof-help-text').show();
            }else
                $('.pof-help-text').hide();
        });
        $(document).on('change',".check_required",function(e){
            requiredAttr = $(this).attr('data-if_required');
            requiredAttr = requiredAttr.split(',');
            if(this.checked){
                $(requiredAttr).each(function( index, value ){
                    $('#'+value).addClass('required');
                });
            }else{
                if(this.checked){
                    $(requiredAttr).each(function( index, value ){
                        $('#'+value).removeClass('required');
                    });
                }
            }
        });
        $(document).on('click','.add_container-btn',function(e){
            ids = $(this).attr('data-show');
            $('.'+ids).removeClass('chide');
            $('#'+ids+'-rcontent').removeClass('chide');
            $(this).parent().addClass('chide');
        });
        $(document).on('click','.remove_container-btn',function(e){
            ids = $(this).attr('data-hide');
            $('.'+ids).addClass('chide');
            $('#'+ids+'-rcontent').addClass('chide');
            $(this).parent().parent().parent().find('.show-hide-btn').removeClass('chide');
            switch(ids){
                case 'specify_thickness-content':
                    $('.ct_or_et-container').addClass('chide');
                    $('#safety_stamp-container').addClass('chide');
                break;
                case 'mshape-content':
                    // console.log('here');
                    $('.mshape-content').find('select').val(null).trigger("change");
                    $('.mshape-content').find('input:checkbox').prop('checked', false);
                    break;
            }
        });
        $(document).on('click','.show_hide_buttons',function(e){
            $('.'+$(this).attr('data-attr')).removeClass('hide');
            $(this).toggle();
            syncFieldTabs();
        });
        $(document).on('click','.remove-btn a',function(e){
            $('.'+$(this).attr('data-attr')).addClass('hide');
            $(this).closest('div').toggle();
            $('.show_hide_buttons').toggle();
            syncFieldTabs();
        });
        $(document).on('click','.showhide-container-btn a',function(e){
            $('.'+$(this).attr('data-attr')+'-container').hide();
            $('#'+$(this).attr('data-attr')+'-btn').toggle();
            $('.'+$(this).attr('data-attr')+'-container').find('select,input,selectarea').val(null).trigger('change');
            syncFieldTabs();
        });
        $(document).on('change','.lens-data',function(e){
            let dataName = $(this).attr('data-name');
            
            console.log('Lens data change triggered:', {
                value: $(this).val(),
                type: $(this).attr('data-attr'),
                dataName: dataName,
                elementId: $(this).attr('id')
            });

            // Only call initLensOptions - field visibility will be handled in AJAX callbacks
            if (dataName) {
                console.log('Calling initLensOptions for:', dataName);
                initLensOptions(dataName);
            }
        });
        $(document).on('change','#ed',function(e){
            // if($(this).val() == 'ed'){
            //     // $('#ed').closest('.form-group').parent().removeClass('hide');
            //     $('#shape').addClass('hide');
            // }
            $('#shape').addClass('hide');
            if($(this).val() == 'shape'){
                // $('#ed').closest('.form-group').parent().addClass('hide');
                $('#shape').removeClass('hide');
            }
        });
        $(document).on('change', '.prism_base', function () {
            if($(this).attr('data-name') == 'base1' || $(this).attr('data-name') == 'base2'){
                if (prismBaseChanging) return;

                      const $this = $(this);
                      const id = $this.attr('id');
                      const { side, pairId } = getSideAndPair(id);
                      const $pair = $('#' + pairId);

                      // If no master for this side yet, the first user change becomes master
                      if (!prismMaster[side]) {
                        prismMaster[side] = id;
                      }

                      // If this element is NOT the master, do not modify the master (respect first selection)
                      if (prismMaster[side] !== id) {
                        // if both cleared by user, release the master lock so next selection reassigns it
                        if (!$this.val() && !$pair.val()) {
                          delete prismMaster[side];
                        }
                        return;
                      }

                      // current element *is* the master: enforce rules on the pair (dependent)
                      enforcePairAgainstMaster($this, $pair);

                      // if both selects are empty now, release the master lock
                      if (!$this.val() && !$pair.val()) {
                        delete prismMaster[side];
                      }
            }
        });
        $(document).on('keyup change','.crawl-mx',function(e){
            $(this).removeClass('is-invalid');
            var value = parseFloat($(this).val());
            var min = $(this).attr('min');
            if(typeof min != 'undefined'){
                if(value < parseFloat(min)){
                    $(this).addClass('is-invalid');
                }
            }
            var max = $(this).attr('max');
            if(typeof max != 'undefined'){
                if(value > parseFloat(max)){
                    $(this).addClass('is-invalid');
                }
            }
        });
        $(document).on('click','.btn-cancel',function(e){
            // clearFormElements();
            // location.reload();
            if(isFormDirty){
                swal({
                    title: "You will lose any changes made to this order.",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes",
                    cancelButtonText: "No",
                    closeOnConfirm: true,
                    closeOnCancel: true,
                }, function(isConfirm){
                    if (isConfirm) {
                        isFormDirty = false;
                        window.location.href = "<?php echo e(route('frontend.user.orders')); ?>";
                    }
                });
            }else{                
                window.location.href = "<?php echo e(route('frontend.user.orders')); ?>";
            }
        });
        $(document).on('click','.btn-reset',function(e){
            // clearFormElements();
            // location.reload();
            if(isFormDirty){
                swal({
                    title: "You will lose any changes made to this order.",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes",
                    cancelButtonText: "No",
                    closeOnConfirm: true,
                    closeOnCancel: true,
                }, function(isConfirm){
                    if (isConfirm) {
                        isFormDirty = false;
                        window.location.href = "<?php echo e(route('frontend.user.new-rx-lens-order')); ?>";
                    }
                });
            }else{                
                window.location.href = "<?php echo e(route('frontend.user.new-rx-lens-order')); ?>";
            }
        });
        $(document).on('change',".numeric-value", function(e) {
            // if(e.which != 38 && e.which != 40)
                // e.preventDefault(e);

            if(typeof $(this).attr('data-def') != 'undefined'){
                let defValue = $(this).attr('data-def');
                if(this.value < defValue)
                    this.value = defValue;
            }

            var max = parseInt($(this).attr('max'));
            var min = parseInt($(this).attr('min'));

            // if ($(this).val() > max)
            // {
            //     this.value = max;
            // }
            // else if ($(this).val() < min)
            // {
            //     this.value = min;
            // }

            if($(this).attr('data-pad') != '')
                this.value = PrependZeros(parseInt(this.value),parseInt($(this).attr('data-pad')));

            if($(this).hasClass('distance-input')){
                var type = $("input[name='data[lens][lens_type][sv]']:checked").val();
                var id = $(this).parent().parent().attr('id');
                var value = parseFloat($(this).val());
                if(type == 'sv_intermediate_or_computer')
                {
                    chk = id.split('-');
                    var initValue = 0;
                    if($(this).attr('data-name') == 'sph'){
                        var percentage = parseInt($('#'+chk[0]+'_intermediate_strength').val());
                        if($('#'+chk[0]+'--add').val() != '')
                            initValue = parseFloat($('#'+chk[0]+'--add').val());

                        var numberToAdd = (percentage / 100) * initValue;
                        value = value + numberToAdd;
                        value = nearestRound(value,0.25);
                        value = value.toFixed(2);
                    }
                    else if($(this).attr('data-name') == 'cyl'){
                        if($('#'+chk[0]+'--add').val() != '')
                            initValue = parseFloat($('#'+chk[0]+'--add').val());

                        value = value + initValue;
                        value = nearestRound(value,0.25);
                        value = value.toFixed(2);
                    }
                }
                else if(type == 'sv_reading')
                {
                    chk = id.split('-');
                    var initValue = 0;
                    if($(this).attr('data-name') == 'sph' || $(this).attr('data-name') == 'cyl'){
                        if($('#'+chk[0]+'--add').val() != '')
                            initValue = parseFloat($('#'+chk[0]+'--add').val());

                        value = value + initValue;
                        value = nearestRound(value,0.25);
                    }
                }
                $('#'+id+'-fr').val(value).trigger('change');
            }
            if(typeof $(this).attr('data-round') != 'undefined' && $(this).attr('data-round') != ''){
                val = parseFloat(this.value);
                this.value = val.toFixed($(this).attr('data-round'));
            }
            showSymbol($(this).parent().find('.input-symbol'), $(this));
            applySpecifyRules();
            // this.value = this.value.replace(/(?!^-)[^0-9.]/g, "").replace(/(\..*)\./g, '$1');
        });
        $(document).on('change',".trigger-value",function(e){
            var trigger = $(this).attr('data-trigger');
            var nameArr = trigger.split(',');
            $.each(nameArr, function( index, value ) {
                if($('input[data-attr="'+value+'"]').val() != '')
                    $('input[data-attr="'+value+'"]').trigger('change');
            });
        });
        $(document).on('change',".select2_fixed,#rx-order_form .md-check, #rx-order_form .toggle",function(e){
        //     savedSelections[$(this).attr('id')] = $(this).val();
        //     Cookies.set('rx_form_fields', JSON.stringify(savedSelections));
            let ignoreZeroValue = [
                'cyl',
                'prism1',
                'prism2'
            ];
            if($.inArray($(this).attr('data-name'), ignoreZeroValue ) !== -1 && $(this).val() == '0'){
                $(this).val(null).trigger('change');
                return false;
            }
            setTimeout(function(){
                checkAdditionalCharges();
            }, 500);
            if(!$(this).hasClass('edited'))
                $(this).addClass('edited');

            if($(this).hasClass('sync-lr-field') && !isNullOrEmpty($(this).val())){
                let dir = 'left_';
                if ($(this).attr('id').indexOf("right") >= 0){
                    dir = 'right_';

                    let field = $(this).attr('id').replace(dir, "");
                    if(!isNullOrEmpty($('#right_'+field).val())){
                        let defaultValue = getDefaultValue($('#left_'+field).attr('data-name'));
                        if(isNullOrEmpty($('#left_'+field).val()) || defaultValue == $('#left_'+field).val()){
                            $('#left_'+field).val($('#right_'+field).val()).trigger('change');
                        }
                    }
                }
            }
            if($(this).attr('data-name') == 'add' || $(this).attr('data-name') == 'oc'){
                checkDifferent('right_'+$(this).attr('data-name'),'left_'+$(this).attr('data-name'));
            }
            if($(this).attr('data-name') == 'sph' || $(this).attr('data-name') == 'cyl'){
                let type = 0;
                if($(this).attr('data-name') == 'cyl'){
                    type = 1;
                }else{
                    updateInputMinMax(rxFormDataValues,true);
                }

                checkTheirSign('right_'+$(this).attr('data-name'),'left_'+$(this).attr('data-name'),type);
            }
            if($(this).attr('data-name') == 'sph' && !isNullOrEmpty($(this).val())){
                let type = getDirectionType($(this));
                let cylElement = $('#'+getDirectionType($(this))+'_cyl');
                let axisElement = $('#'+getDirectionType($(this))+'_axis');
                if (!isNullOrEmpty(rxFormDataValues['sphNoCyl']) && rxFormDataValues['sphNoCyl'].includes(parseFloat($(this).val()).toFixed(2))){
                    cylElement.empty();
                    cylElement.addClass('readonly-select2');
                    axisElement.val(null).trigger('change');
                    axisElement.addClass('readonly-select2');
                }else if(cylElement.find('option').length == 0){
                    cylElement.removeClass('readonly-select2');
                    axisElement.removeClass('readonly-select2');
                    let min = parseFloat(cylElement.attr('data-min'));
                    let max = parseFloat(cylElement.attr('data-max'));
                    let round = parseInt(cylElement.attr('data-round'));
                    let increment = parseFloat(cylElement.attr('data-increment'));
                    appendOptionValues(cylElement,min,max,increment,round,null);
                }else{
                    cylElement.removeClass('readonly-select2');
                    axisElement.removeClass('readonly-select2');
                }
            }

            if($('#lens_type').val() == 'Lined_Multiminusfocal' && ($(this).attr('data-name') == 'dpd' || $(this).attr('data-name') == 'npd')){
                let changeName = 'npd';
                let fValue = -1.50;
                if($(this).attr('data-name') == 'npd'){
                    changeName = 'pd';
                    fValue = 1.50;
                }
                let type = getDirectionType($(this));
                let readingPD = $('#'+getDirectionType($(this))+'_'+changeName);
                if(readingPD.val() == '' || (!isNullOrEmpty(readingPD.val()) && readingPD.val().indexOf("Default") >= 0)){
                    let value = parseFloat($(this).val()) + fValue;
                    let text = value+' (Default)';
                    readingPD.find('option').each(function() {
                        if(typeof $(this).attr('data-new') != 'undefined' && $(this).attr('data-new') == 'true'){
                            $(this).remove();
                        }else if(typeof $(this).attr('data-update') != 'undefined'){
                            this.value = $(this).attr('data-update');
                            this.text = $(this).attr('data-update');
                        }
                        readingPD.select2().triggerHandler('change');
                    });
                    if(readingPD.find('option[value="'+value+'"]').length == 0 && readingPD.find('option[value="'+text+'"]').length == 0){
                        readingPD.prepend($('<option>', {
                            value: text,
                            text : text,
                            'data-new'  : 'true'
                        }));
                        readingPD.select2().triggerHandler('change');
                        readingPD.val(text).trigger('change');
                    }else{
                        let element = readingPD.find('option[value="'+value+'"]');
                        readingPD.val(element.attr('value')).trigger('change');
                        element.attr('data-update',element.attr('value'));
                        element.text(text);
                        element.attr('value',text);
                        readingPD.select2().triggerHandler('change');
                    }
                }
            }
            if($(this).attr('data-name') == 'rx_base_curve'){
                oldBaseCurveField = baseCurveField;
                baseCurveField = $(this).val();
                $('#warningMsg').find('#warning-base-curve').remove();
                showHideWarningContainer();
            }
            if($(this).attr('data-name') == 'corridor'){
                corridorField = $(this).val();
                $('#warningMsg').find('#warning-corridor').remove();
                showHideWarningContainer();
            }
            validateCutOutLenses();
            setTimeout(function(){
                updateAsterickAllFields();
            }, 500);
            applySpecifyRules();


            //Check Comb Power Error
            let combList = [
                'sph',
                'cyl'
            ];
            if($.inArray($(this).attr('data-name'), combList ) !== -1){
                let combError = isCombPowerError();
                $('.form-error-toaster .comb-power-error').remove();
                if(!isNullOrEmpty(combError)){
                    $(this).addClass('is-invalid');
                    $('.form-error-toaster').html('<div class="comb-power-error">'+combError+'</div>');
                    $('.form-error-toaster').show();
                }else if($('.form-error-toaster .comb-power-error').length == 0){
                    $('.form-error-toaster').hide();
                }
            }

        });
        $(document).on('select2:open',".select2_fixed ",function(e){
            let id = $(this).attr('data-name');
            keyValue = id+'Def';
            if($(this).val() == '' && typeof rxFormDataValues[keyValue] !== 'undefined'){
                if(isAesterickOrRequired($(this))){
                    // if(!select2DataClearing){
                        $(this).val(rxFormDataValues[keyValue]).trigger('change');
                    // }
                }else{
                    let selectedText = $('#'+$(this).attr('id')+' option[value="' + rxFormDataValues[keyValue] + '"]').text();
                    if(!isNullOrEmpty(selectedText)){
                        $('.select2-results .select2-results__options li').removeClass('select2-results__option--highlighted');
                        setTimeout(function() {
                            $('.select2-results .select2-results__options li').removeClass('select2-results__option--highlighted');
                            $('.select2-results .select2-results__options li:contains("'+selectedText+'")').addClass('select2-results__option--highlighted');

                             var scrollTopValue = $('.select2-results .select2-results__options li:contains("'+selectedText+'")').position().top + $('.select2-results .select2-results__options').scrollTop()-50;
                            $('.select2-results .select2-results__options').scrollTop(scrollTopValue);
                        }, 80);
                    }
                }
                // else if(isNullOrEmpty($(this).val())){
                    // $(this).val(rxFormDataValues[keyValue]).trigger('change');
                // }
                // if($('.select2-results').length > 0){
                //     setTimeout(function() {
                //         temp = rxFormDataValues[keyValue].toFixed(2);
                //         if(temp > 0)
                //             temp = '+'+temp;

                //         $('.select2-results .select2-results__options li:contains("'+temp+'")').addClass('select2-results__option--highlighted')
                //         console.log(temp);
                //     }, 1000);
                // }
            }
            select2DataClearing = false;
        });

        // $(document).on({
        //     mouseenter: function() {
        //         var parentLeft = $(this).parent().offset().left;
        //         var left = $(this).offset().left;
        //         left = left - parentLeft;
        //         if(left > 436)
        //             left = 436;

        //        $(this).siblings('.preview-large').css("left", left)
        //               .html("<img src="+ $(this).attr("data-preview") +" />")
        //               .fadeIn("fast");
        //     },
        //     mouseleave: function() {
        //        $(this).siblings('.preview-large').fadeOut("fast");
        //     }
        // }, '#shape .btn-frame_shape_choice');
        $('.enable_disable-fields').on('change',function(e){
            let elementId = 'container-'+$(this).attr('id');
            if(this.checked){
                $('#'+elementId).find('input,select').removeAttr("readonly", "readonly");
                $('#'+elementId).find('select').removeAttr("disabled", "disabled");
            }else{
                $('#'+elementId).find('input,select').attr("readonly", "readonly");
                $('#'+elementId).find('select').attr("disabled", "disabled");
                $.each($('#'+elementId).find('input,select'), function( index, value ) {
                    $(this).val(null).trigger('change');
                    updateAsterick($(this),0);
                });
            }
        });
        $('#specify_thickness').on('change',function(e){
            switch($(this).val()){
                case 'Safety':
                    $('#safety_stamp-container').removeClass('chide');
                    $('.ct_or_et-container').addClass('chide');
                    $('.ct_or_et-container').find('input').val(null).trigger("change");
                break;
                case 'Industrial':
                    $('.ct_or_et-container').addClass('chide');
                    $('.ct_or_et-container').find('input').val(null).trigger("change");
                    $('#safety_stamp-container').addClass('chide');
                    var jobType = $("input[name='data[frame][job_type]']:checked").val();
                    $('#safety_stamp-container').addClass('chide');
                    if(jobType != 'uncut')
                        $('#safety_stamp-container').removeClass('chide');
                break;
                case 'Specify':
                    $('.ct_or_et-container').removeClass('chide');
                    applySpecifyRules();

                    $('#safety_stamp-container').addClass('chide');
                break;
                default:
                    $('.ct_or_et-container').addClass('chide');
                    $('.ct_or_et-container').find('input').val(null).trigger("change");
                    $('#safety_stamp-container').addClass('chide');
                break;
            }
        });
        $('.show_hide-abtn').on('click',function(){
            $(this).parent().hide();
            $('.'+$(this).attr('data-element')).show();
            syncFieldTabs();
            if($(this).attr('data-element') == 'add_clip_on-container' && isNullOrEmpty($('#clip_on_type').val())){
                $('.summary-container #clip_on_type-custom').text('');
            }
        });
        $('.remove-abtn').on('click',function(){
            $(this).closest('.cancel-btn').parent().hide();
            $(this).closest('.cancel-btn').parent().next().show();
            if($(this).parent().parent().parent().hasClass('add_repairs-container')){
                $('.repairs_services-container .repairs_service-remove').trigger('click');
                $('.add_repairs-container').find('select,input,selectarea').val(null).trigger('change');
                $('.repair_description-content').hide();
            }else{
                $(this).parent().parent().parent().find('select').val(null).trigger("change");
            }
            updateAdonsSummaryContainer();
        });
        $('#clip_on_type').on('change',function(){
            updateAdonsSummaryContainer();
            $('.clip_on_lens_sub_colour-content').addClass('chide');
            $('.add_clip_on-content .info').html('');
            $('#clip_on_lens_colour').val(null).trigger('change');
            $('#clip_on_lens_sub_colour').val(null).trigger('change');
            let thisValue = $(this).find('option:selected').attr('actual_value');
            $('.summary-container #clip_on_type-custom').text('');
            if(thisValue != ''){
                $('#clip_on_lens_type').empty();
                $('#clip_on_lens_type').append($('<option>', {
                    value: '',
                    text : 'Lens Type'
                }));
                $.each(addons_data.item_category, function( index, value ) {
                    if(typeof value.item_type[thisValue] !== 'undefined'){
                        $.each(value.item_type[thisValue].item_sub_type, function( index2, value2 ) {
                            if(index2 != ''){
                                $('#clip_on_lens_type').append($('<option>', {
                                    value: value2['label'],
                                    text : value2['label'],
                                    actual_value: index2,
                                    price_500:value2['price_500'],
                                    price_501:value2['price_501'],
                                    price_600:value2['price_600'],
                                    price_601:value2['price_601']
                                }));
                            }
                        });
                    }
                });
                let tprice = parseFloat($(this).find('option:selected').attr(custPriceTag.toLowerCase())).toFixed(2);
                if($(this).val() == '')
                    tprice = '0.00';

                $('#clip_on_type-price').text(tprice);
                $('.hidden-prices-container #price_custom_clip_on').val(tprice);
                
                if(!isNullOrEmpty($(this).val())){
                    $('.summary-container #clip_on_type-custom').text('Custom Clip-on');
                }
                if(thisValue == 'rimless_s_flex'){
                    $('.add_clip_on-content .info').html('<i class="fa fa-info-circle"></i> Shipped in 2 business days');
                }
                updateSummaryPrice();
            }
        });
        $('#clip_on_lens_type').on('change',function(){
            $('.clip_on_lens_sub_colour-content').addClass('chide');
            $('#clip_on_lens_sub_colour').val(null).trigger('change');
            let itemCategory = $('#clip_on_type').find('option:selected').attr('actual_value');
            let thisValue = $(this).find('option:selected').attr('actual_value');//$(this).val();
            if(thisValue != ''){
                $('#clip_on_lens_colour').empty();
                $('#clip_on_lens_colour').append($('<option>', {
                    value: '',
                    text : 'Lens Colour'
                }));
                $.each(addons_data.item_category, function( index, value ) {
                    if(typeof value.item_type[itemCategory] !== 'undefined'){
                        $.each(value.item_type[itemCategory].item_sub_type[thisValue].item_colour, function( index2, value2 ) {
                            // $.each(value2, function( index3, value3 ) {
                                if(value2 != ''){
                                    $('#clip_on_lens_colour').append($('<option>', {
                                        value: value2['label'],
                                        text : value2['label'],
                                        actual_value: index2,
                                        price_500:value['price_500'],
                                        price_501:value['price_501'],
                                        price_600:value['price_600'],
                                        price_601:value['price_601']
                                    }));
                                }
                            // });
                        });
                    }
                });

                let tprice = parseFloat($(this).find('option:selected').attr(custPriceTag.toLowerCase())).toFixed(2);
                if($(this).val()== '')
                    tprice = '0.00';

                $('#clip_on_type-price').text(tprice);
                $('.hidden-prices-container #price_custom_clip_on').val(tprice);
                updateSummaryPrice();
            }
        });
        $('#clip_on_lens_colour').on('change',function(){
            $('.clip_on_lens_sub_colour-content').addClass('chide');
            let itemCategory = $('#clip_on_type').find('option:selected').attr('actual_value');
            let itemSubCategory = $('#clip_on_lens_type').find('option:selected').attr('actual_value');
            let thisValue = $(this).find('option:selected').attr('actual_value');//$(this).val();
            $('#clip_on_lens_sub_colour').val(null).trigger('change');
            if(!isNullOrEmpty(thisValue) && !isNullOrEmpty(itemSubCategory)){
                $('#clip_on_lens_sub_colour').empty();
                $('#clip_on_lens_sub_colour').append($('<option>', {
                    value: '',
                    text : 'Rim Colour'
                }));
                $.each(addons_data.item_category, function( index, value ) {
                    if(typeof value.item_type[itemCategory] !== 'undefined'){
                        $.each(value.item_type[itemCategory].item_sub_type[itemSubCategory].item_colour[thisValue].item_sub_colour, function( index2, value2 ) {
                            if(value2 != '' && !isNullOrEmpty(value2['label'])){
                                $('#clip_on_lens_sub_colour').append($('<option>', {
                                    value: value2['label'],
                                    text : value2['label'],
                                    actual_value: index2,
                                    price_500:value['price_500'],
                                    price_501:value['price_501'],
                                    price_600:value['price_600'],
                                    price_601:value['price_601']
                                }));
                            }
                        });
                    }
                });

                let tprice = parseFloat($(this).find('option:selected').attr(custPriceTag.toLowerCase())).toFixed(2);
                if($(this).val()== '')
                    tprice = '0.00';

                $('#clip_on_lens_type-price').text(tprice);
                updateSummaryPrice();
                if($('#clip_on_lens_sub_colour').find('option').length > 1){
                    $('.clip_on_lens_sub_colour-content').removeClass('chide');
                }
            }
            // let thisValue = $(this).val();
            // if(thisValue != ''){

            //     let tprice = parseFloat($(this).find('option:selected').attr(custPriceTag.toLowerCase())).toFixed(2);
            //     if($(this).val()== '')
            //         tprice = '0.00';

            //     $('#clip_on_type-price').text(tprice);
            //     updateSummaryPrice();
            // }
        });
        $(document).on('click','.repairs_service-remove',function(){
            let parentElement = $('.repairs_services-content');
            if(parentElement.length > 1){
                $(this).closest('.repairs_services-content').remove();
                updateSummaryAddons();
            }else{
                $('.repair_description-content').hide();
            }
        });
        $(document).on('change','.repairs_services-list',function(){
            updateAdonsSummaryContainer();
            if($(this).val() != '' && $('.repairs_services-content').length < $('.repairs_services-content:first-child .repairs_services-list > option').length && $(this).parent().find('.repairs_service-remove').is(":hidden")){

                $('.repairs_services-container').find('.repairs_services-content').find('select.repairs_services-list').find("option[value='']").remove();

                let parentElement = $('.repairs_services-container').first().find('.repairs_services-content').first().clone();
                $('.repairs_services-container').append(parentElement);
                parentElement.val('');
                $('.repairs_service-remove').show();
                parentElement.find('.repairs_service-remove').hide();

                parentElement.find('select.repairs_services-list').prepend("<option value='' selected='selected'>Select Repairs & Services</option>");
                $('.repair_description-content').show();
            }else{
                if($(this).parent().find('.repairs_service-remove').is(":visible")){
                    $('.repair_description-content').show();
                }else{
                    $('.repair_description-content').hide();
                }
            }
            updateSummaryAddons();
        });
        $(document).on('change','.oc',function(){
            let fieldType = 'r_corridor';
            // if('r_fh' != $(this).attr('data-attr'))
                // fieldType = 'l_corridor';
            let valueR = parseFloat($('#right_oc').val());
            let valueL = parseFloat($('#left_oc').val());
            if(isNaN(valueL))
                valueL = 0;
            if(isNaN(valueR))
                valueR = 0;

            let value = valueL;
            if(valueR > valueL)
                value = valueR;

            // console.log(value);

            let corridorElement = $('.corridor[data-attr="'+fieldType+'"]');
            updateCustomFields(corridorElement,value);
        });
        $(document).on('change','#right_dist_type,#left_dist_type',function(){
            // let thisValue = $(this).val();
            // if(thisValue != null)
            //     thisValue = thisValue.toLowerCase();

            $('.frame-section').show();
            if($('#right_dist_type').val() == 'Do not order' && $('#left_dist_type').val() == 'Do not order'){
                $('.frame-section').hide();
            }
            setLensTypeSummary();
        });
        $(document).on('change', '.filter-frame-info', function (e) {
            const val = $(this).val();
            const attribute = $(this).attr('data-filter');
            const name = $(this).attr('data-name');
            if(isNullOrEmpty(val)){
                clearFilterFrameInfoDependentFields(attribute);
                return;
            }
            filterFrameInfo(attribute, name);
        });
        $(document).on('change keyup','#rx-order_form .form-control, #rx-order_form .toggle, #rx-order_form .md-check',function(){
            let text = $(this).val();
            let value = $(this).val();
            let elementAttr = $(this).attr('data-name');
            let elementId = $(this).attr('id');
            let type = $(this).attr('type');
            if(type == 'radio' && $(this).attr('data-text') != null){
                text = $(this).attr('data-text').replaceAll('<br>',' ');
                elementAttr = $(this).parent().attr('data-index');
                elementId = elementAttr;
            }
            else if(type == 'checkbox'){
                let rlabel = '';
                if($('label[for='+elementId+']').length > 0)
                    rlabel = $.trim($('label[for='+elementId+']').text());
                text = '';//'✕ '+rlabel;
                if($(this).is(":checked"))
                    text = '✔ '+rlabel;
            }
            else if($(this).is('select')){
                text = '';
                if($(this).val() != '')
                    text = $(this).find('option:selected').text();

                let notInArray = ['prism1','base1','prism2','base2'];
                if($('.summary-container #'+elementId+'-field').parent().text().replaceAll(/\s/g,'') != '' && !$('.summary-container #'+elementId+'-field').is(':first-child') && jQuery.inArray(elementAttr, notInArray) === -1 && $(this).val() != '' && $(this).val() != null){
                    text = ' / '+$(this).find('option:selected').text();
                    if($(this).closest('.mshape-content').length > 0)
                        text = $(this).find('option:selected').text();
                }else{
                    // $('.summary-container #clip_on_type-custom').text('');
                }
            }
            if($(this).hasClass('repairs_services-list')){
                elementId = 'add-repairs';
            }
            switch(elementId){
                case 'first_name':case 'last_name':
                    text = $('#first_name').val()+' '+$('#last_name').val();
                    $('.summary-container #reference-field').html(text);
                    showHideSummaryElements($('.summary-container #reference-field'));
                break;
                case 'frame_type':
                    // edgedText = '';
                    // if($('#brand').val() != ''){
                    //     edgedText = $('#brand').val();
                    // }
                    // if($('#model').val() != ''){
                    //     edgedText += ' '+$('#model').val();
                    // }
                    // if($('#colour').val() != ''){
                    //     edgedText += ' '+$('#colour').val();
                    // }
                    // if($('#size').val() != ''){
                    //     edgedText += ' '+$('#size').val();
                    // }
                    // if((value == 'edged_frame_to_follow' || value == 'lab_supplies_frame') && edgedText != '')
                    //     text += ' ( '+edgedText+' )';
                    // else if(edgedText != ''){
                    //     text += ' ( '+edgedText+' )';
                    // }
                    $('.summary-container #'+elementId+'-field').html(text);
                    showHideSummaryElements($('.summary-container #'+elementId+'-field'));
                break;
                case 'job_type':
                    if(value == 'edged_no_frame_to_follow'){
                        if(!isNullOrEmpty($('#invoice_order_no_field').val()))
                            text += ' ( '+$('#invoice_order_no_field').val()+' )';
                    }
                    console.log('Setting job_type summary text:', text);
                    $('.summary-container #'+elementId+'-field').html(text);
                    showHideSummaryElements($('.summary-container #'+elementId+'-field'));
                break;
                case 'invoice_order_no_field':
                    value = $("input[name='data[frame][job_type]']:checked").val();
                    text = $("input[name='data[frame][job_type]']:checked").attr('data-text');
                    if(value == 'edged_no_frame_to_follow'){
                        if(!isNullOrEmpty($('#invoice_order_no_field').val()))
                            text += ' ( '+$('#invoice_order_no_field').val()+' )';
                    }
                    $('.summary-container #job_type-field').html(text);
                    showHideSummaryElements($('.summary-container #job_type-field'));
                    break;
                case 'brand':case 'model':case 'colour':case 'size':
                    text = '';
                    if($('#brand').val() != ''){
                        text = $('#brand').val();
                    }
                    if($('#model').val() != ''){
                        text += ', '+$('#model').val();
                    }
                    if($('#colour').val() != ''){
                        text += ', '+$('#colour').val();
                    }
                    if($('#size').val() != ''){
                        text += ', '+$('#size').val();
                    }
    
                    $('.summary-container #frame_info-field').html(text);
                    showHideSummaryElements($('.summary-container #frame_info-field'));
                break;
                // case 'clip_on_type':case 'clip_on_lens_type':case 'clip_on_lens_colour':
                //     text = '';
                //     if($('#clip_on_type').val() != null && $('#clip_on_type').val().length != 0){
                //         text = $('#clip_on_type :selected').text();
                //     }
                //     if($('#clip_on_lens_type').val() != null && $('#clip_on_lens_type').val().length != 0){
                //         text += ' -> '+$('#clip_on_lens_type :selected').text();
                //     }
                //     if($('#clip_on_lens_colour').val() != null && $('#clip_on_lens_colour').val().length != 0){
                //         text += ' -> '+$('#clip_on_lens_colour :selected').text();
                //     }

                //     $('.summary-container #clip_on-field').html(text);
                // case 'add-repairs':
                //     text = '';
                //     $.each($('select.repairs_services-list'), function( index, value ) {
                //         if($(this).val()!= null && $(this).val().length != 0 && text == ''){
                //             text = $(this).find('option:selected').text();
                //         }
                //         else if($(this).val()!= null && $(this).val().length != 0){
                //             text += ' -> '+$(this).find('option:selected').text();
                //         }
                //     });

                //     $('.summary-container #add_repairs-field').html(text);
                // break;
                case    'a':case    'b':case    'ed':case    'dbl':case 'shape':
                    text = '';
                    $.each($('.frame_size-fields'), function( index, value ) {
                        let selectElem = $(this).find('select');
                        if(typeof selectElem.find("option:selected").val() != 'undefined' && selectElem.find("option:selected").val() != ''){
                            if((selectElem.attr('data-name') == 'ed' || elementId == 'shape') && selectElem.val() == 'shape' && $("input[name='data[frame][frame_size][shape]']").is(':checked')){
                                text += 'ED (Shape '+$("input[name='data[frame][frame_size][shape]']:checked").val().toUpperCase()+'): '+calculateShapeFactor()+' / ';
                            }else{
                                text += selectElem.attr('data-name').toUpperCase()+': '+selectElem.find("option:selected").text()+' / ';
                            }
                        }
                    });
                    text = text.slice(0, -3);
                    $('#frame_size-details').text(text);
                    showHideSummaryElements($('#frame_size-details'));
                break;
                case    'right_sph':case 'left_sph':case 'right_add':case 'left_add':case 'right_intermediate_strength': case 'sub_type':
                    let array = ['right_','left_'];
                    let flag = true;
                    $.each(array, function( index, value ) {
                        if($('#sub_type').val() == 'Intermediate_(Lab_Converts_Rx)'){
                            if(isAllFilledArray([value+'sph',value+'add','right_intermediate_strength'])){
                                let newAdd = parseFloat($('#'+value+'sph').val()) + (parseFloat($('#'+value+'add').val()) * (parseInt($('#right_intermediate_strength').val())/100));
                                newAdd = roundToNearestQuarter(newAdd);

                                $('.summary-container #'+value+'sph'+'-field').html(addNumberSign(newAdd.toFixed(2)));
                                $('.summary-container #'+value+'add'+'-field').html('');
                                $('.summary-container .rx-info').show();
                                $('.summary-container .rx-info span').text('Rx converted based on Intermediate Strength '+parseInt($('#right_intermediate_strength').val())+'%');
                                flag = false;
                                $('#'+value+'sph_new').val(newAdd.toFixed(2));
                            }
                            $('.summary-container .rx-info-add-left').hide();
                            $('.summary-container .rx-info-add-right').hide();
                        }else if($('#sub_type').val() == 'Reading_(Lab_Converts_Rx)'){
                            if(isAllFilledArray([value+'sph',value+'add'])){
                                let newAdd = parseFloat($('#'+value+'sph').val()) + parseFloat($('#'+value+'add').val());
                                newAdd = roundToNearestQuarter(newAdd);
                                $('.summary-container #'+value+'sph'+'-field').html(addNumberSign(newAdd.toFixed(2)));
                                $('.summary-container #'+value+'add'+'-field').html('');
                                $('.summary-container .rx-info-add-left_').show();
                                $('.summary-container .rx-info-add-left_ span').text('Rx converted based on Add Power '+addNumberSign(parseFloat($('#'+value+'add').val()).toFixed(2)));
                                flag = false;
                                $('#'+value+'sph_new').val(newAdd.toFixed(2));
                            }
                            $('.summary-container .rx-info').hide();
                        }else{
                            $('.summary-container .rx-info').hide();
                            $('.summary-container .rx-info-add-left_').hide();
                            $('.summary-container .rx-info-add-right_').hide();
                            if(!isNullOrEmpty($('#'+value+'sph').val()))
                                $('.summary-container #'+value+'sph'+'-field').html(addNumberSign(parseFloat($('#'+value+'sph').val()).toFixed(2)));
                        }
                        // console.log($('#right_intermediate_strength').val());
                    });
                    if(elementId == 'sub_type' || elementId == 'right_intermediate_strength' || flag){
                        $('.summary-container #'+elementId+'-field').html(text);
                        showHideSummaryElements($('.summary-container #'+elementId+'-field'));
                    }
                break;
                default:
                    if(elementId == 'multipair_ref'){
                        if(!isNullOrEmpty(text)){
                            text = 'MULTI-PAIR with: '+text;
                            $('#multipair_ref-container').show();
                        }else{
                            $('#multipair_ref-container').hide();
                        }
                    }
                    if(typeof $('.summary-container #'+elementId+'-field').attr('data-label') != 'undefined' && $('.summary-container #'+elementId+'-field').attr('data-label') == 'true' && text != ''){
                        text = $('label[for="'+$(this).attr('name')+'"]').text()+': '+text;

                        if($(this).attr('data-name') == 'l_ct_or_et')
                            text = text+',';
                    }
                    if($(this).attr('data-attr') == 'specify_thickness'){
                        if(text != ''){
                            text = 'Lens Thickness: '+text+'.';
                        }
                    }
                    else if($(this).attr('data-attr') == 'bevel_type' && text != ''){
                        text = 'Bevel Type: '+text.replaceAll(' / ',' ');
                        if(!$('#bevel_type').is(":visible")){
                            text = '';
                        }
                    }
                    if($(this).hasClass('lens-data')){
                        // setLensTypeSummary();
                        // $('.summary-container #right-order_container .'+elementId+'-field').html(text);
                        // $('.summary-container #left-order_container .'+elementId+'-field').html(text);
                    }else{
                        $('.summary-container #'+elementId+'-field').html(text);
                        showHideSummaryElements($('.summary-container #'+elementId+'-field'));
                    }
                break;
            }
            rxFormResize();
        });

        // $(document).on('change','#right_fh,#left_fh',function(){
        //     if(jQuery.isArray(rxFormDataValues['corridor'])){
        //         let corridor = '';
        //         let thisValue = parseFloat($(this).val());
        //         $.each(rxFormDataValues['corridorSh'], function( index, value ) {
        //             value = parseFloat(value);
        //             if(thisValue <= value){
        //                 corridor = rxFormDataValues['corridor'][index];
        //             }
        //             else if(thisValue >= value){
        //                 corridor = rxFormDataValues['corridor'][index];
        //             }
        //         });
        //             console.log(corridor);
        //     }
        // });
        $('form :input').on('change input', function () {
            isFormDirty = true;
        });
        // Prompt when the user tries to leave the page
        // $(window).on('beforeunload', function (e) {
        //     if (isFormDirty) {
        //         return 'You will lose any changes made to this order.';
        //     }
        // });
        $("#rx-order_form").on('submit',function (event) {
            isFormDirty = false;
            if ($('#submit_type').val() === 'saved') {
                return true;
            }
            event.preventDefault(); // Prevent the default form submission
            
            $('#submit_type').val('submitted');
            $(".is-required:visible", this).prop("required", false);
// Find all visible input fields and set the "required" attribute
$(".is-required:visible", this).each(function () {
    $(this).removeClass('is-invalid');
    if ($(this).is("input")) {
        // if ($(this).val() === "") {
        //     $(this).prop("required", false);
        // } else {
            $(this).prop("required", true);
            updateAsterick($(this),1);
        // }
    } else if ($(this).is("select")) {
        validateFieldRequired($(this));
    }
    if(!$(this).hasClass('edited'))
        $(this).addClass('edited');

});
            if ($(this).valid()) {
                $('#submit-btn').attr("disabled", "disabled");
                this.submit();
                toastr.success("All done!");
            } else {
                // toastr.error("Please fix the errors");
                isErrorShowFlag = true;
                showErrorToastr();
            }
        });
        $("#save_order-btn").on('click',function(e){
            let flag = true;
            let html = '';
            $('.form-error-toaster').hide();
            $('.form-error-toaster').html('');
            if(isNullOrEmpty($('#first_name').val())){
                $('#first_name').addClass('is-invalid');
                flag = false;
                html += '<div>[ First Name ] is required</div>';
            }
            if(isNullOrEmpty($('#last_name').val())){
                $('#last_name').addClass('is-invalid');
                flag = false;
                html += '<div>[ Last Name ] is required</div>';
            }
            if(flag){
                swal({
                    title: "Are you sure you want to save order for later?",
                    // text:  'Save order!',
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes",
                    cancelButtonText: "No",
                    closeOnConfirm: true,
                    closeOnCancel: true,
                    }, function(isConfirm){
                    if (isConfirm) {
                        $('#submit_type').val('saved');
                        $('#submit-btn').attr("disabled", "disabled");
                        $('#save_order-btn').attr("disabled", "disabled");
                        $("#rx-order_form").off('submit'); 
                        $("#rx-order_form").submit();
                    }
                });
            }else{
                $('.form-error-toaster').html(html);
                $('.form-error-toaster').show();
            }
        });
        $(document).on('keyup', '.select2-search__field', function (e) {
            var keyCaptured = (e.keyCode ? e.keyCode : e.which);
            if(keyCaptured != 38 && keyCaptured != 40){
                let selectItem = $('.select2-container--open').prev();
                let array = [
                    'sph',
                    'cyl',
                    'add',
                ];
                let elementName = selectItem.attr('data-name');

                //Ignore Fields
                let ignoreList = [
                    'brand',
                    'model',
                    'colour',
                    'size'
                ];
                if(jQuery.inArray(elementName, ignoreList) !== -1){
                    // Detect typing in search field and highlight all new tags
                    let exists = $('#'+elementName+' option[data-select2-tag="true"]');
                    console.log(exists);

                    if (exists.length > 0) {
                        $('.select2-results .select2-results__options li.select2-results__option--highlighted').css('background','#ed6b75'); // Highlight new tags
                    }
                    return false;
                }

                let inputValue = $(this).val();
                if(jQuery.inArray(elementName, array) !== -1){
                    let decimalCount = (inputValue.split('.')[1] || []).length;

                    // If the input starts with a dot, prepend '0'
                    if (inputValue.startsWith('.')) {
                        $(this).val('+0' + inputValue).trigger('input');
                    }
                    else if (/^\d/.test(inputValue) && !/[-+]/.test(inputValue)) {
                        $(this).val('+' + inputValue).trigger('input');
                    }else if (inputValue === "-.") {
                        $(this).val("-0.").trigger('input');
                    }else if (inputValue === "+.") {
                        $(this).val("+0.").trigger('input');
                    }
                }
                if(inputValue != ''){
                    $('.select2-results .select2-results__options li').removeClass('select2-results__option--highlighted');
                    setTimeout(function() {
                        let li = 'last';
                        if(elementName == 'axis')
                            li = 'first';
                        else if(parseFloat(inputValue) < 0)
                            li = 'first';

                        $('.select2-results .select2-results__options li:'+li).addClass('select2-results__option--highlighted');
                        if(li == 'last'){
                            var scrollTopValue = $('.select2-results .select2-results__options li:'+li).position().top + $('.select2-results .select2-results__options').scrollTop()-50;
                            $('.select2-results .select2-results__options').scrollTop(scrollTopValue);
                        }else{
                            $('.select2-results .select2-results__options').scrollTop(0);
                        }
                    }, 0);
                }else{
                    let id = selectItem.attr('data-name');
                    keyValue = id+'Def';
                    if(selectItem.val() == '' && typeof rxFormDataValues[keyValue] !== 'undefined'){
                        let selectedText = $('#'+selectItem.attr('id')+' option[value="' + rxFormDataValues[keyValue] + '"]').text();
                        if(selectedText){
                            $('.select2-results .select2-results__options li').removeClass('select2-results__option--highlighted');
                            setTimeout(function() {
                                $('.select2-results .select2-results__options li').removeClass('select2-results__option--highlighted');
                                $('.select2-results .select2-results__options li:contains("'+selectedText+'")').addClass('select2-results__option--highlighted');

                                 var scrollTopValue = $('.select2-results .select2-results__options li:contains("'+selectedText+'")').position().top + $('.select2-results .select2-results__options').scrollTop()-50;
                                $('.select2-results .select2-results__options').scrollTop(scrollTopValue);
                            }, 0);
                        }
                    }
                }
            }
        });
        /*
        *
        * Tab functionality
        */
        docBody.on('keydown', function(e) {
            var keyCaptured = (e.keyCode ? e.keyCode : e.which);
            //shiftPressed = keyCaptured == 16 ? true : false;
            if (keyCaptured == 16) { shiftPressed = true; }
        });
        docBody.on('keyup', function(e) {
            var keyCaptured = (e.keyCode ? e.keyCode : e.which);
            //shiftPressed = keyCaptured == 16 ? true : false;
            if (keyCaptured == 16) { shiftPressed = false; }
        });

        docBody.on('mousedown', function(e){
            // remove other focused references
            clickedOutside = false;
            // record focus
            if ($(e.target).is('[class*="select2"]')!=true) {
                clickedOutside = true;
            }
        });

        docBody.on('select2:unselecting', function(e) {
            $(this).data('state', 'unselected');
            // remove other focused references
            select2DataClearing = true;
        });

        docBody.on('select2:opening', function(e) {
            if ($(this).data('state') === 'unselected') {
                $(this).removeData('state'); 
                var self = e;
                setTimeout(function() {
                    $(self.target).select2('close');
                }, 1);
            }else{
                // this element has focus, remove other flags
                clickedOutside = false;
                // flag this Select2 as open
                $(e.target).attr('data-s2open', 1);
            }
        });
        docBody.on('select2:closing', function(e) {
            // remove flag as Select2 is now closed
            $(e.target).removeAttr('data-s2open');
            if($('.select2-container--open').length > 0){
                highlightedDDLValue = $('.select2-container--open').find('.select2-results__option--highlighted').text();
            }
        });

        docBody.on('select2:select', function(e){
            // remove other focused references
            selectionMade = true;
            $(e.target).trigger('select2:close');
        });

        docBody.on('select2:close', function(e) {
            var elSelect = $(e.target);
            elSelect.removeAttr('data-s2open');
            var currentForm = elSelect.closest('form');
            var othersOpen = currentForm.has('[data-s2open]').length;
            if(typeof event != 'undefined'){
                if (othersOpen == 0 && clickedOutside==false && (event.which == 13 || event.which == 9 || (event.which == 1 && selectionMade))) {
                    /* Find all inputs on the current form that would normally not be focus`able:
                    *  - includes hidden <select> elements whose parents are visible (Select2)
                    *  - EXCLUDES hidden <input>, hidden <button>, and hidden <textarea> elements
                    *  - EXCLUDES disabled inputs
                    *  - EXCLUDES read-only inputs
                    */

                    if (highlightedDDLValue != '') {
                        let option = elSelect.find('option').filter(function() {
                            return $(this).text().trim() === highlightedDDLValue;
                        });
                        if (option.length > 0) {
                            elSelect.val(option.val()).trigger('change');
                        }
                        highlightedDDLValue = '';
                    }

                    var inputs = currentForm.find(':input:enabled:not([readonly], input:hidden, button:hidden, textarea:hidden)')
                        .not(function () {   // do not include inputs with hidden parents
                            return $(this).parent().is(':hidden');
                        });
                    var elFocus = null;
                    $.each(inputs, function (index) {
                        var elInput = $(this);
                        if (elInput.attr('id') == elSelect.attr('id')) {
                            if(elSelect.closest('.crawl-cs-ddl').next('.col-sm').find('.btn').length > 0 && elSelect.closest('.crawl-cs-ddl').next('.col-sm').find('.btn').is(":visible")){
                                elFocus = inputs.eq(index);
                            }else{
                                if ( shiftPressed) { // Shift+Tab
                                    elFocus = inputs.eq(index - 1);
                                } else {
                                    if(isFocusSkipped(inputs.eq(index + 1))){
                                        elFocus = inputs.eq(index + 2);
                                    }else{
                                        elFocus = inputs.eq(index + 1);
                                    }
                                }
                            }
                            return false;
                        }
                    });
                    if (elFocus !== null) {
                        // automatically move focus to the next field on the form
                        // console.log(elFocus.closest('.crawl-cs-ddl').next());
                        if(elSelect.closest('.crawl-cs-ddl').next('.col-sm').find('.btn').length > 0 && elSelect.closest('.crawl-cs-ddl').next('.col-sm').find('.btn').is(":visible")){
                            elSelect.closest('.crawl-cs-ddl').next('.col-sm').find('.btn').focus();
                        }else{
                            var isSelect2 = elFocus.siblings('.select2').length > 0;
                            var ignoreList = ['brand','model', 'colour','size'];
                            var fieldName = elFocus.attr('data-name');
                            if(!ignoreList.includes(fieldName)){
                                if (isSelect2) {
                                    elFocus.select2('open');
                                } else {
                                    elFocus.focus();
                                }
                            }
                        }
                            
                    }
                }
            }
            selectionMade = false;
        });
        /**
         * Capture event where the user entered a Select2 control using the keyboard.
         */
        docBody.on('focus', '.select2', function(e) {
            var elSelect = $(this).siblings('select');
            if (elSelect.is('[disabled]')==false && elSelect.is('[data-s2open]')==false
                && $(this).has('.select2-selection--single').length>0) {
                elSelect.attr('data-s2open', 1);
                elSelect.select2('open');
            }
        });
        $(document).on('focus', '#rx-order_form input,#rx-order_form select', function (e) {
            let labelElem = $('.control-label[for="'+$(this).attr('name')+'"]');
            if(labelElem.length> 0){
                labelElem.css('font-weight','bold');
            }
        });
        $(document).on('blur', '#rx-order_form input,#rx-order_form select', function (e) {
            let labelElem = $('.control-label[for="'+$(this).attr('name')+'"]');
            if(labelElem.length> 0){
                labelElem.css('font-weight','');
            }
        });
        // $(document).on('focus', '.select2', function (e) {
        //     if (e.originalEvent) {
        //         var s2element = $(this).siblings('select');
        //         s2element.select2('open');

        //         // Set focus back to select2 element on closing.
        //         s2element.on('select2:closing', function (e) {
        //             s2element.select2('focus');
        //         });
        //     }
        // });
        /*
        *
        * End Tab functionality
        */
        $('input[type="text"], input[type="radio"],select.lens-data').on('keydown',function(e) {
            if (e.keyCode === 13) { // Check if the pressed key is Enter
                e.preventDefault(); 
                var elSelect = $(e.target);
                var currentForm = elSelect.closest('form');
                var inputs = currentForm.find(':input:enabled:not([readonly], input:hidden, button:hidden, textarea:hidden)')
                    .not(function () {   // do not include inputs with hidden parents
                        return $(this).parent().is(':hidden');
                    });
                var elFocus = null;
                $.each(inputs, function (index) {
                    var elInput = $(this);
                    if (elInput.attr('id') == elSelect.attr('id')) {
                        if(elSelect.closest('.form-group').next('.col-sm').find('.btn').length > 0){
                            elFocus = inputs.eq(index);
                        }else{
                            elFocus = inputs.eq(index + 1);
                        }
                        return false;
                    }
                });
                if (elFocus !== null) {
                    // automatically move focus to the next field on the form
                    // console.log(elFocus.closest('.crawl-cs-ddl').next());
                    if(elSelect.closest('.form-group').next('.col-sm').find('.btn').length > 0){
                        elSelect.closest('.form-group').next('.col-sm').find('.btn').focus();
                    }else{
                        elFocus.focus();
                    }
                        
                }
            }
        });
        setTimeout(function(){
            initForm();
        }, 500);
    });
/*
*
* Custom Functions
*/
function setOrAppendSelect(id, value, options = []) {
    if (value) {
        let $select = $('#' + id);

        if ($select.length) {
            // Check if the value exists in the current dropdown
            if ($select.find('option').filter(function() { return $(this).val() === value; }).length === 0) {
                // If value is not found, append a new option
                let newText = text ? text : value; // Use provided text or fallback to value
                let newOption = new Option(newText, value, true, true);
                $select.append(newOption);
            }

            // Set the value and trigger change
            $select.val(value).trigger('change');
        }
    }
}
function checkIfNewTag(element) {
    let value = element.val();
    if(!isNullOrEmpty(value)){
        let $option = element.find(`option[value="${value}"]`);

        if ($option.length && $option.attr("data-select2-tag") === "true") {
            return true;
        }
    }
    return false;
}

function clearFilterFrameInfoDependentFields(attribute) {
    if (attribute === 'model') {
        $('#model,#colour,#size').empty().append('<option value="">Select</option>');
    } else if (attribute === 'colour') {
        $('#colour,#size').empty().append('<option value="">Select</option>');
    } else if (attribute === 'size') {
        $('#size').empty().append('<option value="">Select</option>');
    } else if (attribute === 'brand') {
        $('#model,#colour,#size').empty().append('<option value="">Select</option>');
    }

    $('#frame_price').val('');
    $('.total_price-container').find('#lab-supplies-price').remove();
    updateAdditionalHiddenInputPrices('frame','','');
    updatePackagePrice(); // Optional: update price to reflect cleared fields
}


function filterFrameInfo(attribute,name){
    let isNewValue = false;
    if(!isNullOrEmpty(name) && checkIfNewTag($('#'+name))){
        isNewValue = true;
    }
    let brand = $('#brand').val();
    // Reset dependent fields based on hierarchy
    if((isNullOrEmpty(attribute) && isNullOrEmpty(brand)) || (attribute != 'brand' && isNullOrEmpty(brand)))
        return false;

    let model = $('#model').val();
    let colour = $('#colour').val();
    let size = $('#size').val();
    if (attribute === 'brand') {
        $('#model, #colour, #size').empty().append('<option value="">Select</option>');
        colour = '';
        size = '';
        model = '';
    } else if (attribute === 'model') {
        $('#model,#colour, #size').empty().append('<option value="">Select</option>');
        colour = '';
        size = '';
        model = '';
    } else if (attribute === 'colour') {
        $('#colour,#size').empty().append('<option value="">Select</option>');
        size = '';
        colour = '';
    } else if (attribute === 'size') {
        $('#size').empty().append('<option value="">Select</option>');
        size = '';
    }
    let isOnlyPrice = false;
    if(!isPackageOn() && $("input[name='data[frame][job_type]']:checked").val() == 'lab_supplies_frame'){
        isOnlyPrice = true;
    }
    let statusD = false;
    if($("input[name='data[frame][job_type]']:checked").val() == 'lab_supplies_frame'){
        statusD = true;
    }
    if(!isNewValue /*&& (attribute != 'brand' || isOnlyPrice == true)*/){
        window.isLoaderFStop = false;
    }
    let package = '';
    if(isPackageOn()){
        package = $('#packageList').val();
    }

    // Proceed with AJAX request only if brand is selected
    // if (/*!isNullOrEmpty(brand) && !isNullOrEmpty(attribute)*/) {
        $.ajax({
            url: "<?= route('frontend.user.filter-frame-info') ?>",
            type: "POST",
            data: {
                _token: "<?= csrf_token() ?>",
                type: attribute,
                brand: brand,
                model: model,
                colour: colour,
                size: size,
                package:package,
                is_only_price:isOnlyPrice,
                statusD:statusD
            },
            complete: function (response) {
                window.isLoaderFStop = true;
                $('.chatpageloader').hide();
            },
            success: function (response) {
                console.log('filterFrameInfo response:', response);
                if (response.status) {
                    if(attribute) {
                        let element = $('#' + attribute);
                        if(element.length > 0){
                            element.empty().append('<option value="">Select</option>');
                            $.each(response.data, function (index, value) {
                                element.append($('<option>', {
                                    value: value,
                                    text: value
                                }));
                            });
                        }
                    }
                    if(isNullOrEmpty(preSize) && response.metaData && response.metaData.a){
                        setOrAppendSelect('a', response.metaData.a);
                        setOrAppendSelect('b', response.metaData.b);
                        setOrAppendSelect('ed', response.metaData.ed);
                        setOrAppendSelect('dbl', response.metaData.dbl);
                        if(response.metaData.edge_type){
                            if(response.metaData.edge_type == 'drill-mount'){
                                $('input[name="data[frame][frame_type]"][value="rimless_drill"]').parent().trigger('click');
                            }
                            else if(response.metaData.edge_type == 'grooved'){
                                $('input[name="data[frame][frame_type]"][value="nyloon_groove"]').parent().trigger('click');
                            }
                            else if(response.metaData.edge_type == 'beveled' && response.metaData.frame_type == 'metal'){
                                $('input[name="data[frame][frame_type]"][value="full_metal"]').parent().trigger('click');
                            }else{                                
                                $('input[name="data[frame][frame_type]"][value="full_plastic"]').parent().trigger('click');
                            }
                        }
                    }
                    packageTeir = null;
                    if(response.metaData.package_tier){
                        packageTeir = response.metaData.package_tier;
                    }
                    if(isOnlyPrice && !isNullOrEmpty(response.metaData.price)){
                        let price = response.metaData.price;
                        $('#frame_price').val(price.toFixed(2));
                        $('.total_price-container').find('#lab-supplies-price').remove();
                        let html = '<span id="lab-supplies-price">Frame: $<span class="price">'+price.toFixed(2)+'</span><br></span>';
                        $('.total_price-container').append(html);
                        updateAdditionalHiddenInputPrices('frame','Frame',price.toFixed(2));
                    }
                    updatePackagePrice();
                }
                setTimeout(() => {
                    if(attribute == 'brand' && !isNullOrEmpty(preBrand)){
                        setOrAppendSelect('brand', preBrand);
                        preBrand = null;
                    }
                    else if(attribute == 'model' && !isNullOrEmpty(preModel)){
                        // $('#model').val(preModel).trigger('change');
                        setOrAppendSelect('model', preModel);
                        preModel = null;
                    }
                    else if(attribute == 'colour' && !isNullOrEmpty(preColour)){
                        // $('#colour').val(preColour).trigger('change');
                        setOrAppendSelect('colour', preColour);
                        preColour = null;
                    }
                    else if(attribute == 'size' && !isNullOrEmpty(preSize)){
                        // $('#size').val(preSize).trigger('change');
                        setOrAppendSelect('size', preSize);
                    }else{
                        if(isNullOrEmpty(preBrand) && isNullOrEmpty(preModel) && isNullOrEmpty(preColour) && !isNullOrEmpty(preSize)){
                            preSize = null;
                        }
                        if(attribute != 'brand'){
                            $('#'+attribute).focus();
                        }
                    }
                },200);
            }
        });
    // }
}
function updateAdditionalHiddenInputPrices(id, label, price) {
    // Remove any previously generated fields for the same ID
    $('.hidden-price-group-' + id).remove();

    if (label !== '') {
        let html = `
            <div class="additional-hidden-prices hidden-price-group-${id}">
                <input type="hidden" name="data[prices][additional][${additionalHiddenIndex}][label]" value="${label}">
                <input type="hidden" name="data[prices][additional][${additionalHiddenIndex}][price]" value="${price}">
            </div>
        `;
        $('.hidden-prices-container').append(html);
        additionalHiddenIndex++;
    }
}
function clearAdditionalHiddenInputPrices(){
    $('.additional-hidden-prices').remove();
}
function validateCutOutLenses(){
    $('#warningCutOut').text('');
    // if($('#warningMsg').height() <= 33){
    //     $('#warningMsg').removeClass('alert alert-warning');
    //     $('#warningMsg').hide();
    // }
    showHideWarningContainer();
    if($('#lens_type').val() == 'Single_Vision_Finished'){
        validateCutOutLenses2('right');
    }
}
function validateCutOutLenses2(type){
    // let type = 'right';
    let fields = getRequiredDiameter('fields',type);
    if(fields.length > 0){
        if(isAllFilledArray(fields)){
            requiredDiameter = getRequiredDiameter('calculate',type);
            cutOutApi(fields,type,requiredDiameter);
        }
    }
}
function getRequiredDiameter(caseValue,type){
    switch (caseValue) {
        case 'fields':
            let fields = [];
            if($('#sub_type').val() == 'Distance'){
                fields = ['a','dbl','ed',type+'_pd',type+'_sph',type+'_cyl','lens_material','coating_name'];
            }else if($('#sub_type').val() == 'Intermediate_(Lab_Converts_Rx)' || $('#sub_type').val() == 'Intermediate_(PreminusConverted_Rx)'){
                fields = ['a','dbl','ed',type+'_intermediate_pd',type+'_sph',type+'_cyl','lens_material','coating_name'];
            }else if($('#sub_type').val() == 'Reading_(Lab_Converts_Rx)' || $('#sub_type').val() == 'Reading_(PreminusConverted_Rx)'){
                fields = ['a','dbl','ed',type+'_npd',type+'_sph',type+'_cyl','lens_material','coating_name'];
            }
            return fields;
            break;
        case 'calculate':
            let value = 0;
            if($('#sub_type').val() == 'Distance'){
                value = $('#'+type+'_pd').val();
            }else if($('#sub_type').val() == 'Intermediate_(Lab_Converts_Rx)' || $('#sub_type').val() == 'Intermediate_(PreminusConverted_Rx)'){
                value = $('#'+type+'-intermediate_pd').val();
            }else if($('#sub_type').val() == 'Reading_(Lab_Converts_Rx)' || $('#sub_type').val() == 'Reading_(PreminusConverted_Rx)'){
                value = $('#'+type+'_npd').val();
            }
            return parseFloat($('#a').val()) + parseFloat($('#dbl').val()) + parseFloat($('#ed').val()) - (parseFloat(value) * 2);
            break;
    }
}
function clearSelect2(element){
    if(element.length > 0){
        element.empty().append('<option value="">Select</option>');
        // element.trigger('change');
    }
}
function updateAdonsSummaryContainer(){
    setTimeout(() => {
        $('.addons-summary').hide();
        if($('.repairs_services-content').is(":visible") || $('#clip_on_type').is(":visible")){
            $('.addons-summary').show();
        }
    }, 300);
}
function cutOutApi(fields,type,requiredDiameter){
    var formData = {};
    formData['_token'] = "<?= csrf_token() ?>";
    let elem = null;
    $.each(fields, function( index, value ) {
        elem = $('#'+value);
        formData[elem.attr('data-name')] = elem.find("option:selected").val();
    });
    formData['lens_colour'] = rxFormDataValues.stockCsvColourValue;
    if(isNullOrEmpty(formData['cyl'])){
        formData['cyl'] = 0.00;
    }
    $.ajax({
        url: cutoutValidationUrl,
        type: "POST",
        data: formData,
        cache:true,
        success: function(response){
            if(response.status){
                // console.log(type+' '+requiredDiameter);
                if(requiredDiameter > response.size){
                    $('#warningMsg').show();
                    $('#warningCutOut').text('Selected finished lens will not cut out with given Rx and frame size. Please choose Surfaced Lenses');
                    $('#warningMsg').addClass('alert alert-warning');
                    // toastr.warning('Selected finished lens will not cut out with given Rx and frame size. Please choose Surfaced Lenses');
                }else if(type == 'right'){
                    validateCutOutLenses2('left');
                }
                else{                    
                    // if($('#warningMsg').height() <= 33){
                    //     $('#warningMsg').removeClass('alert alert-warning');
                    //     $('#warningMsg').hide();
                    // }
                    $('#warningCutOut').text('');
                    showHideWarningContainer();
                }
            }
        }
    });
}
function isAllFilledArray(array){
    let response = true;
    $.each(array,function(index,value){
        // console.log($('#'+value).val()+': '+value);
        if($('#'+value).val() == '' || $('#'+value).val() == null){
            if(value != 'right_cyl' && value != 'left_cyl')
                response = false;
        }
    });
    return response;
}
function isFocusSkipped(element) {
    if(element.attr('data-name') == 'axis'){
        if(isNullOrEmpty($('#'+getDirectionType(element)+'_cyl').val())){
            element.val(null).trigger("change");
            return true;
        }
    }else if(element.attr('data-name') == 'base1'){
        if(isNullOrEmpty($('#'+getDirectionType(element)+'_prism1').val())){
            element.val(null).trigger("change");
            return true;
        }
    }else if(element.attr('data-name') == 'base2'){
        if(isNullOrEmpty($('#'+getDirectionType(element)+'_prism2').val())){
            element.val(null).trigger("change");
            return true;
        }
    }

    return false;
}
function getDefaultValue(id){
    keyValue = id+'Def';
    if(typeof rxFormDataValues[keyValue] !== 'undefined'){
        return rxFormDataValues[keyValue];
    }
    return '';
}
function getDirectionType(element){
    let dir = element.attr('id');
    if (element.attr('id').indexOf("right") >= 0){
        dir = 'right';
    }else if(element.attr('id').indexOf("left") >= 0){
        dir = 'left';
    }
    return dir;
}
function isRequestNeeded(element,id){
    let returnFlag = true;
    let lens_type = $('#lens_type').val();
    let sub_type = $('#sub_type').val();
    let job_type = $("input[name='data[frame][job_type]']:checked").val();
    if(combinationHideArray.hasOwnProperty("lens_type") && typeof combinationHideArray.lens_type[lens_type] !== 'undefined'){
        $.each(combinationHideArray.lens_type[lens_type]['not_required'], function( index, value ) {
            if(value == id){
                returnFlag = false;
            }
        });
    }
    if(combinationHideArray.hasOwnProperty("lens_type") && typeof combinationHideArray.lens_type[lens_type] !== 'undefined'){
        $.each(combinationHideArray.lens_type[lens_type]['required'], function( index, value ) {
            if(value == id){
                returnFlag = true;
            }
        });
    }
    if(combinationHideArray.hasOwnProperty("sub_type") && typeof combinationHideArray.sub_type[sub_type] !== 'undefined'){
        $.each(combinationHideArray.sub_type[sub_type]['required'], function( index, value ) {
            if(value == id){
                returnFlag = true;
            }
        });
    }
    if(combinationHideArray.hasOwnProperty("sub_type") && typeof combinationHideArray.sub_type[sub_type] !== 'undefined'){
        $.each(combinationHideArray.sub_type[sub_type]['not_required'], function( index, value ) {
            if(value == id){
                returnFlag = false;
            }
        });
    }
    if(!isNullOrEmpty(job_type)){
        if(combinationHideArray.hasOwnProperty("lens_type") && typeof combinationHideArray.job_type[job_type] !== 'undefined'){
            $.each(combinationHideArray.job_type[job_type]['not_required'], function( index, value ) {
                if(value == id){
                    returnFlag = false;
                }
            });
        }
    }
    if(returnFlag && element.hasAttr('data-required_if') && !isNullOrEmpty(element.attr('data-required_if'))){
        let attribute = element.attr('data-required_if').split(',');
        let id = '';
        returnFlag = false;
        $(attribute).each(function( index, value ){
            let id = '';
            if(value.indexOf("rl_") >= 0){
                let dir = 'left_';
                if (element.attr('id').indexOf("right") >= 0){
                    dir = 'right_';
                }
                id = dir+value.replace('rl_','');
            }else{
                id = value;
            }
            if($('#'+id).length > 0 && !isNullOrEmpty($('#'+id).val())){
                returnFlag = true;
            }
        });
    }
    return returnFlag;
}
$.fn.hasAttr = function(name) {  
   return this.attr(name) !== undefined;
};
function validateFieldRequired(element){
    const $options = $("option", element);//.not(":first-child")
    let type = element.attr('data-name');
    let id = element.attr('id');
    if(isRequestNeeded(element,id)){
        if ($options.length > 1 || ($options.length == 1 && $options.first().val() != "" )) {
            if(!element.is(":disabled")){
                if(element.attr('data-empty-check')){
                    let dir = 'left';
                    if (element.attr('id').indexOf("right") >= 0){
                        dir = 'right';
                    }
                    if($('#'+dir+'_'+element.attr('data-empty-check')).val() != ''){
                        element.prop("required", true);
                        updateAsterick(element,1);
                    }
                }else{
                    element.prop("required", true);
                    updateAsterick(element,1);
                }
            }else{
                element.prop("required", false);
                updateAsterick(element,0);
            }
        } else {
            element.prop("required", false);
            updateAsterick(element,0);
        }
    }else{
        updateAsterick(element,0);
    }
    showErrorToastr();
}
function updateAsterickAllFields(){
    $(".is-required:visible, #right_oc, #left_oc", $("#rx-order_form")).each(function () {
        $(this).removeClass('is-invalid');
        if ($(this).is("input")) {
                updateAsterick($(this),1);
            // }
        } else if ($(this).is("select")) {
            validateFieldRequired($(this));
        }
    });
}
function isAesterickOrRequired(element){
    let labelElem = $('.control-label[for="'+element.attr('name')+'"]');
    if(labelElem.length> 0 && labelElem.find('.label-asterick').length > 0){
        return true;
    }
    return false;
}
function updateAsterick(element,flag){
    if(element.attr('data-name') == 'oc'){
        $('#right-oc .showhide-container-btn').show();
        if(flag){
            $('#oc_field-btn .show_hide-abtn').trigger('click');
            $('#right-oc .showhide-container-btn').hide();
        }else if($('#right-oc .showhide-container-btn a').is(":visible") && !$('#right_oc').hasAttr('data-s2open') && !$('#left_oc').hasAttr('data-s2open') && isNullOrEmpty($('#left_oc').val()) && isNullOrEmpty($('#right_oc').val())){
            // $('#right-oc .showhide-container-btn a').trigger('click');
            $('.'+$('#right-oc .showhide-container-btn a').attr('data-attr')+'-container').hide();
            $('#'+$('#right-oc .showhide-container-btn a').attr('data-attr')+'-btn').toggle();
            $('.'+$('#right-oc .showhide-container-btn a').attr('data-attr')+'-container').find('select,input,selectarea').val(null).trigger('change');
            $('#right_oc,#left_oc').val(null);
        }
    }
    let labelElem = $('.control-label[for="'+element.attr('name')+'"]');
    if(labelElem.length> 0){
        if(flag){
            if(labelElem.find('.label-asterick').length == 0){
                labelElem.append('<span class="label-asterick">*</span>');
            }
            updateClearOptionSelect2(element,flag);
        }else{
            if(labelElem.find('.label-asterick').length > 0){
                labelElem.find('.label-asterick').remove();
            }
            updateClearOptionSelect2(element,flag);
        }
    }
}
function updateClearOptionSelect2(element,flag){
    if(element.attr('data-name') == 'npd' || element.attr('data-name') == 'oc'){
        if(flag){
            element.next('.select2-container').find('.select2-selection__clear').hide();
        }else{          
            element.next('.select2-container').find('.select2-selection__clear').show();
        }
    }
}
function showHideSummaryElements(element){
    if(typeof element.attr('data-show') !== 'undefined' && element.attr('data-show') !== false){
        if(element.text() != ''){
            $('.'+element.attr('data-show')).show();
        }else{
            $('.'+element.attr('data-show')).hide();
        }
    }
}
function showErrorToastr(){
    if(isErrorShowFlag){
        var firstTwoErrorFields = $(".label-asterick");
        let html = '';
        let field = null;
        let label = null;
        let count = 0;
        let combError = isCombPowerError();
        if(!isNullOrEmpty(combError)){
            $('.form-error-toaster .comb-power-error').remove();
            html += '<div class="comb-power-error">'+combError+'</div>';
        }else{
            firstTwoErrorFields.each(function(index, element) {              
                if($(element).parent().hasAttr('for')){
                    field = $('[name="'+$(element).parent().attr('for')+'"]');
                    if(field.is(":visible") && (isNullOrEmpty(field.val()) || (field.is(':radio') && !field.is(':checked')))){ 
                        label = $(element).parent().text();
                        label = label.replaceAll(' *','');
                        label = label.replaceAll('*','');
                        if(field.hasAttr('id')){
                            if (field.attr('id').indexOf("right_") >= 0){
                                label = 'Right Eye '+label;
                            }else if(field.attr('id').indexOf("left_") >= 0){
                                label = 'Left Eye '+label;
                            }
                        }
                        html += '<div>[ '+label.toUpperCase()+' ] is required</div>';
                        count++;
                    }
                    if(count == 2){
                        return false;
                    }
                }
            });
        }
        if(html != ''){
            $('.form-error-toaster').html('');
            $('.form-error-toaster').html(html);
            $('.form-error-toaster').show();
        }else{
            $('.form-error-toaster').hide();
        }
    }   
}
function get_additional_charges_calculations(callback_function){
    $.ajaxSetup({
        async: false
    });
    // load the prices json file to dynamically change proces based on product item selection
    $.getJSON(rx_lens_additional_charges_json, function(data){
       rxAdditionalCharges = data;
        $.ajaxSetup({
            async: true
        });
       if( !_.isUndefined(callback_function) ){
            callback_function(rxAdditionalCharges);
       }
    });
}
function checkChargeFlag(min,max,dirValue){
    let chargeFlag = false;
    if(dirValue != ''){
        if(min != '' && max != ''){
            if(dirValue >= min && dirValue <= max) {
                chargeFlag = true;
            }
        }else if(min != '' && dirValue >= min){
            chargeFlag = true;
        }else if(max != '' && dirValue <= max){
            chargeFlag = true;
        }
    }
    return chargeFlag;
}
function parseFloatNumber(number){
    if(number != '')
        return parseFloat(number);

    return 0;
}
function checkLensTypeSelection(lensType,lensTypeExclude){
    let lensTypeOption = $('#lens_type option:selected').text();
    lensType = lensType.split('\\');
    lensTypeExclude = lensTypeExclude.split('\\');
    if(lensType[0] == '' && lensTypeExclude[0] == ''){
        return true;
    }
    let flag = false;

    if(lensType[0] == '' || jQuery.inArray(lensTypeOption, lensType) !== -1){
        flag = true;
    }
    if(jQuery.inArray(lensTypeOption, lensTypeExclude) !== -1){
        flag = false;
    }
    return flag;
}
function checkAdditionalCharges(){
    if(isPackageOn()){
        return false;
    }
    if($.isEmptyObject(rxAdditionalCharges))
        get_additional_charges_calculations();

    let priceAttr = 'Price_'+cstCode;
    let additionalChargesArray = [];
    let discount = [];
    $.each(rxAdditionalCharges,function(index,value){
        let idAttr = value.chargeName.replaceAll(" ", "_");
        idAttr = idAttr.replaceAll("+/", "");
        idAttr = idAttr.replaceAll(",", "");
        idAttr = idAttr.replaceAll("(", "");
        idAttr = idAttr.replaceAll(")", "");
        idAttr = idAttr.replaceAll("?", "");
        idAttr = idAttr.replaceAll(".", "");
        idAttr = idAttr.replaceAll("&", "");
        idAttr = idAttr.replaceAll("-", "");
        if(checkLensTypeSelection(value.lensType,value.lensTypeExclude)){
            value.chargeMin = parseFloatNumber(value.chargeMin);
            value.chargeMax = parseFloatNumber(value.chargeMax);
            additionalChargesArray[idAttr] = [];
            let chargeFlag = false;
            if(value.andOr != '' && (value.chargeMin != '' || value.chargeMax != '')){
                let mapFields = value.mapFields.split('\\');
                chargeFlag = false;
                if(value.mapFields == 'power'){
                    let sph = $('#right_sph').val();
                    let cyl = $('#right_cyl').val();
                    let power = 0;
                    sph = parseFloatNumber(sph);
                    cyl = parseFloatNumber(cyl);
                    power = sph + cyl;
                    if(power >= value.chargeMin)
                        chargeFlag = true;
                    else if(power <= value.chargeMax)
                        chargeFlag = true;

                    if(chargeFlag){
                        // price += value[priceAttr]/2;
                        additionalChargesArray[idAttr].push({
                            type: 'right',
                            price: value[priceAttr]/2,
                            label: value.chargeName,
                            id: idAttr
                        });
                    }
                    // FOr left
                    sph = $('#left_sph').val();
                    cyl = $('#left_cyl').val();
                    power = 0;
                    chargeFlag = false;
                    sph = parseFloatNumber(sph);
                    cyl = parseFloatNumber(cyl);
                    power = sph + cyl;
                    if(power >= value.chargeMin)
                        chargeFlag = true;
                    else if(power <= value.chargeMax)
                        chargeFlag = true;

                    if(chargeFlag){
                        // price += value[priceAttr]/2;
                        additionalChargesArray[idAttr].push({
                            type: 'left',
                            price: value[priceAttr]/2,
                            label: value.chargeName,
                            id: idAttr
                        });
                    }
                }else if(value.mapFields == 'prism1\\prism2'){
                    //Right
                    let dirValue = parseFloatNumber($('#right_'+mapFields[0]).val());
                    if($('#right_'+mapFields[1]).val() != ''){
                        dirValue += parseFloatNumber($('#right_'+mapFields[1]).val());
                    }
                    chargeFlag = checkChargeFlag(value.chargeMin,value.chargeMax,dirValue);
                    if(chargeFlag){
                        // price += value[priceAttr]/2;
                        additionalChargesArray[idAttr].push({
                            type: 'right',
                            price: value[priceAttr]/2,
                            label: value.chargeName,
                            id: idAttr
                        });
                    }
                    //Left
                    dirValue = parseFloatNumber($('#left_'+mapFields[0]).val());
                    if($('#left_'+mapFields[1]).val() != ''){
                        dirValue += parseFloatNumber($('#left_'+mapFields[1]).val());
                    }
                    chargeFlag = checkChargeFlag(value.chargeMin,value.chargeMax,dirValue);
                    if(chargeFlag){
                        // price += value[priceAttr]/2;
                        additionalChargesArray[idAttr].push({
                            type: 'left',
                            price: value[priceAttr]/2,
                            label: value.chargeName,
                            id: idAttr
                        });
                    }
                }
            }else if(value.mapFields != ''){
                if(value.chargeMin != '' || value.chargeMax != ''){

                    //For Right
                    let dirValue = parseFloatNumber($('#right_'+value.mapFields).val());
                    if($('#right_'+value.mapFields).length == 0){
                        dirValue = parseFloatNumber($('#'+value.mapFields).val());
                    }
                    if(value.mapFields == 'cyl'){
                        dirValue = Math.abs(dirValue);
                    }
                    chargeFlag = checkChargeFlag(value.chargeMin,value.chargeMax,dirValue);
                    if(chargeFlag){
                        // price += value[priceAttr]/2;
                        additionalChargesArray[idAttr].push({
                            type: 'right',
                            price: value[priceAttr]/2,
                            label: value.chargeName,
                            id: idAttr
                        });
                    }
                    // For Left
                    dirValue = $('#left_'+value.mapFields).val();
                    if($('#left_'+value.mapFields).length == 0){
                        dirValue = $('#'+value.mapFields).val();
                    }
                    if(value.mapFields == 'cyl'){
                        dirValue = Math.abs(parseFloatNumber(dirValue));
                    }
                    chargeFlag = checkChargeFlag(value.chargeMin,value.chargeMax,dirValue);
                    if(chargeFlag){
                        // price += value[priceAttr]/2;
                        additionalChargesArray[idAttr].push({
                            type: 'left',
                            price: value[priceAttr]/2,
                            label: value.chargeName,
                            id: idAttr
                        });
                    }
                }
                else{
                    if(value.mapFields == 'dist_type'){
                        dirValue = $('#right_'+value.mapFields).val();
                        discount['right'] = [];
                        if(dirValue == 'Balance'){
                            discount['right'].push({
                                price: value[priceAttr],
                                label: value.chargeName
                            });
                        }
                        dirValue = $('#left_'+value.mapFields).val();
                        discount['left'] = [];
                        if(dirValue == 'Balance'){
                            discount['left'].push({
                                price: value[priceAttr],
                                label: value.chargeName
                            });
                        }
                    }else{
                        mapFields = value.mapFields.split('\\');
                        let elemType = null;
                        $.each(mapFields,function(index,value2){
                            elemType = $('#'+value2).attr('type');
                            dirValue = '';
                            if(elemType == 'checkbox'){
                                if(!$('#'+value2).closest('.single-checkbox').parent().hasClass('chide') && $('#'+value2).is(":checked")){
                                    chargeFlag = true;
                                }
                            }else if(elemType == 'radio'){
                                elemName = $('#'+value2).attr('name');
                                let job_type = $("input[name='data[frame][job_type]']:checked").val();
                                if(job_type != 'uncut' && $("input[name='"+ elemName +"']:checked").val() == value2){
                                    chargeFlag = true;
                                }
                            }else{
                                dirValue = $('#'+value2).val();
                                chargeFlag = checkChargeFlag(value.chargeMin,value.chargeMax,dirValue);
                            }

                            if(chargeFlag)
                                return false;
                        });
                        if(chargeFlag){
                            // price += value[priceAttr];
                            additionalChargesArray[idAttr].push({
                                type: 'full',
                                price: value[priceAttr],
                                label: value.chargeName,
                                id: idAttr
                            });
                        }
                    }
                }
            }
        }
    });
    additionalChargesArray = Object.keys(additionalChargesArray).map(function (key) { return additionalChargesArray[key]; });
    let price = 0;
    $.each(additionalChargesArray,function(index,value){
        price = 0;
        label = '';
        $.each(value,function(index2,value2){
            if(value2 != 'full'){
                if($('#'+value2.type+'_dist_type').val() != 'Do not order'){
                    if(value2.type in discount && discount[value2.type].length > 0){
                        dPrice = discount[value2.type][0].price.replaceAll("-", "");
                        dPrice = discount[value2.type][0].price.replaceAll("%", "");
                        dPrice = discount[value2.type][0].price.replaceAll("-", "");
                        dPrice = parseFloatNumber(dPrice);
                        dPrice = value2.price * (dPrice / 100);
                        dPrice = value2.price - dPrice;
                        price += dPrice;
                    }else{
                        price += value2.price;
                    }
                    label = value2.label;
                }
            }else{
                price += value2.price;
                label = value2.label;
            }
        });
        //Put Data on summary
        if($('#additonal-content-'+index).length > 0){
            $('#additonal-content-'+index).remove();
            updateAdditionalHiddenInputPrices('additonal-content-'+index,'','');
        }

        if(price > 0){
            let html = '<span id="additonal-content-'+index+'">'+label+': $<span class="price">'+parseFloat(price).toFixed(2)+'</span><br></span>';
            $('.total_price-container').append(html);
            updateAdditionalHiddenInputPrices('additonal-content-'+index,label,parseFloat(price).toFixed(2));
        }
    });
    $('#additonal-content-discount').remove();
    updateAdditionalHiddenInputPrices('additonal-content-discount','','');
    discount = Object.keys(discount).map(function (key) { return discount[key]; });
    if(discount.length > 0){
        $.each(discount,function(index,value){
            if(value.length > 0){
                html = '<span id="additonal-content-discount">'+value[0].label+': <span>'+value[0].price+'</span><br></span>';
                $('.total_price-container').append(html);
                updateAdditionalHiddenInputPrices('additonal-content-discount',value[0].label,value[0].price);
                return false;
            }
        });
    }
    updateSummaryPrice();
    //END Put Data on summary
}
function get_base_curve_calculations(callback_function){
    $.ajaxSetup({
        async: false
    });
    // load the prices json file to dynamically change proces based on product item selection
    $.getJSON(rx_base_curve_json_url, function(data){
       bcCalculations = data;
        $.ajaxSetup({
            async: true
        });
       if( !_.isUndefined(callback_function) ){
            callback_function(bcCalculations);
       }
    });
}
function calculateMaxDia(){
    if($.isEmptyObject(bcCalculations))
        get_base_curve_calculations();

    let flagMd = true;
    let material = '';
    if($.trim($('#lens_material').val()).length > 0)
        material = $('#lens_material').val().toLowerCase();

    // $.each($('.cal-base_curve-req'),function(index,value){
    //     if($(this).hasClass('red') || $(this).val() == '')
    //         flagMd = false;
    // });
    if(isPlanoLenses())
        flagMd = false;
    // else if(isNullOrEmpty($('#right_sph').val()) || isNullOrEmpty($('#left_sph').val()))
    //     flagMd = false;
    else if(isNullOrEmpty($('#a').val()) || isNullOrEmpty($('#ed').val()))
        flagMd = false;
    // else if($("#right_base_curve option").length > 0)
    //     flagMd = false;

    if(flagMd && material != '' && !_.isUndefined(bcCalculations[material])){
        // console.log(bcCalculations[material]);
        let mdX = {
            right:0,
            left:0
        };
        let bc_value = {
            right:0,
            left:0
        };

        //STEP 1: Convert to -CYL if needed
        let rightData = {
            sph:!isNullOrEmpty($('#right_sph').val()) ? parseFloat($('#right_sph').val()) : 0,
            cyl: !isNullOrEmpty($('#right_cyl').val()) ? parseFloat($('#right_cyl').val()) : 0
        };
        let leftData = {
            sph:!isNullOrEmpty($('#left_sph').val()) ? parseFloat($('#left_sph').val()) : 0,
            cyl: !isNullOrEmpty($('#left_cyl').val()) ? parseFloat($('#left_cyl').val()) : 0
        };
        // if(rightData.cyl == '')
            // rightData.cyl = !isNullOrEmpty($('#left_cyl').val()) ? parseFloat($('#left_cyl').val()) : 0

        // if(leftData.cyl == '')
            // leftData.cyl = !isNullOrEmpty($('#right_cyl').val()) ? parseFloat($('#right_cyl').val()) : 0


        if(rightData.cyl > 0){
            rightData.sph += rightData.cyl;
            rightData.cyl *= -1;
        }
        if(leftData.cyl > 0){
            leftData.sph += leftData.cyl;
            leftData.cyl *= -1;
        }
        
        //STEP 2: Calculate for x
        if(rightData.sph > 0){
            mdX.right = rightData.sph;
        }else{
            mdX.right = rightData.sph + rightData.cyl;
        }
        if(leftData.sph > 0){
            mdX.left = leftData.sph;
        }else{
            mdX.left = leftData.sph + leftData.cyl;
        }

        //STEP 3: Calculate for BcR & BcL separately
        for (let i = 0; i < bcCalculations.min.length; ++i) {
            if(bcCalculations.min[i] == '' && bcCalculations.max[i] >= mdX.right){
                bc_value.right = parseFloat(bcCalculations[material][i]);
                break;
            }else if(bcCalculations.min[i] <= mdX.right && bcCalculations.max[i] >= mdX.right){
                bc_value.right = parseFloat(bcCalculations[material][i]);
                break;
            }
        }
        for (let i = 0; i < bcCalculations.min.length; ++i) {
            if(bcCalculations.min[i] == '' && bcCalculations.max[i] >= mdX.left){
                bc_value.left = parseFloat(bcCalculations[material][i]);
                break;
            }else if(bcCalculations.min[i] <= mdX.left && bcCalculations.max[i] >= mdX.left){
                bc_value.left = parseFloat(bcCalculations[material][i]);
                break;
            }
        }
        //STEP 4: Compensate for Sunglasses
        let color = '';
        if(!isNullOrEmpty($('#lens_filter').val())){
            // color = $('#lens_filter').val().toLowerCase();
            var selectedValue = $('#lens_filter').val();
            var selectedOption = $('#lens_filter option[value="' + selectedValue + '"]');
            var optgroup = selectedOption.closest('optgroup');
            color = optgroup.attr('label').toLowerCase();
        }
        let is_sun_array = [
            // 'st-grey',
            // 'st-brown',
            // 'st-green',
            // 'po-grey',
            // 'po-green',
            // 'po-brown',
            'tinted',
            'polarized'
        ];
        if(jQuery.inArray(color, is_sun_array) !== -1 && (parseFloat($('#a').val()) >= 58 || parseFloat($('#ed').val()) >= 58)){
            bc_value.right += 1;
            bc_value.left += 1;
        }

        //Step 4b:
        if(rightData.sph <= 0 && leftData.sph <= 0){
            let prisms = {
                r1:$('#right_prism1').val() != '' ? parseFloat($('#right_prism1').val()) : 0,
                r2: $('#right_prism2').val() != '' ? parseFloat($('#right_prism2').val()) : 0,
                l1:$('#left_prism1').val() != '' ? parseFloat($('#left_prism1').val()) : 0,
                l2: $('#left_prism2').val() != '' ? parseFloat($('#left_prism2').val()) : 0
            };
            let maxPrismR = Math.max(Math.abs(prisms.r1),Math.abs(prisms.r2));
            let maxPrismL = Math.max(Math.abs(prisms.l1),Math.abs(prisms.l2));
            // let maxPrism = Math.max(maxPrismR,maxPrismL);
            bc_value.right -= getPrismCompensate(maxPrismR);
            bc_value.left -= getPrismCompensate(maxPrismL);
        }
        //STEP 5: Calculate DefaultBC
        let bc_difference = Math.abs(bc_value.right - bc_value.left);
        let default_bc = 'auto';
        // if(/*$('.prism-container').is(":hidden") &&*/ bc_difference <= 4){
            if(leftData.sph > 0 || rightData.sph > 0)
                default_bc = Math.max(bc_value.right,bc_value.left);
            else
                default_bc = Math.min(bc_value.right,bc_value.left);
        // }
        let text = 'Auto';
        if(bc_difference <= 4){
            text= default_bc.toString() + ' (Default)';
        }
        let bc_min = 0;
        let bc_max = 12;
        let mx_options_arr = [];
        let counter = default_bc;
        if(rightData.sph > 0 || leftData.sph > 0){
            for (var i = parseInt(default_bc); i <= bc_max; ++i) {
                if(counter == default_bc){
                    mx_options_arr.push(text);
                    if(text == 'Auto')
                        mx_options_arr.push(default_bc);
                }else{
                    mx_options_arr.push(counter);
                }
                ++counter;
            }
        }else{
            counter = bc_min;
            for (var i = bc_min; i <= bc_max; ++i) {
                // mx_options_arr.push(counter == default_bc ? counter+' (Default)' : counter);
                if(counter == default_bc){
                    mx_options_arr.push(text);
                    if(text == 'Auto')
                        mx_options_arr.push(default_bc);
                }
                else
                    mx_options_arr.push(counter);

                ++counter;
            }
        }
        if(mx_options_arr.length > 0){
            $('#right_base_curve').empty();
        }
        $.each(mx_options_arr,function(index,value){
            if(value.toString().toLowerCase().indexOf("default") >= 0){
                if(oldBaseCurveField == '')
                    $('#right_base_curve').append(new Option(value,value,true,true));
                else
                    $('#right_base_curve').append(new Option(value,value));
            }
            else
                $('#right_base_curve').append(new Option(value,value));
        });
        // $('#right_base_curve').removeAttr('disabled');
        $('.closest-label').show();
        if(default_bc == 'auto' || text == 'Auto'){
            // $('#right_base_curve').attr('disabled','disabled');
            $('.closest-label').hide();
        }
        $('#warningMsg').find('#warning-base-curve').remove();
        showHideWarningContainer();
        if(baseCurveField != '' && valueExistsInDropdown($('#right_base_curve'),baseCurveField)){
            $('#right_base_curve').val(baseCurveField);
            $('.summary-container #right_base_curve-field').text(baseCurveField);
        }else{
            $('#right_base_curve').val(text);
            setTimeout(function(){
                checkBaseCurve(text);
            }, 1000);
            $('.summary-container #right_base_curve-field').text(text);
        }
        // $('#right_base_curve').trigger('change');
        // console.log(material);
    }
}
function checkCorridor(value){
    if(corridorField != '' && corridorField != value){
        corridorField = '';
        if(!$('#warningMsg').hasClass('alert')){
            $('#warningMsg').addClass('alert alert-warning');
        }
        $('#warningMsg').append('<div id="warning-corridor" class="secondD">'+"Corridor Value Changed to "+value+'</div>');
        $('#warningMsg').show();
        // setTimeout(function(){
            // $('#warningMsg').find('#warning-corridor').remove();
            // showHideWarningContainer();
        // }, 8000);
    }
}
function isCombPowerError() {
    let leftError = isCombPowerErrorByDirection('left');
    let rightError = isCombPowerErrorByDirection('right');

    if (leftError && rightError) {
        return 'Maximum Combined power out of range for Left and Right Eye';
    } else if (rightError) {
        return 'Maximum Combined power out of range for Right Eye';
    } else if (leftError) {
        return 'Maximum Combined power out of range for Left Eye';
    }

    return '';
}

function isCombPowerErrorByDirection(dir) {
    let sphVal = $('#' + dir + '_sph').val();
    let cylVal = $('#' + dir + '_cyl').val();

    // Only apply logic if sph or cyl is provided
    if (!isNullOrEmpty(sphVal) || !isNullOrEmpty(cylVal)) {
        // Set default bounds
        let minComb = -99999;
        let maxComb = 99999;

        // If both values are valid numbers, use them
        let minCombInput = parseFloat(rxFormDataValues.minComb);
        let maxCombInput = parseFloat(rxFormDataValues.maxComb);

        if (!isNaN(minCombInput)) minComb = minCombInput;
        if (!isNaN(maxCombInput)) maxComb = maxCombInput;

        // Proceed only if both sph and cyl are numbers
        if (!isNullOrEmpty(sphVal) && !isNullOrEmpty(cylVal)) {
            let sph = parseFloat(sphVal);
            let cyl = parseFloat(cylVal);
            let combPower = sph + cyl;

            if (combPower >= minComb && combPower <= maxComb) {
                return false;
            } else {
                $('#' + dir + '_sph').parent('.form-group').addClass('has-error');
                $('#' + dir + '_cyl').parent('.form-group').addClass('has-error');
                return true;
            }
        }
    }

    return false;
}

function checkBaseCurve(value){
    if(baseCurveField != '' && baseCurveField != value){
        baseCurveField = '';
        if(!$('#warningMsg').hasClass('alert')){
            $('#warningMsg').addClass('alert alert-warning');
        }
        $('#warningMsg').append('<div id="warning-base-curve" class="secondD">'+"Lens Base Curve Value Changed to "+value+'</div>');
        $('#warningMsg').show();
        // setTimeout(function(){
            // $('#warningMsg').find('#warning-base-curve').remove();
            // showHideWarningContainer();
        // }, 8000);
    }
}
function showHideWarningContainer(){
    setTimeout(function(){
        var allDivsHaveNoText = $('#warningMsg').find('div').filter(function() {
            // Use $.trim to remove whitespace from the beginning and end of the text
            return $.trim($(this).text()) === '';
        }).length === $('#warningMsg').find('div').length; // Compare lengths

        if (allDivsHaveNoText) {
            $('#warningMsg').removeClass('alert alert-warning');
            $('#warningMsg').hide();
        }
    }, 80);
}
function getPrismCompensate(value){
    if(value >= 2 && value < 4)
        return 1.0;
    if(value >= 4 && value < 6)
        return 2.0;
    if(value >= 6)
        return 3.0;

    return 0;
}
function setLensTypeSummary(){
    setLensTypeByDir('left');
    setLensTypeByDir('right');
    updatePackagePrice();
    // updateSummaryPrice();
}
function setLensTypeByDir(type){
    let orderType = $('#'+type+'_dist_type').val();
    let price = parseFloat(rxFormDataValues.price)/2;
    $('#additonal-content-mdiscount').remove();
    if(Math.abs(rxFormDataValues.discount) > 0 && rxFormDataValues.price > 0){
        // price = price * (1 - (Math.abs(rxFormDataValues.discount) / 100));
        price = Math.abs(price - (Math.abs(rxFormDataValues.discount)/2));
        // let html = '<span id="additonal-content-mdiscount">Discount: <span class="price2">'+rxFormDataValues.discount+'</span><br></span>';
        // $('.total_price-container').append(html);
    }

    let parentElement = $('#'+type+'_dist_type').closest('.row');
    parentElement.find('input,select').not("#"+type+"_dist_type").not(".single-field").removeAttr("disabled");
    $('#'+type+'-extended-info-row').find('input,select').not(".single-field").removeAttr("disabled");
    $('.summary-container #'+type+'-order_other_container span').html('');
    $('.summary-container #'+type+'-order_container').show();
    $('.summary-container #'+type+'-order_other_container').hide();
    if(orderType == 'Order' || isNullOrEmpty(orderType)){
        $('.summary-container #'+type+'-lens_type-price').html(price.toFixed(2));
        $('.hidden-prices-container #price_'+type+'_lens_type').val(price.toFixed(2));
        let text = '';
        $.each($('.lens-data'), function( index, value ) {
            if(typeof $(this).find("option:selected").val() != 'undefined'){
                text += $(this).find("option:selected").text()+', ';
            }
        });
        text = text.slice(0, -2);
        $('.summary-container #'+type+'-order_container .lens_type-field').html(text);

        $('#prism_container #'+type+'-prism1').find('select').removeAttr("disabled");
        $('#prism_container #'+type+'-prism2').find('select').removeAttr("disabled");
        $('#prism_container #'+type+'-base1').find('select').removeAttr("disabled");
        $('#prism_container #'+type+'-base2').find('select').removeAttr("disabled");
    }else if(orderType == 'Balance'){
        let isLensTypeSelected = false;
        $('.lens-data').each(function() {
            if($(this).val() != null){
                isLensTypeSelected = true;
                return false;
            }
        });
        if(isLensTypeSelected){
            $('.summary-container #'+type+'-order_container').hide();
            $('.summary-container #'+type+'-order_other_container span').html('Balance');
            $('.summary-container #'+type+'-order_other_container').show();
            //-----------------
            $('.summary-container #'+type+'-lens_type-price').html(price.toFixed(2));
            $('.hidden-prices-container #price_'+type+'_lens_type').val(price.toFixed(2));
        }
        parentElement.find('input,select').not("#"+type+"_dist_type").not(".single-field").val(null).trigger('change.select2');//.trigger('change');
        parentElement.find('input,select').not("#"+type+"_dist_type").not(".single-field").attr("disabled", "disabled");
        $('#'+type+'-extended-info-row').find('input,select').not(".single-field").val(null).trigger('change.select2');//.trigger('change');
        $('#'+type+'-extended-info-row').find('input,select').not(".single-field").attr("disabled", "disabled");
        $('#prism_container #'+type+'-prism1').find('select').attr("disabled", "disabled");
        $('#prism_container #'+type+'-prism2').find('select').attr("disabled", "disabled");
        $('#prism_container #'+type+'-base1').find('select').attr("disabled", "disabled");
        $('#prism_container #'+type+'-base2').find('select').attr("disabled", "disabled");

        $('#prism_container #'+type+'-prism1').find('select').val('').trigger('change');
        $('#prism_container #'+type+'-prism2').find('select').val('').trigger('change');
        $('#prism_container #'+type+'-base1').find('select').val('').trigger('change');
        $('#prism_container #'+type+'-base2').find('select').val('').trigger('change');
    }else if(orderType == 'Do not order'){
        $('.summary-container #'+type+'-order_container').hide();
        $('.summary-container #'+type+'-order_other_container span').html('Do not order');
        $('.summary-container #'+type+'-order_other_container').show();
        //-----------------------

        $('.summary-container #'+type+'-lens_type-price').html('0.00');
        $('.hidden-prices-container #price_'+type+'_lens_type').val('');

        $('#sm-price').text(0.00);
        $('#hidden_total_price').val('');
        parentElement.find('input,select').not("#"+type+"_dist_type").not(".single-field").val(null).trigger('change.select2');//.trigger('change');
        parentElement.find('input,select').not("#"+type+"_dist_type").not(".single-field").attr("disabled", "disabled");
        $('#'+type+'-extended-info-row').find('input,select').not(".single-field").val(null).trigger('change.select2');//.trigger('change');
        $('#'+type+'-extended-info-row').find('input,select').not(".single-field").attr("disabled", "disabled");

        $('#prism_container #'+type+'-prism1').find('select').attr("disabled", "disabled");
        $('#prism_container #'+type+'-prism2').find('select').attr("disabled", "disabled");
        $('#prism_container #'+type+'-base1').find('select').attr("disabled", "disabled");
        $('#prism_container #'+type+'-base2').find('select').attr("disabled", "disabled");

        $('#prism_container #'+type+'-prism1').find('select').val('').trigger('change');
        $('#prism_container #'+type+'-prism2').find('select').val('').trigger('change');
        $('#prism_container #'+type+'-base1').find('select').val('').trigger('change');
        $('#prism_container #'+type+'-base2').find('select').val('').trigger('change');
    }
}
function isNullOrEmpty(value) {
  return value === null || value === undefined || value === '';
}
function getTotalPrice() {
    let price = 0;
    $.each($('.summary-container .price'), function( index, value ) {
        price += safeParseFloat($(this).text());
    });
    return price;
}
function updateSummaryPrice(){
    let price = getTotalPrice();
    $('span.price').parent().show();
    $('span#sm-price').parent().show();
    $('#sm-price').text(price);
    $('#hidden_total_price').val(price);
    
    if(!isNullOrEmpty(price) && !isNaN(price) && ((isMerchantUser || isPricesShow) && isPackageOn())){
        if(isPricesShow || isPackageOn()){
            if(isPackageOn()){
                // price = parseFloat(price) + parseFloat(getPackagePrice());
                $('#right-lens_type-price').text('0.00');
                $('#left-lens_type-price').text('0.00');

                $('.hidden-prices-container #price_right_lens_type').val('');
                $('.hidden-prices-container #price_left_lens_type').val('');

                $('#right-lens_type-price').parent().hide();
                $('#left-lens_type-price').parent().hide();
                $('#package-price').show();
            }
            $('#sm-price').text(price.toFixed(2));
            $('#hidden_total_price').val(price.toFixed(2));
        }
        $('span#sm-price').parent().show();
    }else if(!isPricesShow){
        $('span.price').parent().hide();
        $('span#sm-price').parent().hide();
    }  

    // Hide elements with 0 or 0.00 value
    $('.summary-container .price').each(function() {
        let val = safeParseFloat($(this).text());
        if (val === 0) {
            $(this).parent().hide();
        }
    });
    let val = safeParseFloat($('#sm-price').text());
    if (val === 0) {
        $('#sm-price').parent().hide();
        $('#hidden_total_price').val('');
    }else{
        $('#hidden_total_price').val($('#sm-price').text());
    }
}
function safeParseFloat(val) {
    if (typeof val !== 'string') val = String(val); // ensure it's a string
    val = val.trim().replace(/[^0-9.-]+/g, ''); // remove currency symbols, commas, etc.

    return val !== '' && !isNaN(val) ? parseFloat(val) : 0;
}
function getPackagePrice(){
    var price = 0;
    if(isPackageOn() &&
        rxFormDataValues &&                      // Ensure rxFormDataValues is not null/undefined
        Array.isArray(rxFormDataValues.packages) && 
        rxFormDataValues.packages.length > 0 &&  // Ensure packages array exists and has elements
        rxFormDataValues.packages[0] &&
        Array.isArray(rxFormDataValues.packages[0].price) && 
        rxFormDataValues.packages[0].price.length >= packageTeir){
        price = parseFloat(rxFormDataValues.packages[0].price[packageTeir - 1]).toFixed(2);
    }
    return price;
}
function updatePackagePrice(){
    $('.total_price-container').find('#package-price').remove();
    updateAdditionalHiddenInputPrices('package','','');
    $('#package_price').val('0.00');
    $('#package_label').val('');
    if(isPackageOn() && !isNullOrEmpty(packageTeir)){
        let price = getPackagePrice();
        let html = '<span id="package-price">'+$('#packageList').val()+' (Tier '+packageTeir+'): $<span class="price">'+price+'</span><br></span>';

        $('#package_price').val(price);
        $('#package_label').val($('#packageList').val()+' (Tier '+packageTeir+')');

        $('#sm-price').text(price);
        $('#hidden_total_price').val(price);
        $('.total_price-container').append(html);
        updateAdditionalHiddenInputPrices('package',$('#packageList').val()+' (Tier '+packageTeir+')',price);
    }
    updateSummaryPrice();
}
function updateSummaryAddons(){
    let price = 0;
    let html = '';
    let priceInputs = '';
    $('.summary-container').find('.repairs_services-mlist').remove();
    $('.hidden-prices-container').find('.repairs_service-prices').remove();
    $.each($('.repairs_services-content'), function( index, value ) {
        elem = $(this).find('.repairs_services-list');
        if(elem.val() != ''){
            html += '<div class="row m-0 p-2 repairs_services-mlist"><div class="col-1 p-0">&nbsp</div><div class="col-9 p-0">'+elem.find('option:selected').text()+'</div><div class="col-2 p-0 bold text-right">$<span class="price">'+parseFloat(elem.find('option:selected').attr(custPriceTag.toLowerCase())).toFixed(2)+'</span></div></div>';
            priceInputs += '<input type="hidden" name="data[prices][repairs_services][]" class="repairs_service-prices"  value="'+parseFloat(elem.find('option:selected').attr(custPriceTag.toLowerCase())).toFixed(2)+'">';
        }
    });
    $('#addons-second-elem').after(html);
    $('.hidden-prices-container').append(priceInputs);
    updateSummaryPrice();
}
function applySpecifyRules(){
    let element = $('#r_ct_or_et');
    var value = parseFloat(parseFloat($('#right_sph').val()).toFixed(2));
    let label = 'R: CT';
    if(!isNaN(value) && value > 0){
        label = 'R: ET';
        appendOptionValues(element,1,5,0.1,1,null);
    }else{
        appendOptionValues(element,1.5,5,0.1,1,null);
    }

    $('.ct_or_et-container.right label').text(label);

    element = $('#l_ct_or_et');
    value = parseFloat(parseFloat($('#left_sph').val()).toFixed(2));

    label = 'L: CT';
    if(!isNaN(value) && value > 0){
        label = 'L: ET';
        appendOptionValues(element,1,5,0.1,1,null);
    }else{
        appendOptionValues(element,1.5,5,0.1,1,null);
    }

    $('.ct_or_et-container.left label').text(label);
}
function updateLensArea(lens_type){
    switch(lens_type){
        case 'sv':
            var value = 'single_vision';
            $("#lens_type option").attr('disabled','disabled');
            $("#lens_type option[value=" + value + "]").removeAttr('disabled');
            $('#lens_type').val(value).trigger('change');
        break;
        case 'multi_focal':
            var value = 'lined_multiminusfocal';
            $("#lens_type option").attr('disabled','disabled');
            $("#lens_type option[value=" + value + "]").removeAttr('disabled');
            $('#lens_type').val(value).trigger('change');
        break;
        case 'progressive':
            var value = 'progressive';
            $("#lens_type option").attr('disabled','disabled');
            $("#lens_type option[value=" + value + "]").removeAttr('disabled');
            $("#lens_type option[value=computer_progressive]").removeAttr('disabled');
            $("#lens_type option[value=extended_computer_progressive]").removeAttr('disabled');
            $('#lens_type').val(value).trigger('change');
        break;
    }
}
function nearestRound(value,nearest){
    return  value + nearest/2 - (value+nearest/2) % nearest;
}
function clearFormElements() {
    window.isLoaderStop = false;
    $.ajax({
        url: '',
        type: "GET",
        success: function(data){
            $data = $(data);
            $('.form-container').html($data);
            setTimeout(function(){
                initForm();
            }, 500);
        }
    });
}
function initForm(){
    toggleTags('brand',true);
    toggleTags('model',true);
    toggleTags('colour',true);
    toggleTags('size',true);
    initLensOptions('');
    validateFields();
    get_addons_data();
    updateAsterickAllFields();
    filterFrameInfo('brand','');
    // $.each($('select.select2'), function( index, value ) {

    // });
}
function calculateShapeFactor(){
    let factorValue = 0;
    if($("input[name='data[frame][frame_size][shape]']").is(':checked')){
        var factor = $("input[name='data[frame][frame_size][shape]']:checked").attr('data-factor');                    
        var aValue = 0;
        if(!isNullOrEmpty($('#a').val()))
            aValue = $('#a').val();

        factorValue = factor * aValue;
    }
    $('input[name="data[frame][frame_size][shape_factor]"]').val(nearestRound(factorValue,0.5).toFixed(1));

    return nearestRound(factorValue,0.5).toFixed(1);
}
function fillData(){
    isFillFields = false;

    if(!isNullOrEmpty(editOrderData)){
        isOrderEditMode = true;
    //     formData = {};        
        if(!isNullOrEmpty(editOrderData.package)){
            $('#package').prop('checked', true);
            $('#package').trigger('change');
            $('#packageList').val(editOrderData.package).trigger('change');
            initLensOptions('package');
        }
        // setTimeout(function() {   
            if(typeof editOrderData.lens != 'undefined'){
                // $('.show-hide-btn a').trigger('click');
                $($('#rx-order_form .lens-data')).each(function(index,value){
                    if(!isNullOrEmpty(editOrderData.lens[$(this).attr('data-name')])){
                        $(this).val(editOrderData.lens[$(this).attr('data-name')]).trigger('change');
                    }
                });
            }
        // }, 500);
        setTimeout(function() {             
            if(!isNullOrEmpty(editOrderData.frame.frame_info.brand)){
                // $('#brand').val(editOrderData.frame.frame_info.brand).trigger('change');
                preBrand = editOrderData.frame.frame_info.brand;
                preModel = editOrderData.frame.frame_info.model;
                preColour = editOrderData.frame.frame_info.colour;
                preSize = editOrderData.frame.frame_info.size;
            }
            $($('#rx-order_form select:not(.lens-data)')).each(function(index){
                fillDataByElements($(this));
                $('.col-rx-form-container').scrollTop(0);
            });
        }, 1200);
        $($('#rx-order_form input')).each(function(index){
            if(($(this).attr('id') == 'first_name' || $(this).attr('id') == 'last_name')){
                if(orderType != 'reuse' || orderType != 'edit'){
                    fillDataByElements($(this));
                }
            }else{
                fillDataByElements($(this));
            }
        });
        $('.col-rx-form-container').scrollTop(0);
        $($('#rx-order_form textarea')).each(function(index){
            fillDataByElements($(this));
        });
        $('.col-rx-form-container').scrollTop(0);

        checkPlanoLenses();
        setTimeout(function() { 
            $('.col-rx-form-container').scrollTop(0);
            isOrderEditMode = false;
        }, 1500);
        // console.log(editOrderData.lens);
    }
        
}
function isObjectOrArrayEmptyOrEmptyValues(input) {
    if (input == null) return true; // Null or undefined check

    if (Array.isArray(input)) {
        // Check if array has only empty or falsy values
        return input.every(item => !item || isObjectOrArrayEmptyOrEmptyValues(item));
    } else if (typeof input === 'object') {
        // Check if object has only empty or falsy values
        for (const key in input) {
            if (input[key] && !isObjectOrArrayEmptyOrEmptyValues(input[key])) {
                return false; // Found a non-empty value
            }
        }
        return true; // All values in the object are empty or falsy
    }

    return false; // Not an object or array and not empty
}
function fillDataByElements(element){
    let result  = element.attr('name').split('[');
    let temp    = null;
    let name = element.attr('name');
    // console.log(element.attr('name'));
    $.each(result, function( index, value ) {
        value = value.replace("]", "");
        if(typeof editOrderData[value] != 'undefined'){
            temp = editOrderData[value];
        }else if(temp != null && typeof temp[value] != 'undefined'){
            temp = temp[value];
        }
    });
    if(name == 'data[additional_items][repairs_services][]'){
        if(editOrderData.additional_items.repairs_services.length > 0){
            $('.show-hide-btn-container a[data-element="add_repairs-container"]').trigger('click');
            $.each(editOrderData.additional_items.repairs_services, function( index, value ) {
                if(!isNullOrEmpty(value)){
                    $('.repairs_services-content:last-child .repairs_services-list').val(value).trigger('change');
                }
            });
        }
    }
    else if (temp != null && !isObjectOrArrayEmptyOrEmptyValues(temp)){
        if(element.attr('type') == 'radio' && element.val() == temp){
            element.prop('checked', true);
            element.parent().trigger('click');
            element.val(temp).trigger('change');
            element.addClass('edited');
        }else if(element.attr('type') == 'checkbox'){
            if(temp == 'on'){
                element.prop('checked', true);
                element.trigger('change');
            }else{
                element.val('on');
            }
        }else if(element.is('textarea')){
            element.append(temp).trigger('change');
            element.addClass('edited');
        }else if(element.attr('type') != 'radio'){
            let ignoreList = [
                'brand',
                'model',
                'colour',
                'size'
            ];
            if($.inArray(element.attr('data-name'), ignoreList ) === -1){
                if(!isNullOrEmpty(element.attr('id'))){
                    setOrAppendSelect(element.attr('id'), temp);
                }else{
                    element.val(temp).trigger('change');
                }
                element.addClass('edited');
            }
        }
        if(element.is(":hidden")){
            if(element.is('select')){
                if(element.attr('data-name') == 'oc'){
                    if(!isNullOrEmpty(element.val())){
                        $('#oc_field-btn .show_hide-abtn').trigger('click');
                    }
                }
                else if(element.closest('.form-group').parent().closest('.row').parent().next('.show-hide-btn').length > 0){
                    element.closest('.form-group').parent().closest('.row').parent().next('.show-hide-btn').find('a').trigger('click');
                }else if(element.closest('.form-group').parent().parent().next('.show-hide-btn').length > 0){
                    element.closest('.form-group').parent().parent().next('.show-hide-btn').find('a').trigger('click');
                }else if(element.attr('data-attr') == 'a_shape_options'){
                    $('#modify_shape').find('.add_container-btn').trigger('click');
                }
            }
        // element.closest('.show-hide-btn').find('a').trigger('click');
        }
    }
}
function isArrayEmpty(arr) {
  // Check if it's an array
  if (Array.isArray(arr)) {
    // Check if every element in the array is null
    return arr.every(function(element) {
      return element === null;
    });
  } else {
    // If it's not an array, it's not considered empty
    return false;
  }
}
var checkJSON = function(m) {

   if (typeof m == 'object') {
      try{ m = JSON.stringify(m); }
      catch(err) { return false; } }

   if (typeof m == 'string') {
      try{ m = JSON.parse(m); }
      catch (err) { return false; } }

   if (typeof m != 'object') { return false; }
   return true;

};
function initAddons(flag){
    $.each(addons_data.item_category, function( index, value ) {
        if(index == 'custom_s_clip_on'){
            $.each(value.item_type, function( index2, value2 ) {
                if(index2 != ''){
                    $('#clip_on_type').append($('<option>', {
                        value: value2['label'],
                        actual_value: index2,
                        text : value2['label'],
                        price_500:value2['price_500'],
                        price_501:value2['price_501'],
                        price_600:value2['price_600'],
                        price_601:value2['price_601']
                    }));
                }
            });
        }
        if(index == 'repairs_s_&_s_services'){
            $.each(value.item_type, function( index2, value2 ) {
                if(index2 != ''){
                    $('select.repairs_services-list:first-child').append($('<option>', {
                        value: index2,
                        text : value2['label'],
                        price_500:value2['price_500'],
                        price_501:value2['price_501'],
                        price_600:value2['price_600'],
                        price_601:value2['price_601']
                    }));
                }
            });
        }
        // if(index == 'repairs_s_&_s_services'){
        //     $('select.repairs_services-list:first-child').append($('<option>', {
        //         value: index,
        //         text : value['label']
        //     }));
        // }
    });
}
function get_addons_data(){
    $.getJSON(rx_lens_addons_json+"?"+JSON.stringify(new Date()), function(data){
       addons_data = data;
       initAddons(1);
    });
}
var PrependZeros = function (str, len) {
    if(typeof str === 'number' || Number(str)){
        str = str.toString();
        return (len - str.length > 0) ? new Array(len + 1 - str.length).join('0') + str: str;
    }
    else{
        for(var i = 0,spl = str.split(' '); i < spl.length; spl[i] = (Number(spl[i])&& spl[i].length < len)?PrependZeros(spl[i],len):spl[i],str = (i == spl.length -1)?spl.join(' '):str,i++);
        return str;
    }
};
function validateFields(){
    $("#rx-order_form").validate({
        // debug: true,
        errorClass: 'is-invalid',
        validClass: '',
        // errorElement: 'span',
        highlight: function(element, errorClass, validClass) {
          $(element).addClass(errorClass);
          $(element).parent('.input-group').addClass(errorClass).removeClass(validClass);
          $(element).closest('.form-group').addClass(errorClass).removeClass(validClass);
          $(element).parent('.md-checkbox').addClass(errorClass).removeClass(validClass);
          $(element).parent('.btn-segment_choice').parent('.btn-group').addClass(errorClass).removeClass(validClass);
        },
        unhighlight: function(element, errorClass, validClass) {
          $(element).removeClass(errorClass);
          $(element).closest('.form-group').removeClass(errorClass).addClass(validClass);
          $(element).parent('.input-group').removeClass(errorClass).addClass(validClass);
          $(element).parent('.md-checkbox').removeClass(errorClass).addClass(validClass);
          $(element).parent('.btn-segment_choice').parent('.btn-group').removeClass(errorClass).addClass(validClass);
        },
        errorPlacement: function(error,element) {
            // if (element.prop("tagName").toLowerCase() !== 'input') return;
            // var parentGroup = element.closest('.form-group');
            // // Insert the error before that parent
            // error.insertAfter(parentGroup);
            return true;
        }
    });
}
function initLensOptions(selected){
    // Show loading indicator for better UX
    showSkeletonOnFields(selected);
    
    // Store form data preparation in a separate function to avoid blocking
    var formData = {};
    var formData2 = {};
    var formDataValues = {};
    formData2['_token'] = "<?= csrf_token() ?>";
    formData2['selected_index'] = '';
    let indexValue = 1;
    var isPackage = false;
    
    if(selected == 'package'){
        selected = '';
        isPackage = true;
        formData['packages'] =  $('#packageList').val();
        formData2['packages'] =  $('#packageList').val();
        formDataValues['packages'] =  $('#packageList').val();
    }
    
    if(!isPackage || isOrderEditMode){
        if(selected != ''){
            formData2['selected_index'] = $('#'+selected).attr('data-name');
            indexValue = parseInt($('#'+selected).attr('data-index'));
        }
        $.each($('.lens-data'), function( index, value ) {
            formData2[$(this).attr('data-name')] = '';
            formDataValues[$(this).attr('data-name')] = '';
            if(typeof $(this).find("option:selected").val() != 'undefined'){
                formDataValues[$(this).attr('data-name')] = $(this).find("option:selected").val();
                if(indexValue >= parseInt($(this).attr('data-index'))){
                    formData[$(this).attr('data-name')] = $(this).find("option:selected").val();
                    formData2[$(this).attr('data-name')] = $(this).find("option:selected").val();
                }
            }
        });
    }else{
        window.isLoaderStop = false;
    }
    
    if(isPackageOn()){
        formData['packages'] =  $('#packageList').val();
        formData2['packages'] =  $('#packageList').val();
        formDataValues['packages'] =  $('#packageList').val();
    }

    // Use setTimeout to make AJAX call asynchronous and non-blocking
    // setTimeout(function() {
        // Use AJAX to get filtered data from backend instead of client-side filtering
        $.ajax({
            url: filteredValidationUrl,
            type: "POST",
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            cache: true,
            timeout: 30000, // 30 seconds timeout to prevent hanging
            beforeSend: function() {
                // Ensure loading indicator is visible
                showSkeletonOnFields(selected);
            },
        success: function(response){
            if(response.status && response.data){
                let data = response.data;
                let price = data.price;
                let did = data.id;

                if(data.data_values && Object.keys(data.data_values).length > 0) {
                    if(data.data_values.pantoMax == 0 && data.data_values.pantoMin == 0){
                        data.data_values.pantoMax = '';
                        data.data_values.pantoMin = '';
                    }
                    if(data.data_values.vertexMax == 0 && data.data_values.vertexMin == 0){
                        data.data_values.vertexMax = '';
                        data.data_values.vertexMin = '';
                    }
                    if(data.data_values.wrapMax == 0 && data.data_values.wrapMin == 0){
                        data.data_values.wrapMax = '';
                        data.data_values.wrapMin = '';
                    }
                }

                $('.preview-large').html('');
                let selectedIndex = 0;
                if(selected != '') {
                    selectedIndex = parseInt($('#'+selected).attr('data-index')) || 0;
                }
                let allIndex = 0;
                $('#right_base_curve').empty();

                // Optimized data processing - cache DOM queries and reduce iterations
                const excludedKeys = ['price', 'id', 'packages', 'data_values', 'discount'];
                const dataKeys = Object.keys(data);

                // Process dropdown fields efficiently
                for (let i = 0; i < dataKeys.length; i++) {
                    const index = dataKeys[i];
                    // Skip invalid indices that could cause jQuery selector errors
                    if (!index || !/^[a-zA-Z][a-zA-Z0-9_-]*$/.test(index)) {
                        console.log('Skipping invalid index:', index);
                        continue;
                    }
        
                    // Skip non-dropdown properties
                    if (excludedKeys.includes(index)) {
                        continue;
                    }

                    const value = data[index];
                    const $element = $('#' + index);

                    // Early exit if element doesn't exist
                    if ($element.length === 0) continue;

                    const allIndex = parseInt($element.attr('data-index')) || 0;
                    const isEmpty = isNullOrEmpty($element.val()) || selectedIndex < allIndex;

                    // Handle right_base_curve specially
                    if (index === 'right_base_curve' && selected !== '') {
                        $element.empty();
                        const valueKeys = Object.keys(value);
                        for (let j = 0; j < valueKeys.length; j++) {
                            const index2 = valueKeys[j];
                            const value2 = value[index2];
                            const selectedOption = formData[index] === index2;

                            $element.append($('<option>', {
                                value: index2,
                                text: value2,
                                selected: selectedOption
                            }));
                        }
                        continue;
                    }

                    // Handle other fields
                    const shouldProcess = selected === '' || ((selectedIndex > allIndex && isNullOrEmpty($element.val())) || isEmpty);

                    if (shouldProcess) {
                        // Auto-select single option for index 1
                        if (selectedIndex > allIndex && isNullOrEmpty($element.val())) {
                            if (allIndex === 1 && Object.keys(value).length === 1) {
                                $element.val(Object.keys(value)[0]);
                                continue;
                            } else if (Object.keys(value).length === 1) {
                                formDataValues[index] = Object.keys(value)[0];
                            }
                        }

                        // Process different field types
                        if (index === 'lens_name' || index === 'coating_name') {
                            $element.empty();
                            const valueKeys = Object.keys(value);
                            for (let j = 0; j < valueKeys.length; j++) {
                                const index2 = valueKeys[j];
                                const value2 = value[index2];

                                $element.append($('<optgroup>', {
                                    label: decodeEntities(index2)
                                }));

                                const value2Keys = Object.keys(value2);
                                for (let k = 0; k < value2Keys.length; k++) {
                                    const index3 = value2Keys[k];
                                    const value3 = value2[index3];
                                    const selectedOption = formData[index] === index3;

                                    $element.find('optgroup').last().append($('<option>', {
                                        value: index3,
                                        text: decodeEntities(value3),
                                        selected: selectedOption
                                    }));
                                }
                            }
                        } else if (index === 'lens_filter') {
                            $element.empty();

                            // Sort the groups by their sort value
                            const sortedGroups = [];
                            const valueKeys = Object.keys(value);
                            for (let j = 0; j < valueKeys.length; j++) {
                                const groupKey = valueKeys[j];
                                const groupData = value[groupKey];
                                sortedGroups.push({
                                    key: groupKey,
                                    sort: groupData.sort || 0,
                                    options: groupData.options || {}
                                });
                            }

                            // Sort by the sort value
                            sortedGroups.sort((a, b) => a.sort - b.sort);

                            // Create optgroups in sorted order
                            for (let j = 0; j < sortedGroups.length; j++) {
                                const group = sortedGroups[j];

                                $element.append($('<optgroup>', {
                                    label: decodeEntities(group.key)
                                }));

                                const optionsKeys = Object.keys(group.options);
                                for (let k = 0; k < optionsKeys.length; k++) {
                                    const optionKey = optionsKeys[k];
                                    const optionValue = group.options[optionKey];
                                    const selectedOption = formData[index] === optionKey;

                                    $element.find('optgroup').last().append($('<option>', {
                                        value: optionKey,
                                        text: decodeEntities(optionValue),
                                        selected: selectedOption
                                    }));
                                }
                            }
                        } else if (index !== 'right_base_curve') {
                            $element.empty();
                            const valueKeys = Object.keys(value);
                            for (let j = 0; j < valueKeys.length; j++) {
                                const index2 = valueKeys[j];
                                const value2 = value[index2];
                                const selectedOption = formData[index] === index2;

                                $element.append($('<option>', {
                                    value: index2,
                                    text: decodeEntities(value2),
                                    selected: selectedOption
                                }));
                            }
                        }
                    }
                }
                $('#right_base_curve').trigger('change');
                
                rxFormData = data;
                if(selected != ''){
                    updateLensTypeDDL();
                    rxFormDataValues['price'] = price;
                    
                    // Handle field visibility logic after AJAX completes
                    handleFieldVisibilityLogic(selected);
                    // Use data_values from our new API instead of calling getDataValues()
                    if(data.data_values && Object.keys(data.data_values).length > 0) {
                        // console.log('Processing data_values with', Object.keys(data.data_values).length, 'keys');
                        // console.log('data_values keys:', Object.keys(data.data_values));
                        
                        // Process data_values in chunks to prevent freezing
                        // setTimeout(function() {
                            try {
                                rxFormDataValues = data.data_values;
                                rxFormDataValues['packages'] = data.packages;
                                
                                // Handle JSON parsing for sphExclude and sphNoCyl
                                let sphExclude = [];
                                if (!isNullOrEmpty(rxFormDataValues['sphExclude'])) {
                                    try {
                                        sphExclude = JSON.parse(rxFormDataValues['sphExclude']);
                                    } catch (e) {
                                        console.error('Invalid sphExclude JSON:', rxFormDataValues['sphExclude']);
                                    }
                                }

                                let sphNoCyl = [];
                                if (!isNullOrEmpty(rxFormDataValues['sphNoCyl'])) {
                                    try {
                                        sphNoCyl = JSON.parse(rxFormDataValues['sphNoCyl']);
                                    } catch (e) {
                                        console.error('Invalid sphNoCyl JSON:', rxFormDataValues['sphNoCyl']);
                                    }
                                }
                                rxFormDataValues['sphNoCyl'] = sphNoCyl;

                                // Process heavy operations in separate timeouts to prevent blocking
                                // setTimeout(function() {
                                    updateInputMinMax(data.data_values, selected);
                                // }, 10);
                                
                                // setTimeout(function() {
                                    updateInputDdl(data.data_values);
                                // }, 20);
                                
                                // setTimeout(function() {
                                    setLensTypeSummary();
                                    calculateMaxDia();
                                    checkPlanoLenses();
                                    updateAsterickAllFields();
                                // }, 30);
                                
                                // setTimeout(function() {
                                    if(isNullOrEmpty(rxFormDataValues.strength)){
                                        $('#right-strength').addClass('chide');
                                    }
                                    if(!$('.specify_thickness-content').hasClass('chide') && $('#specify_thickness').find('option').length > 0 && isNullOrEmpty($('#specify_thickness').val())){
                                        $('#specify_thickness').val('Normal').trigger('change');
                                    }
                                    if($('.oc').is(':visible') && (!isNullOrEmpty($('#right_oc').val()) || !isNullOrEmpty($('#left_oc').val()))){
                                        $('.oc').trigger('change');
                                    }
                                    $('#right_sph').trigger('change');
                                // }, 40);
                                
                            } catch (error) {
                                console.error('Error processing data_values:', error);
                                hideSkeletonOnFields();
                            }
                        // }, 10);
                    }
                }
                if(!isNullOrEmpty(data.packages)){
                    // Handle new package format: array of objects with name and price
                    if (Array.isArray(data.packages)) {
                        const packageList = data.packages.map(package => package.name);
                        syncPackages(packageList);
                    } else {
                        // Fallback for old format if needed
                        let explodedValues = [];
                        Object.values(data.packages).forEach(value => {
                            if (typeof value === 'string' && value) {
                                value.split('|').forEach(pair => {
                                    let parts = pair.split(':'); // Split by ':'
                                    if (parts.length > 1) {
                                        explodedValues.push(parts[1]); // Push only the second value
                                    }
                                });
                            }
                        });
                        const packageList = [...new Set(explodedValues)];
                        syncPackages(packageList);
                    }
                }
                showLensColor();
                showCoatingColorImage();
                syncFieldTabs();
                if(isFillFields){
                    fillData();
                }
                
                hideSkeletonOnFields();
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching filtered data:', error);
            console.error('Status:', status);
            console.error('XHR:', xhr);
            // Hide loading indicator on error
            hideSkeletonOnFields();
            // Handle field visibility logic even on error
            handleFieldVisibilityLogic(selected);
        },
        timeout: function() {
            console.error('AJAX request timed out');
            // Handle field visibility logic even on timeout
            hideSkeletonOnFields();
            handleFieldVisibilityLogic(selected);
        }
    });
    // }, 10); // Small delay to ensure UI remains responsive
}
function decodeEntities(encodedString) {
    if (!encodedString) return ""; // Handle null or undefined input
    const textarea = document.createElement('textarea');
    textarea.innerHTML = encodedString.replace(/_/g, ' '); // Replace _ with space before decoding
    return textarea.value;
}
function addNumberSign(value){
    if (/[+-]/.test(value)){
        return value;
    }
    let text = value;
    if(value > 0){
        text = '+'+value;
    }else if(value < 0){
        text = '-'+value;
    }else if(value == 0){
        text = '+'+value;
    }
    return text;
}

/**
 * Handle field visibility logic after lens data changes
 * This function manages showing/hiding fields based on selected lens options
 * Optimized for better performance
 */
function handleFieldVisibilityLogic(selected) {
    if(selected == '')
        return false;

    console.log('Handling field visibility logic');
    
    // Cache DOM queries and arrays for better performance
    const lensTypeArray = combinationHideArray.lens_type;
    const subTypeArray = combinationHideArray.sub_type;
    const lensDataSelects = $('select.lens-data');
    
    // Show all hidden fields for lens_type and sub_type
    showAllHiddenFields(lensTypeArray);
    showAllHiddenFields(subTypeArray);
    
    // Process each selected lens data field - optimized to avoid nested loops
    lensDataSelects.each(function() {
        const $select = $(this);
        const selectedValue = $select.val();
        const fieldType = $select.attr('data-attr');
        
        // Early exit if no value selected
        if (!selectedValue) return;
        
        // Determine which combination array to use based on field type
        let combinationsArray = null;
        switch(fieldType){
            case 'lens_type':
                combinationsArray = lensTypeArray;
                break;
            case 'sub_type':
                combinationsArray = subTypeArray;
                break;
            default:
                return; // Skip if not a relevant field type
        }
        
        // Apply field visibility rules if they exist for this value
        if (combinationsArray && typeof combinationsArray[selectedValue] !== 'undefined'){
            showHideFields(combinationsArray[selectedValue]);
        }
    });
    
    // Additional validation and processing
    validateCutOutLenses();
    setTimeout(function(){
        checkAdditionalCharges();
    }, 500);
}



function updateLensTypeDDL(){
    let lensTypeArray = [
        // 'lens_type',
        'sub_type',
        'lens_name',
        'lens_material',
        'lens_filter',
        'lens_colour',
        'coating_name',
        'coating_colour'
    ];
    let element = null;
    let selectValue = null;
    let conditions = {};
    let dataTemp = {};
    if(isPackageOn()){
        conditions['packages'] =  $('#packageList').val();
    }
    $.each(lensTypeArray, function( index, value ) {
        element = $('#'+value);
        selectValue = element.val();
        if(!isNullOrEmpty(selectValue)){
            conditions[value] = selectValue;
                            // Removed old filtering calls - now handled by backend
                            // Removed convertRxKeyValue call - no longer needed
            // console.log(conditions);
        }            
        let nextField = lensTypeArray[index+1];

        let element2 = $('#'+nextField);
        let selectValue2 = element2.val();
        if((nextField == 'lens_name' || nextField == 'coating_name') && typeof dataTemp[nextField] != 'undefined'){
            $('#'+nextField).empty();
            $.each(dataTemp[nextField], function( index2, value2 ) {
                $('#'+nextField).append($('<optgroup>', {
                    label : decodeEntities(index2)
                }));
                $.each(value2,function(index3, value3){
                    selectedOption = false;
                    if(selectValue2 == index3)
                        selectedOption = true;

                    $('#'+nextField).find('optgroup').last().append($('<option>', {
                        value: index3,
                        text : decodeEntities(value3),
                        selected: selectedOption
                    }));
                });
            });
        } else if(nextField == 'lens_filter' && typeof dataTemp[nextField] != 'undefined'){
            $('#'+nextField).empty();
            
            // Sort the groups by their sort value
            let sortedGroups = [];
            $.each(dataTemp[nextField], function(groupKey, groupData) {
                sortedGroups.push({
                    key: groupKey,
                    sort: groupData.sort || 0,
                    options: groupData.options || {}
                });
            });
            
            // Sort by the sort value
            sortedGroups.sort(function(a, b) {
                return a.sort - b.sort;
            });
            
            // Create optgroups in sorted order
            $.each(sortedGroups, function(i, group) {
                $('#'+nextField).append($('<optgroup>', {
                    label : decodeEntities(group.key)
                }));
                
                $.each(group.options, function(optionKey, optionValue){
                    selectedOption = false;
                    if(selectValue2 == optionKey)
                        selectedOption = true;

                    $('#'+nextField).find('optgroup').last().append($('<option>', {
                        value: optionKey,
                        text : decodeEntities(optionValue),
                        selected: selectedOption
                    }));
                });
            });
        }else if(dataTemp != null && typeof dataTemp[nextField] != 'undefined'){
            $('#'+nextField).empty();
            $.each(dataTemp[nextField], function( index2, value2 ) {
                selectedOption = false;
                if(selectValue2 == index2)
                    selectedOption = true;

                $('#'+nextField).append($('<option>', {
                    value: index2,
                    text : decodeEntities(value2) ,
                    selected: selectedOption
                }));
            });
        }
    });
}
// Removed getDataValues function - now handled by our new filtered API
function decodeRxValue(text){
    text = text.replaceAll('_s_',' ', text);
    text = text.replaceAll('_point_', '.', text);
    text = text.replaceAll('_',' ', text);
    text = text.replaceAll('plus','+', text);
    text = text.replaceAll('minus','-', text);
    text = text.replaceAll('inverted',"'", text);
    text = text.replaceAll('_',' ', text);
    text = text.replaceAll('_bsl_','\\', text);
    return text;
}
// Removed convertRxKeyValue function - no longer needed with backend filtering
// Removed getUniqueValuesForColumns function - no longer needed with backend filtering
// Removed client-side filtering functions - now handled by backend
function syncFieldTabs(){
    $('.form-control').each(function() {
        $(this).removeAttr('tabindex');
    });
    $('.form-control:visible').each(function() {
        $(this).attr('tabindex', '0');
    });
}
function isPlanoLenses(){
    if($('#lens_type').val() == 'Single_Vision_Finished' && $('#lens_filter').val() == 'Polarized_Plano'){
        return true;
    }
    return false;
}
function checkPlanoLenses(){
    if(rxFormDataValues.sphMax == 0 && rxFormDataValues.sphMin == 0){
        $.each(planoLenses, function( index, value ) {
            $('#'+value).val('').trigger('change');
            $('#'+value).attr("disabled", "disabled");
        });
    }else{
        $.each(planoLenses, function( index, value ) {
            $('#'+value).removeAttr("disabled", "disabled");
        });
    }
    if($('#lens_type').val() == 'Single_Vision_Finished' && !isNullOrEmpty($('#lens_filter').val()) && $('#lens_filter').val().toLowerCase().indexOf("plano") === -1){
        $('#base_curve-content').addClass('hide');
        $('.base_curve-content-col').css('visibility', 'hidden');
        $('#right_base_curve').empty();
        $('#right_base_curve').val('').trigger('change');
    }else{
        $('#base_curve-content').removeClass('hide');
        $('.base_curve-content-col').css('visibility', 'visible');
    }
}
function updatePriceContainer(price){
    let html = '<span class="price"><span class="sign">$</span><span class="currency">'+price+'</span><span class="cent">.00</span></span>';
    $('#generic_price_table .generic_price_tag').html('');
    $('#generic_price_table .generic_price_tag').html(html);
}
function updateCustomFields(corridorElement,valueFH){
    let checkFlag = false;
    if(!isNullOrEmpty(rxFormDataValues.corridorSh) && rxFormDataValues.corridorSh.length > 0){
        $.each(rxFormDataValues.corridorSh, function( index, value ) {
            if(parseFloat(valueFH) <= parseFloat(value) && !checkFlag){
                corridorElement.empty();
                corridorElement.append($('<option>', {
                    value: '',
                    text : ''
                }));
                let selected = false;
                $.each(rxFormDataValues.corridor, function( index2, value2 ) {
                    selected = false;
                    let text = value2;
                    if(rxFormDataValues.corridor[index] == value2){
                        text = value2+' (Default)';
                        if(corridorField == ''){
                            selected = true;
                            checkCorridor(text);
                        }
                        if(value2 == corridorField){
                            corridorField = text;
                        }
                        // selected = true;
                        // checkCorridor(text);
                    }
                    corridorElement.append($('<option>', {
                        value: text,
                        text : text,
                        selected: selected
                    }));
                });
                if(!isNullOrEmpty(corridorField) && jQuery.inArray(corridorField.replace(" (Default)", ""), rxFormDataValues.corridor) !== -1){
                    corridorElement.val(corridorField).trigger('change');
                }

                // corridorElement.val(rxFormDataValues.corridor[index]).trigger('change');
                checkFlag = true;
            }
        });
    }
}
function updateInputDdl(dataValues){
    $.each($('.crawl-ddl'), function( index, value ) {
        let element = $(this).find('select');
        if(!element.hasClass('filter-frame-info')){
            element.empty();
            element.append($('<option>', {
                value: '',
                text : ''
            }));
            let thisValue = element.attr('data-name');
            let values = dataValues[thisValue];
            if(typeof values != 'undefined' && values != '' && values.length > 0){
                $.each(values, function( index, value ) {
                    element.append($('<option>', {
                        value: value,
                        text : value
                    }));
                });
            }
        }
    });
}
function updateLensThicknessOnPackage(){
    $('#specify_thickness').val('Normal');
    $('#specify_thickness').removeClass('readonly-select2');
    $('#safety_stamp').prop('checked', false);
    $('#safety_stamp').parent().removeClass('readonly-container');
    if(isPackageOn() && $('#packageList').val() == 'Safety Package'){
        $('#specify_thickness').val('Industrial');
        $('#specify_thickness').addClass('readonly-select2');
        $('#safety_stamp').prop('checked', true);
        $('#safety_stamp').parent().addClass('readonly-container');
    }
    $('#specify_thickness').trigger('change');
}
function changePackage(){
    $('.total_price-container').find('#lab-supplies-price').remove();
    updateAdditionalHiddenInputPrices('frame','','');
    if ($('#package').is(":checked") && !isNullOrEmpty($('#packageList').val())) {
        // isPricesShow = false;

        // Reset all options
        $('input[name="data[frame][job_type]"]').parent().removeClass('active disabled');
        $('input[name="data[frame][job_type]"]').prop('checked', false);//.prop('disabled', true);

        // Enable and select "Lab Supplies Frame"
        const labSuppliesFrame = $('input[name="data[frame][job_type]"][value="lab_supplies_frame"]');
        labSuppliesFrame.prop('checked', true); // Only check the input
        labSuppliesFrame.parent().addClass('active'); // Manually add the 'active' class
        // labSuppliesFrame.parent().trigger('click'); // Trigger the click handler without scrolling
        // Add 'disabled' class to all others
        $('input[name="data[frame][job_type]"]:not([value="lab_supplies_frame"])').parent().addClass('disabled');
        
        //START Trigger conditions for Lab supplies frame
        validateCheckBoxes();
        checkBevelType();
        removeCondition(combinationHideArray.job_type);
        showHideFields(combinationHideArray.job_type['lab_supplies_frame']);
        toggleTags('brand',false);
        toggleTags('model',false);
        toggleTags('colour',false);
        toggleTags('size',false);
        //END
        // Trigger change for any listeners
        // $('input[name="data[frame][job_type]"]').parent().trigger('click');
    } else if($('#package').is(":checked")) {
        isPricesShow = true;

        // Enable all options
        // $('input[name="data[frame][job_type]"]').prop('checked', false).prop('disabled', false);
        $('input[name="data[frame][job_type]"]').parent().removeClass('disabled');
        toggleTags('brand',false);
        toggleTags('model',false);
        toggleTags('colour',false);
        toggleTags('size',false);
        $('#brand').trigger('change');
        // $('input[name="data[frame][job_type]"]').parent().trigger('change');
    }else{
        $('input[name="data[frame][job_type]"]').parent().removeClass('disabled');
        const labSuppliesFrame = $('input[name="data[frame][job_type]"][value="lab_supplies_frame"]');
        labSuppliesFrame.prop('checked', false);
        labSuppliesFrame.parent().removeClass('active');
        $('#frame_info').addClass('chide');
        const frameInfo = $('.btn-frame_type_choice.active');
        if(frameInfo.length > 0){
            frameInfo.find('input').prop('checked', false);
            frameInfo.removeClass('active');
        }
        $('#a').val(null).trigger('change');
        $('#b').val(null).trigger('change');
        $('#dbl').val(null).trigger('change');
        $('#ed').val(null).trigger('change');
        toggleTags('brand',true);
        toggleTags('model',true);
        toggleTags('colour',true);
        toggleTags('size',true);
        $('#brand').trigger('change');
    }
}
function toggleTags(id,enable) {
    let $select = $("#"+id);

    // Destroy Select2 before changing attribute
    $select.select2('destroy');

    if (enable) {
        $select.attr("data-tags", "true");
        $select.select2({
            tags: true,
            createTag: function (params) {
                let term = $.trim(params.term);
                if (term === '') return null;

                // Check if the tag already exists (case-insensitive)
                let exists = false;
                $select.find('option').each(function () {
                    if ($(this).text().toLowerCase() === term.toLowerCase()) {
                        exists = true;
                        return false; // Stop iteration
                    }
                });

                return exists ? null : { id: term, text: term };
            }
        });
    } else {
        $select.removeAttr("data-tags");
        $select.select2({ tags: false });
    }
}
function isPackageOn(){
    if($('#package').is(":checked")){
        return true;
    }
    return false;
}
function syncPackages(dataValues){
    let element = $('#packageList');
    if(isNullOrEmpty(element.val())){
        element.empty();
        element.append($('<option>', {
            value: '',
            text : ''
        }));
        if(typeof dataValues != 'undefined' && dataValues != '' && dataValues.length > 0){
            $.each(dataValues, function( index, value ) {
                element.append($('<option>', {
                    value: value,
                    text : value
                }));
            });
        }
    }
}
function updateInputMinMax(dataValues,selected){
    $.each($('.crawl-mx'), function( index, value ) {
        id = $(this).attr('data-name');
        keyValue = id+'Min';
        if(typeof dataValues[keyValue] !== 'undefined'){
            $(this).attr('min',dataValues[keyValue]);
        }
        keyValue = id+'Max';
        if(typeof dataValues[keyValue] !== 'undefined'){
            $(this).attr('max',dataValues[keyValue]);
        }
        keyValue = id+'Def';
        if(typeof dataValues[keyValue] !== 'undefined'){
            $(this).attr('data-def',dataValues[keyValue]);
            // $(this).addClass('edited');
        }
    });
    var min = null;
    var max = null;
    var def = null;
    let element = null;
    // dataValues['corridor'] = ["Short", "Medium", "Long"];
    // dataValues['corridorSh'] = ["14", "16", "18"];
    $.each($('.crawl-cs-ddl'), function( index, obj ) {
        min = null;
        max = null;
        def = null;
        element = $(this).find('select');
        id = element.attr('data-name');
        if(id != null){

            keyValue = id;
            if(typeof dataValues[keyValue] !== 'undefined' && jQuery.isArray(dataValues[keyValue])){
                addOptionValues(element,dataValues[keyValue]);
            }else{
                let idName = $(this).attr('id');
                if(id === 'cyl' &&
                    !isNullOrEmpty(dataValues['extSphMin']) &&
                    !isNullOrEmpty(dataValues['extSphMax']) &&
                    !(Number(dataValues['extSphMin']) === 0 && Number(dataValues['extSphMax']) === 0) &&
                    idName !== 'right-cyl-fr' &&
                    idName !== 'left-cyl-fr'){
                    let dir = getDirectionType(element);
                    let sphValue = $('#'+dir+'_sph').val();
                    let endPointMin = 'cylMin';
                    let endPointMax = 'cylMax';
                    if(!isNullOrEmpty(sphValue) && sphValue>= dataValues['extSphMin'] && sphValue <= dataValues['extSphMax']){
                        endPointMin = 'extCylMin';
                        endPointMax = 'cylMax';
                    }
                    if(typeof dataValues[endPointMin] !== 'undefined'){
                        min = dataValues[endPointMin];
                    }
                    if(typeof dataValues[endPointMax] !== 'undefined'){
                        max = dataValues[endPointMax];
                    }
                }else{
                    keyValue = id+'Min';
                    if(typeof dataValues[keyValue] !== 'undefined'){
                        min = dataValues[keyValue];
                    }
                    keyValue = id+'Max';
                    if(typeof dataValues[keyValue] !== 'undefined'){
                        max = dataValues[keyValue];
                    }
                 }
                //endtest
                keyValue = id+'Def';
                if(selected == '' && typeof dataValues[keyValue] !== 'undefined'){
                    // def = dataValues[keyValue];
                }
                // if(savedSelections.hasOwnProperty(element.attr('id'))){
                //     def = savedSelections[element.attr('id')];
                //     console.log(savedSelections[element.attr('id')]);
                // }
                if (element.val() != '')
                    def = element.val();

                let round = parseInt(element.attr('data-round'));
                let increment = parseFloat(element.attr('data-increment'));
                if($.isNumeric(min) && min != null && $.isNumeric(max) && max != null){
                    element.empty();
                    appendOptionValues(element,min,max,increment,round,def);
                }else if(element.attr('data-min') && element.attr('data-max')){
                    element.empty();
                    min = parseFloat(element.attr('data-min'));
                    max = parseFloat(element.attr('data-max'));
                    // step = parseFloat(element.attr('data-step'));
                    appendOptionValues(element,min,max,increment,round,def);
                }else{
                    element.empty();
                }
                showHideOptionField(element);

                let list = [
                    'a',
                    'b',
                    'ed',
                    'dbl'
                ];
                if($.inArray(element.attr('data-name'), list ) !== -1 && !isNullOrEmpty($('#size').val())){
                    setOrAppendSelect(element.attr('data-name'), def);
                }
            }
        }
    });
    $('#price').val(dataValues.price);
}
function showHideOptionField(element){
    if(element.attr('data-name') == 'panto' || element.attr('data-name') == 'wrap' || element.attr('data-name') == 'vertex'){
        if(element.find("option").length <= 1){
            element.closest('.crawl-cs-ddl').addClass('chide');
        }else{
            element.closest('.crawl-cs-ddl').removeClass('chide');
        }
    }
}
function addOptionValues(element,array){
    element.empty();
    element.append($('<option>', {
        value: '',
        text : ''
    }));
    $.each(array, function( index, value ) {
        element.append($('<option>', {
            value: value,
            text : value
        }));
    });
}
function appendOptionValues(element,min,max,step,round,def){
    let roundNo = 2;
    if(!isNaN(round))
        roundNo = round;
    let stepNo = 0.25;
    if(!isNaN(step))
        stepNo = step;

    let selected = true;
    if(def != null)
        selected = false;

    element.empty();
    element.append($('<option>', {
        value: '',
        text : '',
        selected: selected
    }));
    if(element.attr('data-name') == 'ed'){
        element.append($('<option>', {
            value: 'shape',
            text : 'Shape'
        }));
    }
    if(element.attr('data-name') == 'axis'){
        addOptionMinMax(min,max,element,stepNo,selected,roundNo,def);
    }else{
        addOptionMaxMin(min,max,element,stepNo,selected,roundNo,def);
    }

}
function addOptionMinMax(min,max,element,stepNo,selected,roundNo,def){
    let number = 0;
    let text = '';
    for (var i = min; i <= max; i+= stepNo) {
        number = parseFloat(i);
        text = '';
        if(element.attr('data-name') == 'axis'){
            text = addLeadingZeros(number.toFixed(0),3);
        }
        if(element.attr('data-name') == 'add'){
            text = '+'+number.toFixed(roundNo);
        }
        if(text == ''){
            text = number.toFixed(roundNo);
            if(text > 0){
                text = number.toFixed(roundNo);
                if(min < 0)
                    text = '+'+number.toFixed(roundNo);
            }else if(text == 0 && min < 0){
                text = '+'+number.toFixed(roundNo);
            }
        }
        selected = false;
        if(def == number)
            selected = true;

        element.append($('<option>', {
            value: number,
            text : text,
            selected: selected
        }));
    }
}
function addOptionMaxMin(min,max,element,stepNo,selected,roundNo,def){
    let number = 0;
    let text = '';
    for (var i = max; i >= min; i-= stepNo) {
        number = parseFloat(i);
        text = '';

        // Skip number if it's in sphExclude
        if (element.attr('data-name') === 'sph' && !isNullOrEmpty(rxFormDataValues['sphExclude']) && rxFormDataValues['sphExclude'].includes(number.toFixed(2))) {
            continue;
        }else if (element.attr('data-name') === 'add' && !isNullOrEmpty(rxFormDataValues['addExclude']) && rxFormDataValues['addExclude'] == number.toFixed(2)) {
            continue;
        }

        if(element.attr('data-name') == 'axis'){
            text = addLeadingZeros(number.toFixed(0),3);
        }
        if(element.attr('data-name') == 'add'){
            text = '+'+number.toFixed(roundNo);
        }
        if(text == ''){
            text = number.toFixed(roundNo);
            if(text > 0){
                text = number.toFixed(roundNo);
                if(min < 0)
                    text = '+'+number.toFixed(roundNo);
            }else if(text == 0 && min < 0){
                text = '+'+number.toFixed(roundNo);
            }
        }

        if((element.attr('data-name') == 'r_ct_or_et' || element.attr('data-name') == 'l_ct_or_et') && !isNullOrEmpty(number)){
            number = number.toFixed(roundNo);
        }

        selected = false;
        if(def == number)
            selected = true;

        element.append($('<option>', {
            value: number,
            text : text,
            selected: selected
        }));
    }
}
function addLeadingZeros(n,length)
{
    var str = (n > 0 ? n : -n) + "";
    var zeros = "";
    for (var i = length - str.length; i > 0; i--)
        zeros += "0";
    zeros += str;
    return n >= 0 ? zeros : "-" + zeros;
}
function showAllHiddenFields(data){
    $.each(data, function( index, value ) {
        $.each(value['hide'], function( index, value ) {
            $('#'+value).removeClass('chide');
            copy = value.split('-');
            if(copy.length > 1){
                $('#'+copy[1]+'_field-btn').removeClass('chide');
            }
        });
    });
}
function showHiddenFields(data){
    $.each(data['hide'], function( index, value ) {
        $('#'+value).removeClass('chide');
        copy = value.split('-');
        if(copy.length > 1){
            $('#'+copy[1]+'_field-btn').removeClass('chide');
        }
    });
}
function showHideFields(data){
    $.each(data['hide'], function(index, value) {
        $('#' + value).addClass('chide');
        if (typeof value === 'string' && value.includes('-')) {
            let copy = value.split('-');
            if (copy.length > 1) {
                $('#copy-' + copy[1]).addClass('chide');
                $('#' + copy[1] + '_field-btn').addClass('chide');
            }
        }
    });

    $.each(data['show'], function(index, value) {
        $('#' + value).removeClass('chide');
        if (typeof value === 'string' && value.includes('-')) {
            let copy = value.split('-');
            if (copy.length > 1) {
                $('#copy-' + copy[1]).removeClass('chide');
                $('#' + copy[1] + '_field-btn').removeClass('chide');
            }
        }
    });

    checkAndConditions();

    clearHiddenContainerFields();
}
function checkAndConditions(){
    $('#modify_shape').hide();
    let jobType = $("input[name='data[frame][job_type]']:checked").val();
    let frame_type = $("input[name='data[frame][frame_type]']:checked"). val();
    if(jobType == 'edged_frame_to_follow' && (frame_type == 'nyloon_groove' || frame_type == 'rimless_drill')){
        if(!isNullOrEmpty($('#a').val()) && !isNullOrEmpty($('#b').val())){
            $('#modify_shape').show();
        }
    }
}
function clearHiddenContainerFields(){
    let hideElement = $('.chide');
    // hideElement.find('select').val(null).trigger("change");
    hideElement.find('input[type="text"]').val('').trigger("change");
    hideElement.find('input:checkbox').prop('checked', false);
    $.each(hideElement.find('select').not('.filter-frame-info'), function(i, elem) {
        let attr = $(elem).attr('data-default');
        if(typeof attr !== 'undefined' && attr !== false){
            $(elem).val(attr).trigger("change");
        }else{
            $(elem).val(null).trigger("change");
        }
    });
}
function objLength(obj) {
    var L=0;
    $.each(obj, function(i, elem) {
        L++;
    });
    return L;
}
function removeCondition(data){
    if(objLength(data) > 0)
    {
        $.each(data, function(i, elem) {
            $.each(elem['hide'], function( index, value ) {
                $('#'+value).removeClass('chide');
                // copy = value.split('-');
                // if(copy.length > 1)
                    // $('#copy-'+copy[1]).removeClass('chide');
            });
            $.each(elem['show'], function( index, value ) {
                $('#'+value).addClass('chide');
            });
        });
    }
    // else{
    //  $('.chide').removeClass('chide');
    //  $('.initHide').addClass('chide');
    // }
}
function togglePrism(){
    validateFields();
    if(!$('#prism_container .prism-container').is(':visible')){
        $('#prism_container .show-hide-btn').toggle();
        $('#prism_container .prism-container').toggle();
        $('#prism_container .remove_prism-content').toggle();
        //$('#right_prism1').select2('open');
    }else{
        $('#prism_container .prism-container').find('select').val(null).trigger("change");
        setTimeout(function(){
            $('#prism_container .show-hide-btn').toggle();
            $('#prism_container .prism-container').toggle();
            $('#prism_container .remove_prism-content').toggle();
        }, 350);
    }
    syncFieldTabs();
}
function copyLeftToRight(element){
    var eId = element.attr('id');
    copy = eId.split('-');
    if(copy.length > 1){
        right = $('#right-'+copy[1]).find('input').val();
        if(right != '' && typeof right != 'undefined'){
            $('#left-'+copy[1]).find('input').val(right).trigger('change');
            $('#left-'+copy[1]).find('input').addClass('edited');
        }
        else{
            right = $('#right-'+copy[1]).find('select').val();
            if(right != ''){
                $('#left-'+copy[1]).find('select').val(right).trigger('change');
                $('#left-'+copy[1]).find('select').addClass('edited');
            }
        }
    }
}

//Start Prism functions
// Globals (place near your init code)
let prismBaseChanging = false;      // guard to avoid recursion when we programmatically change values
const prismMaster = {};             // map: side -> master element id (e.g. { right: "right_base2" })

function getSideAndPair(id){
  // expects id like "right_base1" or "left_base2"
  const parts = id.split('_'); // ["right","base1"]
  const side = parts[0];
  const pairName = (parts[1] === 'base1') ? 'base2' : 'base1';
  return { side, pairId: side + '_' + pairName };
}
function refreshSelect2($el) {
    // Force Select2 to rebuild its options list
    $el.trigger('change.select2');
    // Also refresh the data adapter (important when disabling/enabling options)
    $el.select2({
        minimumResultsForSearch: Infinity, // keep same config you use
        width: 'resolve'
    });
}
function enforcePairAgainstMaster($master, $pair){
    // enable all first
    $pair.find('option').prop('disabled', false).removeClass('fade-color');

    const val = $master.val();

    if (val === 'in' || val === 'out') {
        $pair.find("option[value='in'], option[value='out']")
             .prop('disabled', true).addClass('fade-color');

        if ($pair.val() === 'in' || $pair.val() === 'out' || !$pair.val()) {
            prismBaseChanging = true;
            $pair.val(null).trigger('change.select2');
            prismBaseChanging = false;
        }
        refreshSelect2($pair);   // 🔑 refresh UI always
        return;
    }

    if (val === 'up' || val === 'down') {
        $pair.find("option[value='up'], option[value='down']")
             .prop('disabled', true).addClass('fade-color');

        if ($pair.val() === 'up' || $pair.val() === 'down' || !$pair.val()) {
            prismBaseChanging = true;
            $pair.val(null).trigger('change.select2');
            prismBaseChanging = false;
        }
        refreshSelect2($pair);   // 🔑 refresh UI always
        return;
    }

    // master is empty / unknown -> fully enable pair
    $pair.find('option').prop('disabled', false).removeClass('fade-color');
    refreshSelect2($pair);   // 🔑 refresh UI always
}
//END Prism functions

function validateCheckBoxes(){
    //Specify Thickness
    var jobType = $("input[name='data[frame][job_type]']:checked").val();
    var specifyThickness = $("#specify_thickness").val();//$("input[name='data[frame][specify_thickness]']").is(":checked");
    if(specifyThickness){
        // $('label[for=specify_thickness]').find('.small-info').text('Surfaced Lenses Only');
        // $('#safety_thickness-container').removeClass('chide');
        // var safetyThickness = $("input[name='data[frame][safety_thickness]']").is(":checked");
        if(specifyThickness == 'Industrial' && jobType != 'uncut'){
            $('#safety_stamp-container').removeClass('chide');
        }else{
            $('#safety_stamp-container').addClass('chide');
        }
        // $('.ct_or_et-container').removeClass('chide');
        $('.ct_or_et-container input').addClass('required');
        $('.ct_or_et-container label').text('ET');
    }else{
        // $('#safety_stamp-container').addClass('chide');
        // $('#safety_thickness-container').addClass('chide');
        // $('.ct_or_et-container').addClass('chide');
        $('.ct_or_et-container input').removeClass('required');
        // $('label[for=specify_thickness]').find('.small-info').text('Lab will decide best thickness');
    }
}
function showSymbol(symbol, element) {
    len = 8;
    if (element.val() === '') {
        symbol.css('display','none');
    } else {
        len = element.val().length * 8;
        symbol.css('display','block');
    }
    symbol.css('left',len+'px');

    if(element.prev().hasClass('input-m-indicator')){
        elementNew = element.prev();
        elementNew.css('display','none');
        var val = parseFloat(element.val());
        if(val > 0){
            elementNew.css('display','');
        }
    }
}
function showCoatingColorImage(){
    var coating_name = $('#coating_name option:selected').text();
    var color = $('#coating_colour option:selected').text();
    // color = color.replace("%", "").toLowerCase();
    if(color != ''){
        color = $.trim(color);
        if(coating_name != ''){
            coating_name = $.trim(coating_name);
            color = coating_name+' '+color;
        }
        color = color.replaceAll("%", "");
        color = color.replaceAll(">", "-");
        color = color.replaceAll("<", "-");
        color = color.replace( /  +/g, ' ' );
        color = baseColorImgUrl+"/"+color;
        var imageExt = ['.svg','.jpg','.jpeg','.png'];
        let flag = false;
        let path = '';
        let cacheBuster = '?v=' + new Date().getTime();
        for (var i = 0; i < imageExt.length; i++) {
            if(flag === false){
                path = color + imageExt[i] + cacheBuster;
                isPathValid(path, function(isValid) {
                  if (isValid != null && flag == false) {
                    flag = true;
                    $('#coating_colour').parent().parent().siblings('.preview-large')
                                .html("<img src='"+isValid+"'' width='100px' />").show();
                  }
                });
            }else{
                return true;
            }
        }
    }
}
function isPathValid(path, callback) {
  $.ajax({
    url: path,
    type: 'HEAD',
    success: function() {
      callback(path); // Path is valid
    },
    error: function() {
      callback(null); // Path is not valid
    }
  });
}
function showLensColor(){
    var color = $('#lens_colour option:selected').text();
    // var lens_filter = $('#lens_filter option:selected').text();
    var selectedOption = $('#lens_filter option:selected');
    var lens_filter = selectedOption.text(); // Get selected option text
    var optgroupLabel = selectedOption.closest('optgroup').attr('label');

    $('#label-colour').text('Colour');
    if(optgroupLabel && optgroupLabel.toLowerCase().indexOf("specialty therapeutic") >= 0){
        $('#label-colour').text('Standard');
    }
    // color = color.replace("%", "").toLowerCase();
    if(color != ''){
        lens_filter = lens_filter.replaceAll(" + UV 400", "");
        // if(lens_filter.replace(/ .*/,'') == 'Transitions'){
        //     lens_filter = 'Transitions';
        // }
        var wordToReplace = 'Asph';
        var regex = new RegExp('\\b' + wordToReplace + '\\b(?![\\w\\s]*\\b' + wordToReplace + '\\b)', 'g');
        lens_filter = lens_filter.replace(regex, '');
        lens_filter = $.trim(lens_filter);
        color = $.trim(color);
        color = lens_filter+' '+color;
        color = color.replaceAll("%", "");
        color = color.replaceAll(">", "-");
        color = color.replaceAll("<", "-");
        color = color.replace( /  +/g, ' ' );
        color = baseColorImgUrl+"/"+color;
        var imageExt = ['.svg','.jpg','.jpeg','.png'];
        let flag = false;
        let path = '';
        let cacheBuster = '?v=' + new Date().getTime();
        for (var i = 0; i < imageExt.length; i++) {
            if(flag === false){
                path = color + imageExt[i] + cacheBuster;
                isPathValid(path, function(isValid) {
                  if (isValid != null && flag == false) {
                    flag = true;
                   $('#lens_colour').parent().parent().siblings('.preview-large').css("right", '7px')
                        .html("<img src='"+isValid+"'' />").show();
                  }
                });
            }else{
                return true;
            }
        }
    }
}
var warnMsg = new Array("Sphere powers are opposite signs.", "Right/Left eye cylinder power is positive", "Add powers are different for Right and Left eyes", "Seg Heights are different for Right and Left eyes");
var warnContainer = new Array("warningMsgSP", "warningMsgCY", "warningMsgAD", "warningMsgSG");
var warnCnt = "";
function getWarnMsg(elementId) {
    var wmsg = "";
    elementId = elementId.toUpperCase();
    if (elementId.indexOf("SPH") > -1)
    {
        wmsg = warnMsg[0];
    }
    if (elementId.indexOf("CYL") > -1)
    {
        wmsg = warnMsg[1];
    }
    if (elementId.indexOf("ADD") > -1)
    {
        wmsg = warnMsg[2];
    }
    if (elementId.indexOf("OC") > -1)
    {
        wmsg = warnMsg[3];
    }
    return wmsg;
}
function getWarnContainer(elementId) {
    elementId = elementId.toUpperCase();
    if (elementId.indexOf("SPH") > -1)
    {
        warnCnt = warnContainer[0];
    }
    if (elementId.indexOf("CYL") > -1)
    {
        warnCnt = warnContainer[1];
    }
    if (elementId.indexOf("ADD") > -1)
    {
        warnCnt = warnContainer[2];
    }
    if (elementId.indexOf("OC") > -1)
    {
        warnCnt = warnContainer[3];
    }
}
function checkDifferent(ele1, ele2) {
    warn1 = "";
    warnCnt = "";
    elmValue1 = document.getElementById(ele1).value;
    elmValue2 = document.getElementById(ele2).value;
    if ((elmValue1 != "") && (elmValue2 != "")) {
        if (elmValue1 != elmValue2) {
            warn1 = getWarnMsg(ele1);
        }
    }
    getWarnContainer(ele1);
    showWarnMessage(warn1);
}
function returnSign(elem)
{
    var rtSign = "";
    var vale = document.getElementById(elem).value;
    if (vale != "") {
        rtSign = "+";
        var issign = vale.charAt(0);
        if ((issign == "-") || (issign == "+"))
            rtSign = issign;
    }
    return rtSign;
}
function checkTheirSign(ele1, ele2, w2)
{
    warn1 = "";
    warnCnt = "";
    var eleSign1 = returnSign(ele1);
    if(w2 == 1 && document.getElementById(ele1).value == '0')
        eleSign1 = '-';

    var eleSign2 = returnSign(ele2);
    if(w2 == 1 && document.getElementById(ele2).value == '0')
        eleSign2 = '-';

    if (document.getElementById(ele2).value != "") {
        if ((eleSign1 != eleSign2) && (eleSign1 != "")) {
            warn1 = getWarnMsg(ele1);
        }
        if (w2 == 1)
        {
            if (eleSign2 == "+")
            {
                warn1 = getWarnMsg(ele1);
            }
        }
    } else
    {
        if ((w2 == 1) && (eleSign1 == "+")) {
            warn1 = getWarnMsg(ele1);
        }
    }
    if(w2 == 0 && (document.getElementById(ele2).value == '0' || document.getElementById(ele1).value == '0')){
        warn1 = '';
    }
    getWarnContainer(ele1);
    showWarnMessage(warn1);
}
function showWarnMessage(warn1) {
    //var wldMsg = document.getElementById('warningMsg');
    var wldMsg = document.getElementById(warnCnt);
    var wCont = document.getElementById('warningMsg');
    if (warn1 != "")
    {
        wldMsg.innerHTML = warn1;
        //wldMsg.className = "warnMessage";
        wCont.style.display = 'block';
        wCont.className = "alert alert-warning";
    } else
    {
        if(warnCnt != '')
            wldMsg.innerHTML = "";
        //wldMsg.className = "blankVld";
        var isw = 0;
        for (var w = 0; w < warnContainer.length; w++) {
            if (document.getElementById(warnContainer[w]).innerHTML != "") {
                isw = isw + 1;
            }
        }
        if (isw == 0) {
            // wCont.style.display = 'none';
            // wCont.className = "";
            showHideWarningContainer();
        }
    }
}
function checkBevelType(){
    var jobType = $("input[name='data[frame][job_type]']:checked").val();
    var frameType = $("input[name='data[frame][frame_type]']:checked").val();
    if(jobType != 'uncut'){
        if(frameType == 'full_metal' || frameType == 'full_plastic'){
            $('#bevel_type').removeClass('chide');
            $('#bevel_type-field').show();
            let text = 'Bevel Type: Normal';
            $('#bevel_type-field').text(text);
        }else{
           $('#bevel_type').addClass('chide'); 
           $('#bevel_type-field').hide();
        }
    }else{
        $('#bevel_type').addClass('chide');
        $('#bevel_type-field').hide();
    }
}
function rxFormResize(){
    let height = $('.rx-summary-container').height();
    var windowHeight = $(window).height() - 120;
    $('.col-rx-form-container').css('min-height',height+'px');  
    $('.col-rx-form-container').css('height',windowHeight+'px');   
}

function updateInvoiceOrderNo(isClear){
    if(!isClear){
        const $orderNoElement = $('#invoice_order_no_field');
        if(!isNullOrEmpty($orderNoElement.val())){
            const $selected = $orderNoElement.find('option:selected');
            setOrAppendSelect('a', $selected.attr('data-a'));
            setOrAppendSelect('b', $selected.attr('data-b'));
            setOrAppendSelect('ed', $selected.attr('data-ed'));
            setOrAppendSelect('dbl', $selected.attr('data-dbl'));
            $('input[name="data[frame][frame_type]"][value="'+$selected.attr('data-frame_type')+'"]').parent().trigger('click');

            if(!isNullOrEmpty($selected.attr('data-brand'))){
                $('#brand').val($selected.attr('data-brand')).trigger('change');
                preModel = $selected.attr('data-model');
                preColour = $selected.attr('data-colour');
                preSize = $selected.attr('data-size');
            }else{
                $('#a').val(null).trigger('change');
                $('#b').val(null).trigger('change');
                $('#dbl').val(null).trigger('change');
                $('#ed').val(null).trigger('change');
                $('#brand').val(null).trigger('change');
            }
        }
    }else{
        $('#invoice_order_no_field').val(null).trigger('change');
        $('#a').val(null).trigger('change');
        $('#b').val(null).trigger('change');
        $('#dbl').val(null).trigger('change');
        $('#ed').val(null).trigger('change');
        $('#brand').val(null).trigger('change');
        // let jobType = $('input[name="data[frame][job_type]"]:checked');
        // if(jobType){
        //     jobType.prop('checked', false);
        //     jobType.parent().removeClass('active');
        // }
    }
    
}

function check(src) {
  return $("<img>").attr('src', src);
}
function roundToNearestQuarter(number) {
    var rounded = Math.round(number * 4) / 4; // Round to the nearest 0.25
    return parseFloat(rounded.toFixed(2)); // Ensure two decimal places
}
function valueExistsInDropdown(element,value) {
    return element.find('option[value="' + value + '"]').length > 0;
}
// List of lens field IDs in order (add this near the top of your JS section)
const lensFieldOrder = [
  'lens_type',
  'sub_type',
  'lens_name',
  'lens_material',
  'lens_filter',
  'lens_colour',
  'coating_name',
  'coating_colour'
];

function showSkeletonOnFields(startField) {
  let showSkeleton = 0;
  lensFieldOrder.forEach(function(field) {
    const $field = $('#' + field);
    if ($field.length === 0) return;
    
    // Start showing skeletons from the selected field onwards
    if(startField == '' || startField == null){
        showSkeleton = 2;
    }else if (field === startField) {
      showSkeleton = 1;
    }
    
    if (showSkeleton == 2) {
      // Hide the field and show 3 skeleton loaders for all subsequent fields
      $field.addClass('lens-field-hidden');
      if ($field.next('.skeleton-loader').length === 0) {
        // Add 3 skeleton loaders
        $field.after('<div class="skeleton-loader"></div>');
        $field.after('<div class="skeleton-loader"></div>');
        $field.after('<div class="skeleton-loader"></div>');
      }
    } else {
      // Keep previous fields visible and remove any existing skeletons
      $field.removeClass('lens-field-hidden');
      $field.nextAll('.skeleton-loader').remove();
    }    
    if (showSkeleton == 1) {
        showSkeleton = 2;
    }
  });
}
function hideSkeletonOnFields() {
   lensFieldOrder.forEach(function(field) {
     const $field = $('#' + field);
     if ($field.length === 0) return;
     $field.removeClass('lens-field-hidden');
     $field.nextAll('.skeleton-loader').remove();
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.split', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/auth/orders/create/rx-lens-order.blade.php ENDPATH**/ ?>