<?php
$layoutMode = 'split';
$sections = $__env->getSections();
if (isset($sections['layout_mode'])) {
    $layoutMode = trim($sections['layout_mode']);
}
?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', app_name()); ?></title>
    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', 'Lens Shapers'); ?>">
    <meta name="author" content="<?php echo $__env->yieldContent('meta_author', 'Lens Shapers'); ?>">
    <?php echo $__env->yieldContent('meta'); ?>
    <?php echo $__env->yieldPushContent('before-styles'); ?>

    <link rel="shortcut icon" href="<?php echo e(asset('assets/img/favicon.ico')); ?>" />

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <?php if($layoutMode == 'split'): ?>
        <script src="https://js.pusher.com/4.1/pusher.min.js"></script>
        <script src="//cdn.ckeditor.com/4.22.1/full-all/ckeditor.js"></script>
        <script src="https://unpkg.com/@popperjs/core@2"></script>
        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
        <?php endif; ?>
   
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
   
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
   
        <?php echo $__env->yieldPushContent('after-styles'); ?>
    <script type="text/javascript">
        var baseUrl = "<?= url('') ?>";
    </script>
</head>
<body class="<?php if($layoutMode == 'app'): ?>page-header-fixed page-sidebar-closed-hide-logo page-content-white <?php else: ?> page-header-fixed page-sidebar-closed-hide-logo frontend <?php endif; ?>">
    <?php if($layoutMode == 'split'): ?>
        <div class="chatpageloader loader">
            <div class="lds-ring">
            </div>
        </div>
    <?php endif; ?>
    <?php echo $__env->make('includes.partials.messages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php if($layoutMode == 'app'): ?>
        <div class="page-wrapper">
            <?php echo $__env->make('frontend.includes.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <div class="page-container">
                <?php echo $__env->make('frontend.includes.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <div class="page-content-wrapper">
                    <div class="page-content">
                        <?php echo Breadcrumbs::render(); ?>

                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('frontend.auth.orders.includes.message-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('frontend.includes.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    <?php else: ?>
        <div class="wrapper split-wrapper">
            <header class="page-header custom-page-header split-header">
                <?php echo $__env->make('frontend.includes.split-header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </header>
            <div class="split-content">
                <div class="container-fluid p-0">
                    <div class="page-content">
                        <div class="breadcrumbs">
                            
                        </div>
                        <?php
                            $stickyMsg = auth()->user()->getCustomerAdmin()->getStickyMessage();
                        ?>
                        <?php if(!empty($stickyMsg)): ?>
                            <div class="col-12">
                                <div class="alert alert-danger" role="alert" style="    font-size: 25px;text-align: center;">
                                  <i class="fa fa-info-circle"></i> <?php echo e($stickyMsg); ?>

                                </div>
                            </div>
                        <?php endif; ?>
                        <?php echo $content ?? ''; ?><?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
            </div>
            <footer class="split-footer">
                <?php echo $__env->make('frontend.includes.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </footer>
            <?php echo $__env->make('frontend.auth.orders.includes.message-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    <?php endif; ?>

    <!-- Scripts -->
    <?php echo $__env->yieldPushContent('before-scripts'); ?>
    <?php if($layoutMode == 'app'): ?>
        <script type="text/javascript">
            var validateUrl = "<?= route('frontend.user.validate') ?>";
            var loginUrl = "<?= route('login') ?>";
            $(function() {
                $.ajax({
                    url: validateUrl,
                    type: "GET",
                    cache: false,
                    error: function (request, status, error) {
                        window.location.replace(loginUrl);
                    }
                });
            });
        </script>
    <?php else: ?>
        <script type="text/javascript"> let portalType = 'customer'; </script>
        <script type="text/javascript">
            var validateUrl = "<?= route('frontend.user.validate') ?>";
            var loginUrl = "<?= route('login') ?>";
            var userId = "<?= auth()->user()->id ?>";
            var isSuperAdmin = false;
            var notificationChannel = null;
            var PhoneLog = {
                TYPE_ORDER_CANCELLATION: 'order_cancellation',
                TYPE_REQUEST_CHANGE: 'request_change',
                TYPE_PHONE_LOG: 'phone_log',
                TYPE_NOTE: 'notes',
                TYPE_QUESTION: 'questions'
            };
            var pusher = new Pusher("<?php echo e(config('app.pusher.key')); ?>", {
                cluster: "<?php echo e(config('app.pusher.options.cluster')); ?>",
                encrypted: true
            });
            notificationChannel = pusher.subscribe("<?php echo e(Auth::user()->getChannelId()); ?>");
            window.isLoaderStop = true;
            window.isLoaderFStop = false;
            document.addEventListener('DOMContentLoaded', function() {
                $('.loader').hide();
                $.ajax({
                    url: validateUrl,
                    type: "GET",
                    cache: false,
                    error: function (request, status, error) {
                        window.location.replace(loginUrl);
                    }
                });
            });
        </script>
    <?php endif; ?>
    <?php echo $__env->yieldPushContent('after-scripts'); ?>
</body>
</html><?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/layouts/split.blade.php ENDPATH**/ ?>