<!DOCTYPE html>
<?php if (\Illuminate\Support\Facades\Blade::check('langrtl')): ?>
    <html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="rtl">
<?php else: ?>
    <html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<?php endif; ?>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <title><?php echo $__env->yieldContent('title', app_name()); ?></title>
        <meta name="description" content="<?php echo $__env->yieldContent('meta_description', 'Lens Shapers'); ?>">
        <meta name="author" content="<?php echo $__env->yieldContent('meta_author', 'Lens Shapers'); ?>">
        <?php echo $__env->yieldContent('meta'); ?>
        <?php echo $__env->yieldPushContent('before-styles'); ?>
        
        <?php echo $__env->yieldPushContent('after-styles'); ?>
    </head>
    <body class="login" style="background: url('<?php echo e(URL::asset('assets/pages/media/bg/3.jpg')); ?>') no-repeat center center fixed; background-size: cover;">
        <?php echo $__env->make('includes.partials.messages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <div class="logo">
            <a href="javascript:void(0);">
                <img src="<?php echo e(URL::asset('img/backend/brand/logo.png')); ?>" alt="" />
            </a>
        </div>
        <div class="content">
            <?php echo $__env->yieldContent('content'); ?>
        </div>

        <!-- Scripts -->
        <?php echo $__env->yieldPushContent('before-scripts'); ?>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
        <?php echo $__env->yieldPushContent('after-scripts'); ?>
    </body>
</html>
<?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/layouts/login.blade.php ENDPATH**/ ?>