<?php
    use App\Models\Backend\UserSettings;
    
    $userSettings = UserSettings::getSettings();
    ?>
<input type="hidden" name="data[rx][distance][right_sph_new]" id="right_sph_new" value="">
<input type="hidden" name="data[rx][distance][left_sph_new]" id="left_sph_new" value="">
<div class="form-body form-container rx-form-container">
    <h4 class="form-section bold m-0" style="margin-bottom:15px;">Patient Reference</h4>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <?php echo e(html()->text('first_name')
                    ->class('form-control required')
                    ->attribute('name', 'data[first_name]')
                    ->attribute('maxlength', 191)
                    ->autofocus()); ?>

                    <?php echo e(html()->label('First Name <span class="label-asterick">*</span>')->class('control-label')->for('data[first_name]')); ?>

                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <?php echo e(html()->text('last_name')
                    ->class('form-control required')
                    ->attribute('maxlength', 191)
                    ->attribute('name', 'data[last_name]')
                    ->autofocus()); ?>

                    <?php echo e(html()->label('Last Name <span class="label-asterick">*</span>')->class('control-label')->for('data[last_name]')); ?>

                </div>
            </div>
           
    </div>
    <div class="row">
            <div class="col-md-2">
                <div class="md-checkbox-list single-checkbox">
                    <div class="md-checkbox">
                        <input type="checkbox" id="is_multipair" class="md-check" name="data[is_multipair]" data-attr="is_multipair">
                        <label class="control-label" for="is_multipair">
                        <span></span>
                        <span class="check"></span>
                        <span class="box"></span> Multi-Pair </label>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group form-md-line-input form-md-floating-label multipair_ref-container" style="margin-top: 18px !important;display: none;">
                    <select class="form-control edited select2_fixed" data-placeholder="" name="data[multipair_ref]" id="multipair_ref" data-name="multipair_ref" data-allow-clear="true" data-tags="true">
                        <?php
                        $multiPlairList = auth()->user()->getMultiPlairList();
                        ?>
                        <?php if(!empty($multiPlairList)): ?>
                        <option></option>
                        <?php $__currentLoopData = $multiPlairList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <option value=""></option>
                        <?php endif; ?>
                    </select>
                    <label class="control-label" for="data[multipair_ref]">Enter Reference for first pair</label>
                </div>
            </div>
            <div class="col-md-2">
                <div class="md-checkbox-list single-checkbox">
                    <div class="md-checkbox">
                        <input type="checkbox" id="package" class="md-check" name="data[package]" data-attr="package">
                        <label class="control-label" for="package">
                        <span></span>
                        <span class="check"></span>
                        <span class="box"></span> Package </label>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group form-md-line-input form-md-floating-label package-container" style="margin-top: 18px !important;display: none;">
                    <select class="form-control edited select2_fixed" data-placeholder="" name="data[package]" id="packageList" data-name="packages" data-allow-clear="false" data-tags="false">
                        <option></option>
                    </select>
                    <label class="control-label" for="data[package]">Select Package</label>
                </div>
            </div>
    </div>
    <h4 class="form-section bold">Lens</h4>
    <div class="row shadow p-b-10 p-t-10 rx-section">
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][lens_type]">Lens Type</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="1" id="lens_type" name="data[lens][lens_type]" data-name="lens_type" size="5" data-attr="lens_type">
                            <!-- <?php $__currentLoopData = $combinationArray['lens_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>"><?php echo e($value['label']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> -->
                        </select>
                    </div>
                </div>
            </div>
            <!-- <div class="col-md-12 clearfix" style="padding-bottom: 9px;" id="aspheric">
                <div class="md-checkbox-list">
                    <div class="md-checkbox">
                        <input type="checkbox" id="lens_information" class="md-check" name="data[lens][aspheric]">
                        <label class="control-label" for="lens_information">
                            <span></span>
                            <span class="check"></span>
                            <span class="box"></span> <?php echo e($combinationArray['lens_information']['aspheric']['label']); ?> </label>
                    </div>
                </div>
                </div> -->
        </div>
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][sub_type]">Sub-Type</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="2" id="sub_type" data-name="sub_type" name="data[lens][sub_type]" size="5" data-attr="sub_type">
                            <?php $__currentLoopData = $combinationArray['lens_information']['sub_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <!-- <div class="col-md-4 mid-section lens-options" style="height: 222px;">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="lens_type">Lens Manufacturer</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                    <select class="form-control lens-data is-required" data-index="3" id="lens_manufacturer" data-name="lens_manufacturer" name="data[lens][lens_manufacturer]" size="5">
                        <?php $__currentLoopData = $combinationArray['lens_information']['lens_manufacturer']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    </div>
                </div>
            </div>
            </div>  -->
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][lens_name]">Lens Name</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="4" id="lens_name" data-name="lens_name" name="data[lens][lens_name]" size="5" data-attr="lens_name">
                            <?php $__currentLoopData = $combinationArray['lens_information']['lens_name']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <!-- <div class="col-md-4 mid-section lens-options" style="height: 170px;">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="lens_type">Base Curve</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                    <select class="form-control lens-data is-required" data-index="5" id="base_curve" data-name="base_curve" name="data[lens][base_curve]">
                        <?php $__currentLoopData = $combinationArray['lens_information']['base_curve']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    </div>
                </div>
            </div>
            </div>    -->
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][lens_material]">Material</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="6" id="lens_material" data-name="lens_material" name="data[lens][lens_material]" size="5" data-attr="lens_material">
                            <?php $__currentLoopData = $combinationArray['lens_information']['lens_material']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][lens_filter]">Filter</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="7" id="lens_filter" data-name="lens_filter" name="data[lens][lens_filter]" size="5" data-attr="lens_filter">
                            <?php $__currentLoopData = $combinationArray['lens_information']['lens_filter']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][lens_colour]" id="label-colour">Colour</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="8" id="lens_colour" data-name="lens_colour" name="data[lens][lens_colour]" size="5" data-attr="lens_colour">
                            <?php $__currentLoopData = $combinationArray['lens_information']['lens_colour']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="preview-large" style="top:initial !important;text-align:right;"></div>
            </div>
        </div>
        <!-- <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="lens_type">Coating Manufacturer</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                    <select class="form-control lens-data is-required" data-index="9" id="coating_made" data-name="coating_made" name="data[lens][coating_made]" size="5">
                        <?php $__currentLoopData = $combinationArray['lens_information']['coating_made']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    </div>
                </div>
            </div>
            </div>   -->
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][coating_name]">Coating</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="10" id="coating_name" data-name="coating_name" name="data[lens][coating_name]" size="5" data-attr="coating_name">
                            <?php $__currentLoopData = $combinationArray['lens_information']['coating_name']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][coating_colour]">Coating Colour</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="11" id="coating_colour" data-name="coating_colour" name="data[lens][coating_colour]" size="5" data-attr="coating_colour">
                            <?php $__currentLoopData = $combinationArray['lens_information']['coating_colour']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="preview-large coating-preview-color" style="top:initial !important;right: -110px;bottom: 10px;"></div>
            </div>
        </div>
    </div>
    <?php $__currentLoopData = $combinationArray['lens_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if(!empty($value['options'])): ?>
    <div class="row p-t-20 initHide chide rx-section" id="<?php echo e($key); ?>">
        <div class="col-md-12">
            <div class="clearfix">
                <div class="btn-group btn-group-circle lens_type lens_type_sv w-100" data-toggle="buttons">
                    <?php $__currentLoopData = $value['options']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 =>$value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="btn btn-secondary btn-segment_choice" style="width:<?= 100/count($value['options']) ?>%;" data-index="<?php echo e($key); ?>">
                        <input type="radio" class="toggle" name="data[lens][lens_type][<?php echo e($key); ?>]" value="<?php echo e($key2); ?>">
                        <div class="label-txt"><?php echo e($value2); ?> </div>
                    </label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <div class="row shadow p-b-10 p-t-10 rx-section">
        <div class="col-md-12 mid-section left_space">
            <h4 class="form-section bold title">Rx</h4>
        </div>
        <!-- Distance Start Section -->
        <div class="col-md-12 mid-section left_space">
            <!-- <h5>Distance</h5> -->
            <div class="row">
                <div class="labels-indicator">
                    <a href="javascript:void(0);" tabindex="-1">
                        <h3><span class="badge bg-primary ind-label">R</span></h3>
                    </a>
                </div>
                <?php $__currentLoopData = $combinationArray['rx']['distance']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($value['type'] == 'dropdown'): ?>
                <?php if($value['single']): ?>
                <div class="<?php echo e($value['class']); ?>" id="right-<?php echo e($key); ?>">
                    <div class="form-group form-md-line-input form-md-floating-label single-item">
                        <select class="form-control edited trigger-value select2_fixed single-field <?php echo e(isset($value['inputClass']) ? $value['inputClass'] : ''); ?>" data-placeholder="" data-trigger="r_sph,r_cyl" name="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]" id="right_<?php echo e($key); ?>" data-name="<?php echo e($value['data-name']); ?>" data-required_if="<?php echo e($value['required_if']); ?>" data-allow-clear="<?php echo e($value['allow-clear']); ?>">
                            <?php if(!empty($value['values'])): ?>
                            <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key2); ?>" <?= ($key2 == '50') ? 'selected' : '' ?>><?php echo e($value2); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <option value=""></option>
                            <?php endif; ?>
                        </select>
                        <label class="control-label" for="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                    </div>
                </div>
                <?php else: ?>
                <div class="<?php echo e($value['class']); ?>" id="right-<?php echo e($key); ?>">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <select class="form-control edited trigger-value select2_fixed <?php echo e(isset($value['inputClass']) ? $value['inputClass'] : ''); ?>" data-placeholder="" data-trigger="r_sph,r_cyl" name="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]" id="right_<?php echo e($key); ?>" data-name="<?php echo e($value['data-name']); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>" data-required_if="<?php echo e($value['required_if']); ?>" data-allow-clear="<?php echo e($value['allow-clear']); ?>">
                            <?php if(!empty($value['values'])): ?>
                            <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key2); ?>" <?= ($key2 == '50') ? 'selected' : '' ?>><?php echo e($value2); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <option value=""></option>
                            <?php endif; ?>
                        </select>
                        <label class="control-label" for="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                    </div>
                </div>
                <?php endif; ?>
                <?php elseif($value['type'] != 'label'): ?>
                <div class="<?php echo e($value['class']); ?>" id="right-<?php echo e($key); ?>">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <?php if(!empty($value['symbol'])): ?>
                        <span class="input-symbol" style="display:none;"><?php echo e($value['symbol']); ?></span>
                        <?php endif; ?>
                        <?php if($value['indicator']): ?>
                        <span class="input-m-indicator" style="display:none;"></span>
                        <?php endif; ?>
                        <input type="<?php echo e($value['type']); ?>" class="form-control crawl-mx numeric-value distance-input add-symbol" data-attr="r_<?php echo e($key); ?>" name="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]" data-name="<?php echo e($value['data-name']); ?>" step="<?php echo e($value['step']); ?>" id="right_<?php echo e($key); ?>" data-pad="<?php echo e($value['pad']); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>" data-required_if="<?php echo e($value['required_if']); ?>" data-allow-clear="<?php echo e($value['allow-clear']); ?>">
                        <label class="control-label" for="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                    </div>
                </div>
                <?php else: ?>
                <div class="<?php echo e($value['class']); ?>" id="right-<?php echo e($key); ?>">
                    <h4><span class="badge bg-warning">0</span></h4>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="row" style="height:28px;">
                <div class="labels-indicator labels-indicator-middle">
                    <!-- <a href="javascript:void(0);" class="copy-all-r-l" tabindex="-1">
                        <h4><span class="label label-danger ind-middle-label">OU</span></h4>
                        </a> -->
                </div>
                <?php $count = 0; ?>
                <?php $__currentLoopData = $combinationArray['rx']['distance']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($value['type'] != 'label'): ?>
                <?php if(!$value['single']): ?>
                <div class="<?php echo e($value['class']); ?> text-center copy-distance" id="copy-<?php echo e($key); ?>">
                    <a href="javascript:void(0);" tabindex="-1">
                    <i
                        class="fa fa-arrow-down"></i>
                    </a>
                </div>
                <?php else: ?>
                <div class="<?php echo e($value['class']); ?> text-center copy-distance v-hidden"></div>
                <?php endif; ?>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="row">
                <div class="labels-indicator">
                    <a href="javascript:void(0);" tabindex="-1">
                        <h3><span class="badge bg-primary ind-label">L</span></h3>
                    </a>
                </div>
                <!-- <div class="col-md-2">
                    <h3><span class="label label-info ind-label">L</span></h3>
                    </div> -->
                <?php $__currentLoopData = $combinationArray['rx']['distance']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($value['type'] == 'dropdown'): ?>
                <?php if(!$value['single']): ?>
                <div class="<?php echo e($value['class']); ?>" id="left-<?php echo e($key); ?>">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <select class="form-control edited trigger-value select2_fixed <?php echo e(isset($value['inputClass']) ? $value['inputClass'] : ''); ?>" data-placeholder="" data-trigger="r_sph,r_cyl" name="<?php echo e($value['name_base']); ?>[left_<?php echo e($key); ?>]" id="left_<?php echo e($key); ?>" data-name="<?php echo e($value['data-name']); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>" data-required_if="<?php echo e($value['required_if']); ?>" data-allow-clear="<?php echo e($value['allow-clear']); ?>">
                            <!-- <option value=""></option> -->
                            <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key2); ?>" <?= ($key2 == '50') ? 'selected' : '' ?>><?php echo e($value2); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <label class="control-label" for="<?php echo e($value['name_base']); ?>[left_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                    </div>
                </div>
                <?php else: ?>
                <div class="<?php echo e($value['class']); ?>" id="left-<?php echo e($key); ?>"></div>
                <?php endif; ?>
                <?php elseif($value['type'] != 'label'): ?>
                <div class="<?php echo e($value['class']); ?>" id="left-<?php echo e($key); ?>">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <?php if(!empty($value['symbol'])): ?>
                        <span class="input-symbol" style="display:none"><?php echo e($value['symbol']); ?></span>
                        <?php endif; ?>
                        <?php if($value['indicator']): ?>
                        <span class="input-m-indicator" style="display:none;"></span>
                        <?php endif; ?>
                        <input type="<?php echo e($value['type']); ?>" class="form-control crawl-mx numeric-value distance-input add-symbol" data-attr="l_<?php echo e($key); ?>" data-name="<?php echo e($value['data-name']); ?>" name="<?php echo e($value['name_base']); ?>[left_<?php echo e($key); ?>]" step="<?php echo e($value['step']); ?>" id="left_<?php echo e($key); ?>" data-pad="<?php echo e($value['pad']); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>" data-required_if="<?php echo e($value['required_if']); ?>" data-allow-clear="<?php echo e($value['allow-clear']); ?>">
                        <label class="control-label" for="<?php echo e($value['name_base']); ?>[left_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                    </div>
                </div>
                <?php else: ?>
                <div class="<?php echo e($value['class']); ?>" id="left-<?php echo e($key); ?>">
                    <h4><span class="badge bg-warning">0</span></h4>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <!-- Distance END Section -->
        <!-- Extended info Section -->
        <div class="col-md-12 mid-section left_space rx-container-default_height">
            <!-- <div class="row">
                <div class="col-md-8 no-padding">
                        <h5>Extended Info</h5>
                </div>
                </div> -->
            <div class="extended-info-container" id="extended-info_module">
                <div class="row" id="right-extended-info-row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">R</span></h3>
                        </a>
                    </div>
                    <?php $__currentLoopData = $combinationArray['rx']['extended_info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($value['type'] == 'dropdown'): ?>
                    <?php if(isset($value['button']) && $value['button']): ?>
                    <div class="col-sm p-2 show_hide-container" style="max-width:15%;" id="<?php echo e($value['button-class']); ?>_field-btn">
                        <a href="javascript:;" class="btn btn-info btn-circle show_hide-abtn single-item" data-element="<?php echo e($value['button-class']); ?>_field-container" tabindex="0" style="right: 0%;top: 56px;"><i class="fa fa-plus"></i> <?php echo e($value['button-label']); ?></a>
                    </div>
                    <?php endif; ?>
                    <?php if($value['single']): ?>
                    <div class="<?php echo e($value['class']); ?>" id="right-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label single-item">
                            <select class="form-control <?php echo e($key); ?> <?php echo e($value['ddl_class']); ?> edited single-field" data-placeholder="" name="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]" data-name="<?php echo e($value['data-name']); ?>" data-attr="r_<?php echo e($key); ?>" id="right_<?php echo e($key); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key2); ?>">
                                    <?php echo e($value2); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <label class="control-label" for="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="<?php echo e($value['class']); ?>" id="right-<?php echo e($key); ?>" style="display: <?php echo e(isset($value['button']) && $value['button'] ? 'none' : ''); ?>">
                        <?php if(isset($value['button']) && $value['button']): ?>
                        <div class="text-right showhide-container-btn" style="padding: 0px;">
                            <a href="javascript:void(0);" class="" data-attr="<?php echo e($value['button-class']); ?>_field" title="Hide" tabindex="0"><i class="fa fa-remove color-red"></i></a>
                        </div>
                        <?php endif; ?>
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control <?php echo e($key); ?> <?php echo e($value['ddl_class']); ?> edited" data-placeholder="" name="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]" data-name="<?php echo e($value['data-name']); ?>" data-attr="r_<?php echo e($key); ?>" id="right_<?php echo e($key); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>" data-allow-clear="<?php echo e($value['allow-clear']); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key2); ?>">
                                    <?php echo e($value2); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <label class="control-label" for="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php else: ?>
                    <div class="col-sm <?= (!$value['display']) ? 'hide_'.$key.' hide' : '' ?>" id="right-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <?php if(!empty($value['symbol'])): ?>
                            <span class="input-symbol" style="display:none"><?php echo e($value['symbol']); ?></span>
                            <?php endif; ?>
                            <input type="<?php echo e($value['type']); ?>" class="form-control crawl-mx numeric-value add-symbol <?php echo e($key); ?>" data-attr="r_<?php echo e($key); ?>" data-name="<?php echo e($value['data-name']); ?>" name="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]" data-pad="<?php echo e($value['pad']); ?>" step="<?php echo e($value['step']); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>" id="right_<?php echo e($key); ?>">
                            <label class="control-label" for="<?php echo e($value['name_base']); ?>[right_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="row">
                    <div class="labels-indicator labels-indicator-middle">
                        <!-- <a href="javascript:void(0);" class="copy-all-r-l" tabindex="-1">
                            <h4><span class="label label-danger ind-middle-label">OU</span></h4>
                            </a> -->
                    </div>
                    <?php $__currentLoopData = $combinationArray['rx']['extended_info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(!$value['single']): ?>
                    <div class="col-sm text-center copy-distance <?= (!$value['display']) ? 'hide_'.$key.' hide' : '' ?>" id="copy-<?php echo e($key); ?>">
                        <a href="javascript:void(0);" tabindex="-1">
                        <i
                            class="fa fa-arrow-down"></i>
                        </a>
                    </div>
                    <?php else: ?>
                    <div class="<?php echo e($value['class']); ?> text-center copy-distance v-hidden"></div>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="row" id="left-extended-info-row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">L</span></h3>
                        </a>
                    </div>
                    <?php $__currentLoopData = $combinationArray['rx']['extended_info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($value['type'] == 'dropdown'): ?>
                    <?php if(!$value['single']): ?>
                    <div class="<?php echo e($value['class']); ?>" id="left-<?php echo e($key); ?>" style="display: <?php echo e(isset($value['button']) && $value['button'] ? 'none' : ''); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control <?php echo e($key); ?> <?php echo e($value['ddl_class']); ?> edited" data-placeholder="" name="<?php echo e($value['name_base']); ?>[left_<?php echo e($key); ?>]" data-name="<?php echo e($value['data-name']); ?>" id="left_<?php echo e($key); ?>" data-attr="l_<?php echo e($key); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>" data-allow-clear="<?php echo e($value['allow-clear']); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key2); ?>">
                                    <?php echo e($value2); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <label class="control-label" for="<?php echo e($value['name_base']); ?>[left_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="<?php echo e($value['class']); ?>" id="left-<?php echo e($key); ?>"></div>
                    <?php endif; ?>
                    <?php else: ?>
                    <div class="col-sm<?= (!$value['display']) ? 'hide_'.$key.' hide' : '' ?>" id="left-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <?php if(!empty($value['symbol'])): ?>
                            <span class="input-symbol" style="display:none"><?php echo e($value['symbol']); ?></span>
                            <?php endif; ?>
                            <span class="input-m-indicator" style="display:none;"></span>
                            <input type="<?php echo e($value['type']); ?>" class="form-control crawl-mx numeric-value add-symbol <?php echo e($key); ?>" data-attr="l_<?php echo e($key); ?>" name="<?php echo e($value['name_base']); ?>[left_<?php echo e($key); ?>]" data-pad="<?php echo e($value['pad']); ?>" step="<?php echo e($value['step']); ?>" id="left_<?php echo e($key); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>" data-name="<?php echo e($value['data-name']); ?>">
                            <label class="control-label" for="<?php echo e($value['name_base']); ?>[left_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <!-- Prism Start Section -->
        <div class="col-md-12 mid-section left_space" id="prism_container" style="position: relative;">
            <div class="row cancel-button">
                <!-- <div class="col-md-8 no-padding">
                    <h5>Prism</h5>
                    </div> -->
                <div class="col-md-12 text-right remove_prism-content" style="display: none;padding: 0;">
                    <a href="javascript:void(0);" id="remove_prism-link" title="Remove Prism" tabindex="-1"><i class="fa fa-remove color-red"></i></a>
                </div>
            </div>
            <div class="prism-container" style="display: none;">
                <div class="row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">R: Prism</span></h3>
                        </a>
                    </div>
                    <div class="col-md-2 col-6"></div>
                    <?php $__currentLoopData = $combinationArray['rx']['prism']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($value['type'] == 'dropdown'): ?>
                    <div class="col-md-2 col-6 prism-list p-2 <?php echo e($value['class']); ?>" id="right-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control prism_base select2_fixed edited <?php echo e(isset($value['inputClass']) ? $value['inputClass'] : ''); ?>" data-placeholder="" name="data[rx][prism][right_<?php echo e($key); ?>]" id="right_<?php echo e($key); ?>" data-attr="r_<?php echo e($key); ?>" data-name="<?php echo e($value['data-name']); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>" data-empty-check="<?php echo e($value['empty_check']); ?>" data-required_if="<?php echo e($value['required_if']); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key2); ?>"><?php echo e($value2); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <label class="control-label" for="data[rx][prism][right_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="col-md-2 col-6 prism-list" id="right-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <?php if(!empty($value['symbol'])): ?>
                            <span class="input-symbol" style="display:none"><?php echo e($value['symbol']); ?></span>
                            <?php endif; ?>
                            <span class="input-m-indicator" style="display:none;"></span>
                            <input type="<?php echo e($value['type']); ?>" class="form-control crawl-mx numeric-value add-symbol" data-attr="r_<?php echo e($key); ?>" data-name="<?php echo e($key); ?>" name="data[rx][prism][right_<?php echo e($key); ?>]" data-pad="<?php echo e($value['pad']); ?>" step="<?php echo e($value['step']); ?>" id="right_<?php echo e($key); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>">
                            <label class="control-label" for="data[rx][prism][right_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="row">
                    <div class="labels-indicator labels-indicator-middle">
                        <!-- <a href="javascript:void(0);" class="copy-all-r-l" tabindex="-1">
                            <h4><span class="label label-danger ind-middle-label">OU</span></h4>
                            </a> -->
                    </div>
                    <div class="col-md-2 col-6 text-center copy-distance"></div>
                    <?php $__currentLoopData = $combinationArray['rx']['prism']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-2 col-6 text-center copy-distance" id="copy-<?php echo e($key); ?>">
                        <a href="javascript:void(0);" tabindex="-1">
                        <i
                            class="fa fa-arrow-down"></i>
                        </a>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">L: Prism</span></h3>
                        </a>
                    </div>
                    <div class="col-md-2 col-6"></div>
                    <?php $__currentLoopData = $combinationArray['rx']['prism']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($value['type'] == 'dropdown'): ?>
                    <div class="col-md-2 col-6 prism-list p-2 <?php echo e($value['class']); ?>" id="left-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control prism_base select2_fixed edited <?php echo e(isset($value['inputClass']) ? $value['inputClass'] : ''); ?>" data-placeholder="" name="data[rx][prism][left_<?php echo e($key); ?>]" id="left_<?php echo e($key); ?>" data-attr="l_<?php echo e($key); ?>" data-name="<?php echo e($value['data-name']); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>" data-empty-check="<?php echo e($value['empty_check']); ?>" data-required_if="<?php echo e($value['required_if']); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key2); ?>"><?php echo e($value2); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <label class="control-label" for="data[rx][prism][left_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="col-md-2 col-6 prism-list" id="left-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <?php if(!empty($value['symbol'])): ?>
                            <span class="input-symbol" style="display:none"><?php echo e($value['symbol']); ?></span>
                            <?php endif; ?>
                            <span class="input-m-indicator" style="display:none;"></span>
                            <input type="<?php echo e($value['type']); ?>" class="form-control crawl-mx numeric-value add-symbol" data-attr="l_<?php echo e($key); ?>" data-name="<?php echo e($key); ?>" name="data[rx][prism][left_<?php echo e($key); ?>]" data-pad="<?php echo e($value['pad']); ?>" step="<?php echo e($value['step']); ?>" id="left_<?php echo e($key); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>">
                            <label class="control-label" for="data[rx][prism][left_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="show-hide-btn">
                <a href="javascript:;" class="btn btn-info btn-circle" id="add_prism-btn" tabindex="0"><i class="fa fa-plus"></i> Add Prism</a>
            </div>
        </div>
        <!-- Prism End Section -->
        <div class="col-md-6 mid-section left_space chide" id="final_rx" style="height: 188px">
            <div class="row">
                <div class="col-md-8 no-padding">
                    <h5>Final Rx</h5>
                </div>
            </div>
            <div class="extended-info-container">
                <div class="row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">R</span></h3>
                        </a>
                    </div>
                    <?php $__currentLoopData = $combinationArray['rx']['final_rx']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="<?php echo e($value['class']); ?>" id="right-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <?php if(!empty($value['symbol'])): ?>
                            <span class="input-symbol" style="display:none"><?php echo e($value['symbol']); ?></span>
                            <?php endif; ?>
                            <input type="text" class="form-control crawl-mx numeric-value add-symbol" id="right-<?php echo e($key); ?>-fr" data-name="<?php echo e($key); ?>" name="data[rx][final_rx][right_<?php echo e($key); ?>]" data-pad="<?php echo e($value['pad']); ?>" readonly>
                            <label class="control-label" for="data[rx][final_rx][right_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">L</span></h3>
                        </a>
                    </div>
                    <?php $__currentLoopData = $combinationArray['rx']['final_rx']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="<?php echo e($value['class']); ?>" id="left-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <?php if(!empty($value['symbol'])): ?>
                            <span class="input-symbol" style="display:none"><?php echo e($value['symbol']); ?></span>
                            <?php endif; ?>
                            <input type="text" class="form-control crawl-mx numeric-value add-symbol" name="data[rx][final_rx][left_<?php echo e($key); ?>]" id="left-<?php echo e($key); ?>-fr" data-pad="<?php echo e($value['pad']); ?>" readonly>
                            <label class="control-label" for="data[rx][final_rx][left_<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <!-- Distance End Section -->
        <div class="col-md-12 p-0">
            <!-- Shorter Corridor Section -->
            <!-- div class="col-md-3" id="use_shorter_corridor">
                <div class="row">
                    <div class="col-md-8 no-padding">
                        <h5></h5>
                    </div>
                </div>
                <div class="reading-container">
                    <div class="row">
                        <div class="col-md-12 input-group  shorter-coridor_padding">
                            <div class="col-md-12">
                                 <div class="md-checkbox-list single-checkbox">
                                    <div class="md-checkbox">
                                        <input type="checkbox" class="md-check" name="data[rx][use_shorter_corridor]" id="use_shorter_corridor1">
                                        <label class="control-label" for="use_shorter_corridor1">
                                            <span></span>
                                            <span class="check"></span>
                                            <span class="box"></span> <?php echo e($combinationArray['rx']['use_shorter_corridor']['label']); ?> </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                </div> -->
            <!-- Distance End Section -->
            <!-- Special Info info Section -->
            <div class="col-md-12 mid-section" id="special_info">
                <!-- <div class="row">
                    <div class="col-md-8 no-padding">
                        <h5>Special Info</h5>
                    </div>
                    </div> -->
                <div class="extended-info-container">
                    <div class="row">
                        <?php $__currentLoopData = $combinationArray['rx']['special_info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($value['type'] == 'dropdown'): ?>
                        <div class="col-md-4 col-4 p-2 crawl-cs-ddl chide" id="<?php echo e($key); ?>">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control prism_base select2_fixed edited <?php echo e(isset($value['inputClass']) ? $value['inputClass'] : ''); ?>" data-placeholder="" name="data[rx][special_info][<?php echo e($key); ?>]" id="<?php echo e($key); ?>" data-attr="<?php echo e($key); ?>" data-name="<?php echo e($value['data-name']); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>">
                                    <option value=""></option>
                                    <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key2); ?>"><?php echo e($value2); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <label class="control-label" for="data[rx][special_info][<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="col-md-4" id="<?php echo e($key); ?>">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <?php if(!empty($value['symbol'])): ?>
                                <span class="input-symbol" style="display:none"><?php echo e($value['symbol']); ?></span>
                                <?php endif; ?>
                                <!-- <span class="input-m-indicator" style="display:none;"></span> -->
                                <input type="<?php echo e($value['type']); ?>" class="form-control crawl-mx numeric-value distance-input add-symbol edited" data-attr="<?php echo e($key); ?>" name="data[rx][special_info][<?php echo e($key); ?>]" data-pad="<?php echo e($value['pad']); ?>" max="<?php echo e($value['max']); ?>" min="<?php echo e($value['min']); ?>" data-name="<?php echo e($value['data-name']); ?>" id="<?php echo e($key); ?>">
                                <label class="control-label" for="data[rx][special_info][<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <!-- SPecial Info End Section -->
        </div>
    </div>
    <div class="row shadow p-b-10 p-t-10 rx-section frame-section">
        <div class="col-md-12 mid-section left_space">
            <h4 class="form-section bold title">Frame</h4>
        </div>
        <div class="col-md-12 mid-section">
            <div class="row">
                <div class="col-md-12 no-padding mt-1">
                    <label class="control-label" for="data[frame][job_type]">Job Type <span class="label-asterick job_type-test">*</span></label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100 job_type_group" data-toggle="buttons">
                    <?php $__currentLoopData = $combinationArray['frame']['job_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="btn btn-secondary btn-segment_choice btn-frame_job_type_choice" data-index="job_type">
                        <input type="radio" class="toggle is-required" name="data[frame][job_type]" value="<?php echo e($key); ?>" data-text="<?php echo $value['label']; ?>">
                        <div class="label-txt"><?php echo $value['label']; ?> </div>
                    </label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="col-md-8 col-md-offset-2 chide clearfix p-b-10 mt-5" id="invoice_order_no">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <!-- <input type="text" class="form-control is-required" name="data[frame][invoice_order_no]" id="invoice_order_no_field" data-attr="invoice_order_no">
                        <label class="control-label" for="data[frame][invoice_order_no]"><?php echo e($combinationArray['frame']['invoice_order_no']['label']); ?></label> -->
                    <select class="form-control invoice_order_no select2_apply edited" data-placeholder="" name="data[frame][invoice_order_no]" data-name="invoice_order_no" id="invoice_order_no_field" data-attr="invoice_order_no" data-allow-clear="false" data-tags="true">
                        <option value=""></option>
                        <?php $__currentLoopData = $logged_in_user->getOrdersData(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $orderData = $value->rxOrderModel->getShowData();
                        ?>
                        <option value="<?php echo e($value->getOrderNumber().', '.$value->invoice_no.', '.$value->patient); ?>" data-frame_type="<?php echo e($orderData['frame']['o_frame_type']); ?>" data-a="<?php echo e($orderData['frame']['frame_size']['values'][0]); ?>" data-b="<?php echo e($orderData['frame']['frame_size']['values'][1]); ?>" data-ed="<?php echo e($orderData['frame']['frame_size']['values'][2]); ?>" data-dbl="<?php echo e($orderData['frame']['frame_size']['values'][3]); ?>" 
                            data-brand="<?php echo e($orderData['frame']['frame_info']['values']['brand']); ?>"
                            data-model="<?php echo e($orderData['frame']['frame_info']['values']['model']); ?>"
                            data-colour="<?php echo e($orderData['frame']['frame_info']['values']['colour']); ?>"
                            data-size="<?php echo e($orderData['frame']['frame_info']['values']['size']); ?>"
                            >
                            <?php echo e($value->getOrderNumber().', '.$value->invoice_no.', '.$value->patient); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <label class="control-label" for="data[frame][invoice_order_no]"><?php echo e($combinationArray['frame']['invoice_order_no']['label']); ?></label>
                </div>
            </div>
        </div>
        <div class="col-md-12 mid-section chide" id="frame_info">
            <div class="row">
                <div class="col-md-12 no-padding mt-4">
                    <label class="control-label" for="frame_info">Frame Info</label>
                </div>
            </div>
            <div class="frame_container">
                <div class="row">
                    <?php $__currentLoopData = $combinationArray['frame']['frame_info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($value['type'] == 'checkbox'): ?>
                    <div class="col-md-2 p-0" id="<?php echo e($key); ?>-container">
                        <div class="md-checkbox-list single-checkbox">
                            <div class="md-checkbox">
                                <input type="checkbox" id="<?php echo e($key); ?>" class="md-check" name="data[frame][frame_info][<?php echo e($key); ?>]" data-attr="<?php echo e($key); ?>">
                                <label class="control-label" for="<?php echo e($key); ?>">
                                <span></span>
                                <span class="check"></span>
                                <span class="box"></span> <?php echo e($value['label']); ?> </label>
                            </div>
                        </div>
                    </div>
                    <?php elseif($value['type'] == 'dropdown'): ?>
                    <div class="<?php echo e($value['class']); ?>" id="left-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control <?php echo e($key); ?> <?php echo e($value['ddl_class']); ?> edited" data-filter="<?php echo e($value['data-filter']); ?>" data-placeholder="" name="data[frame][frame_info][<?php echo e($key); ?>]" data-name="<?php echo e($key); ?>" id="<?php echo e($key); ?>" data-attr="<?php echo e($key); ?>" data-allow-clear="<?php echo e($value['allow-clear']); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key2); ?>">
                                    <?php echo e($value2); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <label class="control-label" for="data[frame][frame_info][<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="col-md-3" id="<?php echo e($key); ?>-container">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <input type="text" class="form-control <?php echo e($value['inputClass']); ?>" id="<?php echo e($key); ?>" name="data[frame][frame_info][<?php echo e($key); ?>]" data-attr="<?php echo e($key); ?>">
                            <label class="control-label" for="data[frame][frame_info][<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-10 text-center help-block font-10 pof-help-text" style="display: none;"> <?php echo e($combinationArray['frame']['frame_info']['pof']['help_text']); ?> </div>
                </div>
            </div>
        </div>
        <div class="col-md-12 mid-section">
            <div class="row">
                <div class="col-md-12 no-padding mt-4">
                    <label class="control-label" for="data[frame][frame_type]">Frame Type <span class="label-asterick">*</span></label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100 frame_type_group" data-toggle="buttons">
                    <?php $__currentLoopData = $combinationArray['frame']['frame_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="btn btn-secondary btn-segment_choice btn-frame_type_choice" data-index="frame_type">
                        <input type="radio" class="toggle form-control is-required" name="data[frame][frame_type]" value="<?php echo e($key); ?>" data-text="<?php echo $value['label']; ?>" id="<?php echo e($key); ?>" >
                        <div class="label-txt"><?php echo e($value['label']); ?> </div>
                    </label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="col-md-4 col-md-offset-3 chide clearfix p-b-10" id="ft_other">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <input type="text" class="form-control" name="data[frame][ft_other]">
                    <label class="control-label" for="data[frame][ft_other]"><?php echo e($combinationArray['frame']['ft_other']['label']); ?></label>
                </div>
            </div>
        </div>
        <div class="col-md-12 mid-section">
            <div class="row">
                <div class="col-md-12 no-padding mt-4">
                    <label class="control-label">Frame Size</label>
                </div>
            </div>
            <div class="row clearfix p-b-10">
                <!-- <div class="btn-group btn-group-circle w-100" data-toggle="buttons"> -->
                <!-- <div class="col-md-1"></div> -->
                <?php $__currentLoopData = $combinationArray['frame']['frame_size']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($value['type'] == 'dropdown'): ?>
                <div class="<?php echo e($value['class']); ?>" id="container-<?php echo e($key); ?>">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <select class="form-control select2_fixed edited <?php echo e(isset($value['inputClass']) ? $value['inputClass'] : ''); ?>" data-placeholder="" id="<?php echo e($key); ?>" name="data[frame][frame_size][<?php echo e($key); ?>]" data-attr="<?php echo e($key); ?>" data-name="<?php echo e($value['data-name']); ?>" data-round="<?php echo e($value['round']); ?>" data-increment="<?php echo e($value['increment']); ?>">
                            <option value=""></option>
                            <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key2); ?>" <?= ($key2 == $value['default']) ? 'selected' : '' ?>>
                                <?php echo e($value2); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <label class="control-label" for="data[frame][frame_size][<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                    </div>
                </div>
                <?php elseif($value['type'] == 'text'): ?>
                <div class="col-md-2">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <?php if(!empty($value['symbol'])): ?>
                        <span class="input-symbol" style="display:none"><?php echo e($value['symbol']); ?></span>
                        <?php endif; ?>
                        <input type="number" class="form-control  crawl-mx numeric-value add-symbol" step="<?php echo e($value['step']); ?>" data-pad="<?php echo e($value['pad']); ?>" data-name="<?php echo e($value['data-name']); ?>" id="<?php echo e($key); ?>" name="data[frame][frame_size][<?php echo e($key); ?>]" data-attr="<?php echo e($key); ?>">
                        <label class="control-label" for="data[frame][<?php echo e($key); ?>]"><?php echo e($value['label']); ?></label>
                    </div>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <!-- </div> -->
            </div>
        </div>
        <div class="col-md-12 mid-section hide" id="shape">
            <div class="row">
                <div class="col-md-8 no-padding">
                    <label class="control-label">Shape <span class="label-asterick">*</span></label>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 clearfix">
                    <input type="hidden" name="data[frame][frame_size][shape_factor]" value="">
                    <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                        <?php $__currentLoopData = $combinationArray['frame']['frame_size']['shape']['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <label class="btn btn-secondary btn-segment_choice btn-frame_shape_choice" data-index="shape">
                            <input type="radio" class="toggle" name="data[frame][frame_size][shape]" value="<?php echo e($key); ?>" data-factor="<?php echo e($value['factor']); ?>" data-text="<?php echo e($value['label']); ?>" data-attr="<?php echo e($key); ?>">
                            <div class="label-txt"><?php echo e($value['label']); ?> </div>
                            <img src="<?php echo e(URL::asset('assets/img/shapes')); ?>/<?php echo e($value['img']); ?>">
                        </label>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12 mid-section chide" id="modify_shape">
            <div class="row">
                <div class="col-md-8 no-padding">
                    <h5>Modify Shape</h5>
                </div>
                <div class="col-md-4 text-right p-t-10 chide" id="mshape-content-rcontent">
                    <a href="javascript:void(0);" class="remove_container-btn" data-hide="mshape-content" title="Remove Prism" tabindex="-1"><i class="fa fa-remove color-red"></i></a>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0 mshape-content chide">
                <?php $__currentLoopData = $combinationArray['frame']['modify_shape']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-1">
                    <div class="md-checkbox-list single-checkbox">
                        <div class="md-checkbox">
                            <input type="checkbox" id="<?php echo e($key); ?>" class="md-check enable_disable-fields" name="data[frame][modify_shape][<?php echo e($key); ?>]" data-attr="<?php echo e($key); ?>">
                            <label class="control-label" for="<?php echo e($key); ?>">
                            <span></span>
                            <span class="check"></span>
                            <span class="box"></span> <?php echo e($value['label']); ?> </label>
                        </div>
                    </div>
                </div>
                <div class="col-md-5" id="container-<?php echo e($key); ?>">
                    <?php $__currentLoopData = $value['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 =>$value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($value2['type'] == 'dropdown'): ?>
                    <div class="<?php echo e($value2['class']); ?>" id="container-<?php echo e($key); ?>">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control select2_fixed edited <?php echo e($value2['inputClass']); ?>" data-placeholder="" name="data[frame][modify_shape][<?php echo e($key2); ?>]" data-attr="<?php echo e($key2); ?>" data-name="<?php echo e($value2['data-name']); ?>" id="<?php echo e($value2['data-name']); ?>" data-min="<?php echo e($value2['min']); ?>" data-max="<?php echo e($value2['max']); ?>" data-step="<?php echo e($value2['step']); ?>" disabled>
                                <option value=""></option>
                                <?php $__currentLoopData = $value2['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value3); ?>"><?php echo e($value3); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <label class="control-label" for="data[frame][modify_shape][<?php echo e($key2); ?>]"><?php echo e($value2['label']); ?></label>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="col-md-6 col-6">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <?php if(!empty($value2['symbol'])): ?>
                            <span class="input-symbol" style="display:none"><?php echo e($value2['symbol']); ?></span>
                            <?php endif; ?>
                            <input type="number" class="form-control numeric-value" id="<?php echo e($key2); ?>" name="data[frame][modify_shape][<?php echo e($key2); ?>]" step="<?php echo e($value2['step']); ?>" min="<?php echo e($value2['min']); ?>" max="<?php echo e($value2['max']); ?>" data-pad="<?php echo e($value2['pad']); ?>" data-round="<?php echo e($value2['round']); ?>" data-attr="<?php echo e($key2); ?>" readonly>
                            <label class="control-label" for="data[frame][modify_shape][<?php echo e($key2); ?>]"><?php echo e($value2['label']); ?></label>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="show-hide-btn" style="padding: 118px;padding: 33px 0;">
                <a href="javascript:;" class="btn btn-info btn-circle add_container-btn" data-show="mshape-content" tabindex="-1"><i class="fa fa-plus"></i> Add Modify Shape</a>
            </div>
        </div>
        <div class="col-md-12 mid-section updated_checkbox p-0" style="min-height:auto;">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <h4 class="no-margin">
                    &nbsp</h5>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0" style="padding-bottom: 14px;">
                <!-- <div class="btn-group btn-group-circle w-100" data-toggle="buttons"> -->
                <div class="row">
                    <div class="col-md-3" id="base_curve-content">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control edited trigger-value select2_fixed" data-placeholder="" data-trigger="r_sph,r_cyl" name="data[rx][extended_info][right_base_curve]" id="right_base_curve" data-name="rx_base_curve" data-placeholder="">
                                <option></option>
                            </select>
                            <label class="control-label" for="right_base_curve">Lens Base Curve</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="col-md-12 text-right p-0 chide" id="specify_thickness-content-rcontent">
                            <a href="javascript:void(0);" class="remove_container-btn" data-hide="specify_thickness-content" title="Remove Prism" tabindex="-1"><i class="fa fa-remove color-red"></i></a>
                        </div>
                        <div class="md-checkbox-list single-checkbox1 specify_thickness-content m-0" id="specify_thickness-content">
                            <!-- <div class="md-checkbox">
                                <input type="checkbox" id="specify_thickness" class="md-check ch_checkboxes" name="data[frame][specify_thickness]">
                                <label class="control-label" for="specify_thickness">
                                    <span></span>
                                    <span class="check"></span>
                                    <span class="box"></span> <?php echo e($combinationArray['frame']['specify_thickness']['label']); ?>

                                    <br><small class="badge badge-primary small-info">Lab will decide best thickness</small>
                                </label>
                                </div> -->
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control select2_fixed edited" id="specify_thickness" name="data[frame][specify_thickness][value]" data-attr="specify_thickness">
                                    <!-- <option><?php echo e($combinationArray['frame']['specify_thickness']['label']); ?></option> -->
                                    <?php $__currentLoopData = $combinationArray['frame']['specify_thickness']['ddl_values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <label class="control-label" for="specify_thickness">Lens Thickness</label>
                            </div>
                        </div>
                        <div class="show-hide-btn chide" style="padding: 24px 0;height: 0px;">
                            <a href="javascript:;" class="btn btn-info btn-circle add_container-btn" data-show="specify_thickness-content" tabindex="-1">Lens Thickness</a>
                        </div>
                    </div>
                </div>
                <div class="row" style="margin-top:10px !important;">
                    <div class="col-sm chide ct_or_et-container right">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <!-- <span class="input-symbol" style="display:none;">mm</span> -->
                            <select class="form-control r_ct_or_et select2_apply edited is-required" data-placeholder="" name="data[frame][specify_thickness][r_ct_or_et]" data-name="r_ct_or_et" id="r_ct_or_et" data-attr="r_ct_or_et" data-allow-clear="true" data-tags="false" data-step="0.50" data-min="0.00" data-max="5.00" data-round="2" >
                                <option value=""></option>
                            </select>
                            <!-- <input type="number" class="form-control crawl-mx numeric-value add-symbol is-required" data-attr="r_ct_or_et" name="data[frame][specify_thickness][r_ct_or_et]" data-name="r_ct_or_et" id="r_ct_or_et" step="0.10" data-pad="" min="0.50" max="5.00" data-round="1"> -->
                            <label class="control-label" for="data[frame][specify_thickness][r_ct_or_et]">R: CT</label>
                        </div>
                    </div>
                    <div class="col-sm chide ct_or_et-container left">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control l_ct_or_et select2_apply edited is-required" data-placeholder="" name="data[frame][specify_thickness][l_ct_or_et]" data-name="l_ct_or_et" id="l_ct_or_et" data-attr="l_ct_or_et" data-allow-clear="true" data-tags="false" data-step="0.10" data-min="0.00" data-max="5.00" data-round="2" >
                                <option value=""></option>
                            </select>
                            <!-- <span class="input-symbol" style="display:none;">mm</span> -->
                            <!-- <input type="number" class="form-control crawl-mx numeric-value add-symbol is-required" name="data[frame][specify_thickness][l_ct_or_et]" id="l_ct_or_et" data-name="l_ct_or_et" min="0.00" step="0.10" max="5.00" data-round="1" data-pad=""> -->
                            <label class="control-label" for="data[frame][specify_thickness][l_ct_or_et]">L: CT</label>
                        </div>
                    </div>
                </div>
                <?php $__currentLoopData = $combinationArray['frame']['specify_thickness']['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-sm <?= !$value['show'] ? 'chide' : '' ?>" id="<?php echo e($value['name']); ?>-container">
                    <div class="md-checkbox-list single-checkbox">
                        <div class="md-checkbox">
                            <input type="checkbox" id="<?php echo e($value['name']); ?>" class="md-check ch_checkboxes" name="data[frame][<?php echo e($value['name']); ?>]" data-attr="<?php echo e($value['name']); ?>">
                            <label class="control-label" for="<?php echo e($value['name']); ?>">
                            <span></span>
                            <span class="check"></span>
                            <span class="box"></span> <?php echo e($value['label']); ?> </label>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="col-sm chide" id="edge_polish">
                    <div class="md-checkbox-list single-checkbox">
                        <div class="md-checkbox">
                            <input type="checkbox" class="md-check ch_checkboxes" id="polish_edges" name="data[frame][edge_polish]" <?= (!empty($userSettings->edge_polish) && $userSettings->edge_polish) ? 'checked' : '' ?>>
                            <label class="control-label" for="polish_edges">
                            <span></span>
                            <span class="check"></span>
                            <span class="box"></span> <?php echo e($combinationArray['frame']['edge_polish']['label']); ?> </label>
                        </div>
                    </div>
                </div>
                <!-- </div> -->
            </div>
        </div>
        <div class="col-md-12 mid-section chide" id="bevel_type">
            <!-- <div class="row">
                <div class="col-md-12 no-padding">
                        <h5>Bevel Type</h5>
                </div>
                </div> -->
            <div class="row">
                <div class="col-md-12 no-padding">
                    <h4 class="no-margin">
                    &nbsp</h5>
                </div>
            </div>
            <!-- <div class="col-md-2"></div> -->
            <div class="col-md-3 clearfix p-b-10">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <select class="form-control select2_fixed edited" data-placeholder="" data-default="normal" name="data[frame][bevel_type]" data-attr="bevel_type" id="bevel_type">
                        <option></option>
                        <?php $__currentLoopData = $combinationArray['frame']['bevel_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?= (!empty($userSettings->bevel_type) && $userSettings->bevel_type == $key) ? 'selected' : '' ?>><?php echo e($value['label']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <label class="control-label" for="bevel_type">Bevel Type</label>
                </div>
                <!-- <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <?php $__currentLoopData = $combinationArray['frame']['bevel_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="btn btn-secondary btn-segment_choice btn-frame_bevel_type_choice <?= (!empty($userSettings->bevel_type) && $userSettings->bevel_type == $key) ? 'active' : '' ?>">
                            <input type="radio" class="toggle" name="data[frame][bevel_type]" value="<?php echo e($key); ?>" <?= (!empty($userSettings->bevel_type) && $userSettings->bevel_type == $key) ? 'checked' : '' ?>>
                            <div class="label-txt"><?php echo e($value['label']); ?> </div>
                    </label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div> -->
            </div>
        </div>
    </div>
    <div class="row shadow p-b-10 p-t-10 rx-section">
        <div class="col-md-12 mid-section left_space">
            <h4 class="form-section bold title">Add-ons</h4>
        </div>
        <div class="col-md-12 mid-section">
            <div class="row">
                <div class="col-md-12 clearfix p-b-10 add_clip_on-container" style="display: none;">
                    <div class="row cancel-btn">
                        <div class="col-md-12 text-right remove_prism-content" style="padding: 0px;">
                            <a href="javascript:void(0);" class="remove-abtn" title="Hide" tabindex="-1"><i class="fa fa-remove color-red"></i></a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm add_clip_on-content">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control select2_fixed edited is-required" data-placeholder="Clip-on Type" id="clip_on_type" name="data[additional_items][clip_on_type]" data-attr="clip_on">
                                    <option value="">Clip-on Type</option>
                                </select>
                                <label class="control-label" for="data[additional_items][clip_on_type]">Clip-on Type</label>
                            </div>
                            <span class="info text-info"></span>
                        </div>
                        <div class="col-sm">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control select2_fixed edited is-required" data-placeholder="Lens Type" id="clip_on_lens_type" name="data[additional_items][clip_on_lens_type]" data-attr="clip_on">
                                    <option value="">Lens Type</option>
                                </select>
                                <label class="control-label" for="data[additional_items][clip_on_lens_type]">Lens Type</label>
                            </div>
                        </div>
                        <div class="col-sm">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control select2_fixed edited is-required" data-placeholder="Lens Colour" id="clip_on_lens_colour" name="data[additional_items][clip_on_lens_colour]" data-attr="clip_on">
                                    <option value="">Lens Colour</option>
                                </select>
                                <label class="control-label" for="data[additional_items][clip_on_lens_colour]">Lens Colour</label>
                            </div>
                        </div>
                        <div class="col-sm clip_on_lens_sub_colour-content chide">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control select2_fixed edited is-required" data-placeholder="Rim Colour" id="clip_on_lens_sub_colour" name="data[additional_items][clip_on_lens_sub_colour]" data-attr="clip_on">
                                    <option value="">Rim Colour</option>
                                </select>
                                <label class="control-label" for="data[additional_items][clip_on_lens_sub_colour]">Rim Colour</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 show-hide-btn show-hide-btn-container text-center">
                    <a href="javascript:;" class="btn btn-info btn-circle show_hide-abtn" data-element="add_clip_on-container" tabindex="0"><i class="fa fa-plus"></i> Add Custom Clip-on</a>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 clearfix p-b-10 add_repairs-container col-md-offset-3" style="display: none;">
                    <div class="row cancel-btn">
                        <div class="col-md-12 text-right remove_prism-content" style="padding: 0px;">
                            <a href="javascript:void(0);" class="remove-abtn" title="Hide" tabindex="-1"><i class="fa fa-remove color-red"></i></a>
                        </div>
                    </div>
                    <div class="row repairs_services-container">
                        <div class="col-md-12 repairs_services-content">
                            <div class="form-group d-flex">
                                <select class="form-control repairs_services-list m-1" name="data[additional_items][repairs_services][]" data-attr="add-repairs">
                                    <option value="">Select Repairs & Services</option>
                                </select>
                                <button class="btn btn-danger m-1 repairs_service-remove" type="button" style="display:none;"><i class="fa fa-close"></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="row repair_description-content" style="display:none;">
                        <div class="col-md-12">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <input type="text" class="form-control" id="repair_description" name="data[additional_items][repair_description]" data-attr="repair_description">
                                <label class="control-label" for="data[additional_items][repair_description]">Repair Description</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 show-hide-btn show-hide-btn-container text-center">
                    <a href="javascript:;" class="btn btn-info btn-circle show_hide-abtn" data-element="add_repairs-container" tabindex="0"><i class="fa fa-plus"></i> Add Repairs & Services</a>
                </div>
            </div>
        </div>
    </div>
    <div class="row shadow p-b-10 p-t-10 rx-section">
        <div class="col-md-12 mid-section left_space">
            <h4 class="form-section bold title">Instructions</h4>
        </div>
        <div class="col-md-12 mid-section">
            <div class="form-group form-md-line-input">
                <div class="col-md-12 content-textarea">
                    <textarea class="form-control" rows="6" name="data[special_instructions]" placeholder="Any instructions given here will result in an analysis of your order by a customer service representative and may delay the processing of your order" id="special_instructions" data-attr="special_instructions"></textarea>
                    <div class="form-control-focus"> </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style type="text/css">
    body{
    overflow: hidden;
    }
    .select2-container--bootstrap .select2-selection{
    border: none;
    }
    .select2-container--bootstrap .select2-selection--single{
    padding: 6px 13px 6px 2px;
    }
    .select2-container--bootstrap .select2-selection--single .select2-selection__arrow b{
    margin-left: 5px;
    }
    .btn-custom-focus .btn:focus{
    color: black !important;
    background-color: white !important;
    border-color: black !important;
    }
    .crawl-cs-ddl,
    .dist-type-ddl{
    max-width: 15%;
    }
    select.lens-data{
    padding-right: 0px;
    }
    .form-error-toaster{
    background: #e73d4a url(../../public/img/exclamation.png) no-repeat 5px center;
    padding: 5px 5px 5px 30px;
    margin: 15px auto;
    font-weight: 700;
    font-family: Arial, Helvetica, sans-serif;
    font-size: 13px;
    font-style: normal;
    text-decoration: none;
    color: #FFF;
    border-radius: 5px;
    position:fixed;bottom:0;left:28%;width: 45%;
    }
    .form-error-toaster div{
    float: left; padding-right: 25px;width: 50%;
    }
    .form-group.form-md-line-input .form-control.edited:not([readonly])~label{
    color: black;
    }
    .form-group.form-md-line-input .form-control.edited:not([readonly])~label:focus{
    font-weight: bolder;
    }
    .btn-info.focus, .btn-info:focus{
    background-color: #2f373e !important;
    border-color: #2f373e !important;
    }
    .form-group {
        width: 100% !important;
    }
    .btn-info {
        color: #fff !important;
        background-color: #659be0 !important;
        border-color: #508edb !important;
    }
    .select2-container--open .select2-selection--single{
    background-color: #2f373e;
    color: white;
    }
    .select2-container--open + .control-label{
    font-weight: bolder !important;
    }
    .select2-container--open .select2-selection__rendered{
    color: white !important;
    }
    .btn-frame_job_type_choice.disabled {
    opacity: 0.5; /* Dim appearance */
    pointer-events: none; /* Prevent clicks */
    cursor: not-allowed; /* Show not-allowed cursor */
    }
    .frame_container .col-sm {
    max-width: 100%;
    overflow: hidden;
    }
    .readonly-select2 + .select2-container{
    cursor: not-allowed;            /* Show disabled cursor */
    }
    .readonly-select2 + .select2-container .select2-selection--single {
    background-color: #eee;         /* Light gray background */
    pointer-events: none;           /* Prevent mouse interaction */
    color: #666;
    }
    .readonly-container {
    opacity: 0.7;
    pointer-events: none;           /* Prevent mouse interaction */
    color: #666;
    cursor: not-allowed; 
    }
    #right-intermediate_strength .label-asterick{
    top: -14px !important;
    }
    label.has-error{
    color: #e73d4a;
    }
    .skeleton-loader {
    height: 36px;
    background: linear-gradient(90deg, #eee 25%, #ddd 50%, #eee 75%);
    background-size: 200% 100%;
    animation: shimmer 1.2s infinite;
    border-radius: 4px;
    margin-bottom: 8px;
    width: 100%;
    }
    @keyframes shimmer {
    0% { background-position: 200% 0; }
    100% { background-position: -200% 0; }
    }
    .lens-field-hidden { display: none !important; }
</style><?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/auth/orders/create/rx-form.blade.php ENDPATH**/ ?>